/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnitOfWorkHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UnitOfWorkHelper.class);

    private UnitOfWorkHelper() {
    }

    @Deprecated
    public static UnitOfWork createUoW(Exchange exchange) {
        return exchange.getContext().getUnitOfWorkFactory().createUnitOfWork(exchange);
    }

    public static void doneUow(UnitOfWork uow, Exchange exchange) {
        try {
            if (uow != null) {
                uow.done(exchange);
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during done UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        try {
            if (uow != null) {
                uow.stop();
            }
        }
        catch (Throwable e) {
            LOG.warn("Exception occurred during stopping UnitOfWork for Exchange: " + exchange + ". This exception will be ignored.", e);
        }
        exchange.setUnitOfWork(null);
    }

    public static void doneSynchronizations(Exchange exchange, List<Synchronization> synchronizations, Logger log2) {
        boolean failed = exchange.isFailed();
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                try {
                    if (failed) {
                        log2.trace("Invoking synchronization.onFailure: {} with {}", (Object)synchronization, (Object)exchange);
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    log2.trace("Invoking synchronization.onComplete: {} with {}", (Object)synchronization, (Object)exchange);
                    synchronization.onComplete(exchange);
                }
                catch (Throwable e) {
                    log2.warn("Exception occurred during onCompletion. This exception will be ignored.", e);
                }
            }
        }
    }

    public static void beforeRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log2) {
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                if (!(synchronization instanceof SynchronizationRouteAware)) continue;
                try {
                    log2.trace("Invoking synchronization.onBeforeRoute: {} with {}", (Object)synchronization, (Object)exchange);
                    ((SynchronizationRouteAware)synchronization).onBeforeRoute(route, exchange);
                }
                catch (Throwable e) {
                    log2.warn("Exception occurred during onBeforeRoute. This exception will be ignored.", e);
                }
            }
        }
    }

    public static void afterRouteSynchronizations(Route route, Exchange exchange, List<Synchronization> synchronizations, Logger log2) {
        if (synchronizations != null && !synchronizations.isEmpty()) {
            ArrayList<Synchronization> copy = new ArrayList<Synchronization>(synchronizations);
            Collections.reverse(copy);
            Collections.sort(copy, new OrderedComparator());
            for (Synchronization synchronization : copy) {
                if (!(synchronization instanceof SynchronizationRouteAware)) continue;
                try {
                    log2.trace("Invoking synchronization.onAfterRoute: {} with {}", (Object)synchronization, (Object)exchange);
                    ((SynchronizationRouteAware)synchronization).onAfterRoute(route, exchange);
                }
                catch (Throwable e) {
                    log2.warn("Exception occurred during onAfterRoute. This exception will be ignored.", e);
                }
            }
        }
    }
}

