## v1.22.01
*(2016-11-30)*

#### Bugfixes
* arp-table uses array_column() breaking discovery on php <=5.4 ([#5099](https://github.com/librenms/librenms/issues/5099))

---

## v1.22
*(2016-11-25)*

#### Features
* validate list devices that have not been polled in the last 5 minutes or took more than 5 minutes to poll ([#5037](https://github.com/librenms/librenms/issues/5037))
* Add Microsoft Teams Alert Transport ([#5023](https://github.com/librenms/librenms/issues/5023))
* Added formatted uptime value for alert templates [#4983](https://github.com/librenms/librenms/issues/4983)
* Adds support for enabling / disabling modules per OS ([#4963](https://github.com/librenms/librenms/issues/4963))
* Improve Dell OpenManage Discovery ([#4957](https://github.com/librenms/librenms/issues/4957))
* Added the option to select alert rules from a collection

#### Bugfixes
* use password type for SMTP Auth [#5051](https://github.com/librenms/librenms/issues/5051)
* Added alert init module to ajax_form [#5058](https://github.com/librenms/librenms/issues/5058)
* eventlog type variable collision ([#5046](https://github.com/librenms/librenms/issues/5046))
* Fixed loaded modules for ajax search ([#5043](https://github.com/librenms/librenms/issues/5043))
* timos6-7 snmprec file error ([#5035](https://github.com/librenms/librenms/issues/5035))
* Strip out " returned from Proxmox application [#4908](https://github.com/librenms/librenms/issues/4908) ([#5003](https://github.com/librenms/librenms/issues/5003))
* Used correct variable for displaying total email count in alert capture ([#5022](https://github.com/librenms/librenms/issues/5022))
* Cisco ASA Sensor Discovery, use correct variable ([#5021](https://github.com/librenms/librenms/issues/5021))
* Stop service modal form disabling services for read-only admin ([#4994](https://github.com/librenms/librenms/issues/4994))
* dbUpdate calls now check if it is 0 or above ([#4996](https://github.com/librenms/librenms/issues/4996))
* Links on devices graphs page to take users straight to specific graph page ([#5001](https://github.com/librenms/librenms/issues/5001))
* Fixed poweralert discovery, check is now case insensitive ([#5000](https://github.com/librenms/librenms/issues/5000))
* Daily.sh log_dir failed when install_dir and log_dir were not set ([#4992](https://github.com/librenms/librenms/issues/4992))
* Merge pull request [#4939](https://github.com/librenms/librenms/issues/4939) from laf/issue-4937
* Remove service type from uniform display ([#4974](https://github.com/librenms/librenms/issues/4974))
* Fixed check for VRFs, so this runs on routers without any VRFs defined ([#4972](https://github.com/librenms/librenms/issues/4972))
* Api rate percent calculation incorrect ([#4956](https://github.com/librenms/librenms/issues/4956))
* Corrects path to proxmox script in docs ([#4949](https://github.com/librenms/librenms/issues/4949))
* Update debug output in service check ([#4933](https://github.com/librenms/librenms/issues/4933))
* Fujitsu PRIMERGY 10Gbe switches are now detected correctly ([#4923](https://github.com/librenms/librenms/issues/4923))
* Toner graphs with invalid chars
* Updated syslog table to use display() for msg output ([#4859](https://github.com/librenms/librenms/issues/4859))
* Added support for https links in alerts procedure url ([#4872](https://github.com/librenms/librenms/issues/4872))
* Updated check to use != in daily.sh ([#4916](https://github.com/librenms/librenms/issues/4916))
* Remove escape characters for services form / display [#4891](https://github.com/librenms/librenms/issues/4891)
* Only update components if data exists in cimc entity-physical discovery [#4902](https://github.com/librenms/librenms/issues/4902)
* Renamed hp3par os polling file to informos ([#4861](https://github.com/librenms/librenms/issues/4861))
* Updated Cisco ASA state sensors descr to be a bit more verbose

#### Documentation
* Added FAQ on why EdgeRouters might not be detected ([#4985](https://github.com/librenms/librenms/issues/4985))
* Update freenode links ([#4935](https://github.com/librenms/librenms/issues/4935))
* Issue template to ask people to use irc / community for creating issues

#### Refactoring
* Rewrite arp-table discovery ([#5048](https://github.com/librenms/librenms/issues/5048))
* Collection and output of db and snmp stats ([#5049](https://github.com/librenms/librenms/issues/5049))
* Disable modules for pbn-cp and multimatic os
* Centralize includes and initialization ([#4991](https://github.com/librenms/librenms/issues/4991))
* Remove inappropriate usages of truncate() ([#5028](https://github.com/librenms/librenms/issues/5028))
* Watchguard Fireware cleanup ([#5015](https://github.com/librenms/librenms/issues/5015))
* Tidy up mibs V-Z ([#4979](https://github.com/librenms/librenms/issues/4979))
* Limit perf array index length to 19 characters due to limitation in ds-name rrdtool ([#4731](https://github.com/librenms/librenms/issues/4731))
* Daily.sh updated ([#4920](https://github.com/librenms/librenms/issues/4920))
* Default to only using mysqli ([#4915](https://github.com/librenms/librenms/issues/4915))
* Start of cleaning up mibs
* Update wifi clients polling to support more than 2 radios ([#4913](https://github.com/librenms/librenms/issues/4913))
* Refactored and added support for $config['log_dir'] to daily.sh
* Improve Cisco ASA Polling Performance ([#4999](https://github.com/librenms/librenms/issues/4999))

#### Devices
* Updated edge-core to edgecos and added further detection ([#5024](https://github.com/librenms/librenms/issues/5024))
* Added basic support for Ceragon devices
* Added support for Dell PowerConnect 6024
* Added PBN-CP devices.
* Added support for Edgerouter devices [#4936](https://github.com/librenms/librenms/issues/4936)
* Added support for Dell Remote consoles [#4881](https://github.com/librenms/librenms/issues/4881)
* Added support for FortiSwitch [#4852](https://github.com/librenms/librenms/issues/4852) ([#4858](https://github.com/librenms/librenms/issues/4858))

#### WebUI
* Availability map compact view, use square tiles instead of rectangles ([#5038](https://github.com/librenms/librenms/issues/5038))
* Add link to recently added device ([#5032](https://github.com/librenms/librenms/issues/5032))
* Do not show Config tab for devices set to be excluded from oxidized [#4592](https://github.com/librenms/librenms/issues/4592) ([#5029](https://github.com/librenms/librenms/issues/5029))
* Update Availability-Map Widget to use sysName when IPs used and config enabled ([#4968](https://github.com/librenms/librenms/issues/4968))
* Added support for skipping snmp check on edit snmp page for devices ([#4896](https://github.com/librenms/librenms/issues/4896))
* Update wifi_clients graph ([#4846](https://github.com/librenms/librenms/issues/4846))
* Further decouple the avail-map page from the widget ([#4887](https://github.com/librenms/librenms/issues/4887))

---

## v1.21
*(2016-10-30)*

#### Features
* Added support for global max repeaters for snmp ([#4880](https://github.com/librenms/librenms/issues/4880))
* Added custom css and include directories which are ignored by git ([#4871](https://github.com/librenms/librenms/issues/4871))
* Add an option for ad authentication to have a default level ([#4801](https://github.com/librenms/librenms/issues/4801))
* Add ping and RxLevel for SAF devices ([#4840](https://github.com/librenms/librenms/issues/4840))
* Added ability to exclude devices from xDP disco based on sysdescr, sysname or platform
* Add Extra Mimosa Discovery ([#4831](https://github.com/librenms/librenms/issues/4831))
* Add support for NX-OS fan status ([#4824](https://github.com/librenms/librenms/issues/4824))
* Add osTicket Alert Transport ([#4791](https://github.com/librenms/librenms/issues/4791))
* Add SonicWALL Sessions [#1686](https://github.com/librenms/librenms/issues/1686)
* Updated libvirt-vminfo to support oVirt
* Enhance Unifi Wireless Client count for multiple VAPs ([#4794](https://github.com/librenms/librenms/issues/4794))
* Added CEF Display page ([#3978](https://github.com/librenms/librenms/issues/3978))
* Added CPU detection for Synology DSM [#2081](https://github.com/librenms/librenms/issues/2081) ([#4756](https://github.com/librenms/librenms/issues/4756))
* Added CPU detection for Synology DSM [#2081](https://github.com/librenms/librenms/issues/2081)
* Stop displaying sensitive info in the settings page ([#4724](https://github.com/librenms/librenms/issues/4724))
* Added Cisco Integrated Management Console inventory and sensor support [#4454](https://github.com/librenms/librenms/issues/4454)
* Added support for show faults array in recovery alerts ([#4708](https://github.com/librenms/librenms/issues/4708))
* Add description and notes to be used in alerts templates ([#4706](https://github.com/librenms/librenms/issues/4706))
* validate.php: check poller and discovery status ([#4663](https://github.com/librenms/librenms/issues/4663))
* Added GlobalProtect sessions to PANOS

#### Bugfixes
* Replace \\\\l with \l on GPRINT lines ([#4882](https://github.com/librenms/librenms/issues/4882))
* fix missing config entries on global settings page [#4884](https://github.com/librenms/librenms/issues/4884)
* Fix the detection of NX-OS fan names ([#4864](https://github.com/librenms/librenms/issues/4864))
* API call to services only returned first one
* Change the wording for the create default rules button
* incomplete polling on aruba controllers
* Fixed wifi clients not reporting when value 0
* ZyWALL Fixes for OS and mem polling [#1652](https://github.com/librenms/librenms/issues/1652)
* Fix irc bot user level ([#4833](https://github.com/librenms/librenms/issues/4833))
* Updated min/max values for ubnt graphs ([#4811](https://github.com/librenms/librenms/issues/4811))
* Fix Riverbed temperature discovery ([#4832](https://github.com/librenms/librenms/issues/4832))
* only poll cipsec for cisco devices. ([#4819](https://github.com/librenms/librenms/issues/4819))
* Zywall Fixes [#1652](https://github.com/librenms/librenms/issues/1652)
* do not show fail if running as the librenms user + slightly less false positives ([#4821](https://github.com/librenms/librenms/issues/4821))
* Do not create rrd folder when -r is specified for poller ([#4812](https://github.com/librenms/librenms/issues/4812))
* Delete all port_id references [#4684](https://github.com/librenms/librenms/issues/4684)
* Used dos2unix on all mibs to prevent .index issue ([#4803](https://github.com/librenms/librenms/issues/4803))
* availability map multiple instances ([#4773](https://github.com/librenms/librenms/issues/4773))
* top widget multiple instances ([#4757](https://github.com/librenms/librenms/issues/4757))
* Updated bin/bash to use env in cronic script ([#4752](https://github.com/librenms/librenms/issues/4752))
* skip ip_exists function when we force add ([#4738](https://github.com/librenms/librenms/issues/4738))
* Stopped showing sub menus when empty [#4713](https://github.com/librenms/librenms/issues/4713)
* Samsun ML typo, remove need for hex_string translation ([#4788](https://github.com/librenms/librenms/issues/4788))
* apc load, runtime and current sensors ([#4780](https://github.com/librenms/librenms/issues/4780))
* Prevent accidental anonymous binds ([#4784](https://github.com/librenms/librenms/issues/4784))
* Update brocade fanspeed description
* qnap temperature sensors [#4586](https://github.com/librenms/librenms/issues/4586)
* Stop displaying sensitive info in the settings page ([#4724](https://github.com/librenms/librenms/issues/4724))
* Ignore meraki bad_uptime [#4691](https://github.com/librenms/librenms/issues/4691)
* Fixed trying to map devices to alert rules
* Re-enable the edit device groups button ([#4726](https://github.com/librenms/librenms/issues/4726))
* Raise version size for packages table to 255 char  ([#4656](https://github.com/librenms/librenms/issues/4656))
* Adjusted padding based on screen width to fit all icons ([#4711](https://github.com/librenms/librenms/issues/4711))
* fixed count test for cisco-otv poller module ([#4714](https://github.com/librenms/librenms/issues/4714))
* Fall back to ipNetToMediaPhysAddress when ipNetToPhysicalPhysAddress not available [#4559](https://github.com/librenms/librenms/issues/4559)
* ipmi poller, run with USER rights and surround username and password with '' [#4710](https://github.com/librenms/librenms/issues/4710)
* Wrapped ipmi user / pass in quotes [#4686](https://github.com/librenms/librenms/issues/4686) and [#4702](https://github.com/librenms/librenms/issues/4702)
* Use snmpv3 username even when NoAuthNoPriv is selected [#4677](https://github.com/librenms/librenms/issues/4677)

#### Documentation
* homepage headers: vertical align, match color, add spacing ([#4870](https://github.com/librenms/librenms/issues/4870))
* Added FAQ on moving install to another server
* Updated index page to make it look more attractive ([#4855](https://github.com/librenms/librenms/issues/4855))
* Adding setup of distro script for Linux (snmpd) configuration
* Added doc on security and vulnerabilities
* Update Graylog.md ([#4717](https://github.com/librenms/librenms/issues/4717))

#### Refactoring
* populate native vlans in the ports_vlan table for cisco devices too ([#4805](https://github.com/librenms/librenms/issues/4805))
* Small poller improvements, removes unecessary queries / execs ([#4741](https://github.com/librenms/librenms/issues/4741))
* Cleanup poller include files ([#4751](https://github.com/librenms/librenms/issues/4751))
* Update alert rules to generate sql query and store in db ([#4748](https://github.com/librenms/librenms/issues/4748))
* toner support ([#4795](https://github.com/librenms/librenms/issues/4795))
* Updated and added more options for http proxy support ([#4718](https://github.com/librenms/librenms/issues/4718))
* small fixes for cisco-voice code ([#4719](https://github.com/librenms/librenms/issues/4719))
* Improve sensors polling for performance increase ([#4725](https://github.com/librenms/librenms/issues/4725))
* Improve sensors polling for performance increase
* Rewrite for qnap fanspeeds ([#4590](https://github.com/librenms/librenms/issues/4590))
* edituser page to allow user selection of a default dashboard ([#4551](https://github.com/librenms/librenms/issues/4551))
* snmp cleanup ([#4683](https://github.com/librenms/librenms/issues/4683))

#### Devices
* Added support for Megatec NetAgent II
* Add UniFi Wireless MIB polling for Capacity [#4266](https://github.com/librenms/librenms/issues/4266)
* Added support for Sinetica UPS ¢4613
* Added additional support for Synology DSM devices [#2738](https://github.com/librenms/librenms/issues/2738)
* Add additional F5 sensor support ([#4642](https://github.com/librenms/librenms/issues/4642))
* Added Unifi Wireless Client statistics [#4772](https://github.com/librenms/librenms/issues/4772)
* Additional support for Hikvision products
* More dnos additions [#4745](https://github.com/librenms/librenms/issues/4745) ([#4749](https://github.com/librenms/librenms/issues/4749))
* Additional support for Hikvision products ([#4750](https://github.com/librenms/librenms/issues/4750))
* Add support for Moxa [#4733](https://github.com/librenms/librenms/issues/4733)
* Add additional features to SAF Tehnika ([#4666](https://github.com/librenms/librenms/issues/4666))
* Add support for more Pulse Secure devices [#4680](https://github.com/librenms/librenms/issues/4680)
* Add support for more DNOS devices [#4627](https://github.com/librenms/librenms/issues/4627)
* Added support for Sinetica UPS
* Add support for Mimosa Wireless [#4676](https://github.com/librenms/librenms/issues/4676)
* Add support for Mimosa Wireless [#4676](https://github.com/librenms/librenms/issues/4676)

#### WebUI
* Allow users to set their default dashboard from preferences page
* Updated devices view ([#4700](https://github.com/librenms/librenms/issues/4700))
* Disable page refresh on the search pages.  Users can manually hit the refresh on the grid. ([#4787](https://github.com/librenms/librenms/issues/4787))
* Display vlans for all devices. [#4349](https://github.com/librenms/librenms/issues/4349), [#3059](https://github.com/librenms/librenms/issues/3059)
* Added sorting and poller time support to top-devices widget [#4668](https://github.com/librenms/librenms/issues/4668)

---

## Release: 201609
*September 2016*

#### Features
* Added alerts output to capture system ([#4574](https://github.com/librenms/librenms/issues/4574))
* Add support for ups-apcups via snmp
* Add snmpsim to Travis automated testing. Update to check new setting for true and isset
* use snmpsim for testing fallback feature so we don't have to run snmpsim on devel computers, should be adequate for now ./scripts/pre-commit.php -u -snmpsim will start an snmpsimd.py process automatically
* Improved readability for snmp debug output
* Add last changed, connected, and mtu to all ports data
* Add temp & state sensors to Riverbed
* Added support for all OS tests
* Added Runtime support for APC ups 
* Capture device troubleshooting info (discovery, poller, snmpwalk)
* Add temp & state sensors to Riverbed
* Add more state sensors to Dell iDrac
* Allow scripts to be run from any working directory ([#4437](https://github.com/librenms/librenms/issues/4437))
* New app: ups-nut ([#4386](https://github.com/librenms/librenms/issues/4386))
* Added new discovery-wrapper.py script to replicate poller-wrapper.py ([#4351](https://github.com/librenms/librenms/issues/4351))
* Extended graphing for sla - icmp-jitter [#4341](https://github.com/librenms/librenms/issues/4341)
* Added Cisco Stackwise Support [#4301](https://github.com/librenms/librenms/issues/4301)
* Add Cisco WAAS Optimized TCP Connections Graph ([#4645](https://github.com/librenms/librenms/issues/4645))

#### Bugfixes
* Toner nrg os capacity ([#4177](https://github.com/librenms/librenms/issues/4177))
* Fixed swos detection [#4533](https://github.com/librenms/librenms/issues/4533)
* Updated edit snmp to set default poller_group ([#4694](https://github.com/librenms/librenms/issues/4694))
* Fixed SQL query for bgpPeers check to remove stale sessions ([#4697](https://github.com/librenms/librenms/issues/4697))
* Netonix version display ([#4672](https://github.com/librenms/librenms/issues/4672))
* FreeBSD variants ([#4661](https://github.com/librenms/librenms/issues/4661))
* unix-agent handling of reported time values from check_mk [#4652](https://github.com/librenms/librenms/issues/4652)
* Add checks for devices with no uptime over snmp [#4587](https://github.com/librenms/librenms/issues/4587)
* stop qnap discovery from running for every device
* Fixed the old port rrd migration code to work with new rrdtool functions ([#4616](https://github.com/librenms/librenms/issues/4616))
* Run cleanup for ipmi sensor discovery ([#4582](https://github.com/librenms/librenms/issues/4582))
* Numerous availability-map bug fixes
* AD auth stop alerts being generated
* Possible additional fix for non-terminating rrdtool processes.
* AD auth stop alerts being generated
* APC runtime graph missing in device>health>overview
* LibreNMS/Proc improvements Should fix sending rrdtool the quit command without a newline at the end. (not sure if this is an issue)
* Port ifLastChange polling now usable ([#4541](https://github.com/librenms/librenms/issues/4541))
* brother toner levels ([#4526](https://github.com/librenms/librenms/issues/4526))
* poweralert ups divisor
* Update Fortinet Logo
* Change CiscoSB devices to use ifEntry
* Disable refreshing on window resize when $no_refresh is set.
* Fix quota bills showing 0/0 for in/out ([#4462](https://github.com/librenms/librenms/issues/4462))
* This removes stale entries in the mac_ipv4 table ([#4444](https://github.com/librenms/librenms/issues/4444))
* Swos os discovery fixes [#3593](https://github.com/librenms/librenms/issues/3593)
* Vyos discovery fix [#4486](https://github.com/librenms/librenms/issues/4486)
* Toner descr that contain invalid characters [#4464](https://github.com/librenms/librenms/issues/4464)
* Alert statics not showing data
* Ubnt bad edgeswitch uptime [#4470](https://github.com/librenms/librenms/issues/4470)
* New installs would have multiple entries in dbSchema table ([#4460](https://github.com/librenms/librenms/issues/4460))
* Force add now ignores all snmp queries
* Clean up errors in the webui ([#4438](https://github.com/librenms/librenms/issues/4438))
* Reduce mib graph queries ([#4439](https://github.com/librenms/librenms/issues/4439))
* Ports page includes disabled, ignored, and deleted ports ([#4419](https://github.com/librenms/librenms/issues/4419))
* RRDTool call was always being done to check for local files ([#4427](https://github.com/librenms/librenms/issues/4427))
* MikroTik OS detection [#3593](https://github.com/librenms/librenms/issues/3593)
* Added cisco886Va to bad_ifXEntry for cisco os ([#4374](https://github.com/librenms/librenms/issues/4374))
* Stop irc bot crashing on .reload [#4353](https://github.com/librenms/librenms/issues/4353)
* Quanta blade switches are now being correctly detected as Quanta switches ([#4358](https://github.com/librenms/librenms/issues/4358))
* Added options to make temperature graphs display y-axis correctly [#4350](https://github.com/librenms/librenms/issues/4350)
* Added options to make voltage graphs display y-axis correctly [#4326](https://github.com/librenms/librenms/issues/4326)
* Calling rrdtool_pipe_open() instead of rrdtool_initialize(); ([#4343](https://github.com/librenms/librenms/issues/4343))
* Enterasys use ifname for port names [#3263](https://github.com/librenms/librenms/issues/3263)
* Ricoh/nrg toner levels [#4177](https://github.com/librenms/librenms/issues/4177)
* Availability map device box reverted to original size, fixes for device groups ([#4334](https://github.com/librenms/librenms/issues/4334))
* Remove Cisco remote access stats graph transparency ([#4331](https://github.com/librenms/librenms/issues/4331))
* Cisco remote access stats bugfix [#4293](https://github.com/librenms/librenms/issues/4293) ([#4309](https://github.com/librenms/librenms/issues/4309))
* Added ability to force devices to use ifEntry instead of ifXEntry ([#4100](https://github.com/librenms/librenms/issues/4100))
* Don’t add Cisco VSS sensors if VSS is not running [#4111](https://github.com/librenms/librenms/issues/4111)
* Always validate the default dashboard_id to make sure it still exists
* NRG Toner detection [#4250](https://github.com/librenms/librenms/issues/4250)
* Missing variable in services api call
* Added influxdb options to check-services.php

#### Documentation
* Include PHP Install instructions for MySQL app
* Added FAQ for why interfaces are missing from overall traffic graphs ([#4696](https://github.com/librenms/librenms/issues/4696))
* Updated Applications to clarify apache setup
* Update apache applications to detail testing and additional requirements.md
* Updated release doc with more information on stable / dev branches
* Corrected the rsyslog documentation to be compatible with logrotate
* Fixed centos snmp path
* Updated to include info on how to use git hook to validate code ([#4484](https://github.com/librenms/librenms/issues/4484))
* Added info on how to perform unit testing
* Added faq to explain why devices show as warning ([#4449](https://github.com/librenms/librenms/issues/4449))
* Standardize snmp extend script location to /etc/snmp/ ([#4418](https://github.com/librenms/librenms/issues/4418))
* Added NFSen docs + update general config docs ([#4412](https://github.com/librenms/librenms/issues/4412))
* Clarify install docs to run validate as root [#4286](https://github.com/librenms/librenms/issues/4286) 
* Added example to alerting doc for using variables of similar name [#4264](https://github.com/librenms/librenms/issues/4264)
* Added docs + file changes to support creating new releases/changelog
* Update snmpd setup in Installation-Ubuntu-1604 docs [#4243](https://github.com/librenms/librenms/issues/4243)

#### Refactoring
* Centralize MIB include directory specification ([#4603](https://github.com/librenms/librenms/issues/4603))
* OS discovery files (a-z)
* F5 device discovery cleanup + test unit
* Remove external uses of GenGroupSQL()
* consolidate snmpcmd generation
* consolidate snmpcmd generation I needed to generate an snmpcmd for an upcoming PR, so I figured I'd save a little code duplication.
* Refactored new helper functions for case sensitivity [#4283](https://github.com/librenms/librenms/issues/4283) 
* Final PSR2 cleanup
* Moved IRCBot class to LibreNMS namespace [#4246](https://github.com/librenms/librenms/issues/4246) 
* Update code in /includes to be psr2 compliant [#4220](https://github.com/librenms/librenms/issues/4220)

#### Devices
* Samsung Printer Discovery [#4251](https://github.com/librenms/librenms/issues/4251) ([#4258](https://github.com/librenms/librenms/issues/4258))
* HP 1820 Discovery [#3933](https://github.com/librenms/librenms/issues/3933) ([#4259](https://github.com/librenms/librenms/issues/4259))
* Added support for Cisco Callmanager
* Edge Core ES3528M - base support
* Added support for Cisco IPS ([#4561](https://github.com/librenms/librenms/issues/4561))
* Added MGE detection
* Netonix switch data collection update
* Eaton PowerXpert
* Added Datacom Dbm Support
* Updated Edgerouter lite detection
* Added support for Cisco Callmanager
* Procurve 5400R series [#4375](https://github.com/librenms/librenms/issues/4375)
* hp online admin cpu and mem [#4327](https://github.com/librenms/librenms/issues/4327)
* Added support for Foundry Networks [#4311](https://github.com/librenms/librenms/issues/4311)
* Added Cisco Stackwise Support [#4301](https://github.com/librenms/librenms/issues/4301)
* Added support for PLANET Networking & Communication switches ([#4308](https://github.com/librenms/librenms/issues/4308))
* Added support for Fujitsu Primergy switches [#4277](https://github.com/librenms/librenms/issues/4277) ([#4280](https://github.com/librenms/librenms/issues/4280))
* Added support for Lanier printers [#4267](https://github.com/librenms/librenms/issues/4267) 
* Added Temp and State support for EdgeSwitch OS [#4265](https://github.com/librenms/librenms/issues/4265) 
* Added support for DDN Storage [#2737](https://github.com/librenms/librenms/issues/2737) ([#4261](https://github.com/librenms/librenms/issues/4261))
* Improved support for UBNT EdgeSwitch OS [#4249](https://github.com/librenms/librenms/issues/4249)
* Improved support for Avaya VSP [#4237](https://github.com/librenms/librenms/issues/4237)
* Added support for macOS Sierra ([#4557](https://github.com/librenms/librenms/issues/4557))
* Improve BDCOM detection ([#4329](https://github.com/librenms/librenms/issues/4329))

#### WebUI
* top devices enhancement [#4447](https://github.com/librenms/librenms/issues/4447)
* Individual devices now use bootgrid syslog ([#4584](https://github.com/librenms/librenms/issues/4584))
* added amazon server icon
* Update all glyphicon to font awesome
* Relocate Alerts menu
* Updated force add option for addhost.php to be present in all instances ([#4428](https://github.com/librenms/librenms/issues/4428))
* Add check to display make bill on port page only if billing is enabled ([#4361](https://github.com/librenms/librenms/issues/4361))
* Added Pagination and server side search via Ajax to NTP ([#4330](https://github.com/librenms/librenms/issues/4330))

---

### August 2016

#### Bug fixes
  - WebUI
    - Fix Infoblox dhcp messages graph ([PR3898](https://github.com/librenms/librenms/pull/3898))
    - Fix version_info output in Safari ([PR3914](https://github.com/librenms/librenms/pull/3914))
    - Added missing apps to Application page ([PR3964](https://github.com/librenms/librenms/pull/3964))
  - Discovery / Polling
    - Clear our stale IPSEC sessions from the DB ([PR3904](https://github.com/librenms/librenms/pull/3904))
    - Fixed some InfluxDB bugs in check-services and ports ([PR4031](https://github.com/librenms/librenms/pull/4031))
    - Fixed Promox and Ceph rrd's ([PR4038](https://github.com/librenms/librenms/pull/4038), [PR4037](https://github.com/librenms/librenms/pull/4037), [PR4047](https://github.com/librenms/librenms/pull/4047), [PR4041](https://github.com/librenms/librenms/pull/4041))
    - Fixed LLDP Remote port in discovery-protocols module ([PR4070](https://github.com/librenms/librenms/pull/4070))
  - Billing
    - Check if ifSpeed is returned for calculating billing ([PR3921](https://github.com/librenms/librenms/pull/3921))
  - Applications
    - NFS-V3 stats fixed ([PR3963](https://github.com/librenms/librenms/pull/3963))
  - Misc
    - Dell Equallogic storage fix ([PR3956](https://github.com/librenms/librenms/pull/3956))
    - Fix syslog bug where entries would log to the wrong device ([PR3996](https://github.com/librenms/librenms/pull/3996))

#### Improvements
  - Added / improved detection for:
    - Cisco WAAS / WAVE ([PR3899](https://github.com/librenms/librenms/pull/3899))
    - Maipu MyPower ([PR3909](https://github.com/librenms/librenms/pull/3909))
    - TPLink Switches ([PR3919](https://github.com/librenms/librenms/pull/3919))
    - Dell N3024 ([PR3941](https://github.com/librenms/librenms/pull/3941))
    - Cisco FXOS ([PR3943](https://github.com/librenms/librenms/pull/3943))
    - Brocade FABOS ([PR3959](https://github.com/librenms/librenms/pull/3959), [PR3988](https://github.com/librenms/librenms/pull/3988))
    - JunOS ([PR3976](https://github.com/librenms/librenms/pull/3976))
    - Dell PowerConnect ([PR3998](https://github.com/librenms/librenms/pull/3998), [PR4007](https://github.com/librenms/librenms/pull/4007))
    - Comware ([PR3967](https://github.com/librenms/librenms/pull/3967))
    - Calix E5 ([PR3864](https://github.com/librenms/librenms/pull/3864))
    - Raisecom ([PR3992](https://github.com/librenms/librenms/pull/3864))
    - Cisco ISE ([PR4063](https://github.com/librenms/librenms/pull/4063))
    - Acano ([PR4064](https://github.com/librenms/librenms/pull/4064))
    - McAfee SIEM Nitro ([PR4066](https://github.com/librenms/librenms/pull/4064))
    - HP Bladesystem C3000/C7000 OA ([PR4035](https://github.com/librenms/librenms/pull/4035))
    - Cisco VCS (Expressway) ([PR4086](https://github.com/librenms/librenms/pull/4086))
    - Cisco Telepresence Conductor ([PR4087](https://github.com/librenms/librenms/pull/4087))
    - Avaya VSP ([PR4048](https://github.com/librenms/librenms/pull/4048))
    - Cisco/Tandberg Video Conferencing ([PR4065](https://github.com/librenms/librenms/pull/4065))
    - Cisco Prime Infrastructure ([PR4088](https://github.com/librenms/librenms/pull/4088))
    - HWGroup STE2 ([PR4116](https://github.com/librenms/librenms/pull/4116))
    - HP 2530 Procurve / Arube ([PR4119](https://github.com/librenms/librenms/pull/4119))
    - Brother Printers ([PR4141](https://github.com/librenms/librenms/pull/4141))
    - Hytera Repeater ([PR4163](https://github.com/librenms/librenms/pull/4163))
    - Sonus ([PR4176](https://github.com/librenms/librenms/pull/4176))
    - Freeswitch ([PR4203](https://github.com/librenms/librenms/pull/4203))
  - WebUI
    - Improved OSPF display ([PR3908](https://github.com/librenms/librenms/pull/3908))
    - Improved Apps overview page ([PR3954](https://github.com/librenms/librenms/pull/3954))
    - Improved Syslog page ([PR3955](https://github.com/librenms/librenms/pull/3955), [PR3971](https://github.com/librenms/librenms/pull/3971))
    - Rewrite availability map ([PR4043](https://github.com/librenms/librenms/pull/4043))
    - Add predicted usage to billing overview ([PR4049](https://github.com/librenms/librenms/pull/4049))
  - API
    - Added services calls to API ([PR4215](https://github.com/librenms/librenms/pull/4215))
  - Discovery / Polling
    - Added CPU detection for Dell PowerConnect 8024F ([PR3966](https://github.com/librenms/librenms/pull/3966))
    - Cisco VSS state discovery ([PR3977](https://github.com/librenms/librenms/pull/3977))
    - Refactor of BGP Discovery and Polling (mainly JunOS) ([PR3938](https://github.com/librenms/librenms/pull/3938))
    - Added Sensors for Brocade NOS ([PR3969](https://github.com/librenms/librenms/pull/3969))
    - Cisco ASA HA States ([PR4012](https://github.com/librenms/librenms/pull/4012))
    - Improved IPSLA Support ([PR4006](https://github.com/librenms/librenms/pull/4006))
    - Added support for CISCO-NTP-MIB ([PR4005](https://github.com/librenms/librenms/pull/4005))
    - Improved toner support for Ricoh devices ([PR4180](https://github.com/librenms/librenms/pull/4180))
  - Documentation
    - New doc site live http://docs.librenms.org/
    - Added rsyslog 5 example to syslog docs ([PR3912](https://github.com/librenms/librenms/pull/3912))
    - Application doc updates ([PR3928](https://github.com/librenms/librenms/pull/3928))
  - Applications
    - App OS Updates support ([PR3935](https://github.com/librenms/librenms/pull/3935))
    - PowerDNS Recursor improvements ([PR3932](https://github.com/librenms/librenms/pull/3932))
    - Add DHCP Stats support ([PR3970](https://github.com/librenms/librenms/pull/3970))
    - Added snmp support to Memcached ([PR3949](https://github.com/librenms/librenms/pull/3949))
    - Added Unbound support ([PR4074](https://github.com/librenms/librenms/pull/4074))
    - Added snmp support to Proxmox ([PR4052](https://github.com/librenms/librenms/pull/4052))
    - Added Raspberry Pi Sensor support ([PR4057](https://github.com/librenms/librenms/pull/4057))
    - Updated NTPD support ([PR4077](https://github.com/librenms/librenms/pull/4077))
  - Misc
    - Added cleanup of old RRD files to daily.sh ([PR3907](https://github.com/librenms/librenms/pull/3907))
    - Refactored addHost event logs ([PR3929](https://github.com/librenms/librenms/pull/3929), [PR3997](https://github.com/librenms/librenms/pull/3997))
    - Refactored RRD Functions ([PR3800](https://github.com/librenms/librenms/pull/3800), [PR4081](https://github.com/librenms/librenms/pull/4081))
    - Added support for nets-exclude in snmp-scan ([PR4000](https://github.com/librenms/librenms/pull/4045))
    - Refactored files in html (Libraries and PSR2 style ([PR4071](https://github.com/librenms/librenms/pull/4071), [PR4101](https://github.com/librenms/librenms/pull/4101), [PR4117](https://github.com/librenms/librenms/pull/4117))
    - Various IRC updates and fixes ([PR4200](https://github.com/librenms/librenms/pull/4200), [PR4204](https://github.com/librenms/librenms/pull/4204), [PR4201](https://github.com/librenms/librenms/pull/4201))

### July 2016

#### Bug fixes
  - API
    - Stop outputting vrf lite and IP info when device doesn't exist ([PR3785](https://github.com/librenms/librenms/pull/3785))
  - WebUI
    - Added force refresh for generic image widget ([PR3817](https://github.com/librenms/librenms/pull/3817))
    - Fixed NFSen tab not showing in all cases ([PR3857](https://github.com/librenms/librenms/pull/3857))
  - Discovery / Polling
    - Fixed incorrect IBM-AMM thresholds ([PR3866](https://github.com/librenms/librenms/pull/3866))
    - Fixed Pulse OS whitespace in polling ([PR3883](https://github.com/librenms/librenms/pull/3883))
  - Misc
    - Fixed device group search ([PR3788](https://github.com/librenms/librenms/pull/3788))
    - Fixed sporadic device delete ([PR3805](https://github.com/librenms/librenms/pull/3805))
    - Retry creation of two tables ([PR3848](https://github.com/librenms/librenms/pull/3848))

#### Improvements
  - Added / improved detection for:
    - Telco systems ([PR3773](https://github.com/librenms/librenms/pull/3773), [PR3804](https://github.com/librenms/librenms/pull/3804))
    - Cisco ACS ([PR3786](https://github.com/librenms/librenms/pull/3786))
    - Adtran AOS ([PR3787](https://github.com/librenms/librenms/pull/3787), [PR3799](https://github.com/librenms/librenms/pull/3799))
    - Lantronix SLC ([PR3797](https://github.com/librenms/librenms/pull/3797))
    - PBN Sensor support ([PR3820](https://github.com/librenms/librenms/pull/3820))
    - Ironware VRF discovery ([PR3827](https://github.com/librenms/librenms/pull/3827))
    - Comware sensors discovery ([PR3881](https://github.com/librenms/librenms/pull/3881), [PR3889](https://github.com/librenms/librenms/pull/3889), [PR3896](https://github.com/librenms/librenms/pull/3896))
    - Brocade VDX detection ([PR3888](https://github.com/librenms/librenms/pull/3888))
    - Checkpoint GAiA ([PR3890](https://github.com/librenms/librenms/pull/3890))
    - Cisco ASA-X Hardware detection ([PR3897](https://github.com/librenms/librenms/pull/3897))
  - WebUI
    - Added sysName to global search if != hostname ([PR3815](https://github.com/librenms/librenms/pull/3815))
    - Improved look of device SLA panel ([PR3831](https://github.com/librenms/librenms/pull/3831))
    - Added more colours to Cisco CBQOS graphs ([PR3842](https://github.com/librenms/librenms/pull/3842))
    - Improved look of Cisco IPSEC Tunnels page ([PR3874](https://github.com/librenms/librenms/pull/3874))
  - Discovery / Polling
    - Added ability to set Max repeaters per device ([PR3781](https://github.com/librenms/librenms/pull/3781))
  - Applications
    - Moved all application scripts to librenms/librenms-agent repo ([PR3865](https://github.com/librenms/librenms/pull/3865), [PR3886](https://github.com/librenms/librenms/pull/3886))
    - Added NFS stats ([PR3792](https://github.com/librenms/librenms/pull/3792), [PR3853](https://github.com/librenms/librenms/pull/3853))
    - Added PowerDNS Recursor ([PR3869](https://github.com/librenms/librenms/pull/3869))
  - Alerting
    - Updated format for Slack alerts ([PR3852](https://github.com/librenms/librenms/pull/3852))
    - Added support for multiple emails in sysContact and users table ([PR3885](https://github.com/librenms/librenms/pull/3885))
    - Added ability to use uptime in alert templates ([PR3893](https://github.com/librenms/librenms/pull/3893))
  - Misc
    - Added date to git version info ([PR3782](https://github.com/librenms/librenms/pull/3782))
    - Added logging of versions when upgrading ([PR3807](https://github.com/librenms/librenms/pull/3807))
    - Added ability to lookup device from IP for syslog ([PR3812](https://github.com/librenms/librenms/pull/3812))
    - Updated component system ([PR3821](https://github.com/librenms/librenms/pull/3821))
    - Improvements to validate script ([PR3840](https://github.com/librenms/librenms/pull/3840), [PR3868](https://github.com/librenms/librenms/pull/3868))

### June 2016

#### Bug fixes
  - WebUI:
    - Rename $ds to $ldap_connection for auth modules ([PR3596](https://github.com/librenms/librenms/pull/3596))
    - Fix the display of custom snmp ports ([PR3646](https://github.com/librenms/librenms/pull/3646))
    - Fix bugs in Create new / edit alert templates ([PR3651](https://github.com/librenms/librenms/pull/3651))
    - Fixed ajax_ calls for use with base_url ([PR3661](https://github.com/librenms/librenms/pull/3661))
    - Updated old frontpage to use new services format ([PR3691](https://github.com/librenms/librenms/pull/3691))
    - Order alerts by state to indicate which alerts are open ([PR3692](https://github.com/librenms/librenms/pull/3692))
    - Fixed maintenance windows showing as lapsed ([PR3704](https://github.com/librenms/librenms/pull/3704))
    - Removed duplicated dbInsert from dashboard creation ([PR3761](https://github.com/librenms/librenms/pull/3761))
    - Fixed 95th for graphs ([PR3762](https://github.com/librenms/librenms/pull/3762))
  - Polling / Discovery:
    - Updated Poweralert divisor to 10 for sensors ([PR3645](https://github.com/librenms/librenms/pull/3645))
    - Fixed NX-OS version polling ([PR3688](https://github.com/librenms/librenms/pull/3688))
    - Fixed STP log spam from Mikrotik device ([PR3689](https://github.com/librenms/librenms/pull/3689))
    - Removed " from ZyWall version number ([PR3693](https://github.com/librenms/librenms/pull/3693))
    - Updated register_mib to use d_echo ([PR3739](https://github.com/librenms/librenms/pull/3739))
    - Fixed invalid SQL for BGP Discovery ([PR3742](https://github.com/librenms/librenms/pull/3742))
  - Alerting:
    - Unacknowledged alerts will now continue to send alerts ([PR3667](https://github.com/librenms/librenms/pull/3667))
  - Misc:
    - Fix smokeping path in gen_smokeping ([PR3577](https://github.com/librenms/librenms/pull/3577))
    - Fix full include path in includes/polling/functions.inc.php ([PR3614](https://github.com/librenms/librenms/pull/3614))
    - Added port_id to tune_port.php query ([PR3753](https://github.com/librenms/librenms/pull/3753))
    - Updated port schema to support > 17.1 Gbs for _rate values ([PR3754](https://github.com/librenms/librenms/pull/3754))

#### Improvements
  - Added / improved detection for:
    - HPE 3Par ([PR3578](https://github.com/librenms/librenms/pull/3578))
    - Buffalo TeraStation ([PR3587](https://github.com/librenms/librenms/pull/3587))
    - Samsung C printers ([PR3598](https://github.com/librenms/librenms/pull/3598))
    - Roomalert3e ([PR3599](https://github.com/librenms/librenms/pull/3599))
    - Avtech Switches ([PR3611](https://github.com/librenms/librenms/pull/3611))
    - IBM Bladecenter switches ([PR3623](https://github.com/librenms/librenms/pull/3623))
    - HWg support ([PR3624](https://github.com/librenms/librenms/pull/3624))
    - IBM IMM ([PR3625](https://github.com/librenms/librenms/pull/3625))
    - ServerTech Sentry4 PDUs ([PR3659](https://github.com/librenms/librenms/pull/3659))
    - SwOS ([PR3662](https://github.com/librenms/librenms/pull/3662))
    - Sophos (R3678, [PR3679](https://github.com/librenms/librenms/pull/3679), [PR3736](https://github.com/librenms/librenms/pull/3736))
    - OSX El Capitan ([PR3690](https://github.com/librenms/librenms/pull/3690))
    - DNOS ([PR3703](https://github.com/librenms/librenms/pull/3703), [PR3730](https://github.com/librenms/librenms/pull/3730))
    - Cisco SB SG200 ([PR3705](https://github.com/librenms/librenms/pull/3705))
    - EMC FlareOS ([PR3712](https://github.com/librenms/librenms/pull/3712))
    - Enhance Brocade Fabric OS ([PR3712](https://github.com/librenms/librenms/pull/3712))
    - Huawei SmartAX ([PR3737](https://github.com/librenms/librenms/pull/3737))
  - Polling / Discovery:
    - Use lsb_release in distro script ([PR3580](https://github.com/librenms/librenms/pull/3580))
    - Allow lmsensors fanspeeds of 0 to be discovered ([PR3616](https://github.com/librenms/librenms/pull/3616))
    - Added support for rrdcached application monitoring ([PR3627](https://github.com/librenms/librenms/pull/3627))
    - Improve the output of polling/debug to make it easier to see modules ([PR3694](https://github.com/librenms/librenms/pull/3694))
  - WebUI:
    - Resolve some reported security issues ([PR3586](https://github.com/librenms/librenms/pull/3586)) With thanks to https://twitter.com/wireghoul
    - Order apps list alphabetically ([PR3600](https://github.com/librenms/librenms/pull/3600))
    - Network map improvements ([PR3602](https://github.com/librenms/librenms/pull/3602))
    - Added support for varying hostname formats in Oxidized integration ([PR3617](https://github.com/librenms/librenms/pull/3617))
    - Added device hw/location on hover in alerts table ([PR3621](https://github.com/librenms/librenms/pull/3621))
    - Updated unpolled notification to link directly to those devices ([PR3696](https://github.com/librenms/librenms/pull/3696))
    - Added ability to search via IP for Graylog integration ([PR3697](https://github.com/librenms/librenms/pull/3697))
    - Optimised network map SQL ([PR3715](https://github.com/librenms/librenms/pull/3715))
    - Added support for wildcards in custom graph groups ([PR3722](https://github.com/librenms/librenms/pull/3722))
    - Added ability to override ifSpeed for ports ([PR3752](https://github.com/librenms/librenms/pull/3752))
    - Added sysName to global search ([PR3757](https://github.com/librenms/librenms/pull/3757))
  - Alerting:
    - Added ability to use location in alert templates ([PR3652](https://github.com/librenms/librenms/pull/3652))
  - Documentation:
    - Added docs on Auto discovery ([PR3671](https://github.com/librenms/librenms/pull/3671))
    - Updated InfluxDB docs ([PR3673](https://github.com/librenms/librenms/pull/3673))
    - Updated distributed polling docs ([PR3675](https://github.com/librenms/librenms/pull/3675))
    - Updated FAQs ([PR3677](https://github.com/librenms/librenms/pull/3677))
  - Misc:
    - Added pivot table for device groups ready for V2 ([PR3589](https://github.com/librenms/librenms/pull/3589))
    - Added device_id column to eventlog ([PR3682](https://github.com/librenms/librenms/pull/3682))
    - Cleanup sensors and related tables + added constraints ([PR3745](https://github.com/librenms/librenms/pull/3745))

### May 2016

#### Bug fixes
  - WebUI:
    - Fixed broken performance charts using VisJS ([PR3479](https://github.com/librenms/librenms/pull/3479))
    - Fixed include path to file in create alert item ([PR3480](https://github.com/librenms/librenms/pull/3480))
    - Updated services box on front page to utilise the new services ([PR3481](https://github.com/librenms/librenms/pull/3481))
    - Potential fix for intermittent logouts ([PR3372](https://github.com/librenms/librenms/pull/3372))
    - Updated sensors hostname to use correct variable ([PR3485](https://github.com/librenms/librenms/pull/3485))
  - Polling / Discovery:
    - Only poll AirMAX if device supports the MIB ([PR3486](https://github.com/librenms/librenms/pull/3486))
  - Alerting:
    - Don't alert unless the sensor value surpasses the threshold ([PR3507](https://github.com/librenms/librenms/pull/3507))

#### Improvements
  - Added / improved detection for:
    - Microsemo timing devices ([PR3453](https://github.com/librenms/librenms/pull/3453))
    - Bintec smart routers ([PR3454](https://github.com/librenms/librenms/pull/3454))
    - PoweWalker support ([PR3456](https://github.com/librenms/librenms/pull/3456))
    - BDCom support ([PR3459](https://github.com/librenms/librenms/pull/3459))
    - Cisco WAPs ([PR3460](https://github.com/librenms/librenms/pull/3460))
    - EMC Data domain ([PR3461](https://github.com/librenms/librenms/pull/3461))
    - Xerox support ([PR3462](https://github.com/librenms/librenms/pull/3462))
    - Calix support ([PR3463](https://github.com/librenms/librenms/pull/3463))
    - Isilon OneFS ([PR3482](https://github.com/librenms/librenms/pull/3482))
    - Ricoh printers ([PR3483](https://github.com/librenms/librenms/pull/3483))
    - HP Virtual Connect ([PR3487](https://github.com/librenms/librenms/pull/3487))
    - Equallogic arrays + Dell servers ([PR3519](https://github.com/librenms/librenms/pull/3519))
    - Alcatel-Lucent SR + SAR ([PR3535](https://github.com/librenms/librenms/pull/3535), [PR3553](https://github.com/librenms/librenms/pull/3553))
    - Xirrus Wireless Access Points ([PR3543](https://github.com/librenms/librenms/pull/3543))
  - Polling / Discovery:
    - Add config option to stop devices with duplicate sysName's being added ([PR3473](https://github.com/librenms/librenms/pull/3473))
    - Enable discovery support of CDP neighbours by IP ([PR3561](https://github.com/librenms/librenms/pull/3561))
  - Alerting:
    - Added ability to use sysName in templates ([PR3470](https://github.com/librenms/librenms/pull/3470))
    - Send Slack alerts as pure JSON ([PR3522](https://github.com/librenms/librenms/pull/3522))
    - Apply colour to HipChat messages ([PR3539](https://github.com/librenms/librenms/pull/3539))
  - WebUI:
    - Added ability to filter alerts by state ([PR3471](https://github.com/librenms/librenms/pull/3471))
    - Added support for using local openstreet map tiles ([PR3472](https://github.com/librenms/librenms/pull/3472))
    - Added ability to show services on availability map ([PR3496](https://github.com/librenms/librenms/pull/3496))
    - Added combined auth module for http auth and AD auth ([PR3531](https://github.com/librenms/librenms/pull/3531))
    - List services alphabetically ([PR3538](https://github.com/librenms/librenms/pull/3538))
    - Added support for scrollable widgets ([PR3565](https://github.com/librenms/librenms/pull/3565))
  - Graphs:
    - Added Hit/Misses for memcached graphs ([PR3499](https://github.com/librenms/librenms/pull/3499))
  - API:
    - Update get_graph_generic_by_hostname to use device_id as well ([PR3494](https://github.com/librenms/librenms/pull/3494))
  - Docs:
    - Added configuration for SNMP Proxy support ([PR3528](https://github.com/librenms/librenms/pull/3528))
  - Misc:
    - Added purge for alert log ([PR3469](https://github.com/librenms/librenms/pull/3469))

### April 2016

#### Bug fixes
  - Discovery / Polling:
    - Fix poweralert OS detection ([PR3414](https://github.com/librenms/librenms/pull/3414))
  - WebUI:
    - Fixed headers for varying ajax calls ([PR3432](https://github.com/librenms/librenms/pull/3432), [PR3433](https://github.com/librenms/librenms/pull/3433), [PR3434](https://github.com/librenms/librenms/pull/3434), [PR3435](https://github.com/librenms/librenms/pull/3435))
  - Misc:
    - Update syslog to support incorrect time ([PR3348](https://github.com/librenms/librenms/pull/3348))
    - Fixed InfluxDB to send data as int/float ([PR3354](https://github.com/librenms/librenms/pull/3354))
    - Small bug fixes to the services update ([PR3366](https://github.com/librenms/librenms/pull/3366), [PR3396](https://github.com/librenms/librenms/pull/3396), [PR3425](https://github.com/librenms/librenms/pull/3425), [PR3426](https://github.com/librenms/librenms/pull/3426), [PR3427](https://github.com/librenms/librenms/pull/3427))
    - Fix bug with obtaining data for new bills in some scenarios ([PR3404](https://github.com/librenms/librenms/pull/3404))
    - Improved PHP 7 support ([PR3417](https://github.com/librenms/librenms/pull/3417))
    - Fix urls within billing section for sub dir support ([PR3442](https://github.com/librenms/librenms/pull/3442))

#### Improvements
  - WebUI:
    - Update rancid file detection ([PR3341](https://github.com/librenms/librenms/pull/3341))
    - Make graphs in widgets clickable ([PR3355](https://github.com/librenms/librenms/pull/3355))
    - Add config option to set the typeahead results ([PR3363](https://github.com/librenms/librenms/pull/3363))
    - Add config option to set min graph height ([PR3410](https://github.com/librenms/librenms/pull/3410))
  - Discovery / Polling:
    - Updated Infoblox mibs and logo ([PR3340](https://github.com/librenms/librenms/pull/3340))
    - Updated arp discovery to support vrf lite ([PR3359](https://github.com/librenms/librenms/pull/3359))
    - Added RSSI and MNC for Cisco WWAN routers ([PR3371](https://github.com/librenms/librenms/pull/3371))
    - Updated DNOS and added CPU, Memory and Temp ([PR3391](https://github.com/librenms/librenms/pull/3391), [PR3393](https://github.com/librenms/librenms/pull/3393), [PR3395](https://github.com/librenms/librenms/pull/3395))
    - Added PoE state support for Netonix devices ([PR3416](https://github.com/librenms/librenms/pull/3416))
    - Added ability to exclude ports via ifName and ifAlias regex ([PR3439](https://github.com/librenms/librenms/pull/3439))
  - Added detection for:
    - Viprenet routers ([PR3365](https://github.com/librenms/librenms/pull/3365))
    - FreeBSD via distro script ([PR3399](https://github.com/librenms/librenms/pull/3399))
  - Documentation:
    - Updated nginx install docs ([PR3397](https://github.com/librenms/librenms/pull/3397))
    - Added FAQ on renaming hosts ([PR3444](https://github.com/librenms/librenms/pull/3444))
  - API:
    - Added call for IPsec tunnels ([PR3411](https://github.com/librenms/librenms/pull/3411))
  - Misc:
    - Added check_mk FreeBSD agent support ([PR3406](https://github.com/librenms/librenms/pull/3406))
    - Added suggestion to fix files not owned by correct user to validate.php ([PR3415](https://github.com/librenms/librenms/pull/3415))
    - Added detection for missing timezone to validate.php ([PR3428](https://github.com/librenms/librenms/pull/3428))
    - Added detection for install_dir config and local git repo issues to validate.php ([PR3440](https://github.com/librenms/librenms/pull/3440))

### March 2016

#### Bug fixes
  - WebUI:
    - Skip authentication check in graph.php if unauth graphs is enabled ([PR3019](https://github.com/librenms/librenms/pull/3019))
    - Stop double escaping notes for devices ([PR3149](https://github.com/librenms/librenms/pull/3149))
    - Corrected aggregate graph on smokeping page ([PR3177](https://github.com/librenms/librenms/pull/3177))
    - Fix non-admin syslog queries ([PR3191](https://github.com/librenms/librenms/pull/3191))
    - Fix services SQL ([PR3205](https://github.com/librenms/librenms/pull/3205))
  - Discovery / Polling:
    - Revert arp discovery to pre-vrf lite support ([PR3126](https://github.com/librenms/librenms/pull/3126))
    - Fix IOS-XR DBM sensors ([PR3291](https://github.com/librenms/librenms/pull/3291))
  - Alerting:
    - Fix alert failure response from transports ([PR3283](https://github.com/librenms/librenms/pull/3283))
  - Misc:
    - Fix data in bills if counters doesn't change ([PR3132](https://github.com/librenms/librenms/pull/3132))
    - Improve performance of billing poller ([PR3129](https://github.com/librenms/librenms/pull/3129))
    - Fix API tokens when using LDAP auth ([PR3178](https://github.com/librenms/librenms/pull/3178))
    - Import notifications with original datetime ([PR3200](https://github.com/librenms/librenms/pull/3200))
    - Add sysName for top-interfaces widget ([PR3201](https://github.com/librenms/librenms/pull/3201))
    - Fix Cisco syslog parsing when logging timestamp enabled ([PR3203](https://github.com/librenms/librenms/pull/3203))

#### Improvements
  - WebUI:
    - Added ability to show device group specific maps ([PR3018](https://github.com/librenms/librenms/pull/3018))
    - Updated Billing UI ([PR3194](https://github.com/librenms/librenms/pull/3194), [PR3195](https://github.com/librenms/librenms/pull/3195), [PR3216](https://github.com/librenms/librenms/pull/3216), [PR3239](https://github.com/librenms/librenms/pull/3239), [PR3240](https://github.com/librenms/librenms/pull/3240))
    - Added Juniper
    - Added config option for HTML emails in mail transport ([PR3221](https://github.com/librenms/librenms/pull/3221))
  - Discovery / Polling:
    - Added Juniper state support ([PR3121](https://github.com/librenms/librenms/pull/3121))
    - Added Ironware state support ([PR3160](https://github.com/librenms/librenms/pull/3160))
    - Check sysObjectID before detecting ILO temp sensors ([PR3204](https://github.com/librenms/librenms/pull/3204))
    - Improved Avtech support ([PR3207](https://github.com/librenms/librenms/pull/3207))
    - Improved Dell NOS detection ([PR3213](https://github.com/librenms/librenms/pull/3213))
    - Added Juniper alarm state monitoring ([PR3226](https://github.com/librenms/librenms/pull/3226))
    - Updated Drac state support ([PR3228](https://github.com/librenms/librenms/pull/3228))
    - Improved serial # detection for Brocade Ironware devices ([PR3292](https://github.com/librenms/librenms/pull/3292))
  - Added detection for:
    - Develop Ineo printers ([PR3224](https://github.com/librenms/librenms/pull/3224))
    - Cumulus Linux ([PR3237](https://github.com/librenms/librenms/pull/3237))
    - Deliberant WiFi ([PR3246](https://github.com/librenms/librenms/pull/3246))
    - Juniper EX2500 ([PR3254](https://github.com/librenms/librenms/pull/3254))
    - Cambium devices ([PR3279](https://github.com/librenms/librenms/pull/3279))
  - Alerting:
    - Added Canopsis alerting transport ([PR3299](https://github.com/librenms/librenms/pull/3299))
  - Misc:
    - Improved syslog support ([PR3171](https://github.com/librenms/librenms/pull/3171), [PR3172](https://github.com/librenms/librenms/pull/3172), [PR3173](https://github.com/librenms/librenms/pull/3173))
    - Added Nginx install docs for Debian/Ubuntu ([PR3301](https://github.com/librenms/librenms/pull/3301))
    - Updated InfluxDB php module ([PR3302](https://github.com/librenms/librenms/pull/3302))
    - Updated Component API ([PR3304](https://github.com/librenms/librenms/pull/3304))

### February 2016

#### Bug fixes
  - Discovery / Polling:
    - Quote snmp v2c community ([PR2927](https://github.com/librenms/librenms/pull/2927))
    - For entity-sensor, changed variable name again ([PR2948](https://github.com/librenms/librenms/pull/2948))
    - Fix some issues with/introduced by port association mode configuration ([PR2923](https://github.com/librenms/librenms/pull/2923))
    - Deal with 0 value sensors better ([PR2972](https://github.com/librenms/librenms/pull/2972), [PR2973](https://github.com/librenms/librenms/pull/2973))
    - Reverted Fortigate CPU change from Dec 2015 ([PR2990](https://github.com/librenms/librenms/pull/2990))
    - Reverted bgp code from vrf lite support ([PR3010](https://github.com/librenms/librenms/pull/3010), [PR3011](https://github.com/librenms/librenms/pull/3011), [PR3028](https://github.com/librenms/librenms/pull/3028), [PR3050](https://github.com/librenms/librenms/pull/3050))
    - Add icon to database ([PR3076](https://github.com/librenms/librenms/pull/3076))
    - Discovery updated to check for distributed polling group ([PR3086](https://github.com/librenms/librenms/pull/3086))
  - WebUI:
    - Fix ceph graps ([PR2909](https://github.com/librenms/librenms/pull/2909), [PR2942](https://github.com/librenms/librenms/pull/2942))
    - BGP Overlib ([PR2915](https://github.com/librenms/librenms/pull/2915))
    - Added `application/json` headers where json is returned ([PR2936](https://github.com/librenms/librenms/pull/2936), [PR2961](https://github.com/librenms/librenms/pull/2961))
    - Stop realtime graph page from auto refreshing ([PR2939](https://github.com/librenms/librenms/pull/2939))
    - Updated parsing of alert rules to allow `|` ([PR2917](https://github.com/librenms/librenms/pull/2917))
    - Fix IP Display ([PR2951](https://github.com/librenms/librenms/pull/2951))
    - Added missing from email config option ([PR2986](https://github.com/librenms/librenms/pull/2986))
    - Ignore devices that do not provide an uptime statistic ([PR3009](https://github.com/librenms/librenms/pull/3009))
    - Added unique id for alert widget ([PR3034](https://github.com/librenms/librenms/pull/3034))
  - Misc:
    - Updated `device_by_id_cache()` to convert IP column ([PR2940](https://github.com/librenms/librenms/pull/2940))
    - Fixed auto updating if not enabled ([PR3063](https://github.com/librenms/librenms/pull/3063))
  - Documentation:
    - Removed devloping doc as none of the info is current ([PR2911](https://github.com/librenms/librenms/pull/2911))

#### Improvements
  - WebUI:
    - Merged device option links to dropdown ([PR2955](https://github.com/librenms/librenms/pull/2955))
    - Added ability to configure # results for global search ([PR2957](https://github.com/librenms/librenms/pull/2957))
    - Added ability to show / hide line numbers for config for devices ([PR2988](https://github.com/librenms/librenms/pull/2988))
    - Added support for showing diff for Oxidized configs ([PR2994](https://github.com/librenms/librenms/pull/2994))
    - Updated visjs to 4.14.0 ([PR3031](https://github.com/librenms/librenms/pull/3031))
    - Updated apps layout to use panels ([PR3117](https://github.com/librenms/librenms/pull/3117))
  - Discovery / Polling:
    - Added VRF Lite support ([PR2820](https://github.com/librenms/librenms/pull/2820))
    - Added ability to ignore device sensors from entity mib ([PR2862](https://github.com/librenms/librenms/pull/2862))
    - Added `ifOperStatus_prev` and `ifAdminStatus_prev` values to db ([PR2912](https://github.com/librenms/librenms/pull/2912))
    - Improved bgpPolling efficiency ([PR2967](https://github.com/librenms/librenms/pull/2967))
    - Use raw timeticks for uptime ([PR3021](https://github.com/librenms/librenms/pull/3021))
    - Introduced state monitoring ([PR3102](https://github.com/librenms/librenms/pull/3102))
  - Added detection for:
    - Dell Networking N2048 ([PR2949](https://github.com/librenms/librenms/pull/2949))
    - Calix E7 devices ([PR2958](https://github.com/librenms/librenms/pull/2958))
    - Improved support for Netonix ([PR2959](https://github.com/librenms/librenms/pull/2959))
    - Improved detection for Windows 10 ([PR2962](https://github.com/librenms/librenms/pull/2962))
    - Improved support for FortiOS ([PR2991](https://github.com/librenms/librenms/pull/2991))
    - Barracuda Spam firewall support ([PR2998](https://github.com/librenms/librenms/pull/2998))
    - Improved sysDescr parsing for Unifi Switches ([PR3020](https://github.com/librenms/librenms/pull/3020))
    - Canon iR ([PR3045](https://github.com/librenms/librenms/pull/3045))
    - Cisco SF500 ([PR3057](https://github.com/librenms/librenms/pull/3057))
    - Eaton UPS ([PR3066](https://github.com/librenms/librenms/pull/3066), [PR3067](https://github.com/librenms/librenms/pull/3067), [PR3070](https://github.com/librenms/librenms/pull/3070), [PR3071](https://github.com/librenms/librenms/pull/3071))
    - ServerIron / ServerIron ADX ([PR3074](https://github.com/librenms/librenms/pull/3074))
    - Additional Qnap sensors ([PR3088](https://github.com/librenms/librenms/pull/3088), [PR3089](https://github.com/librenms/librenms/pull/3089))
    - Avtech environment sensors ([PR3091](https://github.com/librenms/librenms/pull/3091))
  - Misc:
    - Added check for rrd vadility ([PR2908](https://github.com/librenms/librenms/pull/2908))
    - Add systemd unit file for the python poller service ([PR2913](https://github.com/librenms/librenms/pull/2913))
    - Added more detection to validate for bad installs ([PR2985](https://github.com/librenms/librenms/pull/2985))
    - Syslog cleanup ([PR3036](https://github.com/librenms/librenms/pull/3036), [PR3093](https://github.com/librenms/librenms/pull/3093), [PR3099](https://github.com/librenms/librenms/pull/3099))
  - Documentation:
    -  Added description of AD configuration options ([PR2910](https://github.com/librenms/librenms/pull/2910))
    -  Add description to mibbases polling ([PR2919](https://github.com/librenms/librenms/pull/2919))

### January 2016

#### Bug fixes
  - Discovery / Polling:
    - Ignore HC Broadcast and Multicast counters for Cisco SB ([PR2552](https://github.com/librenms/librenms/pull/2552))
    - Fix Cisco temperature discovery ([PR2765](https://github.com/librenms/librenms/pull/2765))
  - WebUI:
    - Fix ajax_search.php returning null instead of [] ([PR2695](https://github.com/librenms/librenms/pull/2695))
    - Fix notification links ([PR2721](https://github.com/librenms/librenms/pull/2721))
    - Fix wrong suggestion to install PEAR in Web installer ([PR2727](https://github.com/librenms/librenms/pull/2727))
    - Fixed mysqli support for Web installer ([PR2730](https://github.com/librenms/librenms/pull/2730))
  - Misc:
    - Fix deleting device_perf entries ([PR2755](https://github.com/librenms/librenms/pull/2755))
    - Fix for schema updates to device table when poller is running ([PR2825](https://github.com/librenms/librenms/pull/2825))

#### Improvements
  - WebUI:
    - Converted arp pages to use bootgrid ([PR2669](https://github.com/librenms/librenms/pull/2669))
    - Updated VMWare listing page ([PR2684](https://github.com/librenms/librenms/pull/2684))
    - Updated typeahead.js ([PR2698](https://github.com/librenms/librenms/pull/2698))
    - Added ability to set notes for ports ([PR2688](https://github.com/librenms/librenms/pull/2688))
    - Use browser width to scale CPU and Bandwidth graphs ([PR2537](https://github.com/librenms/librenms/pull/2537), [PR2633](https://github.com/librenms/librenms/pull/2633))
    - Removed onClick from ports list ([PR2744](https://github.com/librenms/librenms/pull/2744))
    - Added support for showing sysName when hostname is IP ([PR2796](https://github.com/librenms/librenms/pull/2796))
    - Updated rancid support for different hostnames ([PR2807](https://github.com/librenms/librenms/pull/2807))
    - Added combined HTTP Auth and LDAP Auth authentication module ([PR2835](https://github.com/librenms/librenms/pull/2835))
    - Added ability to filter alerts using widgets ([PR2834](https://github.com/librenms/librenms/pull/2834))
  - Discovery / Polling:
    - Print runtime info per poller/discovery modules ([PR2713](https://github.com/librenms/librenms/pull/2713))
    - Improved polling/discovery vmware module performance ([PR2696](https://github.com/librenms/librenms/pull/2696))
    - Added STP/RSTP support ([PR2690](https://github.com/librenms/librenms/pull/2690))
    - Moved system poller module to core module ([PR2637](https://github.com/librenms/librenms/pull/2637))
    - Added lookup of IP for devices with hostname ([PR2798](https://github.com/librenms/librenms/pull/2798))
    - Centralised sensors module file structure ([PR2794](https://github.com/librenms/librenms/pull/2794))
    - Graph poller module run times ([PR2849](https://github.com/librenms/librenms/pull/2849))
    - Updated vlan support using IEEE8021-Q-BRIDGE-MIB ([PR2851](https://github.com/librenms/librenms/pull/2851))
  - Added detection for:
    - Added support for Samsung printers ([PR2680](https://github.com/librenms/librenms/pull/2680))
    - Added support for Canon printers ([PR2687](https://github.com/librenms/librenms/pull/2687))
    - Added support for Sub10 support ([PR2469](https://github.com/librenms/librenms/pull/2469))
    - Added support for Zyxel GS range ([PR2729](https://github.com/librenms/librenms/pull/2729))
    - Added support for HWGroup Poseidon ([PR2742](https://github.com/librenms/librenms/pull/2742))
    - Added support for Samsung SCX printers ([PR2760](https://github.com/librenms/librenms/pull/2760))
    - Added additional support for HP MSM ([PR2766](https://github.com/librenms/librenms/pull/2766), [PR2768](https://github.com/librenms/librenms/pull/2768))
    - Added additional support for Cisco ASA and RouterOS ([PR2784](https://github.com/librenms/librenms/pull/2784))
    - Added support for Lenovo EMC NAS ([PR2795](https://github.com/librenms/librenms/pull/2795))
    - Added support for Infoblox ([PR2801](https://github.com/librenms/librenms/pull/2801))
  - API:
    - Added support for Oxidized groups ([PR2745](https://github.com/librenms/librenms/pull/2745))
  - Misc:
    - Added option to specify Smokeping ping value ([PR2676](https://github.com/librenms/librenms/pull/2676))
    - Added backend support for InfluxDB ([PR2208](https://github.com/librenms/librenms/pull/2208))
    - Alpha2 release of MIB Polling released ([PR2536](https://github.com/librenms/librenms/pull/2536), [PR2763](https://github.com/librenms/librenms/pull/2763))
    - Centralised version info ([PR2697](https://github.com/librenms/librenms/pull/2697))
    - Added username support for libvirt over SSH ([PR2728](https://github.com/librenms/librenms/pull/2728))
    - Added Oxidized reload call when adding device ([PR2792](https://github.com/librenms/librenms/pull/2792))
    - Added components system to centralize data in MySQL ([PR2623](https://github.com/librenms/librenms/pull/2623))
