/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class TelicProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("dddd").number("(d{6}|d{15})").number("(d{1,2}),").number("d{12},").number("d+,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").groupBegin().number("(ddd)(dd)(dddd),").number("(dd)(dd)(dddd),").or().number("(-?d+),").number("(-?d+),").groupEnd().number("(d),").number("(d+),").number("(d+),").number("(d+)?,").expression("(?:[^,]*,){7}").number("(d+),").any().compile();

    public TelicProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int eventId) {
        switch (eventId) {
            case 1: {
                return "powerOn";
            }
            case 2: {
                return "sos";
            }
            case 5: {
                return "powerOff";
            }
            case 7: {
                return "geofenceEnter";
            }
            case 8: {
                return "geofenceExit";
            }
            case 22: {
                return "lowBattery";
            }
            case 25: {
                return "movement";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        int event = parser.nextInt(0);
        position.set("event", event);
        position.set("alarm", this.decodeAlarm(event));
        if (event == 11) {
            position.set("ignition", true);
        } else if (event == 12) {
            position.set("ignition", false);
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        if (parser.hasNext(6)) {
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN));
        }
        if (parser.hasNext(2)) {
            position.setLongitude(parser.nextDouble(0.0) / 10000.0);
            position.setLatitude(parser.nextDouble(0.0) / 10000.0);
        }
        position.setValid(parser.nextInt(0) != 1);
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext()) {
            position.set("sat", parser.nextInt(0));
        }
        position.set("battery", parser.nextInt(0));
        return position;
    }
}

