/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class AlematicsProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$T,").number("(d+),").number("(d+),").number("(d+),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+.d),").number("(d+),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(d+),").groupBegin().text("0,$S,").expression("(.*)").or().number("(d+),").expression("(.*)").or().any().groupEnd().compile();

    public AlematicsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeExtras(Position position, Parser parser) {
        int mask = parser.nextInt();
        String[] data = parser.next().split(",");
        int index = 0;
        if (BitUtil.check(mask, 0)) {
            ++index;
        }
        if (BitUtil.check(mask, 1)) {
            position.set("power", Integer.parseInt(data[index++]));
        }
        if (BitUtil.check(mask, 2)) {
            position.set("battery", Integer.parseInt(data[index++]));
        }
        if (BitUtil.check(mask, 3)) {
            position.set("obdSpeed", Integer.parseInt(data[index++]));
        }
        if (BitUtil.check(mask, 4)) {
            position.set("rpm", Integer.parseInt(data[index++]));
        }
        if (BitUtil.check(mask, 5)) {
            position.set("rssi", Integer.parseInt(data[index++]));
        }
        if (BitUtil.check(mask, 6)) {
            ++index;
        }
        if (BitUtil.check(mask, 7)) {
            ++index;
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("type", parser.nextInt());
        position.set("index", parser.nextInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setFixTime(parser.nextDateTime());
        position.setDeviceTime(parser.nextDateTime());
        position.setValid(true);
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt(0)));
        position.setCourse(parser.nextInt(0));
        position.setAltitude(parser.nextInt(0));
        position.set("hdop", parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("input", parser.nextInt());
        position.set("output", parser.nextInt());
        position.set("adc1", parser.nextDouble());
        position.set("power", parser.nextDouble());
        position.set("odometer", parser.nextInt());
        if (parser.hasNext()) {
            position.set("text", parser.next());
        } else if (parser.hasNext()) {
            this.decodeExtras(position, parser);
        }
        return position;
    }
}

