/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.traccar.database.DataManager;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.Driver;

public class DriversManager
extends ExtendedObjectManager<Driver> {
    private Map<String, Driver> driversByUniqueId;

    public DriversManager(DataManager dataManager) {
        super(dataManager, Driver.class);
        if (this.driversByUniqueId == null) {
            this.driversByUniqueId = new ConcurrentHashMap<String, Driver>();
        }
    }

    private void putUniqueDriverId(Driver driver) {
        if (this.driversByUniqueId == null) {
            this.driversByUniqueId = new ConcurrentHashMap<String, Driver>(this.getAllItems().size());
        }
        this.driversByUniqueId.put(driver.getUniqueId(), driver);
    }

    @Override
    protected void addNewItem(Driver driver) {
        super.addNewItem(driver);
        this.putUniqueDriverId(driver);
    }

    @Override
    protected void updateCachedItem(Driver driver) {
        Driver cachedDriver = (Driver)this.getById(driver.getId());
        cachedDriver.setName(driver.getName());
        if (!driver.getUniqueId().equals(cachedDriver.getUniqueId())) {
            this.driversByUniqueId.remove(cachedDriver.getUniqueId());
            cachedDriver.setUniqueId(driver.getUniqueId());
            this.putUniqueDriverId(cachedDriver);
        }
        cachedDriver.setAttributes(driver.getAttributes());
    }

    @Override
    protected void removeCachedItem(long driverId) {
        Driver cachedDriver = (Driver)this.getById(driverId);
        if (cachedDriver != null) {
            String driverUniqueId = cachedDriver.getUniqueId();
            super.removeCachedItem(driverId);
            this.driversByUniqueId.remove(driverUniqueId);
        }
    }

    public Driver getDriverByUniqueId(String uniqueId) {
        return this.driversByUniqueId.get(uniqueId);
    }
}

