/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.geocoder.Geocoder;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class GeocoderHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeocoderHandler.class);
    private final Geocoder geocoder;
    private final boolean processInvalidPositions;
    private final int geocoderReuseDistance;

    public GeocoderHandler(Geocoder geocoder, boolean processInvalidPositions) {
        this.geocoder = geocoder;
        this.processInvalidPositions = processInvalidPositions;
        this.geocoderReuseDistance = Context.getConfig().getInteger("geocoder.reuseDistance", 0);
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) throws Exception {
        if (message instanceof Position) {
            final Position position = (Position)message;
            if (this.processInvalidPositions || position.getValid()) {
                Position lastPosition;
                if (this.geocoderReuseDistance != 0 && (lastPosition = Context.getIdentityManager().getLastPosition(position.getDeviceId())) != null && lastPosition.getAddress() != null && position.getDouble("distance") <= (double)this.geocoderReuseDistance) {
                    position.setAddress(lastPosition.getAddress());
                    ctx.fireChannelRead((Object)position);
                    return;
                }
                Context.getStatisticsManager().registerGeocoderRequest();
                this.geocoder.getAddress(position.getLatitude(), position.getLongitude(), new Geocoder.ReverseGeocoderCallback(){

                    @Override
                    public void onSuccess(String address) {
                        position.setAddress(address);
                        ctx.fireChannelRead((Object)position);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        LOGGER.warn("Geocoding failed", e);
                        ctx.fireChannelRead((Object)position);
                    }
                });
            } else {
                ctx.fireChannelRead((Object)position);
            }
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

