/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.autoupdate.members;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;

public class MemberUtils {
    private static final Logger LOG = Logger.getLogger("au.com.trgtd.tr.autoupdate.members");
    private static final String MEMBER_UC_NAME = "tr-member-uc";
    private static final String MEMBER_UC_DISPLAY_NAME = "ThinkingRock Member Update Center";
    private static final String MEMBER_UC_URL_STRING = "http://www.trgtd.com.au/tr/updates/2.2/updates.xml";
    private static final String MEMBER_BETA_UC_NAME = "tr-member-beta-uc";
    private static final String MEMBER_BETA_UC_DISPLAY_NAME = "ThinkingRock Member BETA Update Center";
    private static final String MEMBER_BETA_UC_URL_STRING = "http://www.trgtd.com.au/tr/updates/2.2/beta/updates.xml";
    private static final String GET_PASSWORD_PHP_URL_STRING = "http://www.trgtd.com.au/tr/php/getpass.php";
    private static final int CONNECTION_TIMEOUT_MS = 10000;
    private static MemberUtils instance;
    private URL GET_PASSWORD_PHP_URL;
    private URL MEMBER_UC_URL;
    private URL MEMBER_BETA_UC_URL;

    private MemberUtils() {
        try {
            this.MEMBER_UC_URL = new URL(MEMBER_UC_URL_STRING);
        }
        catch (MalformedURLException ex) {
            LOG.severe("MalformedURLException for URL: http://www.trgtd.com.au/tr/updates/2.2/updates.xml");
        }
        try {
            this.MEMBER_BETA_UC_URL = new URL(MEMBER_BETA_UC_URL_STRING);
        }
        catch (MalformedURLException ex) {
            LOG.severe("MalformedURLException for URL: http://www.trgtd.com.au/tr/updates/2.2/beta/updates.xml");
        }
        try {
            this.GET_PASSWORD_PHP_URL = new URL(GET_PASSWORD_PHP_URL_STRING);
        }
        catch (Exception ex) {
            LOG.severe("MalformedURLException for URL: http://www.trgtd.com.au/tr/php/getpass.php");
        }
    }

    public static MemberUtils getDefault() {
        if (instance == null) {
            instance = new MemberUtils();
        }
        return instance;
    }

    public UpdateUnitProvider getMemberUpdateCenter() {
        if (this.MEMBER_UC_URL == null) {
            return null;
        }
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getProviderURL().equals(this.MEMBER_UC_URL)) continue;
            return uup;
        }
        return null;
    }

    public synchronized void removeMemberUpdateCenter() {
        LOG.info("Started removing member update center at: " + new Date());
        if (this.MEMBER_UC_URL == null) {
            return;
        }
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getProviderURL().equals(this.MEMBER_UC_URL)) continue;
            f.remove(uup);
            LOG.info("Member update center removed.");
            break;
        }
        LOG.info("Finished removing member update center at: " + new Date());
    }

    public UpdateUnitProvider createMemberUpdateCenter() {
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        UpdateUnitProvider p = f.create(MEMBER_UC_NAME, MEMBER_UC_DISPLAY_NAME, this.MEMBER_UC_URL);
        LOG.info("Member update center created.");
        return p;
    }

    public UpdateUnitProvider getMemberBetaUpdateCenter() {
        if (this.MEMBER_BETA_UC_URL == null) {
            return null;
        }
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getProviderURL().equals(this.MEMBER_BETA_UC_URL)) continue;
            return uup;
        }
        return null;
    }

    public void removeMemberBetaUpdateCenter() {
        LOG.info("Started removing member beta update center at: " + new Date());
        if (this.MEMBER_BETA_UC_URL == null) {
            return;
        }
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        for (UpdateUnitProvider uup : f.getUpdateUnitProviders(false)) {
            if (!uup.getProviderURL().equals(this.MEMBER_BETA_UC_URL)) continue;
            f.remove(uup);
            LOG.info("Member beta update center removed.");
            break;
        }
        LOG.info("Finished removing member beta update center at: " + new Date());
    }

    public UpdateUnitProvider createMemberBetaUpdateCenter() {
        UpdateUnitProviderFactory f = UpdateUnitProviderFactory.getDefault();
        UpdateUnitProvider p = f.create(MEMBER_BETA_UC_NAME, MEMBER_BETA_UC_DISPLAY_NAME, this.MEMBER_BETA_UC_URL);
        LOG.info("Member beta update center created.");
        return p;
    }

    public Boolean isMember(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return false;
        }
        if (password == null || password.trim().length() == 0) {
            return false;
        }
        if (this.GET_PASSWORD_PHP_URL == null) {
            return null;
        }
        URLConnection conn = this.getURLConnection(this.GET_PASSWORD_PHP_URL);
        if (conn == null) {
            return null;
        }
        String dbPassword = this.getDBPassword(conn, username);
        if (dbPassword == null) {
            return null;
        }
        if (dbPassword.length() == 0) {
            return false;
        }
        return this.comparePasswords(dbPassword, password);
    }

    private URLConnection getURLConnection(URL url) {
        LOG.info("Started getting URL connection at: " + new Date());
        try {
            URLConnection conn = url.openConnection();
            LOG.info("Connection timeout default: " + conn.getConnectTimeout());
            conn.setConnectTimeout(10000);
            LOG.info("Connection timeout changed: " + conn.getConnectTimeout());
            LOG.info("Finished getting URL connection at: " + new Date());
            return conn;
        }
        catch (IOException ex) {
            LOG.info("Could not open connection to URL: " + url.toString());
            return null;
        }
    }

    private final String getDBPassword(URLConnection conn, String username) {
        LOG.info("Started getting DB password at: " + new Date());
        String password = null;
        try {
            conn.setDoOutput(true);
            String data = URLEncoder.encode("u", "UTF-8") + "=" + URLEncoder.encode(username, "UTF-8");
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            password = rd.readLine();
            if (password == null) {
                password = "";
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            LOG.info("Could not get DB password at: " + new Date());
            return null;
        }
        LOG.info("Finished getting DB password at: " + new Date());
        return password;
    }

    private boolean comparePasswords(String dbPassword, String password) {
        String[] parts = dbPassword.split(":");
        if (parts.length != 2) {
            LOG.info("Password does not have correct format.");
            return false;
        }
        String pass = parts[0];
        String salt = parts[1];
        return pass.equals(this.getMd5Digest(password + salt));
    }

    private final String getMd5Digest(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            return number.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

