/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.analysis.TokenTypeUtils;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="StopWordLabelFilter")
public class StopWordLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        short[] termTypes = context.allWords.type;
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        return !TokenTypeUtils.isCommon(termTypes[wordIndices[0]]) && !TokenTypeUtils.isCommon(termTypes[wordIndices[wordIndices.length - 1]]);
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return !TokenTypeUtils.isCommon(context.allWords.type[wordIndex]);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

