/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackendFactory;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private final AtomicInteger usage = new AtomicInteger(0);
    private final ReentrantLock countLock = new ReentrantLock();
    private final Condition full = this.countLock.newCondition();
    private int maxCapacity = 200;
    private final ConcurrentMap<URI, RrdEntry> pool = new ConcurrentHashMap<URI, RrdEntry>(200);
    private final RrdBackendFactory defaultFactory;

    public static RrdDbPool getInstance() {
        return RrdDbPoolSingletonHolder.instance;
    }

    RrdDbPool() {
        if (!(RrdBackendFactory.getDefaultFactory() instanceof RrdFileBackendFactory)) {
            throw new RuntimeException("Cannot create instance of " + this.getClass().getName() + " with a default backend factory not derived from RrdFileBackendFactory");
        }
        this.defaultFactory = RrdBackendFactory.getDefaultFactory();
    }

    public int getOpenFileCount() {
        return this.usage.get();
    }

    public URI[] getOpenUri() {
        HashSet files = new HashSet();
        files.addAll(this.pool.keySet());
        return files.toArray(new URI[0]);
    }

    public String[] getOpenFiles() {
        HashSet<String> files = new HashSet<String>();
        for (RrdEntry i : this.pool.values()) {
            files.add(i.rrdDb.getPath());
        }
        return files.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RrdEntry getEntry(URI uri, boolean cancreate) throws IOException, InterruptedException {
        do {
            if ((ref = (RrdEntry)this.pool.get(uri)) == null) {
                try {
                    this.countLock.lockInterruptibly();
                    while (ref == null && this.usage.get() >= this.maxCapacity && cancreate) {
                        this.full.await();
                        ref = (RrdEntry)this.pool.get(uri);
                    }
                    if (ref != null || !cancreate || (ref = this.pool.putIfAbsent(uri, new RrdEntry(true, uri))) != null) ** GOTO lbl23
                    ref = new RrdEntry(false, uri);
                    this.usage.incrementAndGet();
                }
                finally {
                    if (this.countLock.isHeldByCurrentThread()) {
                        this.countLock.unlock();
                    }
                }
            } else {
                if (!ref.placeholder) {
                    if (this.pool.replace(uri, ref, new RrdEntry(true, uri))) continue;
                    ref = new RrdEntry(true, uri);
                    continue;
                }
                ref.inuse.await();
            }
lbl23:
            // 5 sources

        } while (ref != null && ref.placeholder);
        return ref;
    }

    private void passNext(ACTION a, RrdEntry e) {
        RrdEntry o = null;
        switch (a) {
            case SWAP: {
                o = this.pool.put(e.uri, e);
                break;
            }
            case DROP: {
                o = (RrdEntry)this.pool.remove(e.uri);
                if (this.usage.decrementAndGet() >= this.maxCapacity) break;
                try {
                    this.countLock.lockInterruptibly();
                    this.full.signalAll();
                    this.countLock.unlock();
                    break;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (o != null) {
            o.inuse.countDown();
        }
    }

    public void release(RrdDb rrdDb) throws IOException {
        RrdEntry ref;
        if (rrdDb == null) {
            return;
        }
        URI dburi = rrdDb.getUri();
        try {
            ref = this.getEntry(dburi, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("release interrupted for " + rrdDb, e);
        }
        if (ref == null) {
            return;
        }
        if (ref.count <= 0) {
            this.passNext(ACTION.DROP, ref);
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], the file was never requested");
        }
        if (--ref.count == 0) {
            if (ref.rrdDb == null) {
                this.passNext(ACTION.DROP, ref);
                throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], pool corruption");
            }
            ref.rrdDb.close();
            this.passNext(ACTION.DROP, ref);
            ref.waitempty.countDown();
        } else {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    public RrdDb requestRrdDb(String path) throws IOException {
        return this.requestRrdDb(this.defaultFactory.getUri(path), this.defaultFactory);
    }

    public RrdDb requestRrdDb(URI uri) throws IOException {
        RrdBackendFactory factory = RrdBackendFactory.findFactory(uri);
        return this.requestRrdDb(uri, factory);
    }

    private RrdDb requestRrdDb(URI uri, RrdBackendFactory factory) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(uri, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for " + uri, e);
        }
        if (ref.count == 0) {
            try {
                ref.rrdDb = new RrdDb(factory.getPath(uri), factory);
            }
            catch (IOException e) {
                this.passNext(ACTION.DROP, ref);
                throw e;
            }
        }
        ++ref.count;
        this.passNext(ACTION.SWAP, ref);
        return ref.rrdDb;
    }

    private RrdEntry waitEmpty(URI uri) throws IOException, InterruptedException {
        RrdEntry ref = this.getEntry(uri, true);
        try {
            while (ref.count != 0) {
                this.passNext(ACTION.SWAP, ref);
                ref.waitempty.await();
                ref = this.getEntry(uri, true);
            }
            return ref;
        }
        catch (InterruptedException e) {
            this.passNext(ACTION.DROP, ref);
            throw e;
        }
    }

    private RrdEntry requestEmpty(URI uri) throws InterruptedException, IOException {
        RrdEntry ref = this.waitEmpty(uri);
        ref.count = 1;
        return ref;
    }

    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        RrdEntry ref = null;
        try {
            URI uri = RrdBackendFactory.findFactory(rrdDef.getUri()).getCanonicalUri(rrdDef.getUri());
            ref = this.requestEmpty(uri);
            RrdDb rrdDb = ref.rrdDb = new RrdDb(rrdDef);
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
            return rrdDb;
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                throw new RuntimeException("request interrupted for new rrdDef " + rrdDef.getPath(), e);
            }
            catch (Throwable throwable) {
                if (ref != null) {
                    this.passNext(ACTION.SWAP, ref);
                }
                throw throwable;
            }
        }
    }

    public RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.requestEmpty(this.defaultFactory.getUri(path));
            RrdDb rrdDb = ref.rrdDb = new RrdDb(path, sourcePath);
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for new rrd " + path, e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    public RrdDb requestRrdDb(URI uri, String sourcePath) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.requestEmpty(uri);
            RrdDb rrdDb = ref.rrdDb = new RrdDb(uri, sourcePath);
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for new rrd " + uri, e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    public void setCapacity(int newCapacity) {
        int oldUsage = this.usage.getAndSet(this.maxCapacity);
        try {
            if (oldUsage != 0) {
                throw new RuntimeException("Can only be done on a empty pool");
            }
        }
        finally {
            this.usage.set(oldUsage);
        }
        this.maxCapacity = newCapacity;
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public int getOpenCount(RrdDb rrdDb) throws IOException {
        return this.getOpenCount(rrdDb.getUri());
    }

    public int getOpenCount(String path) throws IOException {
        return this.getOpenCount(this.defaultFactory.getUri(path));
    }

    public int getOpenCount(URI uri) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(uri, false);
            if (ref == null) {
                int n = 0;
                return n;
            }
            int n = ref.count;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("getOpenCount interrupted", e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    private static enum ACTION {
        SWAP,
        DROP;

    }

    private static class RrdEntry {
        RrdDb rrdDb = null;
        int count = 0;
        final CountDownLatch waitempty;
        final CountDownLatch inuse;
        final boolean placeholder;
        final URI uri;

        RrdEntry(boolean placeholder, URI canonicalPath) {
            this.placeholder = placeholder;
            this.uri = canonicalPath;
            if (placeholder) {
                this.inuse = new CountDownLatch(1);
                this.waitempty = null;
            } else {
                this.inuse = null;
                this.waitempty = new CountDownLatch(1);
            }
        }
    }

    private static class RrdDbPoolSingletonHolder {
        static final RrdDbPool instance = new RrdDbPool();

        private RrdDbPoolSingletonHolder() {
        }
    }
}

