/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ReplicaListTransformer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShufflingReplicaListTransformer;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.stats.InstrumentedHttpListenerFactory;
import org.apache.solr.util.stats.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized,
SolrMetricProducer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String DEFAULT_SCHEME = "http";
    private ExecutorService commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue(), (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"), false);
    protected volatile Http2SolrClient defaultClient;
    protected InstrumentedHttpListenerFactory httpListenerFactory;
    private LBHttp2SolrClient loadbalancer;
    int corePoolSize = 0;
    int maximumPoolSize = Integer.MAX_VALUE;
    int keepAliveTime = 5;
    int queueSize = -1;
    int permittedLoadBalancerRequestsMinimumAbsolute = 0;
    float permittedLoadBalancerRequestsMaximumFraction = 1.0f;
    boolean accessPolicy = false;
    private WhitelistHostChecker whitelistHostChecker = null;
    private String scheme = null;
    private InstrumentedHttpListenerFactory.NameStrategy metricNameStrategy;
    protected final Random r = new Random();
    private final ReplicaListTransformer shufflingReplicaListTransformer = new ShufflingReplicaListTransformer(this.r);
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE = "loadBalancerRequestsMinimumAbsolute";
    static final String LOAD_BALANCER_REQUESTS_MAX_FRACTION = "loadBalancerRequestsMaximumFraction";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";
    public static final String INIT_SHARDS_WHITELIST = "shardsWhitelist";
    static final String INIT_SOLR_DISABLE_SHARDS_WHITELIST = "solr.disable.shardsWhitelist";
    static final String SET_SOLR_DISABLE_SHARDS_WHITELIST_CLUE = " set -Dsolr.disable.shardsWhitelist=true to disable shards whitelist checks";

    @Override
    public ShardHandler getShardHandler() {
        return this.getShardHandler(this.defaultClient);
    }

    public ShardHandler getShardHandler(Http2SolrClient httpClient) {
        return new HttpShardHandler(this, httpClient);
    }

    @Deprecated
    public ShardHandler getShardHandler(final HttpClient httpClient) {
        return new HttpShardHandler(this, null){

            @Override
            protected NamedList<Object> request(String url, SolrRequest req) throws IOException, SolrServerException {
                try (HttpSolrClient client = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(url).withHttpClient(httpClient)).build();){
                    NamedList namedList = client.request(req);
                    return namedList;
                }
            }
        };
    }

    public WhitelistHostChecker getWhitelistHostChecker() {
        return this.whitelistHostChecker;
    }

    @Deprecated
    static boolean doGetDisableShardsWhitelist() {
        return HttpShardHandlerFactory.getDisableShardsWhitelist();
    }

    private static boolean getDisableShardsWhitelist() {
        return Boolean.getBoolean(INIT_SOLR_DISABLE_SHARDS_WHITELIST);
    }

    @Override
    public void init(PluginInfo info) {
        StringBuilder sb = new StringBuilder();
        NamedList args = info.initArgs;
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, null, sb);
        if (StringUtils.endsWith((String)this.scheme, (String)"://")) {
            this.scheme = StringUtils.removeEnd((String)this.scheme, (String)"://");
        }
        String strategy = this.getParameter(args, "metricNameStrategy", "queryLessURLAndMethod", sb);
        this.metricNameStrategy = InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.get(strategy);
        if (this.metricNameStrategy == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown metricNameStrategy: " + strategy + " found. Must be one of: " + InstrumentedHttpListenerFactory.KNOWN_METRIC_NAME_STRATEGIES.keySet());
        }
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, this.corePoolSize, sb);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, this.maximumPoolSize, sb);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, this.keepAliveTime, sb);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, this.queueSize, sb);
        this.permittedLoadBalancerRequestsMinimumAbsolute = this.getParameter(args, LOAD_BALANCER_REQUESTS_MIN_ABSOLUTE, this.permittedLoadBalancerRequestsMinimumAbsolute, sb);
        this.permittedLoadBalancerRequestsMaximumFraction = this.getParameter(args, LOAD_BALANCER_REQUESTS_MAX_FRACTION, Float.valueOf(this.permittedLoadBalancerRequestsMaximumFraction), sb).floatValue();
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, this.accessPolicy, sb);
        this.whitelistHostChecker = new WhitelistHostChecker(args == null ? null : (String)args.get(INIT_SHARDS_WHITELIST), !HttpShardHandlerFactory.getDisableShardsWhitelist());
        log.info("Host whitelist initialized: {}", (Object)this.whitelistHostChecker);
        log.debug("created with {}", (Object)sb);
        String v = System.getProperty("tests.shardhandler.randomSeed");
        if (v != null) {
            this.r.setSeed(Long.parseLong(v));
        }
        AbstractQueue blockingQueue = this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy);
        this.commExecutor = new ExecutorUtil.MDCAwareThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, (long)this.keepAliveTime, TimeUnit.SECONDS, blockingQueue, (ThreadFactory)new DefaultSolrThreadFactory("httpShardExecutor"));
        this.httpListenerFactory = new InstrumentedHttpListenerFactory(this.metricNameStrategy);
        int connectionTimeout = this.getParameter(args, "connTimeout", 60000, sb);
        int maxConnectionsPerHost = this.getParameter(args, "maxConnectionsPerHost", 100000, sb);
        int soTimeout = this.getParameter(args, "socketTimeout", 600000, sb);
        this.defaultClient = new Http2SolrClient.Builder().connectionTimeout(connectionTimeout).idleTimeout(soTimeout).maxConnectionsPerHost(maxConnectionsPerHost).build();
        this.defaultClient.addListenerFactory((HttpListenerFactory)this.httpListenerFactory);
        this.loadbalancer = new LBHttp2SolrClient(this.defaultClient, new String[0]);
    }

    @Override
    public void setSecurityBuilder(HttpClientBuilderPlugin clientBuilderPlugin) {
        clientBuilderPlugin.setup(this.defaultClient);
    }

    protected <T> T getParameter(NamedList initArgs, String configKey, T defaultValue, StringBuilder sb) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            T t = toReturn = temp != null ? temp : defaultValue;
        }
        if (sb != null && toReturn != null) {
            sb.append(configKey).append(" : ").append(toReturn).append(",");
        }
        return toReturn;
    }

    @Override
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.commExecutor);
        }
        finally {
            try {
                if (this.loadbalancer != null) {
                    this.loadbalancer.close();
                }
            }
            finally {
                if (this.defaultClient != null) {
                    IOUtils.closeQuietly((Closeable)this.defaultClient);
                }
            }
        }
    }

    public LBSolrClient.Rsp makeLoadBalancedRequest(QueryRequest req, List<String> urls) throws SolrServerException, IOException {
        return this.loadbalancer.request(this.newLBHttpSolrClientReq(req, urls));
    }

    protected LBSolrClient.Req newLBHttpSolrClientReq(QueryRequest req, List<String> urls) {
        int numServersToTry = (int)Math.floor((float)urls.size() * this.permittedLoadBalancerRequestsMaximumFraction);
        if (numServersToTry < this.permittedLoadBalancerRequestsMinimumAbsolute) {
            numServersToTry = this.permittedLoadBalancerRequestsMinimumAbsolute;
        }
        return new LBSolrClient.Req((SolrRequest)req, urls, Integer.valueOf(numServersToTry));
    }

    public List<String> buildURLList(String shard) {
        List urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
        for (int i = 0; i < urls.size(); ++i) {
            urls.set(i, this.buildUrl((String)urls.get(i)));
        }
        return urls;
    }

    protected ReplicaListTransformer getReplicaListTransformer(final SolrQueryRequest req) {
        SolrParams params = req.getParams();
        boolean preferLocalShards = params.getBool("preferLocalShards", false);
        String shardsPreferenceSpec = params.get("shards.preference", "");
        if (preferLocalShards || !shardsPreferenceSpec.isEmpty()) {
            if (preferLocalShards && !shardsPreferenceSpec.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "preferLocalShards is deprecated and must not be used with shards.preference");
            }
            final List preferenceRules = StrUtils.splitSmart((String)shardsPreferenceSpec, (char)',');
            if (preferLocalShards) {
                preferenceRules.add("replica.location:local");
            }
            return new ShufflingReplicaListTransformer(this.r){

                @Override
                public void transform(List<?> choices) {
                    if (choices.size() > 1) {
                        super.transform(choices);
                        if (log.isDebugEnabled()) {
                            log.debug("Applying the following sorting preferences to replicas: {}", (Object)Arrays.toString(preferenceRules.toArray()));
                        }
                        try {
                            choices.sort(new NodePreferenceRulesComparator(preferenceRules, req));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, iae.getMessage());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Applied sorting preferences to replica list: {}", (Object)Arrays.toString(choices.toArray()));
                        }
                    }
                }
            };
        }
        return this.shufflingReplicaListTransformer;
    }

    public CompletionService newCompletionService() {
        return new ExecutorCompletionService(this.commExecutor);
    }

    private String buildUrl(String url) {
        if (!URLUtil.hasScheme((String)url)) {
            return StringUtils.defaultIfEmpty((String)this.scheme, (String)DEFAULT_SCHEME) + "://" + url;
        }
        if (StringUtils.isNotEmpty((String)this.scheme)) {
            return this.scheme + "://" + URLUtil.removeScheme((String)url);
        }
        return url;
    }

    @Override
    public void initializeMetrics(SolrMetricManager manager, String registry, String tag, String scope) {
        String expandedScope = SolrMetricManager.mkName(scope, SolrInfoBean.Category.QUERY.name());
        this.httpListenerFactory.initializeMetrics(manager, registry, tag, expandedScope);
        this.commExecutor = MetricUtils.instrumentedExecutorService(this.commExecutor, null, manager.registry(registry), SolrMetricManager.mkName("httpShardExecutor", expandedScope, "threadPool"));
    }

    public static class WhitelistHostChecker {
        private final Set<String> whitelistHosts;
        private final boolean whitelistHostCheckingEnabled;

        public WhitelistHostChecker(String whitelistStr, boolean enabled) {
            this.whitelistHosts = WhitelistHostChecker.implGetShardsWhitelist(whitelistStr);
            this.whitelistHostCheckingEnabled = enabled;
        }

        static final Set<String> implGetShardsWhitelist(String shardsWhitelist) {
            if (shardsWhitelist != null && !shardsWhitelist.isEmpty()) {
                return StrUtils.splitSmart((String)shardsWhitelist, (char)',').stream().map(String::trim).map(hostUrl -> {
                    URL url;
                    try {
                        url = !hostUrl.startsWith("http://") && !hostUrl.startsWith("https://") ? new URL("http://" + hostUrl) : new URL((String)hostUrl);
                    }
                    catch (MalformedURLException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid URL syntax in \"shardsWhitelist\": " + shardsWhitelist, (Throwable)e);
                    }
                    if (url.getHost() == null || url.getPort() < 0) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid URL syntax in \"shardsWhitelist\": " + shardsWhitelist);
                    }
                    return url.getHost() + ":" + url.getPort();
                }).collect(Collectors.toSet());
            }
            return null;
        }

        protected void checkWhitelist(String shardsParamValue, List<String> shardUrls) {
            this.checkWhitelist(null, shardsParamValue, shardUrls);
        }

        protected void checkWhitelist(ClusterState clusterState, String shardsParamValue, List<String> shardUrls) {
            if (!this.whitelistHostCheckingEnabled) {
                return;
            }
            Set<Object> localWhitelistHosts = this.whitelistHosts == null && clusterState != null ? this.generateWhitelistFromLiveNodes(clusterState) : (this.whitelistHosts != null ? this.whitelistHosts : Collections.emptySet());
            shardUrls.stream().map(String::trim).forEach(shardUrl -> {
                URL url;
                try {
                    url = !shardUrl.startsWith("http://") && !shardUrl.startsWith("https://") ? new URL("http://" + shardUrl) : new URL((String)shardUrl);
                }
                catch (MalformedURLException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid URL syntax in \"shards\" parameter: " + shardsParamValue, (Throwable)e);
                }
                if (url.getHost() == null || url.getPort() < 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid URL syntax in \"shards\" parameter: " + shardsParamValue);
                }
                if (!localWhitelistHosts.contains(url.getHost() + ":" + url.getPort())) {
                    log.warn("The 'shards' parameter value '" + shardsParamValue + "' contained value(s) not on the shards whitelist (" + localWhitelistHosts + "), shardUrl:" + shardUrl);
                    throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "The 'shards' parameter value '" + shardsParamValue + "' contained value(s) not on the shards whitelist. shardUrl:" + shardUrl + "." + HttpShardHandlerFactory.SET_SOLR_DISABLE_SHARDS_WHITELIST_CLUE);
                }
            });
        }

        Set<String> generateWhitelistFromLiveNodes(ClusterState clusterState) {
            return clusterState.getLiveNodes().stream().map(liveNode -> liveNode.substring(0, liveNode.indexOf(95))).collect(Collectors.toSet());
        }

        public boolean hasExplicitWhitelist() {
            return this.whitelistHosts != null;
        }

        public boolean isWhitelistHostCheckingEnabled() {
            return this.whitelistHostCheckingEnabled;
        }

        @VisibleForTesting
        Set<String> getWhitelistHosts() {
            return this.whitelistHosts;
        }

        public String toString() {
            return "WhitelistHostChecker [whitelistHosts=" + this.whitelistHosts + ", whitelistHostCheckingEnabled=" + this.whitelistHostCheckingEnabled + "]";
        }
    }

    static class NodePreferenceRulesComparator
    implements Comparator<Object> {
        private final SolrQueryRequest request;
        private List<PreferenceRule> preferenceRules;
        private String localHostAddress = null;

        public NodePreferenceRulesComparator(List<String> sortRules, SolrQueryRequest request) {
            this.request = request;
            this.preferenceRules = new ArrayList<PreferenceRule>(sortRules.size());
            sortRules.forEach(rule -> {
                String[] parts = rule.split(":", 2);
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Invalid shards.preference rule: " + rule);
                }
                this.preferenceRules.add(new PreferenceRule(parts[0], parts[1]));
            });
        }

        @Override
        public int compare(Object left, Object right) {
            for (PreferenceRule preferenceRule : this.preferenceRules) {
                boolean rhs;
                boolean lhs;
                switch (preferenceRule.name) {
                    case "replica.type": {
                        lhs = NodePreferenceRulesComparator.hasReplicaType(left, preferenceRule.value);
                        rhs = NodePreferenceRulesComparator.hasReplicaType(right, preferenceRule.value);
                        break;
                    }
                    case "replica.location": {
                        lhs = this.hasCoreUrlPrefix(left, preferenceRule.value);
                        rhs = this.hasCoreUrlPrefix(right, preferenceRule.value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid shards.preference type: " + preferenceRule.name);
                    }
                }
                if (lhs == rhs) continue;
                return lhs ? -1 : 1;
            }
            return 0;
        }

        private boolean hasCoreUrlPrefix(Object o, String prefix) {
            String s;
            if (o instanceof String) {
                s = (String)o;
            } else if (o instanceof Replica) {
                s = ((Replica)o).getCoreUrl();
            } else {
                return false;
            }
            if (prefix.equals("local")) {
                if (null == this.localHostAddress) {
                    ZkController zkController = this.request.getCore().getCoreContainer().getZkController();
                    String string = this.localHostAddress = zkController != null ? zkController.getBaseUrl() : "";
                    if (this.localHostAddress.isEmpty()) {
                        log.warn("Couldn't determine current host address for sorting of local replicas");
                    }
                }
                if (!this.localHostAddress.isEmpty() && s.startsWith(this.localHostAddress)) {
                    return true;
                }
            } else if (s.startsWith(prefix)) {
                return true;
            }
            return false;
        }

        private static boolean hasReplicaType(Object o, String preferred) {
            if (!(o instanceof Replica)) {
                return false;
            }
            String s = ((Replica)o).getType().toString();
            return s.equals(preferred);
        }

        private static class PreferenceRule {
            public final String name;
            public final String value;

            public PreferenceRule(String name, String value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

