/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import com.google.common.base.Objects;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.util.DateMathParser;
import org.apache.solr.util.TimeZoneUtils;

public class TimeRoutedAlias {
    public static final String ROUTER_PREFIX = "router.";
    public static final String ROUTER_TYPE_NAME = "router.name";
    public static final String ROUTER_FIELD = "router.field";
    public static final String ROUTER_START = "router.start";
    public static final String ROUTER_INTERVAL = "router.interval";
    public static final String ROUTER_MAX_FUTURE = "router.maxFutureMs";
    public static final String ROUTER_PREEMPTIVE_CREATE_MATH = "router.preemptiveCreateMath";
    public static final String ROUTER_AUTO_DELETE_AGE = "router.autoDeleteAge";
    public static final String CREATE_COLLECTION_PREFIX = "create-collection.";
    public static final List<String> REQUIRED_ROUTER_PARAMS = Collections.unmodifiableList(Arrays.asList("name", "router.name", "router.field", "router.start", "router.interval"));
    public static final List<String> OPTIONAL_ROUTER_PARAMS = Collections.unmodifiableList(Arrays.asList("router.maxFutureMs", "router.autoDeleteAge", "router.preemptiveCreateMath", "TZ"));
    static Predicate<String> PARAM_IS_PROP = key -> key.equals("TZ") || key.startsWith(ROUTER_PREFIX) && !key.equals(ROUTER_START) || key.startsWith(CREATE_COLLECTION_PREFIX);
    public static final String ROUTED_ALIAS_NAME_CORE_PROP = "routedAliasName";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendPattern("[_HH[_mm[_ss]]]").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter(Locale.ROOT).withZone(ZoneOffset.UTC);
    private final String aliasName;
    private final String routeField;
    private final String intervalMath;
    private final long maxFutureMs;
    private final String preemptiveCreateMath;
    private final String autoDeleteAgeMath;
    private final TimeZone timeZone;

    public static Instant parseInstantFromCollectionName(String aliasName, String collection) {
        String dateTimePart = collection.substring(aliasName.length() + 1);
        return DATE_TIME_FORMATTER.parse((CharSequence)dateTimePart, Instant::from);
    }

    public static String formatCollectionNameFromInstant(String aliasName, Instant timestamp) {
        String nextCollName = DATE_TIME_FORMATTER.format(timestamp);
        for (int i = 0; i < 3; ++i) {
            if (!nextCollName.endsWith("_00")) continue;
            nextCollName = nextCollName.substring(0, nextCollName.length() - 3);
        }
        assert (DATE_TIME_FORMATTER.parse((CharSequence)nextCollName, Instant::from).equals(timestamp));
        return aliasName + "_" + nextCollName;
    }

    public TimeRoutedAlias(String aliasName, Map<String, String> aliasMetadata) {
        this.aliasName = aliasName;
        MapSolrParams params = new MapSolrParams(aliasMetadata);
        RequiredSolrParams required = params.required();
        if (!"time".equals(required.get(ROUTER_TYPE_NAME))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only 'time' routed aliases is supported right now.");
        }
        this.routeField = required.get(ROUTER_FIELD);
        this.intervalMath = required.get(ROUTER_INTERVAL);
        this.maxFutureMs = params.getLong(ROUTER_MAX_FUTURE, TimeUnit.MINUTES.toMillis(10L));
        String pcmTmp = params.get(ROUTER_PREEMPTIVE_CREATE_MATH);
        this.preemptiveCreateMath = pcmTmp != null ? (pcmTmp.startsWith("-") ? pcmTmp : "-" + pcmTmp) : null;
        this.autoDeleteAgeMath = params.get(ROUTER_AUTO_DELETE_AGE);
        this.timeZone = TimeZoneUtils.parseTimezone(aliasMetadata.get("TZ"));
        Date now = new Date();
        try {
            Date after = new DateMathParser(now, this.timeZone).parseMath(this.intervalMath);
            if (!after.after(now)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must add to produce a time in the future");
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.interval, " + e, (Throwable)e);
        }
        if (this.autoDeleteAgeMath != null) {
            try {
                Date before = new DateMathParser(now, this.timeZone).parseMath(this.autoDeleteAgeMath);
                if (now.before(before)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "duration must round or subtract to produce a time in the past");
                }
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "bad router.autoDeleteAge, " + e, (Throwable)e);
            }
        }
        if (this.preemptiveCreateMath != null) {
            try {
                new DateMathParser().parseMath(this.preemptiveCreateMath);
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid date math for preemptiveCreateMath:" + this.preemptiveCreateMath);
            }
        }
        if (this.maxFutureMs < 0L) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxFutureMs must be >= 0");
        }
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getRouteField() {
        return this.routeField;
    }

    public String getIntervalMath() {
        return this.intervalMath;
    }

    public long getMaxFutureMs() {
        return this.maxFutureMs;
    }

    public String getPreemptiveCreateWindow() {
        return this.preemptiveCreateMath;
    }

    public String getAutoDeleteAgeMath() {
        return this.autoDeleteAgeMath;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("aliasName", (Object)this.aliasName).add("routeField", (Object)this.routeField).add("intervalMath", (Object)this.intervalMath).add("maxFutureMs", this.maxFutureMs).add("preemptiveCreateMath", (Object)this.preemptiveCreateMath).add("autoDeleteAgeMath", (Object)this.autoDeleteAgeMath).add("timeZone", (Object)this.timeZone).toString();
    }

    public List<Map.Entry<Instant, String>> parseCollections(Aliases aliases, Supplier<SolrException> aliasNotExist) {
        List collections = (List)aliases.getCollectionAliasListMap().get(this.aliasName);
        if (collections == null) {
            throw aliasNotExist.get();
        }
        ArrayList<Map.Entry<Instant, String>> result = new ArrayList<Map.Entry<Instant, String>>(collections.size());
        for (String collection : collections) {
            Instant colStartTime = TimeRoutedAlias.parseInstantFromCollectionName(this.aliasName, collection);
            result.add(new AbstractMap.SimpleImmutableEntry<Instant, String>(colStartTime, collection));
        }
        result.sort((e1, e2) -> ((Instant)e2.getKey()).compareTo((Instant)e1.getKey()));
        return result;
    }

    public Instant computeNextCollTimestamp(Instant fromTimestamp) {
        Instant nextCollTimestamp = DateMathParser.parseMath(Date.from(fromTimestamp), "NOW" + this.intervalMath, this.timeZone).toInstant();
        assert (nextCollTimestamp.isAfter(fromTimestamp));
        return nextCollTimestamp;
    }
}

