/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.OverseerMessageHandler;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.noggit.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerConfigSetMessageHandler
implements OverseerMessageHandler {
    public static final String CONFIGSETS_ACTION_PREFIX = "configsets:";
    public static final String BASE_CONFIGSET = "baseConfigSet";
    public static final String PROPERTY_PREFIX = "configSetProp";
    private ZkStateReader zkStateReader;
    private final Set configSetWriteWip;
    private final Set configSetReadWip;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public OverseerConfigSetMessageHandler(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.configSetWriteWip = new HashSet();
        this.configSetReadWip = new HashSet();
    }

    @Override
    public SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList results = new NamedList();
        try {
            if (!operation.startsWith(CONFIGSETS_ACTION_PREFIX)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Operation does not contain proper prefix: " + operation + " expected: " + CONFIGSETS_ACTION_PREFIX);
            }
            operation = operation.substring(CONFIGSETS_ACTION_PREFIX.length());
            log.info("OverseerConfigSetMessageHandler.processMessage : " + operation + " , " + message.toString());
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)operation);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            switch (action) {
                case CREATE: {
                    this.createConfigSet(message);
                    break;
                }
                case DELETE: {
                    this.deleteConfigSet(message);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
                }
            }
        }
        catch (Exception e) {
            String configSetName = message.getStr("name");
            if (configSetName == null) {
                SolrException.log((Logger)log, (String)("Operation " + operation + " failed"), (Throwable)e);
            } else {
                SolrException.log((Logger)log, (String)("ConfigSet: " + configSetName + " operation: " + operation + " failed"), (Throwable)e);
            }
            results.add("Operation " + operation + " caused exception:", (Object)e);
            SimpleOrderedMap nl = new SimpleOrderedMap();
            nl.add("msg", (Object)e.getMessage());
            nl.add("rspCode", (Object)(e instanceof SolrException ? ((SolrException)((Object)e)).code() : -1));
            results.add("exception", (Object)nl);
        }
        return new OverseerSolrResponse(results);
    }

    @Override
    public String getName() {
        return "Overseer ConfigSet Message Handler";
    }

    @Override
    public String getTimerName(String operation) {
        return "configset_" + operation;
    }

    @Override
    public OverseerMessageHandler.Lock lockTask(ZkNodeProps message, OverseerTaskProcessor.TaskBatch taskBatch) {
        String configSetName = this.getTaskKey(message);
        if (this.canExecute(configSetName, message)) {
            this.markExclusiveTask(configSetName, message);
            return () -> this.unmarkExclusiveTask(configSetName, message);
        }
        return null;
    }

    @Override
    public String getTaskKey(ZkNodeProps message) {
        return message.getStr("name");
    }

    private void markExclusiveTask(String configSetName, ZkNodeProps message) {
        String baseConfigSet = this.getBaseConfigSetIfCreate(message);
        this.markExclusive(configSetName, baseConfigSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markExclusive(String configSetName, String baseConfigSetName) {
        Set set = this.configSetWriteWip;
        synchronized (set) {
            this.configSetWriteWip.add(configSetName);
            if (baseConfigSetName != null) {
                this.configSetReadWip.add(baseConfigSetName);
            }
        }
    }

    private void unmarkExclusiveTask(String configSetName, ZkNodeProps message) {
        String baseConfigSet = this.getBaseConfigSetIfCreate(message);
        this.unmarkExclusiveConfigSet(configSetName, baseConfigSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkExclusiveConfigSet(String configSetName, String baseConfigSetName) {
        Set set = this.configSetWriteWip;
        synchronized (set) {
            this.configSetWriteWip.remove(configSetName);
            if (baseConfigSetName != null) {
                this.configSetReadWip.remove(baseConfigSetName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canExecute(String configSetName, ZkNodeProps message) {
        String baseConfigSetName = this.getBaseConfigSetIfCreate(message);
        Set set = this.configSetWriteWip;
        synchronized (set) {
            if (this.configSetWriteWip.contains(configSetName) || this.configSetReadWip.contains(configSetName)) {
                return false;
            }
            if (baseConfigSetName != null && this.configSetWriteWip.contains(baseConfigSetName)) {
                return false;
            }
        }
        return true;
    }

    private String getBaseConfigSetIfCreate(ZkNodeProps message) {
        ConfigSetParams.ConfigSetAction action;
        String operation = message.getStr("operation");
        if (operation != null && (action = ConfigSetParams.ConfigSetAction.get((String)(operation = operation.substring(CONFIGSETS_ACTION_PREFIX.length())))) == ConfigSetParams.ConfigSetAction.CREATE) {
            String baseConfigSetName = message.getStr(BASE_CONFIGSET);
            if (baseConfigSetName == null || baseConfigSetName.length() == 0) {
                baseConfigSetName = "_default";
            }
            return baseConfigSetName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList getConfigSetProperties(String path) throws IOException {
        byte[] oldPropsData = null;
        try {
            oldPropsData = this.zkStateReader.getZkClient().getData(path, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            log.info("no existing ConfigSet properties found");
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error reading old properties", SolrZkClient.checkInterrupted((Throwable)e));
        }
        if (oldPropsData != null) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(oldPropsData), StandardCharsets.UTF_8);){
                NamedList namedList = ConfigSetProperties.readFromInputStream(reader);
                return namedList;
            }
        }
        return null;
    }

    private Map<String, Object> getNewProperties(ZkNodeProps message) {
        HashMap properties = null;
        for (Map.Entry entry : message.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("configSetProp.")) continue;
            if (properties == null) {
                properties = new HashMap();
            }
            properties.put(((String)entry.getKey()).substring("configSetProp.".length()), entry.getValue());
        }
        return properties;
    }

    private void mergeOldProperties(Map<String, Object> newProps, NamedList oldProps) {
        for (Map.Entry oldEntry : oldProps) {
            if (newProps.containsKey(oldEntry.getKey())) continue;
            newProps.put((String)oldEntry.getKey(), oldEntry.getValue());
        }
    }

    private byte[] getPropertyData(Map<String, Object> newProps) {
        if (newProps != null) {
            String propertyDataStr = JSONUtil.toJSON(newProps);
            if (propertyDataStr == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid property specification");
            }
            return propertyDataStr.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    private String getPropertyPath(String configName, String propertyPath) {
        return "/configs/" + configName + "/" + propertyPath;
    }

    private void createConfigSet(ZkNodeProps message) throws IOException {
        block11: {
            NamedList oldProps;
            String configSetName = this.getTaskKey(message);
            if (configSetName == null || configSetName.length() == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
            }
            String baseConfigSetName = message.getStr(BASE_CONFIGSET, "_default");
            ZkConfigManager configManager = new ZkConfigManager(this.zkStateReader.getZkClient());
            if (configManager.configExists(configSetName).booleanValue()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet already exists: " + configSetName);
            }
            if (!configManager.configExists(baseConfigSetName).booleanValue()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Base ConfigSet does not exist: " + baseConfigSetName);
            }
            String propertyPath = "configsetprops.json";
            Map<String, Object> props = this.getNewProperties(message);
            if (props != null && (oldProps = this.getConfigSetProperties(this.getPropertyPath(baseConfigSetName, propertyPath))) != null) {
                this.mergeOldProperties(props, oldProps);
            }
            byte[] propertyData = this.getPropertyData(props);
            HashSet copiedToZkPaths = new HashSet();
            try {
                configManager.copyConfigDir(baseConfigSetName, configSetName, copiedToZkPaths);
                if (propertyData == null) break block11;
                try {
                    this.zkStateReader.getZkClient().makePath(this.getPropertyPath(configSetName, propertyPath), propertyData, CreateMode.PERSISTENT, null, false, true);
                }
                catch (InterruptedException | KeeperException e) {
                    throw new IOException("Error writing new properties", SolrZkClient.checkInterrupted((Throwable)e));
                }
            }
            catch (Exception e) {
                try {
                    if (configManager.configExists(configSetName).booleanValue() && copiedToZkPaths.size() > 0) {
                        this.deleteConfigSet(configSetName, true);
                    }
                }
                catch (IOException ioe) {
                    log.error("Error while trying to delete partially created ConfigSet", (Throwable)ioe);
                }
                throw e;
            }
        }
    }

    private void deleteConfigSet(ZkNodeProps message) throws IOException {
        String configSetName = this.getTaskKey(message);
        if (configSetName == null || configSetName.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
        }
        this.deleteConfigSet(configSetName, false);
    }

    private void deleteConfigSet(String configSetName, boolean force) throws IOException {
        ZkConfigManager configManager = new ZkConfigManager(this.zkStateReader.getZkClient());
        if (!configManager.configExists(configSetName).booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet does not exist to delete: " + configSetName);
        }
        for (Map.Entry entry : this.zkStateReader.getClusterState().getCollectionsMap().entrySet()) {
            if (!configSetName.equals(this.zkStateReader.readConfigName((String)entry.getKey()))) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not delete ConfigSet as it is currently being used by collection [" + (String)entry.getKey() + "]");
        }
        String propertyPath = "configsetprops.json";
        NamedList properties = this.getConfigSetProperties(this.getPropertyPath(configSetName, propertyPath));
        if (properties != null) {
            boolean isImmutableConfigSet;
            Object immutable = properties.get("immutable");
            boolean bl = isImmutableConfigSet = immutable != null ? Boolean.parseBoolean(immutable.toString()) : false;
            if (!force && isImmutableConfigSet) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Requested delete of immutable ConfigSet: " + configSetName);
            }
        }
        configManager.deleteConfigDir(configSetName);
    }
}

