/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.CollectorRegistry;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Collector {
    public static final double NANOSECONDS_PER_SECOND = 1.0E9;
    public static final double MILLISECONDS_PER_SECOND = 1000.0;
    private static final Pattern METRIC_NAME_RE = Pattern.compile("[a-zA-Z_:][a-zA-Z0-9_:]*");
    private static final Pattern METRIC_LABEL_NAME_RE = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private static final Pattern RESERVED_METRIC_LABEL_NAME_RE = Pattern.compile("__.*");
    private static final Pattern SANITIZE_PREFIX_PATTERN = Pattern.compile("^[^a-zA-Z_]");
    private static final Pattern SANITIZE_BODY_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");

    public abstract List<MetricFamilySamples> collect();

    public <T extends Collector> T register() {
        return this.register(CollectorRegistry.defaultRegistry);
    }

    public <T extends Collector> T register(CollectorRegistry registry) {
        registry.register(this);
        return (T)this;
    }

    protected static void checkMetricName(String name) {
        if (!METRIC_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric name: " + name);
        }
    }

    public static String sanitizeMetricName(String metricName) {
        return SANITIZE_BODY_PATTERN.matcher(SANITIZE_PREFIX_PATTERN.matcher(metricName).replaceFirst("_")).replaceAll("_");
    }

    protected static void checkMetricLabelName(String name) {
        if (!METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name: " + name);
        }
        if (RESERVED_METRIC_LABEL_NAME_RE.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid metric label name, reserved for internal use: " + name);
        }
    }

    public static String doubleToGoString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return "+Inf";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        return Double.toString(d);
    }

    public static interface Describable {
        public List<MetricFamilySamples> describe();
    }

    public static class MetricFamilySamples {
        public final String name;
        public final Type type;
        public final String help;
        public final List<Sample> samples;

        public MetricFamilySamples(String name, Type type, String help, List<Sample> samples) {
            this.name = name;
            this.type = type;
            this.help = help;
            this.samples = samples;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetricFamilySamples)) {
                return false;
            }
            MetricFamilySamples other = (MetricFamilySamples)obj;
            return other.name.equals(this.name) && other.type.equals((Object)this.type) && other.help.equals(this.help) && other.samples.equals(this.samples);
        }

        public int hashCode() {
            int hash = 1;
            hash = 37 * hash + this.name.hashCode();
            hash = 37 * hash + this.type.hashCode();
            hash = 37 * hash + this.help.hashCode();
            hash = 37 * hash + this.samples.hashCode();
            return hash;
        }

        public String toString() {
            return "Name: " + this.name + " Type: " + (Object)((Object)this.type) + " Help: " + this.help + " Samples: " + this.samples;
        }

        public static class Sample {
            public final String name;
            public final List<String> labelNames;
            public final List<String> labelValues;
            public final double value;

            public Sample(String name, List<String> labelNames, List<String> labelValues, double value) {
                this.name = name;
                this.labelNames = labelNames;
                this.labelValues = labelValues;
                this.value = value;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Sample)) {
                    return false;
                }
                Sample other = (Sample)obj;
                return other.name.equals(this.name) && other.labelNames.equals(this.labelNames) && other.labelValues.equals(this.labelValues) && other.value == this.value;
            }

            public int hashCode() {
                int hash = 1;
                hash = 37 * hash + this.name.hashCode();
                hash = 37 * hash + this.labelNames.hashCode();
                hash = 37 * hash + this.labelValues.hashCode();
                long d = Double.doubleToLongBits(this.value);
                hash = 37 * hash + (int)(d ^ d >>> 32);
                return hash;
            }

            public String toString() {
                return "Name: " + this.name + " LabelNames: " + this.labelNames + " labelValues: " + this.labelValues + " Value: " + this.value;
            }
        }
    }

    public static enum Type {
        COUNTER,
        GAUGE,
        SUMMARY,
        HISTOGRAM,
        UNTYPED;

    }
}

