/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.lang.properties.references.I18nizeQuickFixModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePropertyFix
implements IntentionAction,
LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeQuickFix");
    private final PsiAnchor myElement;
    private final String myKey;
    private final List<PropertiesFile> myPropertiesFiles;
    public static final String NAME = PropertiesBundle.message("create.property.quickfix.text", new Object[0]);

    public CreatePropertyFix() {
        this(null, null, null);
    }

    public CreatePropertyFix(PsiElement element, String key, List<PropertiesFile> propertiesFiles) {
        this.myElement = element == null ? null : PsiAnchor.create((PsiElement)element);
        this.myKey = key;
        this.myPropertiesFiles = propertiesFiles;
    }

    @NotNull
    public String getName() {
        String string = NAME;
        if (string == null) {
            CreatePropertyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CreatePropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            CreatePropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CreatePropertyFix.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        if (this.isAvailable(project, null, null)) {
            this.invoke(project, null, psiElement.getContainingFile());
        }
    }

    @NotNull
    public String getText() {
        String string = NAME;
        if (string == null) {
            CreatePropertyFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        if (project == null) {
            CreatePropertyFix.$$$reportNull$$$0(5);
        }
        return this.myElement != null && this.myElement.retrieve() != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CreatePropertyFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            CreatePropertyFix.$$$reportNull$$$0(7);
        }
        this.invokeAction(project, file, this.myElement.retrieve(), this.myKey, this.myPropertiesFiles);
    }

    private void invokeAction(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement psiElement, @Nullable String suggestedKey, final @Nullable List<PropertiesFile> propertiesFiles) {
        if (project == null) {
            CreatePropertyFix.$$$reportNull$$$0(8);
        }
        if (file == null) {
            CreatePropertyFix.$$$reportNull$$$0(9);
        }
        if (psiElement == null) {
            CreatePropertyFix.$$$reportNull$$$0(10);
        }
        final I18nizeQuickFixDialog.DialogCustomization dialogCustomization = CreatePropertyFix.createDefaultCustomization(suggestedKey, propertiesFiles);
        I18nizeQuickFixModel model = ApplicationManager.getApplication().isUnitTestMode() ? new I18nizeQuickFixModel(){

            @Override
            public String getValue() {
                return "";
            }

            @Override
            public String getKey() {
                return dialogCustomization.getSuggestedName();
            }

            @Override
            public boolean hasValidData() {
                return true;
            }

            @Override
            public Collection<PropertiesFile> getAllPropertiesFiles() {
                return propertiesFiles;
            }
        } : new I18nizeQuickFixDialog(project, file, NAME, dialogCustomization);
        this.doAction(project, psiElement, model);
    }

    protected static I18nizeQuickFixDialog.DialogCustomization createDefaultCustomization(String suggestedKey, List<PropertiesFile> propertiesFiles) {
        return new I18nizeQuickFixDialog.DialogCustomization(NAME, false, true, propertiesFiles, suggestedKey == null ? "" : suggestedKey);
    }

    protected Couple<String> doAction(Project project, PsiElement psiElement, I18nizeQuickFixModel model) {
        if (!model.hasValidData()) {
            return null;
        }
        String key = model.getKey();
        String value = model.getValue();
        Collection<PropertiesFile> selectedPropertiesFiles = model.getAllPropertiesFiles();
        CreatePropertyFix.createProperty(project, psiElement, selectedPropertiesFiles, key, value);
        return Couple.of((Object)key, (Object)value);
    }

    public static void createProperty(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull Collection<? extends PropertiesFile> selectedPropertiesFiles, @NotNull String key, @NotNull String value) {
        if (project == null) {
            CreatePropertyFix.$$$reportNull$$$0(11);
        }
        if (psiElement == null) {
            CreatePropertyFix.$$$reportNull$$$0(12);
        }
        if (selectedPropertiesFiles == null) {
            CreatePropertyFix.$$$reportNull$$$0(13);
        }
        if (key == null) {
            CreatePropertyFix.$$$reportNull$$$0(14);
        }
        if (value == null) {
            CreatePropertyFix.$$$reportNull$$$0(15);
        }
        for (PropertiesFile propertiesFile : selectedPropertiesFiles) {
            if (FileModificationService.getInstance().prepareFileForWrite(propertiesFile.getContainingFile())) continue;
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)psiElement.getContainingFile());
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                CreatePropertyFix.$$$reportNull$$$0(16);
            }
            if (selectedPropertiesFiles == null) {
                CreatePropertyFix.$$$reportNull$$$0(17);
            }
            if (key == null) {
                CreatePropertyFix.$$$reportNull$$$0(18);
            }
            if (value == null) {
                CreatePropertyFix.$$$reportNull$$$0(19);
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                if (project == null) {
                    CreatePropertyFix.$$$reportNull$$$0(20);
                }
                if (selectedPropertiesFiles == null) {
                    CreatePropertyFix.$$$reportNull$$$0(21);
                }
                if (key == null) {
                    CreatePropertyFix.$$$reportNull$$$0(22);
                }
                if (value == null) {
                    CreatePropertyFix.$$$reportNull$$$0(23);
                }
                try {
                    I18nUtil.createProperty(project, selectedPropertiesFiles, key, value);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/references/CreatePropertyFix";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPropertiesFiles";
                break;
            }
            case 14: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/references/CreatePropertyFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProperty";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createProperty$1";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

