/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.documentation.doctest.PyDocReference;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveStatementQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnusedLocalInspectionVisitor
extends PyInspectionVisitor {
    private final boolean myIgnoreTupleUnpacking;
    private final boolean myIgnoreLambdaParameters;
    private final boolean myIgnoreRangeIterationVariables;
    private final boolean myIgnoreVariablesStartingWithUnderscore;
    private final HashSet<PsiElement> myUnusedElements;
    private final HashSet<PsiElement> myUsedElements;

    public PyUnusedLocalInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, boolean ignoreTupleUnpacking, boolean ignoreLambdaParameters, boolean ignoreRangeIterationVariables, boolean ignoreVariablesStartingWithUnderscore) {
        if (holder == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(1);
        }
        super(holder, session);
        this.myIgnoreTupleUnpacking = ignoreTupleUnpacking;
        this.myIgnoreLambdaParameters = ignoreLambdaParameters;
        this.myIgnoreRangeIterationVariables = ignoreRangeIterationVariables;
        this.myIgnoreVariablesStartingWithUnderscore = ignoreVariablesStartingWithUnderscore;
        this.myUnusedElements = new HashSet();
        this.myUsedElements = new HashSet();
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        if (!PyiUtil.isOverload(node, this.myTypeEvalContext)) {
            this.processScope(node);
        }
    }

    @Override
    public void visitPyLambdaExpression(PyLambdaExpression node) {
        this.processScope(node);
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.processScope(node);
    }

    private void processScope(ScopeOwner owner) {
        if (owner.getContainingFile() instanceof PyExpressionCodeFragment) {
            return;
        }
        if (!(owner instanceof PyClass) && !PyUnusedLocalInspectionVisitor.callsLocals(owner)) {
            this.collectAllWrites(owner);
        }
        this.collectUsedReads(owner);
    }

    @Override
    public void visitPyStringLiteralExpression(final PyStringLiteralExpression pyString) {
        final ScopeOwner owner = ScopeUtil.getScopeOwner(pyString);
        if (owner != null && !(owner instanceof PsiFile)) {
            PsiElement instrAnchor = PyDocReference.getControlFlowAnchorForFString(pyString);
            if (instrAnchor == null) {
                return;
            }
            final Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
            final int startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)instrAnchor);
            if (startInstruction < 0) {
                return;
            }
            Project project = pyString.getProject();
            List pairs = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)pyString);
            if (pairs != null) {
                for (Pair pair : pairs) {
                    ((PsiElement)pair.getFirst()).accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                        @Override
                        public void visitPyReferenceExpression(PyReferenceExpression expr) {
                            PyExpression qualifier = expr.getQualifier();
                            if (qualifier != null) {
                                qualifier.accept(this);
                                return;
                            }
                            String name = expr.getName();
                            if (name != null) {
                                PyUnusedLocalInspectionVisitor.this.analyzeReadsInScope(name, owner, instructions, startInstruction, pyString);
                            }
                        }
                    });
                }
            }
        }
    }

    private void collectAllWrites(ScopeOwner owner) {
        Instruction[] instructions;
        for (Instruction instruction : instructions = ControlFlowCache.getControlFlow(owner).getInstructions()) {
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            PsiElement element = instruction.getElement();
            if (element instanceof PyFunction && owner instanceof PyFunction) {
                if (PyKnownDecoratorUtil.hasUnknownDecorator((PyFunction)element, this.myTypeEvalContext) || this.myUsedElements.contains(element)) continue;
                this.myUnusedElements.add(element);
                continue;
            }
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isWriteAccess()) continue;
            String name = readWriteInstruction.getName();
            Scope scope = ControlFlowCache.getScope(owner);
            if (name == null || "_".equals(name) || scope.isGlobal(name) || scope.isNonlocal(name) || element instanceof PyTargetExpression && ((PyTargetExpression)element).isQualified() || name.startsWith("_") && element instanceof PyParameter || element == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false) || PyImportStatementNavigator.getImportStatementByElement(element) != null || PyAugAssignmentStatementNavigator.getStatementByTarget(element) != null || PyUnusedLocalInspectionVisitor.parameterInMethodWithFixedSignature(owner, element) || this.myUsedElements.contains(element)) continue;
            this.myUnusedElements.add(element);
        }
    }

    private static boolean parameterInMethodWithFixedSignature(@NotNull ScopeOwner owner, @NotNull PsiElement element) {
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (owner instanceof PyFunction && element instanceof PyParameter) {
            PyFunction function = (PyFunction)owner;
            String functionName = function.getName();
            LanguageLevel level = LanguageLevel.forElement(function);
            ImmutableMap<String, PyNames.BuiltinDescription> builtinMethods = function.getContainingClass() != null ? PyNames.getBuiltinMethods(level) : PyNames.getModuleBuiltinMethods(level);
            return !"__init__".equals(functionName) && builtinMethods.containsKey((Object)functionName);
        }
        return false;
    }

    private void collectUsedReads(ScopeOwner owner) {
        Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            int startInstruction;
            PsiElement element;
            String name;
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            Instruction instruction = instructions[i];
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isReadAccess() || (name = readWriteInstruction.getName()) == null || (element = instruction.getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false)) continue;
            if (access.isWriteAccess()) {
                PyAugAssignmentStatement augAssignmentStatement = PyAugAssignmentStatementNavigator.getStatementByTarget(element);
                startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)augAssignmentStatement);
            } else {
                startInstruction = i;
            }
            this.analyzeReadsInScope(name, owner, instructions, startInstruction, (PsiElement)PyUtil.as(element, PyReferenceExpression.class));
        }
    }

    private void analyzeReadsInScope(@NotNull String name, @NotNull ScopeOwner owner, @NotNull Instruction[] instructions, int startInstruction, @Nullable PsiElement scopeAnchor) {
        ScopeOwner declOwner;
        if (name == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (instructions == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (scopeAnchor != null && (declOwner = ScopeUtil.getDeclarationScopeOwner(scopeAnchor, name)) != null && declOwner != owner) {
            Collection<PsiElement> writeElements = ScopeUtil.getReadWriteElements(name, declOwner, false, true);
            for (PsiElement e : writeElements) {
                this.myUsedElements.add(e);
                this.myUnusedElements.remove(e);
            }
        }
        ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, inst -> {
            ReadWriteInstruction rwInstruction;
            PsiElement instElement;
            if (name == null) {
                PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(9);
            }
            if (owner == null) {
                PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(10);
            }
            if ((instElement = inst.getElement()) instanceof PyFunction) {
                if (name.equals(((PyFunction)instElement).getName())) {
                    this.myUsedElements.add(instElement);
                    this.myUnusedElements.remove(instElement);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (inst instanceof ReadWriteInstruction && (rwInstruction = (ReadWriteInstruction)((Object)inst)).getAccess().isWriteAccess() && name.equals(rwInstruction.getName())) {
                if (instElement != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)instElement, (boolean)false)) {
                    this.myUsedElements.add(instElement);
                    this.myUnusedElements.remove(instElement);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
    }

    private static boolean callsLocals(ScopeOwner owner) {
        try {
            owner.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyCallExpression(PyCallExpression node) {
                    PyExpression callee = node.getCallee();
                    if (callee != null && "locals".equals(callee.getName())) {
                        throw new DontPerformException();
                    }
                    node.acceptChildren(this);
                }

                @Override
                public void visitPyFunction(PyFunction node) {
                }
            });
        }
        catch (DontPerformException e) {
            return true;
        }
        return false;
    }

    void registerProblems() {
        List filters = PyInspectionExtension.EP_NAME.getExtensionList();
        HashSet<PyFunction> functionsWithInheritors = new HashSet<PyFunction>();
        HashMap<PyFunction, Boolean> emptyFunctions = new HashMap<PyFunction, Boolean>();
        for (PsiElement element : this.myUnusedElements) {
            boolean ignoreUnused = false;
            for (PyInspectionExtension filter : filters) {
                if (!filter.ignoreUnused(element, this.myTypeEvalContext)) continue;
                ignoreUnused = true;
            }
            if (ignoreUnused) continue;
            if (element instanceof PyFunction) {
                PsiElement nameIdentifier = ((PyFunction)element).getNameIdentifier();
                this.registerWarning(nameIdentifier == null ? element : nameIdentifier, PyBundle.message("INSP.unused.locals.local.function.isnot.used", ((PyFunction)element).getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            if (element instanceof PyClass) {
                PyClass cls = (PyClass)element;
                PsiElement name = cls.getNameIdentifier();
                this.registerWarning(name != null ? name : element, PyBundle.message("INSP.unused.locals.local.class.isnot.used", cls.getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            String name = element.getText();
            if (element instanceof PyNamedParameter || element.getParent() instanceof PyNamedParameter) {
                PyNamedParameter namedParameter = element instanceof PyNamedParameter ? (PyNamedParameter)element : (PyNamedParameter)element.getParent();
                name = namedParameter.getName();
                if (namedParameter.isSelf() || this.myIgnoreLambdaParameters && PsiTreeUtil.getParentOfType((PsiElement)element, PyCallable.class) instanceof PyLambdaExpression) continue;
                boolean mayBeField = false;
                PyClass containingClass = null;
                PyParameterList paramList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class);
                if (paramList != null && paramList.getParent() instanceof PyFunction) {
                    PyFunction func = (PyFunction)paramList.getParent();
                    containingClass = func.getContainingClass();
                    if ("__init__".equals(func.getName()) && containingClass != null && !namedParameter.isKeywordContainer() && !namedParameter.isPositionalContainer()) {
                        mayBeField = true;
                    } else if (this.ignoreUnusedParameters(func, functionsWithInheritors)) continue;
                    if (func.asMethod() != null) {
                        Boolean isEmpty = (Boolean)emptyFunctions.get(func);
                        if (isEmpty == null) {
                            isEmpty = PyUtil.isEmptyFunction(func);
                            emptyFunctions.put(func, isEmpty);
                        }
                        if (isEmpty.booleanValue() && !mayBeField) continue;
                    }
                }
                boolean canRemove = !(PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PyParameter.class) instanceof PySingleStarParameter) || PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PyParameter.class) != null;
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (mayBeField) {
                    fixes.add(new AddFieldQuickFix(name, name, containingClass.getName(), false));
                }
                if (canRemove) {
                    fixes.add(new PyRemoveParameterQuickFix());
                }
                this.registerWarning(element, PyBundle.message("INSP.unused.locals.parameter.isnot.used", name), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (this.myIgnoreTupleUnpacking && this.isTupleUnpacking(element)) continue;
            PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
            if (forStatement != null) {
                if (this.myIgnoreRangeIterationVariables && this.isRangeIteration(forStatement)) continue;
                this.registerProblem(element, PyBundle.message("INSP.unused.locals.local.variable.isnot.used", name), ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, new ReplaceWithWildCard());
                continue;
            }
            if (this.myIgnoreVariablesStartingWithUnderscore && name.startsWith("_")) continue;
            this.registerWarning(element, PyBundle.message("INSP.unused.locals.local.variable.isnot.used", name), new PyRemoveStatementQuickFix());
        }
    }

    private boolean isRangeIteration(@NotNull PyForStatement forStatement) {
        PyExpression source;
        if (forStatement == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(7);
        }
        if (!((source = forStatement.getForPart().getSource()) instanceof PyCallExpression)) {
            return false;
        }
        PyCallExpression expr = (PyCallExpression)source;
        if (expr.isCalleeText("range", "xrange")) {
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(forStatement);
            return ContainerUtil.exists(expr.multiResolveCalleeFunction(resolveContext), builtinCache::isBuiltin);
        }
        return false;
    }

    private boolean ignoreUnusedParameters(PyFunction func, Set<PyFunction> functionsWithInheritors) {
        if (functionsWithInheritors.contains(func)) {
            return true;
        }
        if (!"__init__".equals(func.getName()) && PySuperMethodsSearch.search(func, this.myTypeEvalContext).findFirst() != null || PyOverridingMethodsSearch.search(func, true).findFirst() != null) {
            functionsWithInheritors.add(func);
            return true;
        }
        return false;
    }

    private boolean isTupleUnpacking(PsiElement element) {
        if (!(element instanceof PyTargetExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyStarExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PyTupleExpression) {
            PyTupleExpression tuple = (PyTupleExpression)parent;
            for (PyExpression expression : tuple.getElements()) {
                if (!(expression instanceof PyStarExpression ? !this.myUnusedElements.contains(((PyStarExpression)expression).getExpression()) : !this.myUnusedElements.contains(expression))) continue;
                return true;
            }
        }
        return false;
    }

    private void registerWarning(@NotNull PsiElement element, String msg, LocalQuickFix ... quickfixes) {
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(8);
        }
        this.registerProblem(element, msg, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, quickfixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parameterInMethodWithFixedSignature";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeReadsInScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRangeIteration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWarning";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$analyzeReadsInScope$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceWithWildCard
    implements LocalQuickFix {
        private ReplaceWithWildCard() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("INSP.unused.locals.replace.with.wildcard", new Object[0]);
            if (string == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement psiElement;
            PyFile pyFile;
            PyExpression target;
            if (project == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(2);
            }
            if ((target = ((PyForStatement)(pyFile = (PyFile)PyElementGenerator.getInstance((psiElement = descriptor2.getPsiElement()).getProject()).createDummyFile(LanguageLevel.getDefault(), "for _ in tuples:\n  pass")).getStatements().get(0)).getForPart().getTarget()) != null) {
                psiElement.replace((PsiElement)target);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class DontPerformException
    extends RuntimeException {
        DontPerformException() {
        }
    }
}

