/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.Developer;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.IdeaReportingEvent;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ITNProxy {
    private static final String DEFAULT_USER = "idea_anonymous";
    private static final String DEFAULT_PASS = "guest";
    private static final String DEVELOPERS_LIST_URL = "https://ea-engine.labs.intellij.net/data?category=developers";
    private static final String NEW_THREAD_POST_URL = "https://ea-report.jetbrains.com/trackerRpc/idea/createScr";
    private static final String NEW_THREAD_VIEW_URL = "https://ea.jetbrains.com/browser/ea_reports/";
    private static final NotNullLazyValue<Map<String, String>> TEMPLATE = AtomicNotNullLazyValue.createValue(() -> {
        LinkedHashMap<String, String> template = new LinkedHashMap<String, String>();
        template.put("protocol.version", "1");
        template.put("os.name", SystemInfo.OS_NAME);
        template.put("java.version", SystemInfo.JAVA_VERSION);
        template.put("java.vm.vendor", SystemInfo.JAVA_VENDOR);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        BuildNumber build2 = appInfo.getBuild();
        String buildNumberWithAllDetails = build2.asString();
        if (StringUtil.startsWith((CharSequence)buildNumberWithAllDetails, (CharSequence)(build2.getProductCode() + "-"))) {
            buildNumberWithAllDetails = buildNumberWithAllDetails.substring(build2.getProductCode().length() + 1);
        }
        template.put("app.name", namesInfo.getProductName());
        template.put("app.name.full", namesInfo.getFullProductName());
        template.put("app.name.version", appInfo.getVersionName());
        template.put("app.eap", Boolean.toString(appInfo.isEAP()));
        template.put("app.internal", Boolean.toString(ApplicationManager.getApplication().isInternal()));
        template.put("app.build", appInfo.getApiVersion());
        template.put("app.version.major", appInfo.getMajorVersion());
        template.put("app.version.minor", appInfo.getMinorVersion());
        template.put("app.build.date", ITNProxy.format(appInfo.getBuildDate()));
        template.put("app.build.date.release", ITNProxy.format(appInfo.getMajorReleaseBuildDate()));
        template.put("app.compilation.timestamp", IdeaLogger.getOurCompilationTimestamp());
        template.put("app.product.code", build2.getProductCode());
        template.put("app.build.number", buildNumberWithAllDetails);
        return template;
    });
    private static SSLContext ourSslContext;
    private static final String JB_CA_CERT = "-----BEGIN CERTIFICATE-----\nMIIFvjCCA6agAwIBAgIQMYHnK1dpIZVCoitWqBwhXjANBgkqhkiG9w0BAQsFADBn\nMRMwEQYKCZImiZPyLGQBGRYDTmV0MRgwFgYKCZImiZPyLGQBGRYISW50ZWxsaUox\nFDASBgoJkiaJk/IsZAEZFgRMYWJzMSAwHgYDVQQDExdKZXRCcmFpbnMgRW50ZXJw\ncmlzZSBDQTAeFw0xMjEyMjkxMDEyMzJaFw0zMjEyMjkxMDIyMzBaMGcxEzARBgoJ\nkiaJk/IsZAEZFgNOZXQxGDAWBgoJkiaJk/IsZAEZFghJbnRlbGxpSjEUMBIGCgmS\nJomT8ixkARkWBExhYnMxIDAeBgNVBAMTF0pldEJyYWlucyBFbnRlcnByaXNlIENB\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAzPCE2gPgKECo5CB3BTAw\n4XrrNpg+YwTMzeNNDYs4VdPzBq0snWsbm5qP6z1GBGUTr4agERQUxc4//gZMR0UJ\n89GWVNYPbZ/MrkfyaOiem8xosuZ+7WoFu4nYnKbBBMBA7S2idrPSmPv2wYiHJCY7\neN2AdViiFSAUeGw/7pIgou92/4Bbm6SSzRBKBYfRIfwq0ZgETSIjhNR5o3XJB5i2\nCkSjMk7kNiMWBaq+Alv+Um/xMFnl5jiq9H7YAALgH/mZHr8ANniSyBwkj4r/7GQ3\nUIYwoLrGxSOSEY9UhEpdqQkRbSSjQiFYMlhYEAtLERK4KZObTuUgdiE6Wk38EOKZ\nwy1eE/EIh8vWBHFSH5opPSK4dyamxj9o5c2g1hJ07ZBUCV/nsrKb+ruMkwBfI286\n+HPTMUmoKuUfSfHZ5TiuF5EvcSD7Df2ZCFpRugPs26FRGvtsiBMEmu4u6fu5RNkh\ns7Ueq6ISblt6dj/youywiAZnyrtNKJVyK0m051g9b2IokHjrk9XTswTqBHDjZKYr\nYG/5jDSSzvR/ptR9YIrHF0a9A6LQLZ6ews4FUO6O/RhiYXV8FggD7ZUg019OBUx3\nrF1L3GBYA8YhYP/N18r8DqOaFgUiRDyeRMbka9OXZ2KJT6iL+mOfg/svSW8lc4Ly\nEgcyJ9sk7MRwrhlp3Kc0W7UCAwEAAaNmMGQwEwYJKwYBBAGCNxQCBAYeBABDAEEw\nCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFB/HK/yYoWW9\nvr2XAyhcMmV3gSfGMBAGCSsGAQQBgjcVAQQDAgEAMA0GCSqGSIb3DQEBCwUAA4IC\nAQBnYu49dZRBK9W3voy6bgzz64sZfX51/RIA6aaoHAH3U1bC8EepChqWeRgijGCD\nCBvLTk7bk/7fgXPPvL+8RwYaxEewCi7t1RQKqPmNvUnEnw28OLvYLBEO7a4yeN5Y\nYaZwdfVH+0qMvTqMQku5p5Xx3dY+DAm4EqXEFD0svfeMJmOA+R1CIqRz1CXnN2FY\nA+86m7WLmGZ8oWlRUJDa1etqrE3ZxXHH/IunVJOGOfaQVkid3u3ageyUOnMw/iME\n7vi0UNVYVsCjXYZxrzCDLCxtguZaV4rMYvLRt1oUxZ+VnmdVa3aW0W//GQ70sqh2\nKQDtIF6Iumf8ya4vA0+K+AAowOSR/k4jQzlWQdZvJNMHP/Jc0OyJyHEegjtWssrS\nNoRtI6V4j277ugWF1Xpt1x0YxYyGSZTI4rqGLqVT8x6Llr24YaHCdp56rKWC/5ob\nIFZ7tJys7oQqof11ANDExrnHv/FEE39VDlfEIUVGyCpsyKbzO7MPfdOce2bIaQOS\ndQ76TpYClrnezikJgp9MSQmd3+ozs9w1upGynHNGNmVhzZ5sex9voWcGoyjmOFhs\nwg13S9Hjy3VYq8y0krRYLEGLctd4vnxWGzJzUNSnqezwHZRl4v4Ejp3dQUZP+5sY\n1F81Vj1G264YnZAcWp5x3GTI4K6+k9Xx3pwUPcKOYdlpZQ==\n-----END CERTIFICATE-----\n";
    private static final String JB_CA_CN = "JetBrains Enterprise CA";
    private static final String JB_CA_FP = "604d3c703a13a3be2d452f14442be11b37e186f";

    ITNProxy() {
    }

    @Nullable
    private static String format(@Nullable Calendar calendar) {
        return calendar == null ? null : Long.toString(calendar.getTime().getTime());
    }

    @NotNull
    static List<Developer> fetchDevelopers(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            ITNProxy.$$$reportNull$$$0(0);
        }
        List list2 = (List)HttpRequests.request((String)DEVELOPERS_LIST_URL).connect(request -> {
            String line;
            if (indicator == null) {
                ITNProxy.$$$reportNull$$$0(6);
            }
            ArrayList<Developer> developers = new ArrayList<Developer>();
            developers.add(Developer.NULL);
            while ((line = request.getReader().readLine()) != null) {
                int i = line.indexOf(9);
                if (i == -1) {
                    throw new IOException("Protocol error");
                }
                int id = Integer.parseInt(line.substring(0, i));
                String name = line.substring(i + 1);
                developers.add(new Developer(id, name));
                indicator.checkCanceled();
            }
            return developers;
        });
        if (list2 == null) {
            ITNProxy.$$$reportNull$$$0(1);
        }
        return list2;
    }

    static void sendError(@Nullable Project project, @Nullable String login, @Nullable String password, final @NotNull ErrorBean error, final @NotNull IntConsumer onSuccess2, final @NotNull Consumer<? super Exception> onError2) {
        if (error == null) {
            ITNProxy.$$$reportNull$$$0(2);
        }
        if (onSuccess2 == null) {
            ITNProxy.$$$reportNull$$$0(3);
        }
        if (onError2 == null) {
            ITNProxy.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)login)) {
            login = DEFAULT_USER;
            password = DEFAULT_PASS;
        } else if (password == null) {
            password = "";
        }
        final String _login = login;
        final String _password = password;
        new Task.Backgroundable(project, DiagnosticBundle.message("title.submitting.error.report", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    onSuccess2.accept(ITNProxy.postNewThread(_login, _password, error));
                }
                catch (Exception ex) {
                    onError2.accept(ex);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diagnostic/ITNProxy$1", "run"));
            }
        }.queue();
    }

    @NotNull
    static String getBrowseUrl(int threadId) {
        String string = NEW_THREAD_VIEW_URL + threadId;
        if (string == null) {
            ITNProxy.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static int postNewThread(String login, String password, ErrorBean error) throws Exception {
        HttpURLConnection connection;
        int responseCode;
        if (ourSslContext == null) {
            ourSslContext = ITNProxy.initContext();
        }
        if ((responseCode = (connection = ITNProxy.post(new URL(NEW_THREAD_POST_URL), ITNProxy.createRequest(login, password, error))).getResponseCode()) != 200) {
            throw new InternalEAPException(DiagnosticBundle.message("error.http.result.code", responseCode));
        }
        String response = FileUtil.loadTextAndClose((InputStream)connection.getInputStream());
        if ("unauthorized".equals(response)) {
            throw new NoSuchEAPUserException(login);
        }
        if (response.startsWith("update ")) {
            throw new UpdateAvailableException(response.substring(7));
        }
        if (response.startsWith("message ")) {
            throw new InternalEAPException(response.substring(8));
        }
        try {
            return Integer.valueOf(response.trim());
        }
        catch (NumberFormatException ex) {
            throw new InternalEAPException(DiagnosticBundle.message("error.itn.returns.wrong.data", new Object[0]));
        }
    }

    private static byte[] createRequest(String login, String password, ErrorBean error) throws UnsupportedEncodingException {
        Object eventData;
        StringBuilder builder2 = new StringBuilder(8192);
        for (Map.Entry entry : ((Map)TEMPLATE.getValue()).entrySet()) {
            ITNProxy.append(builder2, (String)entry.getKey(), (String)entry.getValue());
        }
        ITNProxy.append(builder2, "user.login", login);
        ITNProxy.append(builder2, "user.password", password);
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        ITNProxy.append(builder2, "update.channel.status", updateSettings.getSelectedChannelStatus().getCode());
        ITNProxy.append(builder2, "update.ignored.builds", StringUtil.join(updateSettings.getIgnoredBuildNumbers(), (String)","));
        ITNProxy.append(builder2, "plugin.name", error.pluginName);
        ITNProxy.append(builder2, "plugin.version", error.pluginVersion);
        ITNProxy.append(builder2, "last.action", error.lastActionId);
        if (error.previousException > 0) {
            ITNProxy.append(builder2, "previous.exception", Integer.toString(error.previousException));
        }
        String message = StringUtil.notNullize((String)error.event.getMessage()).trim();
        String stacktrace = error.event.getThrowableText();
        boolean redacted = false;
        if (error.event instanceof IdeaReportingEvent) {
            boolean tracesDiffer;
            String originalMessage = StringUtil.notNullize((String)((IdeaReportingEvent)error.event).getOriginalMessage()).trim();
            String originalStacktrace = ((IdeaReportingEvent)error.event).getOriginalThrowableText();
            boolean messagesDiffer = !Objects.equals(message, originalMessage);
            boolean bl = tracesDiffer = !Objects.equals(stacktrace, originalStacktrace);
            if (messagesDiffer || tracesDiffer) {
                String summary = "";
                if (messagesDiffer) {
                    summary = summary + "*** message was redacted (" + ITNProxy.diff(originalMessage, message) + ")\n";
                }
                if (tracesDiffer) {
                    summary = summary + "*** stacktrace was redacted (" + ITNProxy.diff(originalStacktrace, stacktrace) + ")\n";
                }
                message = !message.isEmpty() ? summary + '\n' + message : summary.trim();
                redacted = true;
            }
        }
        ITNProxy.append(builder2, "error.message", message);
        ITNProxy.append(builder2, "error.stacktrace", stacktrace);
        ITNProxy.append(builder2, "error.description", error.comment);
        if (redacted) {
            ITNProxy.append(builder2, "error.redacted", Boolean.toString(true));
        }
        if ((eventData = error.event.getData()) instanceof AbstractMessage) {
            AbstractMessage messageObj = (AbstractMessage)eventData;
            for (Attachment attachment : messageObj.getIncludedAttachments()) {
                ITNProxy.append(builder2, "attachment.name", attachment.getName());
                ITNProxy.append(builder2, "attachment.value", attachment.getEncodedBytes());
            }
            if (messageObj.getAssigneeId() != null) {
                ITNProxy.append(builder2, "assignee.id", Integer.toString(messageObj.getAssigneeId()));
            }
        }
        return builder2.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static void append(StringBuilder builder2, String key, @Nullable String value) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        if (builder2.length() > 0) {
            builder2.append('&');
        }
        builder2.append(key).append('=').append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
    }

    private static String diff(String original, String redacted) {
        return "original:" + ITNProxy.wc(original) + " submitted:" + ITNProxy.wc(redacted);
    }

    private static String wc(String s) {
        return s.isEmpty() ? "-" : StringUtil.splitByLines((String)s).length + "/" + s.split("[^\\w']+").length + "/" + s.length();
    }

    private static HttpURLConnection post(URL url, byte[] bytes) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(ourSslContext.getSocketFactory());
        if (!NetUtils.isSniEnabled()) {
            connection.setHostnameVerifier(new EaHostnameVerifier());
        }
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + StandardCharsets.UTF_8.name());
        connection.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        try (OutputStream out = connection.getOutputStream();){
            out.write(bytes);
        }
        return connection;
    }

    private static synchronized SSLContext initContext() throws GeneralSecurityException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate ca = cf.generateCertificate(new ByteArrayInputStream(JB_CA_CERT.getBytes(StandardCharsets.US_ASCII)));
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setCertificateEntry("JetBrains CA", ca);
        TrustManagerFactory jbTmf = TrustManagerFactory.getInstance("X.509");
        jbTmf.init(ks);
        TrustManagerFactory sysTmf = TrustManagerFactory.getInstance("X.509");
        sysTmf.init((KeyStore)null);
        SSLContext ctx = SSLContext.getInstance("TLS");
        CompositeX509TrustManager composite = new CompositeX509TrustManager((TrustManager[][])new TrustManager[][]{jbTmf.getTrustManagers(), sysTmf.getTrustManagers()});
        ctx.init(null, new TrustManager[]{composite}, null);
        return ctx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/ITNProxy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/ITNProxy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchDevelopers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowseUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchDevelopers";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchDevelopers$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EaHostnameVerifier
    implements HostnameVerifier {
        private EaHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, @NotNull SSLSession session2) {
            if (session2 == null) {
                EaHostnameVerifier.$$$reportNull$$$0(0);
            }
            try {
                Certificate[] certificates = session2.getPeerCertificates();
                if (certificates.length > 1) {
                    String cn;
                    Certificate certificate = certificates[0];
                    if (certificate instanceof X509Certificate && ((cn = CertificateUtil.getCommonName((X509Certificate)((X509Certificate)certificate))).endsWith(".jetbrains.com") || cn.endsWith(".intellij.net"))) {
                        return true;
                    }
                    Certificate ca = certificates[certificates.length - 1];
                    if (ca instanceof X509Certificate) {
                        String cn2 = CertificateUtil.getCommonName((X509Certificate)((X509Certificate)ca));
                        byte[] digest = MessageDigest.getInstance("SHA-1").digest(ca.getEncoded());
                        StringBuilder fp = new StringBuilder(2 * digest.length);
                        for (byte b : digest) {
                            fp.append(Integer.toHexString(b & 0xFF));
                        }
                        if (ITNProxy.JB_CA_CN.equals(cn2) && ITNProxy.JB_CA_FP.equals(fp.toString())) {
                            return true;
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException | SSLPeerUnverifiedException exception) {
                // empty catch block
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/diagnostic/ITNProxy$EaHostnameVerifier", "verify"));
        }
    }

    static class ErrorBean {
        final IdeaLoggingEvent event;
        final String comment;
        final String pluginName;
        final String pluginVersion;
        final String lastActionId;
        final int previousException;

        ErrorBean(IdeaLoggingEvent event, String comment, String pluginName, String pluginVersion, String lastActionId, int previousException) {
            this.event = event;
            this.comment = comment;
            this.pluginName = pluginName;
            this.pluginVersion = pluginVersion;
            this.lastActionId = lastActionId;
            this.previousException = previousException;
        }
    }
}

