/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.util.Map;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.spring.namespace.ConfigurationParser;
import org.directwebremoting.spring.namespace.FilterParserHelper;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ConverterParserHelper
extends FilterParserHelper {
    protected static final String INCLUDE = "dwr:include";
    protected static final String EXCLUDE = "dwr:exclude";
    protected static final String CONVERT = "dwr:convert";
    protected static final String PARAMETER = "dwr:param";

    public static Map<String, ConverterConfig> lookupConverters(BeanDefinitionRegistry registry) {
        BeanDefinition config = ConfigurationParser.registerConfigurationIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("converters").getValue();
    }

    protected void parseConverterSettings(ConverterConfig converterConfig, Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (INCLUDE.equals(child.getNodeName())) {
                converterConfig.addInclude(child.getAttribute("method"));
                continue;
            }
            if (EXCLUDE.equals(child.getNodeName())) {
                converterConfig.addExclude(child.getAttribute("method"));
                continue;
            }
            if (!PARAMETER.equals(node.getNodeName())) continue;
            converterConfig.getParams().put(child.getAttribute("name"), child.getAttribute("value"));
        }
    }
}

