/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.log;

import net.jradius.log.RadiusLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Log4JRadiusLogger
implements RadiusLogger {
    private static final Log log = LogFactory.getLog(Log4JRadiusLogger.class);

    public boolean isLoggable(int logLevel) {
        switch (logLevel) {
            case 0: {
                return true;
            }
            case 2: {
                return log.isErrorEnabled();
            }
            case 4: {
                return log.isWarnEnabled();
            }
            default: {
                return log.isInfoEnabled();
            }
            case 8: 
        }
        return log.isDebugEnabled();
    }

    public void error(String message) {
        if (message != null) {
            log.error((Object)message);
        }
    }

    public void error(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.error((Object)message, e);
            } else {
                log.error((Object)message);
            }
        } else if (e != null) {
            log.error((Object)"", e);
        }
    }

    public void warn(String message) {
        if (message != null) {
            log.warn((Object)message);
        }
    }

    public void warn(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.warn((Object)message, e);
            } else {
                log.warn((Object)message);
            }
        } else if (e != null) {
            log.warn((Object)"", e);
        }
    }

    public void info(String message) {
        if (message != null) {
            log.info((Object)message);
        }
    }

    public void info(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.info((Object)message, e);
            } else {
                log.info((Object)message);
            }
        } else if (e != null) {
            log.info((Object)"", e);
        }
    }

    public void debug(String message) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            log.debug((Object)message);
        }
    }

    public void debug(String message, Throwable e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            if (e != null) {
                log.debug((Object)message, e);
            } else {
                log.debug((Object)message);
            }
        } else if (e != null) {
            log.debug((Object)"", e);
        }
    }
}

