/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.xmlprops;

import com.mchange.v1.xml.ResourceEntityResolver;
import com.mchange.v1.xml.StdErrErrorHandler;
import com.mchange.v1.xmlprops.XmlPropsException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DomXmlPropsParser {
    static final String XMLPROPS_NAMESPACE_URI = "http://www.mchange.com/namespaces/xmlprops";
    static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public Properties parseXmlProps(InputStream istr) throws XmlPropsException {
        return this.parseXmlProps(new InputSource(istr), new ResourceEntityResolver(this.getClass()), new StdErrErrorHandler());
    }

    private Properties parseXmlProps(InputSource isrc, EntityResolver eresolv, ErrorHandler grrr) throws XmlPropsException {
        try {
            Properties props = new Properties();
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            dbuilder.setEntityResolver(eresolv);
            dbuilder.setErrorHandler(grrr);
            Document doc = dbuilder.parse(isrc);
            Element docElem = doc.getDocumentElement();
            NodeList propertiesNL = docElem.getElementsByTagName("property");
            int len = propertiesNL.getLength();
            for (int i = 0; i < len; ++i) {
                Element propElem = (Element)propertiesNL.item(i);
                String name = propElem.getAttribute("name");
                StringBuffer valueBuf = new StringBuffer();
                NodeList peNL = propElem.getChildNodes();
                int plen = peNL.getLength();
                for (int j = 0; j < plen; ++j) {
                    Node node = peNL.item(j);
                    if (node.getNodeType() != 3) continue;
                    valueBuf.append(node.getNodeValue());
                }
                props.put(name, valueBuf.toString());
            }
            return props;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlPropsException(e);
        }
    }

    public static void main(String[] argv) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(argv[0]));
            DomXmlPropsParser parser = new DomXmlPropsParser();
            Properties props = parser.parseXmlProps(is);
            for (String string : props.keySet()) {
                String value = props.getProperty(string);
                System.err.println(string + '=' + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        factory.setNamespaceAware(true);
        factory.setValidating(true);
    }
}

