/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.facade;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.facade.HttpSessionFacade;
import org.apache.tomcat.facade.ServletInputStreamFacade;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.RequestUtil;
import org.apache.tomcat.util.StringManager;

final class HttpServletRequestFacade
implements HttpServletRequest {
    private static StringManager smCore = StringManager.getManager("org.apache.tomcat.core");
    private static StringManager smUtil = StringManager.getManager("org.apache.tomcat.util");
    private Request request;
    HttpSessionFacade sessionFacade;
    ServletInputStreamFacade isFacade = null;
    BufferedReader reader;
    static final boolean NO_SESSION_FACADE = true;
    private boolean usingStream = false;
    private boolean usingReader = false;

    HttpServletRequestFacade(Request request) {
        this.request = request;
    }

    void recycle() {
        this.usingReader = false;
        this.usingStream = false;
        if (this.sessionFacade != null) {
            this.sessionFacade.recycle();
        }
        if (this.isFacade != null) {
            this.isFacade.recycle();
        }
    }

    Request getRealRequest() {
        return this.request;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public Cookie[] getCookies() {
        int count = this.request.getCookieCount();
        Cookie[] cookieArray = new Cookie[count];
        int i = 0;
        while (i < count) {
            cookieArray[i] = this.request.getCookie(i);
            ++i;
        }
        return cookieArray;
    }

    public long getDateHeader(String name) {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long date = RequestUtil.toDate(value);
        if (date == -1L) {
            String msg = smUtil.getString("httpDate.pe", value);
            throw new IllegalArgumentException(msg);
        }
        return date;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            String msg = smCore.getString("reqfac.getinstream.ise");
            throw new IllegalStateException(msg);
        }
        this.usingStream = true;
        if (this.isFacade != null) {
            return this.isFacade;
        }
        if (this.request.getInputBuffer() != null) {
            this.isFacade = new ServletInputStreamFacade();
            this.isFacade.setRequest(this.request);
            return this.isFacade;
        }
        return this.request.getInputStream();
    }

    public int getIntHeader(String name) throws NumberFormatException {
        String value = this.request.getHeader(name);
        if (value == null) {
            return -1;
        }
        int valueInt = Integer.parseInt(value);
        return valueInt;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    public Enumeration getParameterNames() {
        return this.request.getParameterNames();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingStream) {
            String msg = smCore.getString("reqfac.getreader.ise");
            throw new IllegalStateException(msg);
        }
        this.usingReader = true;
        if (this.isFacade == null && this.request.getInputBuffer() == null) {
            return this.request.getReader();
        }
        if (this.isFacade == null) {
            this.isFacade = new ServletInputStreamFacade();
        }
        this.isFacade.setRequest(this.request);
        if (this.reader != null) {
            return this.reader;
        }
        String encoding = this.request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "8859_1";
        }
        InputStreamReader r = new InputStreamReader((InputStream)((Object)this.isFacade), encoding);
        this.reader = new BufferedReader(r);
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String pI;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/") && (path = (pI = this.request.getPathInfo()) == null ? FileUtil.catPath(this.request.getServletPath(), path) : FileUtil.catPath(this.request.getServletPath() + pI, path)) == null) {
            return null;
        }
        return this.request.getContext().getFacade().getRequestDispatcher(path);
    }

    public Locale getLocale() {
        return (Locale)this.getLocales().nextElement();
    }

    public Enumeration getLocales() {
        return RequestUtil.getLocales(this);
    }

    public String getContextPath() {
        return this.request.getContext().getPath();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public String getRealPath(String name) {
        return this.request.getContext().getRealPath(name);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public HttpSession getSession() {
        return this.request.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession realSession = this.request.getSession(create);
        return realSession;
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        boolean isvalid = false;
        HttpSession session = this.request.getSession(false);
        if (session != null && session.getId().equals(this.getRequestedSessionId())) {
            isvalid = true;
        }
        return isvalid;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return "cookie".equals(this.request.getSessionIdSource());
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return "url".equals(this.request.getSessionIdSource());
    }
}

