/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.cfg.schema;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Schemas {
    public static final String DESTDIR = "Destdir";
    public static final String PROJECTNAME = "ProjectName";
    public static final String VERSION = "Version";
    public static final String SCHEMA = "Schema";
    private String _Destdir;
    private String _ProjectName;
    private BigDecimal _Version;
    private List _Schema = new ArrayList();
    private String schemaLocation;

    public Schemas() {
    }

    public Schemas(Schemas source) {
        this(source, false);
    }

    public Schemas(Schemas source, boolean justData) {
        this._Destdir = source._Destdir;
        this._ProjectName = source._ProjectName;
        this._Version = source._Version;
        for (Schema srcElement : source._Schema) {
            this._Schema.add(srcElement == null ? null : this.newSchema(srcElement, justData));
        }
        this.schemaLocation = source.schemaLocation;
    }

    public void setDestdir(String value) {
        this._Destdir = value;
    }

    public String getDestdir() {
        return this._Destdir;
    }

    public void setProjectName(String value) {
        this._ProjectName = value;
    }

    public String getProjectName() {
        return this._ProjectName;
    }

    public void setVersion(BigDecimal value) {
        this._Version = value;
    }

    public BigDecimal getVersion() {
        return this._Version;
    }

    public void setSchema(Schema[] value) {
        if (value == null) {
            value = new Schema[]{};
        }
        this._Schema.clear();
        ((ArrayList)this._Schema).ensureCapacity(value.length);
        for (int i = 0; i < value.length; ++i) {
            this._Schema.add(value[i]);
        }
    }

    public void setSchema(int index, Schema value) {
        this._Schema.set(index, value);
    }

    public Schema[] getSchema() {
        Schema[] arr = new Schema[this._Schema.size()];
        return this._Schema.toArray(arr);
    }

    public List fetchSchemaList() {
        return this._Schema;
    }

    public Schema getSchema(int index) {
        return (Schema)this._Schema.get(index);
    }

    public int sizeSchema() {
        return this._Schema.size();
    }

    public int addSchema(Schema value) {
        this._Schema.add(value);
        int positionOfNewItem = this._Schema.size() - 1;
        return positionOfNewItem;
    }

    public int removeSchema(Schema value) {
        int pos = this._Schema.indexOf(value);
        if (pos >= 0) {
            this._Schema.remove(pos);
        }
        return pos;
    }

    public void _setSchemaLocation(String location) {
        this.schemaLocation = location;
    }

    public String _getSchemaLocation() {
        return this.schemaLocation;
    }

    public Schema newSchema() {
        return new Schema();
    }

    public Schema newSchema(Schema source, boolean justData) {
        return new Schema(source, justData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileObject fo) throws IOException {
        FileLock lock = fo.lock();
        try {
            OutputStream out = fo.getOutputStream(lock);
            this.write(out);
            out.close();
        }
        finally {
            lock.releaseLock();
        }
    }

    public void write(FileObject dir, String filename) throws IOException {
        FileObject file = dir.getFileObject(filename);
        if (file == null) {
            file = dir.createData(filename);
        }
        this.write(file);
    }

    public void write(File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            this.write(out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, null);
    }

    public void write(OutputStream out, String encoding) throws IOException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, encoding));
        this.write(w, encoding);
        ((Writer)w).flush();
    }

    public void write(Writer out, String encoding) throws IOException {
        out.write("<?xml version='1.0'");
        if (encoding != null) {
            out.write(" encoding='" + encoding + "'");
        }
        out.write(" ?>\n");
        this.writeNode(out, "schemas", "");
    }

    public void writeNode(Writer out) throws IOException {
        String myName = "schemas";
        this.writeNode(out, myName, "");
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        this.writeNode(out, nodeName, null, indent, new HashMap());
    }

    public void writeNode(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        out.write(indent);
        out.write("<");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(" xmlns='");
        out.write("http://xml.netbeans.org/schema/JAXBWizConfig");
        out.write("'");
        if (this.schemaLocation != null) {
            namespaceMap.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            out.write(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='");
            out.write(this.schemaLocation);
            out.write("'");
        }
        this.writeNodeAttributes(out, nodeName, namespace, indent, namespaceMap);
        out.write(">\n");
        this.writeNodeChildren(out, nodeName, namespace, indent, namespaceMap);
        out.write(indent);
        out.write("</");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
    }

    protected void writeNodeAttributes(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        if (this._Destdir != null) {
            out.write(" destdir='");
            Schemas.writeXML(out, this._Destdir, true);
            out.write("'");
        }
        if (this._ProjectName != null) {
            out.write(" projectName='");
            Schemas.writeXML(out, this._ProjectName, true);
            out.write("'");
        }
        if (this._Version != null) {
            out.write(" version='");
            out.write(this._Version.toString());
            out.write("'");
        }
    }

    protected void writeNodeChildren(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        String nextIndent = indent + "\t";
        for (Schema element : this._Schema) {
            if (element == null) continue;
            element.writeNode(out, "schema", null, nextIndent, namespaceMap);
        }
    }

    public static Schemas read(FileObject fo) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = fo.getInputStream();
        try {
            Schemas schemas = Schemas.read(in);
            return schemas;
        }
        finally {
            in.close();
        }
    }

    public static Schemas read(File f) throws ParserConfigurationException, SAXException, IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            Schemas schemas = Schemas.read(in);
            return schemas;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static Schemas read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return Schemas.read(new InputSource(in), false, null, null);
    }

    public static Schemas readNoEntityResolver(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        return Schemas.read(new InputSource(in), false, new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                ByteArrayInputStream bin = new ByteArrayInputStream(new byte[0]);
                return new InputSource(bin);
            }
        }, null);
    }

    public static Schemas read(InputSource in, boolean validate, EntityResolver er, ErrorHandler eh) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(validate);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (er != null) {
            db.setEntityResolver(er);
        }
        if (eh != null) {
            db.setErrorHandler(eh);
        }
        Document doc = db.parse(in);
        return Schemas.read(doc);
    }

    public static Schemas read(Document document) {
        Schemas aSchemas = new Schemas();
        aSchemas.readFromDocument(document);
        return aSchemas;
    }

    protected void readFromDocument(Document document) {
        this.readNode(document.getDocumentElement());
    }

    public void readNode(Node node) {
        this.readNode(node, new HashMap());
    }

    public void readNode(Node node, Map namespacePrefixes) {
        if (node.hasAttributes()) {
            Attr attr;
            NamedNodeMap attrs = node.getAttributes();
            boolean firstNamespaceDef = true;
            for (int attrNum = 0; attrNum < attrs.getLength(); ++attrNum) {
                attr = (Attr)attrs.item(attrNum);
                String attrName = attr.getName();
                if (!attrName.startsWith("xmlns:")) continue;
                if (firstNamespaceDef) {
                    firstNamespaceDef = false;
                    namespacePrefixes = new HashMap<String, String>(namespacePrefixes);
                }
                String attrNSPrefix = attrName.substring(6, attrName.length());
                namespacePrefixes.put(attrNSPrefix, attr.getValue());
            }
            String xsiPrefix = "xsi";
            for (String prefix : namespacePrefixes.keySet()) {
                String ns = (String)namespacePrefixes.get(prefix);
                if (!"http://www.w3.org/2001/XMLSchema-instance".equals(ns)) continue;
                xsiPrefix = prefix;
                break;
            }
            if ((attr = (Attr)attrs.getNamedItem("" + xsiPrefix + ":schemaLocation")) != null) {
                String attrValue;
                this.schemaLocation = attrValue = attr.getValue();
            }
            this.readNodeAttributes(node, namespacePrefixes, attrs);
        }
        this.readNodeChildren(node, namespacePrefixes);
    }

    protected void readNodeAttributes(Node node, Map namespacePrefixes, NamedNodeMap attrs) {
        String attrValue;
        Attr attr = (Attr)attrs.getNamedItem("destdir");
        if (attr != null) {
            this._Destdir = attrValue = attr.getValue();
        }
        if ((attr = (Attr)attrs.getNamedItem("projectName")) != null) {
            this._ProjectName = attrValue = attr.getValue();
        }
        if ((attr = (Attr)attrs.getNamedItem("version")) != null) {
            attrValue = attr.getValue();
            this._Version = new BigDecimal(attrValue);
        }
    }

    protected void readNodeChildren(Node node, Map namespacePrefixes) {
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName != "schema") continue;
            Schema aSchema = this.newSchema();
            aSchema.readNode(childNode, namespacePrefixes);
            this._Schema.add(aSchema);
        }
    }

    public static void writeXML(Writer out, String msg) throws IOException {
        Schemas.writeXML(out, msg, true);
    }

    public static void writeXML(Writer out, String msg, boolean attribute) throws IOException {
        if (msg == null) {
            return;
        }
        int msgLength = msg.length();
        for (int i = 0; i < msgLength; ++i) {
            char c = msg.charAt(i);
            Schemas.writeXML(out, c, attribute);
        }
    }

    public static void writeXML(Writer out, char msg, boolean attribute) throws IOException {
        if (msg == '&') {
            out.write("&amp;");
        } else if (msg == '<') {
            out.write("&lt;");
        } else if (msg == '>') {
            out.write("&gt;");
        } else if (attribute) {
            if (msg == '\"') {
                out.write("&quot;");
            } else if (msg == '\'') {
                out.write("&apos;");
            } else if (msg == '\n') {
                out.write("&#xA;");
            } else if (msg == '\t') {
                out.write("&#x9;");
            } else {
                out.write(msg);
            }
        } else {
            out.write(msg);
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "destdir") {
            this.setDestdir((String)value);
        } else if (name == "projectName") {
            this.setProjectName((String)value);
        } else if (name == "version") {
            this.setVersion((BigDecimal)value);
        } else if (name == "schema") {
            this.addSchema((Schema)value);
        } else if (name == "schema[]") {
            this.setSchema((Schema[])value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for Schemas");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "destdir") {
            return this.getDestdir();
        }
        if (name == "projectName") {
            return this.getProjectName();
        }
        if (name == "version") {
            return this.getVersion();
        }
        if (name == "schema[]") {
            return this.getSchema();
        }
        throw new IllegalArgumentException(name + " is not a valid property name for Schemas");
    }

    public String nameSelf() {
        return "/Schemas";
    }

    public String nameChild(Object childObj) {
        return this.nameChild(childObj, false, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName) {
        return this.nameChild(childObj, returnConstName, returnSchemaName, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName) {
        Object child;
        if (childObj instanceof Schema) {
            child = (Schema)childObj;
            int index = 0;
            for (Schema element : this._Schema) {
                if (child == element) {
                    if (returnConstName) {
                        return SCHEMA;
                    }
                    if (returnSchemaName) {
                        return "schema";
                    }
                    if (returnXPathName) {
                        return "schema[position()=" + index + "]";
                    }
                    return "Schema." + Integer.toHexString(index);
                }
                ++index;
            }
        }
        if (childObj instanceof String) {
            child = (String)childObj;
            if (child == this._Destdir) {
                if (returnConstName) {
                    return DESTDIR;
                }
                if (returnSchemaName) {
                    return "destdir";
                }
                if (returnXPathName) {
                    return "@destdir";
                }
                return DESTDIR;
            }
            if (child == this._ProjectName) {
                if (returnConstName) {
                    return PROJECTNAME;
                }
                if (returnSchemaName) {
                    return "projectName";
                }
                if (returnXPathName) {
                    return "@projectName";
                }
                return PROJECTNAME;
            }
        }
        if (childObj instanceof BigDecimal && (child = (BigDecimal)childObj) == this._Version) {
            if (returnConstName) {
                return VERSION;
            }
            if (returnSchemaName) {
                return "version";
            }
            if (returnXPathName) {
                return "@version";
            }
            return VERSION;
        }
        return null;
    }

    public Object[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        Object[] result = new Object[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
        for (Schema element : this._Schema) {
            if (element == null) continue;
            if (recursive) {
                element.childBeans(true, beans);
            }
            beans.add(element);
        }
    }

    public boolean equals(Object o) {
        return o instanceof Schemas && this.equals((Schemas)o);
    }

    public boolean equals(Schemas inst) {
        if (inst == this) {
            return true;
        }
        if (inst == null) {
            return false;
        }
        if (!(this._Destdir != null ? this._Destdir.equals(inst._Destdir) : inst._Destdir == null)) {
            return false;
        }
        if (!(this._ProjectName != null ? this._ProjectName.equals(inst._ProjectName) : inst._ProjectName == null)) {
            return false;
        }
        if (!(this._Version != null ? this._Version.equals(inst._Version) : inst._Version == null)) {
            return false;
        }
        if (this.sizeSchema() != inst.sizeSchema()) {
            return false;
        }
        Iterator it = this._Schema.iterator();
        Iterator it2 = inst._Schema.iterator();
        while (it.hasNext() && it2.hasNext()) {
            Schema element = (Schema)it.next();
            Schema element2 = (Schema)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._Destdir == null ? 0 : this._Destdir.hashCode());
        result = 37 * result + (this._ProjectName == null ? 0 : this._ProjectName.hashCode());
        result = 37 * result + (this._Version == null ? 0 : this._Version.hashCode());
        result = 37 * result + (this._Schema == null ? 0 : this._Schema.hashCode());
        return result;
    }
}

