/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2sedeploy.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2sedeploy.J2SEDeployProperties;
import org.netbeans.modules.java.j2seproject.api.J2SECategoryExtensionProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JSEDeploymentPanel
extends JPanel
implements HelpCtx.Provider {
    private final J2SEDeployProperties props;
    private Project project;
    private List<J2SECategoryExtensionProvider> compProviders = new LinkedList<J2SECategoryExtensionProvider>();
    private int nextExtensionYPos;
    private List<ActionListener> okListener = new ArrayList<ActionListener>();
    private List<ActionListener> storeListener = new ArrayList<ActionListener>();
    private List<ActionListener> closeListener = new ArrayList<ActionListener>();
    private JCheckBox checkBoxNativePackaging;
    private JPanel extPanel;
    private JLabel labelNativePackaging;
    private JPanel mainPanel;

    public JSEDeploymentPanel(J2SEDeployProperties props) {
        this.props = props;
        this.initComponents();
        this.checkBoxNativePackaging.setSelected(props.getNativeBundlingEnabled());
        this.project = props.getProject();
        for (J2SECategoryExtensionProvider compProvider : this.project.getLookup().lookupAll(J2SECategoryExtensionProvider.class)) {
            if (compProvider.getCategory() != J2SECategoryExtensionProvider.ExtensibleCategory.DEPLOYMENT || !this.addExtPanel(this.project, compProvider, this.nextExtensionYPos)) continue;
            this.compProviders.add(compProvider);
            ++this.nextExtensionYPos;
        }
        this.addPanelFiller(this.nextExtensionYPos);
    }

    @NonNull
    public List<ActionListener> getOKListeners() {
        return this.okListener;
    }

    @NonNull
    public List<ActionListener> getStoreListeners() {
        return this.storeListener;
    }

    @NonNull
    public List<ActionListener> getCloseListeners() {
        return this.closeListener;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.labelNativePackaging = new JLabel();
        this.checkBoxNativePackaging = new JCheckBox();
        this.extPanel = new JPanel();
        this.setPreferredSize(new Dimension(550, 400));
        this.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(550, 60));
        this.mainPanel.setLayout(new GridBagLayout());
        this.labelNativePackaging.setLabelFor(this.checkBoxNativePackaging);
        Mnemonics.setLocalizedText((JLabel)this.labelNativePackaging, (String)NbBundle.getMessage(JSEDeploymentPanel.class, (String)"JSEDeploymentPanel.labelNativePackaging.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        this.mainPanel.add((Component)this.labelNativePackaging, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.checkBoxNativePackaging, (String)NbBundle.getMessage(JSEDeploymentPanel.class, (String)"JSEDeploymentPanel.checkBoxNativePackaging.text"));
        this.checkBoxNativePackaging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSEDeploymentPanel.this.checkBoxNativePackagingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(7, 15, 0, 0);
        this.mainPanel.add((Component)this.checkBoxNativePackaging, gridBagConstraints);
        this.checkBoxNativePackaging.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JSEDeploymentPanel.class, (String)"AN_JSEDeploymentPanel.checkBoxNativePackaging"));
        this.checkBoxNativePackaging.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSEDeploymentPanel.class, (String)"AD_JSEDeploymentPanel.checkBoxNativePackaging"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.extPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.extPanel, gridBagConstraints);
    }

    private void checkBoxNativePackagingActionPerformed(ActionEvent evt) {
        boolean sel = this.checkBoxNativePackaging.isSelected();
        this.props.setNativeBundlingEnabled(sel);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSEDeploymentPanel.class);
    }

    private boolean addExtPanel(Project p, J2SECategoryExtensionProvider compProvider, int gridY) {
        J2SECategoryExtensionProvider.ConfigChangeListener ccl;
        JComponent comp;
        if (compProvider != null && (comp = compProvider.createComponent(p, ccl = new J2SECategoryExtensionProvider.ConfigChangeListener(){

            public void propertiesChanged(Map<String, String> updates) {
            }
        })) != null) {
            Object closeObject;
            Object storeObject;
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = gridY;
            constraints.weightx = 1.0;
            this.extPanel.add((Component)comp, constraints);
            Object okObject = comp.getClientProperty("pass.OK.listener");
            if (okObject != null && okObject instanceof ActionListener) {
                this.okListener.add((ActionListener)okObject);
            }
            if ((storeObject = comp.getClientProperty("pass.Store.listener")) != null && storeObject instanceof ActionListener) {
                this.storeListener.add((ActionListener)storeObject);
            }
            if ((closeObject = comp.getClientProperty("pass.Close.listener")) != null && closeObject instanceof ActionListener) {
                this.closeListener.add((ActionListener)closeObject);
            }
            return true;
        }
        return false;
    }

    private void addPanelFiller(int gridY) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = gridY;
        constraints.weighty = 1.0;
        this.extPanel.add((Component)new Box.Filler(new Dimension(), new Dimension(), new Dimension(10000, 10000)), constraints);
    }
}

