/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.DirectoryScanner;
import org.netbeans.api.project.Project;
import org.netbeans.core.startup.TestModuleDeployer;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.openide.filesystems.FileUtil;

public class ExecutionChecker
implements ExecutionResultChecker {
    private Project project;

    public ExecutionChecker(Project prj) {
        this.project = prj;
    }

    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        if ("nbmreload".equals(config.getActionName()) && resultCode == 0) {
            DirectoryScanner scanner = new DirectoryScanner();
            NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            File basedir = new File(prj.getMavenProject().getBuild().getDirectory(), "nbm");
            scanner.setBasedir(basedir);
            scanner.setIncludes(new String[]{"**/modules/*.jar", "**/modules/eager/*.jar", "**/modules/autoload/*.jar"});
            scanner.scan();
            String[] incl = scanner.getIncludedFiles();
            if (incl != null && incl.length > 0) {
                if (incl[0].indexOf("eager") > -1 || incl[0].indexOf("autoload") > -1) {
                    res.getInputOutput().getErr().println("NetBeans: Cannot reload 'autoload' or 'eager' modules.");
                }
                try {
                    res.getInputOutput().getOut().println("NetBeans: Deploying NBM module in development IDE...");
                    TestModuleDeployer.deployTestModule((File)FileUtil.normalizeFile((File)new File(basedir, incl[0])));
                }
                catch (IOException ex) {
                    res.getInputOutput().getOut().println("NetBeans: Error redeploying NBM module in development IDE.");
                    Logger.getLogger(ExecutionChecker.class.getName()).log(Level.INFO, "Error reloading netbeans module in development IDE.", ex);
                }
            } else {
                res.getInputOutput().getErr().println("NetBeans: Cannot find any built NetBeans Module artifacts for reload.");
            }
        }
    }
}

