/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListModel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MessDetectorCustomizerPanel
extends JPanel {
    private static final long serialVersionUID = -4687321324676897L;
    public static final String ENABLED = "messDetector.enabled";
    public static final String RULE_SETS = "messDetector.ruleSets";
    private final MessDetectorRuleSetsListModel ruleSetsListModel = new MessDetectorRuleSetsListModel();
    final Analyzer.CustomizerContext<Void, MessDetectorCustomizerPanel> context;
    final Preferences settings;
    private JCheckBox enabledCheckBox;
    private JLabel ruleSetsLabel;
    private JList<String> ruleSetsList;
    private JScrollPane ruleSetsScrollPane;

    public MessDetectorCustomizerPanel(Analyzer.CustomizerContext<Void, MessDetectorCustomizerPanel> context) {
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    @CheckForNull
    public static List<String> getRuleSets(Preferences settings) {
        if (settings == null) {
            return null;
        }
        String ruleSets = settings.get(RULE_SETS, null);
        if (ruleSets == null) {
            return null;
        }
        return AnalysisUtils.deserialize(ruleSets);
    }

    private void init() {
        this.enabledCheckBox.addItemListener(e -> {
            this.setMessDetectorEnabled();
            this.setRuleSetsComponentsEnabled(this.enabledCheckBox.isSelected());
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.enabledCheckBox.setSelected(isEnabled);
        this.setRuleSetsComponentsEnabled(isEnabled);
        this.ruleSetsList.setModel(this.ruleSetsListModel);
        List<String> ruleSets = MessDetectorCustomizerPanel.getRuleSets(this.settings);
        if (ruleSets == null) {
            ruleSets = AnalysisOptions.getInstance().getMessDetectorRuleSets();
        }
        this.selectRuleSets(ruleSets);
        this.ruleSetsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MessDetectorCustomizerPanel.this.validateAndSetData();
            }
        });
    }

    List<String> getSelectedRuleSets() {
        return this.ruleSetsList.getSelectedValuesList();
    }

    void selectRuleSets(List<String> ruleSets) {
        this.ruleSetsList.clearSelection();
        for (String ruleSet : ruleSets) {
            int indexOf = MessDetectorRuleSetsListModel.getAllRuleSets().indexOf(ruleSet);
            assert (indexOf != -1) : "Rule set not found: " + ruleSet;
            this.ruleSetsList.addSelectionInterval(indexOf, indexOf);
        }
    }

    void validateAndSetData() {
        if (this.validateData()) {
            this.setData();
        }
    }

    private boolean validateData() {
        ValidationResult result = new AnalysisOptionsValidator().validateMessDetectorRuleSets(this.getSelectedRuleSets()).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setData() {
        this.settings.put(RULE_SETS, AnalysisUtils.serialize(this.getSelectedRuleSets()));
    }

    private void setMessDetectorEnabled() {
        this.settings.putBoolean(ENABLED, this.enabledCheckBox.isSelected());
    }

    private void setRuleSetsComponentsEnabled(boolean isEnabled) {
        this.ruleSetsLabel.setEnabled(isEnabled);
        this.ruleSetsList.setEnabled(isEnabled);
        this.ruleSetsScrollPane.setEnabled(isEnabled);
    }

    private void initComponents() {
        this.ruleSetsLabel = new JLabel();
        this.ruleSetsScrollPane = new JScrollPane();
        this.ruleSetsList = new JList();
        this.enabledCheckBox = new JCheckBox();
        this.ruleSetsLabel.setLabelFor(this.ruleSetsList);
        Mnemonics.setLocalizedText((JLabel)this.ruleSetsLabel, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.ruleSetsLabel.text"));
        this.ruleSetsScrollPane.setViewportView(this.ruleSetsList);
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(MessDetectorCustomizerPanel.class, (String)"MessDetectorCustomizerPanel.enabledCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ruleSetsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ruleSetsScrollPane, -1, 166, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ruleSetsLabel).addComponent(this.ruleSetsScrollPane, -2, -1, -2))));
    }
}

