/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.nodes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;

public class ClassConstantDeclarationInfo
extends ASTNodeInfo<Identifier> {
    private final String value;
    private final ConstantDeclaration constantDeclaration;

    ClassConstantDeclarationInfo(Identifier node, String value, ConstantDeclaration constantDeclaration) {
        super(node);
        this.value = value;
        this.constantDeclaration = constantDeclaration;
    }

    public static List<? extends ClassConstantDeclarationInfo> create(ConstantDeclaration constantDeclaration) {
        ArrayList<ClassConstantDeclarationInfo> retval = new ArrayList<ClassConstantDeclarationInfo>();
        Iterator<Identifier> iteratorNames = constantDeclaration.getNames().iterator();
        Iterator<Expression> iteratorInitializers = constantDeclaration.getInitializers().iterator();
        while (iteratorNames.hasNext()) {
            UnaryOperation unaryOperation;
            Expression expression;
            String value = null;
            Identifier name = iteratorNames.next();
            Expression initializer = iteratorInitializers.next();
            if (initializer instanceof Scalar) {
                value = ((Scalar)initializer).getStringValue();
            } else if (initializer instanceof UnaryOperation && (expression = (unaryOperation = (UnaryOperation)initializer).getExpression()) instanceof Scalar) {
                value = (Object)((Object)unaryOperation.getOperator()) + ((Scalar)expression).getStringValue();
            }
            retval.add(new ClassConstantDeclarationInfo(name, value, constantDeclaration));
        }
        return retval;
    }

    @Override
    public ASTNodeInfo.Kind getKind() {
        return ASTNodeInfo.Kind.CLASS_CONSTANT;
    }

    @Override
    public String getName() {
        return ((Identifier)this.getOriginalNode()).getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return QualifiedName.createUnqualifiedName(this.getName());
    }

    @Override
    public OffsetRange getRange() {
        Identifier name = (Identifier)this.getOriginalNode();
        return new OffsetRange(name.getStartOffset(), name.getEndOffset());
    }

    public String getValue() {
        return this.value;
    }

    public PhpModifiers getAccessModifiers() {
        return PhpModifiers.fromBitMask(this.constantDeclaration.getModifier());
    }
}

