/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.openide.filesystems.FileObject;

public final class VariableScopeFinder {
    public static VariableScopeFinder create() {
        return new VariableScopeFinder();
    }

    private VariableScopeFinder() {
    }

    public VariableScope find(Scope scope, int offset, ScopeRangeAcceptor scopeRangeAcceptor) {
        assert (scope != null);
        return this.find(scope.getElements(), offset, scopeRangeAcceptor);
    }

    public VariableScope find(List<? extends ModelElement> elements, int offset, ScopeRangeAcceptor scopeRangeAcceptor) {
        return this.findWrapper(elements, offset, scopeRangeAcceptor).getVariableScope();
    }

    private VariableScopeWrapper findWrapper(List<? extends ModelElement> elements, int offset, ScopeRangeAcceptor scopeRangeAcceptor) {
        assert (elements != null);
        assert (scopeRangeAcceptor != null);
        VariableScopeWrapper retval = VariableScopeWrapper.NONE;
        LinkedList<? extends ModelElement> subElements = new LinkedList<ModelElement>();
        for (ModelElement modelElement : elements) {
            LazyBuild scope;
            VariableScope varScope;
            VariableScopeWrapperImpl varScopeWrapper;
            if (!(modelElement instanceof VariableScope) || !scopeRangeAcceptor.accept(varScopeWrapper = new VariableScopeWrapperImpl(varScope = (VariableScope)modelElement, scopeRangeAcceptor), offset) || !scopeRangeAcceptor.overlaps(retval, varScopeWrapper)) continue;
            if (modelElement instanceof LazyBuild && !(scope = (LazyBuild)((Object)modelElement)).isScanned()) {
                scope.scan();
            }
            retval = varScopeWrapper;
            subElements.addAll(varScopeWrapper.getElements());
        }
        VariableScopeWrapper subResult = subElements.isEmpty() ? VariableScopeWrapper.NONE : this.findWrapper(subElements, offset, scopeRangeAcceptor);
        return subResult == VariableScopeWrapper.NONE ? retval : subResult;
    }

    public VariableScope findNearestVarScope(Scope scope, int offset, VariableScope atOffset) {
        List<? extends ModelElement> elements = scope.getElements();
        for (ModelElement modelElement : elements) {
            VariableScope variableScope;
            OffsetRange blockRange;
            FileObject fileObject;
            if (modelElement instanceof ClassScope || modelElement instanceof NamespaceScope) {
                atOffset = this.findNearestVarScope((Scope)modelElement, offset, atOffset);
            }
            if (!(modelElement instanceof VariableScope) || modelElement.getNameRange().getStart() > offset || atOffset != null && atOffset.getOffset() >= modelElement.getOffset() || (fileObject = modelElement.getFileObject()) != scope.getFileObject() || (blockRange = (variableScope = (VariableScope)modelElement).getBlockRange()) != null && !blockRange.containsInclusive(offset)) continue;
            atOffset = variableScope;
        }
        if (atOffset == null) {
            OffsetRange blockRange;
            while (scope != null && !(scope instanceof VariableScope)) {
                scope = scope.getInScope();
            }
            if (scope != null && ((blockRange = scope.getBlockRange()) == null || blockRange.containsInclusive(offset))) {
                atOffset = (VariableScope)scope;
            }
        }
        return atOffset;
    }

    private static final class VariableScopeWrapperImpl
    implements VariableScopeWrapper {
        private final VariableScope variableScope;
        private final ScopeRangeAcceptor scopeRangeAcceptor;

        private VariableScopeWrapperImpl(VariableScope variableScope, ScopeRangeAcceptor scopeRangeAcceptor) {
            assert (variableScope != null);
            this.variableScope = variableScope;
            this.scopeRangeAcceptor = scopeRangeAcceptor;
        }

        @Override
        public VariableScope getVariableScope() {
            return this.variableScope;
        }

        @Override
        public boolean overlaps(VariableScopeWrapper variableScopeWrapper) {
            return this.scopeRangeAcceptor.overlaps(this, variableScopeWrapper);
        }

        @Override
        public List<? extends ModelElement> getElements() {
            return this.getVariableScope().getElements();
        }

        @Override
        public OffsetRange getNameRange() {
            return this.getVariableScope().getNameRange();
        }

        @Override
        public OffsetRange getBlockRange() {
            return this.getVariableScope().getBlockRange();
        }
    }

    public static interface VariableScopeWrapper {
        public static final VariableScopeWrapper NONE = new VariableScopeWrapper(){

            @Override
            public VariableScope getVariableScope() {
                return null;
            }

            @Override
            public boolean overlaps(VariableScopeWrapper variableScopeWrapper) {
                return true;
            }

            @Override
            public List<? extends ModelElement> getElements() {
                return Collections.EMPTY_LIST;
            }

            @Override
            public OffsetRange getNameRange() {
                return null;
            }

            @Override
            public OffsetRange getBlockRange() {
                return null;
            }
        };

        public VariableScope getVariableScope();

        public boolean overlaps(VariableScopeWrapper var1);

        public List<? extends ModelElement> getElements();

        public OffsetRange getNameRange();

        public OffsetRange getBlockRange();
    }

    public static interface ScopeRangeAcceptor {
        public static final ScopeRangeAcceptor BLOCK = new ScopeRangeAcceptor(){

            @Override
            public boolean accept(VariableScopeWrapper variableScopeWrapper, int offset) {
                boolean result = false;
                OffsetRange blockRange = variableScopeWrapper.getBlockRange();
                if (blockRange != null && blockRange != OffsetRange.NONE) {
                    boolean possibleScope = true;
                    VariableScope variableScope = variableScopeWrapper.getVariableScope();
                    if ((variableScope instanceof FunctionScope || variableScope instanceof ClassScope) && blockRange.getEnd() == offset) {
                        possibleScope = false;
                    }
                    result = possibleScope && blockRange.containsInclusive(offset);
                }
                return result;
            }

            @Override
            public boolean overlaps(VariableScopeWrapper old, VariableScopeWrapper young) {
                OffsetRange oldBlockRange = old.getBlockRange();
                OffsetRange youngBlockRange = young.getBlockRange();
                return old == VariableScopeWrapper.NONE || oldBlockRange != null && youngBlockRange != null && oldBlockRange.overlaps(youngBlockRange);
            }
        };
        public static final ScopeRangeAcceptor NAME_START_BLOCK_END = new ScopeRangeAcceptor(){

            @Override
            public boolean accept(VariableScopeWrapper variableScopeWrapper, int offset) {
                OffsetRange blockRange;
                OffsetRange nameRange;
                boolean result = BLOCK.accept(variableScopeWrapper, offset);
                if (!result && (nameRange = variableScopeWrapper.getNameRange()) != null & (blockRange = variableScopeWrapper.getBlockRange()) != null) {
                    OffsetRange allRange = new OffsetRange(nameRange.getStart(), blockRange.getStart());
                    result = allRange.containsInclusive(offset);
                }
                return result;
            }

            @Override
            public boolean overlaps(VariableScopeWrapper old, VariableScopeWrapper young) {
                OffsetRange oldNameRange = old.getNameRange();
                OffsetRange oldBlockRange = old.getBlockRange();
                OffsetRange oldRange = null;
                if (oldNameRange != null && oldBlockRange != null) {
                    oldRange = new OffsetRange(oldNameRange.getStart(), oldBlockRange.getStart());
                }
                OffsetRange youngNameRange = young.getNameRange();
                OffsetRange youngBlockRange = young.getBlockRange();
                OffsetRange youngRange = null;
                if (youngNameRange != null && youngBlockRange != null) {
                    youngRange = new OffsetRange(youngNameRange.getStart(), youngBlockRange.getStart());
                }
                return old == VariableScopeWrapper.NONE || BLOCK.overlaps(old, young) || oldRange != null && youngRange != null && oldRange.overlaps(youngRange);
            }
        };

        public boolean accept(VariableScopeWrapper var1, int var2);

        public boolean overlaps(VariableScopeWrapper var1, VariableScopeWrapper var2);
    }
}

