/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.filesystems.FileObject;

public final class LatteUtils {
    private static final String LATTE_EXTENSION = "latte";
    private static final String DOTTED_RELATIVE_PRESENTER_PATH = "../../presenters/";
    private static final String COMMON_RELATIVE_PRESENTER_PATH = "../../../presenters/";
    private static final String PRESENTER_CLASS_SUFFIX = "Presenter";
    private static final String PRESENTER_FILE_SUFFIX = "Presenter.php";

    private LatteUtils() {
    }

    public static boolean isView(FileObject templateFile) {
        assert (templateFile != null);
        return LATTE_EXTENSION.equals(templateFile.getExt());
    }

    public static FileObject getPresenterFile(FileObject templateFile) {
        String relativePath;
        String presenterName;
        String templateName = templateFile.getName();
        if (templateName.contains(".")) {
            String[] parts = templateName.split("\\.");
            assert (parts.length > 0);
            presenterName = parts[0];
            relativePath = DOTTED_RELATIVE_PRESENTER_PATH;
        } else {
            presenterName = templateFile.getParent().getName();
            relativePath = COMMON_RELATIVE_PRESENTER_PATH;
        }
        return templateFile.getFileObject(relativePath + StringUtils.capitalize((String)presenterName) + PRESENTER_FILE_SUFFIX);
    }
}

