/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.action;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.ConnectException;
import java.text.ParseException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.PathUtils;
import org.netbeans.modules.terminal.api.IONotifier;
import org.netbeans.modules.terminal.api.ui.IOTerm;
import org.netbeans.modules.terminal.support.TerminalPinSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class TerminalSupportImpl {
    private static final RequestProcessor RP = new RequestProcessor("Terminal Action RP", 100);

    private TerminalSupportImpl() {
    }

    public static Component getToolbarPresenter(Action action) {
        JButton button = new JButton(action);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setText(null);
        button.putClientProperty("hideActionText", Boolean.TRUE);
        Object icon = action.getValue("SmallIcon");
        if (icon == null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/terminal/action/local_term.png", (boolean)false);
        }
        if (!(icon instanceof Icon)) {
            throw new IllegalStateException("No icon provided for " + action);
        }
        button.setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)icon)));
        return button;
    }

    public static void openTerminalImpl(final IOContainer ioContainer, String tabTitle, final ExecutionEnvironment env, final String dir, final boolean silentMode, final boolean pwdFlag, final long termId) {
        IOProvider ioProvider = IOProvider.get((String)"Terminal");
        if (ioProvider != null) {
            final AtomicReference<InputOutput> ioRef = new AtomicReference<InputOutput>();
            InputOutput io = ioProvider.getIO(tabTitle, null, ioContainer);
            ioRef.set(io);
            final AtomicBoolean destroyed = new AtomicBoolean(false);
            Runnable runnable = new Runnable(){
                private final Runnable delegate = new Runnable(){

                    @Override
                    public void run() {
                        if (SwingUtilities.isEventDispatchThread()) {
                            ioContainer.requestActive();
                        } else {
                            this.doWork();
                        }
                    }
                };
                RequestProcessor.Task task = TerminalSupportImpl.access$100().create(this.delegate);
                private final HyperlinkAdapter retryLink = new HyperlinkAdapter(){

                    @Override
                    public void outputLineAction(OutputEvent ev) {
                        task.schedule(0);
                    }
                };

                @Override
                public void run() {
                    this.delegate.run();
                }

                private void doWork() {
                    HostInfo hostInfo;
                    boolean verbose = env.isRemote();
                    OutputWriter out = ((InputOutput)ioRef.get()).getOut();
                    long id = TerminalPinSupport.getDefault().createPinDetails(TerminalPinSupport.TerminalCreationDetails.create((Term)IOTerm.term((InputOutput)((InputOutput)ioRef.get())), (long)termId, (String)env.getDisplayName(), (boolean)pwdFlag));
                    if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                        try {
                            if (verbose) {
                                out.println(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_ConnectingTo", (Object)env.getDisplayName()));
                            }
                            ConnectionManager.getInstance().connectTo(env);
                        }
                        catch (IOException ex) {
                            if (!destroyed.get()) {
                                if (verbose) {
                                    try {
                                        out.print(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_ConnectionFailed"));
                                        out.println(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_Retry"), (OutputListener)this.retryLink);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                String msg = NbBundle.getMessage(TerminalSupportImpl.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                            }
                            return;
                        }
                        catch (ConnectionManager.CancellationException ex) {
                            if (verbose) {
                                try {
                                    out.print(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_Canceled"));
                                    out.println(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_Retry"), (OutputListener)this.retryLink);
                                }
                                catch (IOException error) {
                                    // empty catch block
                                }
                            }
                            return;
                        }
                    }
                    String expandedDir = null;
                    try {
                        block39: {
                            if (!ConnectionManager.getInstance().isConnectedTo(env)) {
                                return;
                            }
                            try {
                                if (dir == null) break block39;
                                try {
                                    expandedDir = PathUtils.expandPath((String)dir, (ExecutionEnvironment)env);
                                }
                                catch (ParseException msg) {
                                    // empty catch block
                                }
                                if (expandedDir == null || !HostInfoUtils.directoryExists((ExecutionEnvironment)env, (String)expandedDir)) {
                                    out.print(NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_DirNotExist", (Object)dir, (Object)env.getDisplayName()));
                                    return;
                                }
                            }
                            catch (ConnectException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                        boolean isSupported = PtySupport.isSupportedFor((ExecutionEnvironment)env);
                        if (!isSupported) {
                            if (!silentMode) {
                                String message = hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS ? NbBundle.getMessage(TerminalSupportImpl.class, (String)"LocalTerminalNotSupported.error.nocygwin") : NbBundle.getMessage(TerminalSupportImpl.class, (String)"LocalTerminalNotSupported.error");
                                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 1);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            }
                            return;
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return;
                    }
                    if (verbose) {
                        try {
                            out.reset();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        final Term term = IOTerm.term((InputOutput)((InputOutput)ioRef.get()));
                        term.setEmulation("xterm");
                        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
                        npb.getEnvironment().put("LD_LIBRARY_PATH", "");
                        npb.getEnvironment().put("DYLD_LIBRARY_PATH", "");
                        if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                            npb.getEnvironment().put("CHERE_INVOKING", "1");
                        }
                        final TerminalPinSupport support = TerminalPinSupport.getDefault();
                        String envId = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
                        npb.addNativeProcessListener((ChangeListener)new NativeProcessListener((InputOutput)ioRef.get(), destroyed));
                        if (pwdFlag) {
                            String promptCommand = "printf \"\u001b]3;${PWD}\u0007\"; ideopen() { printf \"\u001b]10;ext[::] ideopen $*;\u0007\"; printf \"Opening $# file(s) ...\n\";}";
                            String commandName = "PROMPT_COMMAND";
                            String usrPrompt = npb.getEnvironment().get("PROMPT_COMMAND");
                            npb.getEnvironment().put("PROMPT_COMMAND", usrPrompt == null ? "printf \"\u001b]3;${PWD}\u0007\"; ideopen() { printf \"\u001b]10;ext[::] ideopen $*;\u0007\"; printf \"Opening $# file(s) ...\n\";}" : "printf \"\u001b]3;${PWD}\u0007\"; ideopen() { printf \"\u001b]10;ext[::] ideopen $*;\u0007\"; printf \"Opening $# file(s) ...\n\";};" + usrPrompt);
                            term.putClientProperty((Object)"ExecutionEnvironment_KEY", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env));
                        }
                        String shell = hostInfo.getLoginShell();
                        if (expandedDir != null) {
                            npb.setWorkingDirectory(expandedDir);
                        }
                        npb.setExecutable(shell);
                        if (shell.endsWith("bash") || shell.endsWith("bash.exe")) {
                            npb.setArguments(new String[]{"--login"});
                        }
                        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput((InputOutput)ioRef.get());
                        descr.postExecution(new Runnable(){

                            @Override
                            public void run() {
                                ((InputOutput)ioRef.get()).closeInputOutput();
                                support.close(term);
                            }
                        });
                        NativeExecutionService es = NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"Terminal Emulator");
                        Future result = es.run();
                        SwingUtilities.invokeLater(this);
                        try {
                            Integer rc = (Integer)result.get(10L, TimeUnit.SECONDS);
                            if (rc != 0) {
                                Logger.getLogger(TerminalSupportImpl.class.getName()).log(Level.INFO, "{0}{1}", new Object[]{NbBundle.getMessage(TerminalSupportImpl.class, (String)"LOG_ReturnCode"), rc});
                            }
                        }
                        catch (TimeoutException rc) {
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            if (!destroyed.get()) {
                                String error = ex.getCause() == null ? ex.getMessage() : ex.getCause().getMessage();
                                String msg = NbBundle.getMessage(TerminalSupportImpl.class, (String)"TerminalAction.FailedToStart.text", (Object)error);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                            }
                        }
                    }
                    catch (CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        this.reportInIO((InputOutput)ioRef.get(), ex);
                    }
                }

                private void reportInIO(InputOutput io, Exception ex) {
                    if (io != null && ex != null) {
                        io.getErr().print(ex.getLocalizedMessage());
                    }
                }
            };
            RP.post(runnable);
        }
    }

    private static class HyperlinkAdapter
    implements OutputListener {
        private HyperlinkAdapter() {
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class NativeProcessListener
    implements ChangeListener,
    PropertyChangeListener {
        private final AtomicReference<NativeProcess> processRef;
        private final AtomicBoolean destroyed;

        public NativeProcessListener(InputOutput io, AtomicBoolean destroyed) {
            assert (destroyed != null);
            this.destroyed = destroyed;
            this.processRef = new AtomicReference();
            IONotifier.addPropertyChangeListener((InputOutput)io, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)io));
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            NativeProcess process = this.processRef.get();
            if (process == null && e.getSource() instanceof NativeProcess) {
                this.processRef.compareAndSet(null, (NativeProcess)e.getSource());
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NativeProcess proc;
            if ("IOVisibility.PROP_VISIBILITY".equals(evt.getPropertyName()) && Boolean.FALSE.equals(evt.getNewValue()) && this.destroyed.compareAndSet(false, true) && (proc = this.processRef.get()) != null) {
                RP.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            proc.destroy();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }
}

