/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import com.microsoft.azure.eventhubs.ReceiverRuntimeInformation;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public interface PartitionReceiver {
    public static final int MINIMUM_PREFETCH_COUNT = 10;
    public static final int DEFAULT_PREFETCH_COUNT = 999;
    public static final long NULL_EPOCH = 0L;

    public String getPartitionId();

    public int getPrefetchCount();

    public void setPrefetchCount(int var1) throws EventHubException;

    public Duration getReceiveTimeout();

    public void setReceiveTimeout(Duration var1);

    public long getEpoch();

    public ReceiverRuntimeInformation getRuntimeInformation();

    default public Iterable<EventData> receiveSync(int maxEventCount) throws EventHubException {
        return ExceptionUtil.sync(() -> this.receive(maxEventCount).get());
    }

    public CompletableFuture<Iterable<EventData>> receive(int var1);

    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler var1);

    public CompletableFuture<Void> setReceiveHandler(PartitionReceiveHandler var1, boolean var2);

    public CompletableFuture<Void> close();

    public void closeSync() throws EventHubException;
}

