/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.RubyUtil;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.plugins.pipeline.AddressState;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

public class PipelineBus {
    final ConcurrentHashMap<String, AddressState> addressStates = new ConcurrentHashMap();
    final ConcurrentHashMap<PipelineOutput, ConcurrentHashMap<String, AddressState>> outputsToAddressStates = new ConcurrentHashMap();
    volatile boolean blockOnUnlisten = false;
    private static final Logger logger = LogManager.getLogger(PipelineBus.class);

    public void sendEvents(PipelineOutput sender, Collection<JrubyEventExtLibrary.RubyEvent> events, boolean ensureDelivery) {
        if (events.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, AddressState> addressesToInputs = this.outputsToAddressStates.get(sender);
        addressesToInputs.forEach((address, addressState) -> {
            boolean sendWasSuccess;
            Stream<JrubyEventExtLibrary.RubyEvent> clones = events.stream().map(e -> e.rubyClone(RubyUtil.RUBY));
            PipelineInput input = addressState.getInput();
            boolean bl = sendWasSuccess = input != null && input.internalReceive(clones);
            while (ensureDelivery && !sendWasSuccess) {
                String message = String.format("Attempted to send event to '%s' but that address was unavailable. Maybe the destination pipeline is down or stopping? Will Retry.", address);
                logger.warn(message);
                input = addressState.getInput();
                sendWasSuccess = input != null && input.internalReceive(clones);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    logger.error("Sleep unexpectedly interrupted in bus retry loop", (Throwable)e2);
                }
            }
        });
    }

    public void registerSender(PipelineOutput output, Iterable<String> addresses) {
        addresses.forEach(address -> this.addressStates.compute((String)address, (k, value) -> {
            AddressState state = value != null ? value : new AddressState((String)address);
            state.addOutput(output);
            return state;
        }));
        this.updateOutputReceivers(output);
    }

    public void unregisterSender(PipelineOutput output, Iterable<String> addresses) {
        addresses.forEach(address -> this.addressStates.computeIfPresent((String)address, (k, state) -> {
            state.removeOutput(output);
            if (state.isEmpty()) {
                return null;
            }
            return state;
        }));
        this.outputsToAddressStates.remove(output);
    }

    private void updateOutputReceivers(PipelineOutput output) {
        this.outputsToAddressStates.compute(output, (k, value) -> {
            ConcurrentHashMap outputAddressToInputMapping = value != null ? value : new ConcurrentHashMap();
            this.addressStates.forEach((address, state) -> {
                if (state.hasOutput(output)) {
                    outputAddressToInputMapping.put(address, state);
                }
            });
            return outputAddressToInputMapping;
        });
    }

    public boolean listen(PipelineInput input, String address) {
        boolean[] result = new boolean[1];
        this.addressStates.compute(address, (k, value) -> {
            AddressState state;
            AddressState addressState = state = value != null ? value : new AddressState(address);
            if (state.assignInputIfMissing(input)) {
                state.getOutputs().forEach(this::updateOutputReceivers);
                result[0] = true;
            } else {
                result[0] = false;
            }
            return state;
        });
        return result[0];
    }

    public void unlisten(PipelineInput input, String address) throws InterruptedException {
        if (this.isBlockOnUnlisten()) {
            this.unlistenBlock(input, address);
        } else {
            this.unlistenNonblock(input, address);
        }
    }

    public void unlistenBlock(PipelineInput input, String address) throws InterruptedException {
        boolean[] waiting = new boolean[]{true};
        while (true) {
            this.addressStates.compute(address, (k, state) -> {
                if (state == null) {
                    waiting[0] = false;
                    return null;
                }
                if (state.getOutputs().isEmpty()) {
                    state.unassignInput(input);
                    waiting[0] = false;
                    return null;
                }
                return state;
            });
            if (!waiting[0]) break;
            Thread.sleep(100L);
        }
    }

    public void unlistenNonblock(PipelineInput input, String address) {
        this.addressStates.computeIfPresent(address, (k, state) -> {
            state.unassignInput(input);
            state.getOutputs().forEach(this::updateOutputReceivers);
            return state.isEmpty() ? null : state;
        });
    }

    public boolean isBlockOnUnlisten() {
        return this.blockOnUnlisten;
    }

    public void setBlockOnUnlisten(boolean blockOnUnlisten) {
        this.blockOnUnlisten = blockOnUnlisten;
    }
}

