/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs;

import co.elastic.logstash.api.Configuration;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.LogstashPlugin;
import co.elastic.logstash.api.PluginConfigSpec;
import co.elastic.logstash.api.PluginHelper;
import co.elastic.logstash.api.v0.Codec;
import co.elastic.logstash.api.v0.Input;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.execution.queue.QueueWriter;
import org.logstash.plugins.discovery.PluginRegistry;

@LogstashPlugin(name="java-stdin")
public class Stdin
implements Input,
Consumer<Map<String, Object>> {
    private static final Logger logger = LogManager.getLogger(Stdin.class);
    public static final PluginConfigSpec<String> CODEC_CONFIG = Configuration.stringSetting("codec", "java-line");
    private static final int BUFFER_SIZE = 65536;
    private final LongAdder eventCounter = new LongAdder();
    private String hostname;
    private Codec codec;
    private volatile boolean stopRequested = false;
    private final CountDownLatch isStopped = new CountDownLatch(1);
    private FileChannel input;
    private QueueWriter writer;

    public Stdin(Configuration configuration, Context context) {
        this(configuration, context, new FileInputStream(FileDescriptor.in).getChannel());
    }

    Stdin(Configuration configuration, Context context, FileChannel inputChannel) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostname = "[unknownHost]";
        }
        String codecName = configuration.get(CODEC_CONFIG);
        this.codec = PluginRegistry.getCodec(codecName, configuration, context);
        if (this.codec == null) {
            throw new IllegalStateException(String.format("Unable to obtain codec '%a'", codecName));
        }
        this.input = inputChannel;
    }

    @Override
    public void start(QueueWriter writer) {
        this.writer = writer;
        ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
        try {
            while (!this.stopRequested && this.input.read(buffer) > -1) {
                buffer.flip();
                this.codec.decode(buffer, this);
                buffer.compact();
            }
        }
        catch (AsynchronousCloseException e2) {
            logger.warn("Stop request interrupted pending read");
        }
        catch (IOException e) {
            this.stopRequested = true;
            logger.error("Stopping stdin after read error", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            try {
                this.input.close();
            }
            catch (IOException e2) {}
            buffer.flip();
            this.codec.flush(buffer, this);
            this.isStopped.countDown();
        }
    }

    @Override
    public void accept(Map<String, Object> event) {
        event.putIfAbsent("hostname", this.hostname);
        this.writer.push(event);
        this.eventCounter.increment();
    }

    @Override
    public void stop() {
        this.stopRequested = true;
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.isStopped.await();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return PluginHelper.commonInputOptions(Collections.singletonList(CODEC_CONFIG));
    }
}

