/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins;

import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.plugins.discovery.PluginRegistry;

public final class PluginLookup {
    private static final IRubyObject RUBY_REGISTRY = RubyUtil.RUBY.executeScript("require 'logstash/plugins/registry'\nrequire 'logstash/plugin'\nLogStash::Plugin", "");

    private PluginLookup() {
    }

    public static PluginClass lookup(PluginType type, String name) {
        final Class<?> javaClass = PluginRegistry.getPluginClass(type, name);
        if (javaClass != null) {
            return new PluginClass(){

                @Override
                public PluginLanguage language() {
                    return PluginLanguage.JAVA;
                }

                @Override
                public Object klass() {
                    return javaClass;
                }
            };
        }
        IRubyObject klass = RUBY_REGISTRY.callMethod(RubyUtil.RUBY.getCurrentContext(), "lookup", new IRubyObject[]{type.rubyLabel(), RubyUtil.RUBY.newString(name)});
        final PluginLanguage language = klass instanceof RubyClass ? PluginLanguage.RUBY : PluginLanguage.JAVA;
        final IRubyObject resolvedClass = klass instanceof JavaClass ? ((JavaClass)klass).javaClass() : klass;
        return new PluginClass(){

            @Override
            public PluginLanguage language() {
                return language;
            }

            @Override
            public Object klass() {
                return resolvedClass;
            }
        };
    }

    public static enum PluginType {
        INPUT("input"),
        FILTER("filter"),
        OUTPUT("output"),
        CODEC("codec");

        private final RubyString label;

        private PluginType(String label) {
            this.label = RubyUtil.RUBY.newString(label);
        }

        RubyString rubyLabel() {
            return this.label;
        }
    }

    public static enum PluginLanguage {
        JAVA,
        RUBY;

    }

    public static interface PluginClass {
        public PluginLanguage language();

        public Object klass();

        default public String toReadableString() {
            return String.format("Plugin class [%s], language [%s]", new Object[]{this.klass(), this.language()});
        }
    }
}

