/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.process;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;
import org.logstash.instrument.witness.schedule.ScheduledWitness;

@JsonSerialize(using=Serializer.class)
public class ProcessWitness
implements SerializableWitness,
ScheduledWitness {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final String KEY = "process";
    public static final boolean isUnix = osMxBean instanceof UnixOperatingSystemMXBean;
    private static final UnixOperatingSystemMXBean unixOsBean = isUnix ? (UnixOperatingSystemMXBean)osMxBean : null;
    private final NumberGauge openFileDescriptors = new NumberGauge("open_file_descriptors", -1);
    private final NumberGauge peakOpenFileDescriptors;
    private final NumberGauge maxFileDescriptors = new NumberGauge("max_file_descriptors", -1);
    private final Cpu cpu;
    private final Memory memory;
    private final Snitch snitch;

    public ProcessWitness() {
        this.peakOpenFileDescriptors = new NumberGauge("peak_open_file_descriptors", -1);
        this.cpu = new Cpu();
        this.memory = new Memory();
        this.snitch = new Snitch(this);
    }

    @Override
    public void refresh() {
        if (isUnix) {
            long currentOpen = unixOsBean.getOpenFileDescriptorCount();
            this.openFileDescriptors.set(currentOpen);
            if (this.maxFileDescriptors.getValue() == null || ((Number)this.peakOpenFileDescriptors.getValue()).longValue() < currentOpen) {
                this.peakOpenFileDescriptors.set(currentOpen);
            }
            this.maxFileDescriptors.set(unixOsBean.getMaxFileDescriptorCount());
        }
        this.cpu.refresh();
        this.memory.refresh();
    }

    public Snitch snitch() {
        return this.snitch;
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    private short scaleLoadToPercent(double load) {
        if (isUnix && load >= 0.0) {
            return Double.valueOf(Math.floor(load * 100.0)).shortValue();
        }
        return -1;
    }

    public static final class Snitch {
        private final ProcessWitness witness;

        private Snitch(ProcessWitness witness) {
            this.witness = witness;
        }

        public long openFileDescriptors() {
            return ((Number)this.witness.openFileDescriptors.getValue()).longValue();
        }

        public long maxFileDescriptors() {
            return ((Number)this.witness.maxFileDescriptors.getValue()).longValue();
        }

        public long peakOpenFileDescriptors() {
            return ((Number)this.witness.peakOpenFileDescriptors.getValue()).longValue();
        }

        public short cpuProcessPercent() {
            return ((Number)this.witness.cpu.cpuProcessPercent.getValue()).shortValue();
        }

        public long cpuTotalInMillis() {
            return ((Number)this.witness.cpu.cpuTotalInMillis.getValue()).longValue();
        }

        public long memTotalVirtualInBytes() {
            return ((Number)this.witness.memory.memTotalVirtualInBytes.getValue()).longValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<ProcessWitness> {
        public Serializer() {
            this(ProcessWitness.class);
        }

        protected Serializer(Class<ProcessWitness> t) {
            super(t);
        }

        public void serialize(ProcessWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(ProcessWitness witness, JsonGenerator gen) throws IOException {
            MetricSerializer<Metric<Number>> numberSerializer = MetricSerializer.Get.numberSerializer(gen);
            gen.writeObjectFieldStart(ProcessWitness.KEY);
            numberSerializer.serialize(witness.openFileDescriptors);
            numberSerializer.serialize(witness.peakOpenFileDescriptors);
            numberSerializer.serialize(witness.maxFileDescriptors);
            gen.writeObjectFieldStart("mem");
            numberSerializer.serialize(witness.memory.memTotalVirtualInBytes);
            gen.writeEndObject();
            gen.writeObjectFieldStart("cpu");
            numberSerializer.serialize(witness.cpu.cpuTotalInMillis);
            numberSerializer.serialize(witness.cpu.cpuProcessPercent);
            gen.writeEndObject();
            gen.writeEndObject();
        }
    }

    public class Memory
    implements ScheduledWitness {
        private static final String KEY = "mem";
        private final NumberGauge memTotalVirtualInBytes = new NumberGauge("total_virtual_in_bytes", -1);

        private Memory() {
        }

        @Override
        public void refresh() {
            this.memTotalVirtualInBytes.set(unixOsBean.getCommittedVirtualMemorySize());
        }
    }

    public class Cpu
    implements ScheduledWitness {
        private static final String KEY = "cpu";
        private final NumberGauge cpuProcessPercent = new NumberGauge("percent", -1);
        private final NumberGauge cpuTotalInMillis = new NumberGauge("total_in_millis", -1);

        private Cpu() {
        }

        @Override
        public void refresh() {
            this.cpuProcessPercent.set(ProcessWitness.this.scaleLoadToPercent(unixOsBean.getProcessCpuLoad()));
            this.cpuTotalInMillis.set(TimeUnit.MILLISECONDS.convert(unixOsBean.getProcessCpuTime(), TimeUnit.NANOSECONDS));
        }
    }
}

