/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.logstash.Event;
import org.logstash.Timestamp;
import org.logstash.ackedqueue.Queueable;

public class DLQEntry
implements Cloneable,
Queueable {
    private final Event event;
    private final String pluginType;
    private final String pluginId;
    private final String reason;
    private final Timestamp entryTime;

    public DLQEntry(Event event, String pluginType, String pluginId, String reason) {
        this(event, pluginType, pluginId, reason, Timestamp.now());
    }

    public DLQEntry(Event event, String pluginType, String pluginId, String reason, Timestamp entryTime) {
        this.event = event;
        this.pluginType = pluginType;
        this.pluginId = pluginId;
        this.reason = reason;
        this.entryTime = entryTime;
    }

    @Override
    public byte[] serialize() throws IOException {
        byte[] entryTimeInBytes = this.entryTime.serialize();
        byte[] eventInBytes = this.event.serialize();
        byte[] pluginTypeBytes = this.pluginType.getBytes();
        byte[] pluginIdBytes = this.pluginId.getBytes();
        byte[] reasonBytes = this.reason.getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(entryTimeInBytes.length + eventInBytes.length + pluginTypeBytes.length + pluginIdBytes.length + reasonBytes.length + 20);
        DLQEntry.putLengthAndBytes(buffer, entryTimeInBytes);
        DLQEntry.putLengthAndBytes(buffer, eventInBytes);
        DLQEntry.putLengthAndBytes(buffer, pluginTypeBytes);
        DLQEntry.putLengthAndBytes(buffer, pluginIdBytes);
        DLQEntry.putLengthAndBytes(buffer, reasonBytes);
        return buffer.array();
    }

    public static DLQEntry deserialize(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.position(0);
        Timestamp entryTime = new Timestamp(new String(DLQEntry.getLengthPrefixedBytes(buffer)));
        Event event = Event.deserialize(DLQEntry.getLengthPrefixedBytes(buffer));
        String pluginType = new String(DLQEntry.getLengthPrefixedBytes(buffer));
        String pluginId = new String(DLQEntry.getLengthPrefixedBytes(buffer));
        String reason = new String(DLQEntry.getLengthPrefixedBytes(buffer));
        return new DLQEntry(event, pluginType, pluginId, reason, entryTime);
    }

    private static void putLengthAndBytes(ByteBuffer buffer, byte[] bytes) {
        buffer.putInt(bytes.length);
        buffer.put(bytes);
    }

    private static byte[] getLengthPrefixedBytes(ByteBuffer buffer) {
        int length = buffer.getInt();
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getReason() {
        return this.reason;
    }

    public Timestamp getEntryTime() {
        return this.entryTime;
    }

    public String toString() {
        return "DLQEntry{event=" + this.event + ", pluginType='" + this.pluginType + '\'' + ", pluginId='" + this.pluginId + '\'' + ", reason='" + this.reason + '\'' + ", entryTime=" + this.entryTime + '}';
    }
}

