/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.StringReader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriXsltErrorListener;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.serializer.SerializationHandler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;

@JRubyClass(name={"Nokogiri::XSLT::Stylesheet"})
public class XsltStylesheet
extends RubyObject {
    private TransformerFactory factory = null;
    private Templates sheet = null;
    private IRubyObject stylesheet = null;
    private boolean htmlish = false;
    private Pattern p = Pattern.compile("'.{1,}'");
    private static final Pattern HTML_TAG = Pattern.compile("<(%s)*html", 2);

    public XsltStylesheet(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void addParametersToTransformer(ThreadContext threadContext, Transformer transformer, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (iRubyObject instanceof RubyHash) {
            this.setHashParameters(transformer, (RubyHash)iRubyObject);
        } else if (iRubyObject instanceof RubyArray) {
            this.setArrayParameters(transformer, ruby, (RubyArray)iRubyObject);
        } else {
            throw ruby.newTypeError("parameters should be given either Array or Hash");
        }
    }

    private void setHashParameters(Transformer transformer, RubyHash rubyHash) {
        Set set = rubyHash.keySet();
        for (String string : set) {
            String string2 = (String)rubyHash.get((Object)string);
            transformer.setParameter(string, this.unparseValue(string2));
        }
    }

    private void setArrayParameters(Transformer transformer, Ruby ruby, RubyArray rubyArray) {
        int n = rubyArray.getLength();
        if (n % 2 == 1) {
            --n;
        }
        for (int i = 0; i < n; i += 2) {
            String string = rubyArray.aref((IRubyObject)ruby.newFixnum(i)).asJavaString();
            String string2 = rubyArray.aref((IRubyObject)ruby.newFixnum(i + 1)).asJavaString();
            transformer.setParameter(string, this.unparseValue(string2));
        }
    }

    private String unparseValue(String string) {
        Matcher matcher = this.p.matcher(string);
        if (string.startsWith("\"") && string.endsWith("\"") || matcher.matches()) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject parse_stylesheet_doc(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby = threadContext.getRuntime();
        XsltStylesheet.ensureFirstArgIsDocument(ruby, iRubyObjectArray[0]);
        XmlDocument xmlDocument = (XmlDocument)iRubyObjectArray[0];
        XsltStylesheet.ensureDocumentHasNoError(threadContext, xmlDocument);
        Document document = ((XmlDocument)xmlDocument.dup_implementation(threadContext, true)).getDocument();
        XsltStylesheet xsltStylesheet = (XsltStylesheet)NokogiriService.XSLT_STYLESHEET_ALLOCATOR.allocate(ruby, (RubyClass)iRubyObject);
        try {
            xsltStylesheet.init(iRubyObjectArray[1], document);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw ruby.newRuntimeError("could not parse xslt stylesheet");
        }
        return xsltStylesheet;
    }

    private void init(IRubyObject iRubyObject, Document document) throws TransformerConfigurationException {
        this.stylesheet = iRubyObject;
        if (this.factory == null) {
            this.factory = TransformerFactory.newInstance();
        }
        NokogiriXsltErrorListener nokogiriXsltErrorListener = new NokogiriXsltErrorListener();
        this.factory.setErrorListener(nokogiriXsltErrorListener);
        this.sheet = this.factory.newTemplates(new DOMSource(document));
    }

    private static void ensureFirstArgIsDocument(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlDocument) {
            return;
        }
        throw ruby.newArgumentError("doc must be a Nokogiri::XML::Document instance");
    }

    private static void ensureDocumentHasNoError(ThreadContext threadContext, XmlDocument xmlDocument) {
        Ruby ruby = threadContext.getRuntime();
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        if (!rubyArray.isEmpty()) {
            throw ruby.newRuntimeError(rubyArray.first().asString().asJavaString());
        }
    }

    @JRubyMethod
    public IRubyObject serialize(ThreadContext threadContext, IRubyObject iRubyObject) throws IOException, TransformerException {
        XmlDocument xmlDocument = (XmlDocument)iRubyObject;
        TransformerImpl transformerImpl = (TransformerImpl)this.sheet.newTransformer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        SerializationHandler serializationHandler = transformerImpl.createSerializationHandler((Result)streamResult);
        serializationHandler.serialize(xmlDocument.getNode());
        return threadContext.getRuntime().newString(byteArrayOutputStream.toString());
    }

    @JRubyMethod(rest=true, required=1, optional=2)
    public IRubyObject transform(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        DOMResult dOMResult;
        Ruby ruby = threadContext.getRuntime();
        XsltStylesheet.argumentTypeCheck(ruby, iRubyObjectArray[0]);
        NokogiriXsltErrorListener nokogiriXsltErrorListener = new NokogiriXsltErrorListener();
        DOMSource dOMSource = new DOMSource(((XmlDocument)iRubyObjectArray[0]).getDocument());
        String string = null;
        try {
            dOMResult = this.tryXsltTransformation(threadContext, iRubyObjectArray, dOMSource, nokogiriXsltErrorListener);
            if (dOMResult.getNode().getFirstChild() == null) {
                string = this.retryXsltTransformation(threadContext, iRubyObjectArray, dOMSource, nokogiriXsltErrorListener);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw ruby.newRuntimeError(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw ruby.newRuntimeError(transformerException.getMessage());
        }
        catch (IOException iOException) {
            throw ruby.newRuntimeError(iOException.getMessage());
        }
        switch (nokogiriXsltErrorListener.getErrorType()) {
            case ERROR: 
            case FATAL: {
                throw ruby.newRuntimeError(nokogiriXsltErrorListener.getErrorMessage());
            }
        }
        if (string == null) {
            return this.createDocumentFromDomResult(threadContext, ruby, dOMResult);
        }
        return this.createDocumentFromString(threadContext, ruby, string);
    }

    private DOMResult tryXsltTransformation(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, DOMSource dOMSource, NokogiriXsltErrorListener nokogiriXsltErrorListener) throws TransformerException {
        Transformer transformer = this.sheet.newTransformer();
        transformer.reset();
        transformer.setErrorListener(nokogiriXsltErrorListener);
        if (iRubyObjectArray.length > 1) {
            this.addParametersToTransformer(threadContext, transformer, iRubyObjectArray[1]);
        }
        DOMResult dOMResult = new DOMResult();
        transformer.transform(dOMSource, dOMResult);
        return dOMResult;
    }

    private String retryXsltTransformation(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, DOMSource dOMSource, NokogiriXsltErrorListener nokogiriXsltErrorListener) throws TransformerException, IOException {
        Templates templates = this.getTemplatesFromStreamSource();
        Transformer transformer = templates.newTransformer();
        transformer.setErrorListener(nokogiriXsltErrorListener);
        if (iRubyObjectArray.length > 1) {
            this.addParametersToTransformer(threadContext, transformer, iRubyObjectArray[1]);
        }
        PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader();
        pipedWriter.connect(pipedReader);
        StreamResult streamResult = new StreamResult(pipedWriter);
        transformer.transform(dOMSource, streamResult);
        char[] cArray = new char[1024];
        int n = pipedReader.read(cArray, 0, 1024);
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(cArray, 0, n);
        this.htmlish = XsltStylesheet.isHtml(stringBuilder);
        while (n == 1024) {
            n = pipedReader.read(cArray, 0, 1024);
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        pipedReader.close();
        pipedWriter.close();
        return stringBuilder.toString();
    }

    private IRubyObject createDocumentFromDomResult(ThreadContext threadContext, Ruby ruby, DOMResult dOMResult) {
        if ("html".equals(dOMResult.getNode().getFirstChild().getNodeName())) {
            HtmlDocument htmlDocument = (HtmlDocument)NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::HTML::Document").allocate();
            htmlDocument.setDocumentNode(threadContext, (Document)dOMResult.getNode());
            return htmlDocument;
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document"));
        xmlDocument.setDocumentNode(threadContext, (Document)dOMResult.getNode());
        return xmlDocument;
    }

    private Templates getTemplatesFromStreamSource() throws TransformerConfigurationException {
        if (this.stylesheet instanceof RubyString) {
            StringReader stringReader = new StringReader(this.stylesheet.asJavaString());
            StreamSource streamSource = new StreamSource(stringReader);
            return this.factory.newTemplates(streamSource);
        }
        return null;
    }

    private static boolean isHtml(CharSequence charSequence) {
        Matcher matcher = HTML_TAG.matcher(charSequence);
        return matcher.find();
    }

    private IRubyObject createDocumentFromString(ThreadContext threadContext, Ruby ruby, String string) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[4];
        iRubyObjectArray[0] = NokogiriHelpers.stringOrBlank(ruby, string);
        iRubyObjectArray[1] = ruby.getNil();
        iRubyObjectArray[2] = ruby.getNil();
        RubyClass rubyClass = (RubyClass)ruby.getClassFromPath("Nokogiri::XML::ParseOptions");
        if (this.htmlish) {
            iRubyObjectArray[3] = rubyClass.getConstant("DEFAULT_HTML");
            RubyClass rubyClass2 = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::HTML::Document");
            return RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)rubyClass2, (String)"parse", (IRubyObject[])iRubyObjectArray);
        }
        iRubyObjectArray[3] = rubyClass.getConstant("DEFAULT_XML");
        RubyClass rubyClass3 = NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::Document");
        XmlDocument xmlDocument = (XmlDocument)RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)rubyClass3, (String)"parse", (IRubyObject[])iRubyObjectArray);
        if (((Document)xmlDocument.getNode()).getDocumentElement() == null) {
            RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
            RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)rubyArray, (String)"<<", (IRubyObject)iRubyObjectArray[0]);
        }
        return xmlDocument;
    }

    private static void argumentTypeCheck(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlDocument) {
            return;
        }
        throw ruby.newArgumentError("argument must be a Nokogiri::XML::Document");
    }

    @JRubyMethod(name={"registr", "register"}, meta=true)
    public static IRubyObject register(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        throw threadContext.getRuntime().newNotImplementedError("Nokogiri::XSLT.register method is not implemented");
    }
}

