/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochRequest
extends AbstractRequest {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "An array of topics to get epochs for");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "An array of partitions to get epochs for");
    private static final Field.Int32 LEADER_EPOCH = new Field.Int32("leader_epoch", "The epoch to lookup an offset for.");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, LEADER_EPOCH);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_V0;
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_V1;
    private static final Field PARTITIONS_V2;
    private static final Field TOPICS_V2;
    private static final Schema OFFSET_FOR_LEADER_EPOCH_REQUEST_V2;
    private Map<TopicPartition, PartitionData> epochsByPartition;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FOR_LEADER_EPOCH_REQUEST_V0, OFFSET_FOR_LEADER_EPOCH_REQUEST_V1, OFFSET_FOR_LEADER_EPOCH_REQUEST_V2};
    }

    public Map<TopicPartition, PartitionData> epochsByTopicPartition() {
        return this.epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Map<TopicPartition, PartitionData> epochsByPartition, short version) {
        super(ApiKeys.OFFSET_FOR_LEADER_EPOCH, version);
        this.epochsByPartition = epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Struct struct, short version) {
        super(ApiKeys.OFFSET_FOR_LEADER_EPOCH, version);
        this.epochsByPartition = new HashMap<TopicPartition, PartitionData>();
        for (Object topicAndEpochsObj : struct.get(TOPICS)) {
            Struct topicAndEpochs = (Struct)topicAndEpochsObj;
            String topic = topicAndEpochs.get(CommonFields.TOPIC_NAME);
            for (Object partitionAndEpochObj : topicAndEpochs.get(PARTITIONS)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                int partitionId = partitionAndEpoch.get(CommonFields.PARTITION_ID);
                int leaderEpoch = partitionAndEpoch.get(LEADER_EPOCH);
                Optional<Integer> currentEpoch = RequestUtils.getLeaderEpoch(partitionAndEpoch, CommonFields.CURRENT_LEADER_EPOCH);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                this.epochsByPartition.put(tp, new PartitionData(currentEpoch, leaderEpoch));
            }
        }
    }

    public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(versionId, buffer), versionId);
    }

    @Override
    protected Struct toStruct() {
        Struct requestStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.requestSchema(this.version()));
        Map<String, Map<Integer, PartitionData>> topicsToPartitionEpochs = CollectionUtils.groupPartitionDataByTopic(this.epochsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicToEpochs : topicsToPartitionEpochs.entrySet()) {
            Struct topicsStruct = requestStruct.instance(TOPICS);
            topicsStruct.set(CommonFields.TOPIC_NAME, topicToEpochs.getKey());
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEpoch : topicToEpochs.getValue().entrySet()) {
                Struct partitionStruct = topicsStruct.instance(PARTITIONS);
                partitionStruct.set(CommonFields.PARTITION_ID, partitionEpoch.getKey());
                PartitionData partitionData = partitionEpoch.getValue();
                partitionStruct.set(LEADER_EPOCH, partitionData.leaderEpoch);
                RequestUtils.setLeaderEpochIfExists(partitionStruct, CommonFields.CURRENT_LEADER_EPOCH, partitionData.currentLeaderEpoch);
                partitions.add(partitionStruct);
            }
            topicsStruct.set(PARTITIONS, partitions.toArray());
            topics.add(topicsStruct);
        }
        requestStruct.set(TOPICS, topics.toArray());
        return requestStruct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, EpochEndOffset> errorResponse = new HashMap<TopicPartition, EpochEndOffset>();
        for (TopicPartition tp : this.epochsByPartition.keySet()) {
            errorResponse.put(tp, new EpochEndOffset(error, -1, -1L));
        }
        return new OffsetsForLeaderEpochResponse(throttleTimeMs, errorResponse);
    }

    static {
        OFFSET_FOR_LEADER_EPOCH_REQUEST_V1 = OFFSET_FOR_LEADER_EPOCH_REQUEST_V0 = new Schema(TOPICS_V0);
        PARTITIONS_V2 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.CURRENT_LEADER_EPOCH, LEADER_EPOCH);
        TOPICS_V2 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V2);
        OFFSET_FOR_LEADER_EPOCH_REQUEST_V2 = new Schema(TOPICS_V2);
    }

    public static class PartitionData {
        public final Optional<Integer> currentLeaderEpoch;
        public final int leaderEpoch;

        public PartitionData(Optional<Integer> currentLeaderEpoch, int leaderEpoch) {
            this.currentLeaderEpoch = currentLeaderEpoch;
            this.leaderEpoch = leaderEpoch;
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetsForLeaderEpochRequest> {
        private final Map<TopicPartition, PartitionData> epochsByPartition;

        public Builder(short version, Map<TopicPartition, PartitionData> epochsByPartition) {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH, version);
            this.epochsByPartition = epochsByPartition;
        }

        @Override
        public OffsetsForLeaderEpochRequest build(short version) {
            return new OffsetsForLeaderEpochRequest(this.epochsByPartition, version);
        }

        public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short version) {
            return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(version, buffer), version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=OffsetForLeaderEpochRequest, ").append("epochsByTopic=").append(this.epochsByPartition).append(")");
            return bld.toString();
        }
    }
}

