/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class OpAsgnConstDeclNode
extends Node
implements BinaryOperatorNode {
    private Node lhs;
    private String operator;
    private Node rhs;

    public OpAsgnConstDeclNode(ISourcePosition position, Node lhs, String operator, Node rhs) {
        super(position, lhs.containsVariableAssignment() || rhs.containsVariableAssignment());
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    @Override
    public Node getFirstNode() {
        return this.lhs;
    }

    @Override
    public Node getSecondNode() {
        return this.rhs;
    }

    public String getOperator() {
        return this.operator;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visitOpAsgnConstDeclNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return OpAsgnConstDeclNode.createList(this.lhs, (Node)new LiteralNode(this.getPosition(), this.operator), this.rhs);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.OPASGNCONSTDECLNODE;
    }
}

