/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LoadDataHandler
extends RequestHandler {
    private static final String OSM_MIME_TYPE = "application/x-osm+xml";
    public static final String command = "load_data";
    private String data;
    private DataSet dataSet;

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        MainApplication.worker.submit(new LoadDataTask(this.getDownloadParams(), this.dataSet, (String)this.args.get("layer_name")));
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"data"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "mime_type", "layer_name", "layer_locked", "download_policy", "upload_policy"};
    }

    @Override
    public String getUsage() {
        return "Reads data encoded directly in the URL and adds it to the current data set";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/load_data?layer_name=extra_layer&new_layer=true&data=" + Utils.encodeUrl("<osm version='0.6'><node id='-1' lat='1' lon='2' /></osm>")};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load the following data:", new Object[0]) + "<br>" + this.data;
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.IMPORT_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.validateDownloadParams();
        this.data = (String)this.args.get("data");
        String mimeType = Utils.firstNonNull((String)this.args.get("mime_type"), OSM_MIME_TYPE);
        try {
            if (OSM_MIME_TYPE.equals(mimeType)) {
                ByteArrayInputStream in = new ByteArrayInputStream(this.data.getBytes(StandardCharsets.UTF_8));
                this.dataSet = OsmReader.parseDataSet(in, null);
            } else {
                this.dataSet = new DataSet();
            }
        }
        catch (IllegalDataException e) {
            throw new RequestHandler.RequestHandlerBadRequestException("Failed to parse " + this.data + ": " + e.getMessage(), e);
        }
    }

    protected static class LoadDataTask
    extends DownloadOsmTask.AbstractInternalTask {
        protected final String layerName;

        public LoadDataTask(DownloadParams settings, DataSet dataSet, String layerName) {
            super(settings, I18n.tr("Loading data", new Object[0]), false, true);
            this.dataSet = dataSet;
            this.layerName = layerName;
        }

        @Override
        public void realRun() {
        }

        @Override
        protected void cancel() {
        }

        @Override
        protected void finish() {
            this.loadData(this.layerName, null);
        }
    }
}

