/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.DeclareVariablesAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.VarName;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.ForLoop;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.regions.DepthRegionTraversal;
import jadx.core.dex.visitors.regions.TracedRegionVisitor;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProcessVariables
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) throws JadxException {
        Usage u;
        if (mth.isNoCode()) {
            return;
        }
        List<RegisterArg> mthArguments = mth.getArguments(true);
        LinkedHashMap<Variable, Usage> usageMap = new LinkedHashMap<Variable, Usage>();
        for (RegisterArg registerArg : mthArguments) {
            ProcessVariables.addToUsageMap(registerArg, usageMap);
        }
        CollectUsageRegionVisitor collect = new CollectUsageRegionVisitor(usageMap);
        DepthRegionTraversal.traverse(mth, collect);
        for (RegisterArg arg : mthArguments) {
            usageMap.remove(new Variable(arg));
        }
        Iterator iterator = usageMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Usage u2 = (Usage)entry.getValue();
            if (u2.getAssigns().isEmpty()) {
                iterator.remove();
                continue;
            }
            InsnNode parentInsn = u2.getArg().getParentInsn();
            if (parentInsn != null && parentInsn.getType() != InsnType.MOVE_EXCEPTION) continue;
            iterator.remove();
        }
        if (usageMap.isEmpty()) {
            return;
        }
        Iterator it = usageMap.entrySet().iterator();
        block3: while (it.hasNext()) {
            Map.Entry entry = it.next();
            u = (Usage)entry.getValue();
            for (IRegion assignRegion : u.getAssigns()) {
                if (u.getArgRegion() != assignRegion || !ProcessVariables.canDeclareInRegion(u, assignRegion) || !ProcessVariables.declareAtAssign(u)) continue;
                it.remove();
                continue block3;
            }
        }
        if (usageMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : usageMap.entrySet()) {
            u = (Usage)entry.getValue();
            Set<IRegion> set = u.getUseRegions();
            Iterator<IRegion> it2 = set.iterator();
            while (it2.hasNext()) {
                IRegion r = it2.next();
                IRegion parent = r.getParent();
                if (parent == null || !set.contains(parent)) continue;
                it2.remove();
            }
            IRegion region = null;
            if (!set.isEmpty()) {
                region = set.iterator().next();
            } else if (!u.getAssigns().isEmpty()) {
                region = u.getAssigns().iterator().next();
            }
            if (region == null) continue;
            IRegion parent = region;
            boolean declared = false;
            while (parent != null) {
                if (ProcessVariables.canDeclareInRegion(u, region)) {
                    ProcessVariables.declareVar(region, u.getArg());
                    declared = true;
                    break;
                }
                region = parent;
                parent = region.getParent();
            }
            if (declared) continue;
            ProcessVariables.declareVar(mth.getRegion(), u.getArg());
        }
    }

    private static Usage addToUsageMap(RegisterArg arg, Map<Variable, Usage> usageMap) {
        Variable varId = new Variable(arg);
        Usage usage = usageMap.computeIfAbsent(varId, v -> new Usage());
        if (usage.getVarName() == null) {
            VarName argVN = arg.getSVar().getVarName();
            if (argVN == null) {
                argVN = new VarName();
                arg.getSVar().setVarName(argVN);
            }
            usage.setVarName(argVN);
        } else {
            arg.getSVar().setVarName(usage.getVarName());
        }
        return usage;
    }

    private static boolean declareAtAssign(Usage u) {
        RegisterArg arg = u.getArg();
        InsnNode parentInsn = arg.getParentInsn();
        if (parentInsn == null) {
            return false;
        }
        if (!arg.equals(parentInsn.getResult())) {
            return false;
        }
        parentInsn.add(AFlag.DECLARE_VAR);
        return true;
    }

    private static void declareVar(IContainer region, RegisterArg arg) {
        DeclareVariablesAttr dv = region.get(AType.DECLARE_VARIABLES);
        if (dv == null) {
            dv = new DeclareVariablesAttr();
            region.addAttr(dv);
        }
        dv.addVar(arg);
    }

    private static boolean canDeclareInRegion(Usage u, IRegion region) {
        if (region instanceof LoopRegion) {
            for (IRegion r : u.getAssigns()) {
                if (RegionUtils.isRegionContainsRegion(region, r)) continue;
                return false;
            }
        }
        if (region.contains(AFlag.ELSE_IF_CHAIN)) {
            return false;
        }
        return ProcessVariables.isAllRegionsAfter(region, u.getAssigns()) && ProcessVariables.isAllRegionsAfter(region, u.getUseRegions());
    }

    private static boolean isAllRegionsAfter(IRegion region, Set<IRegion> others) {
        for (IRegion r : others) {
            if (RegionUtils.isRegionContainsRegion(region, r)) continue;
            return false;
        }
        return true;
    }

    private static class CollectUsageRegionVisitor
    extends TracedRegionVisitor {
        private final List<RegisterArg> args;
        private final Map<Variable, Usage> usageMap;

        public CollectUsageRegionVisitor(Map<Variable, Usage> usageMap) {
            this.usageMap = usageMap;
            this.args = new ArrayList<RegisterArg>();
        }

        @Override
        public void processBlockTraced(MethodNode mth, IBlock container, IRegion curRegion) {
            this.regionProcess(curRegion);
            int len = container.getInstructions().size();
            for (int i = 0; i < len; ++i) {
                InsnNode insn = container.getInstructions().get(i);
                if (insn.contains(AFlag.SKIP)) continue;
                this.args.clear();
                this.processInsn(insn, curRegion);
            }
        }

        private void regionProcess(IRegion region) {
            LoopRegion loopRegion;
            LoopType loopType;
            if (region instanceof LoopRegion && (loopType = (loopRegion = (LoopRegion)region).getType()) instanceof ForLoop) {
                ForLoop forLoop = (ForLoop)loopType;
                this.processInsn(forLoop.getInitInsn(), region);
                this.processInsn(forLoop.getIncrInsn(), region);
            }
        }

        void processInsn(InsnNode insn, IRegion curRegion) {
            if (insn == null) {
                return;
            }
            RegisterArg result = insn.getResult();
            if (result != null && result.isRegister()) {
                Usage u = ProcessVariables.addToUsageMap(result, this.usageMap);
                if (u.getArg() == null) {
                    u.setArg(result);
                    u.setArgRegion(curRegion);
                }
                u.getAssigns().add(curRegion);
            }
            this.args.clear();
            insn.getRegisterArgs(this.args);
            for (RegisterArg arg : this.args) {
                Usage u = ProcessVariables.addToUsageMap(arg, this.usageMap);
                u.getUseRegions().add(curRegion);
            }
        }
    }

    private static class Usage {
        private RegisterArg arg;
        private VarName varName;
        private IRegion argRegion;
        private final Set<IRegion> uses = new LinkedHashSet<IRegion>(2);
        private final Set<IRegion> assigns = new LinkedHashSet<IRegion>(2);

        private Usage() {
        }

        public void setArg(RegisterArg arg) {
            this.arg = arg;
        }

        public RegisterArg getArg() {
            return this.arg;
        }

        public VarName getVarName() {
            return this.varName;
        }

        public void setVarName(VarName varName) {
            this.varName = varName;
        }

        public void setArgRegion(IRegion argRegion) {
            this.argRegion = argRegion;
        }

        public IRegion getArgRegion() {
            return this.argRegion;
        }

        public Set<IRegion> getAssigns() {
            return this.assigns;
        }

        public Set<IRegion> getUseRegions() {
            return this.uses;
        }

        public String toString() {
            return this.arg + ", a:" + this.assigns + ", u:" + this.uses;
        }
    }

    private static class Variable {
        private final int regNum;
        private final ArgType type;

        public Variable(RegisterArg arg) {
            this.regNum = arg.getRegNum();
            this.type = arg.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.regNum == variable.regNum && this.type.equals(variable.type);
        }

        public int hashCode() {
            return 31 * this.regNum + this.type.hashCode();
        }

        public String toString() {
            return "r" + this.regNum + ":" + this.type;
        }
    }
}

