/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import hu.akarnokd.rxjava2.swing.SwingSchedulers;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.CommonSearchDialog;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.search.TextSearchIndex;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDialog
extends CommonSearchDialog {
    private static final Logger LOG = LoggerFactory.getLogger(SearchDialog.class);
    private static final long serialVersionUID = -5105405456969134105L;
    private final boolean textSearch;
    private transient Set<SearchOptions> options;
    private transient JTextField searchField;
    private transient Disposable searchDisposable;
    private transient SearchEventEmitter searchEmitter;

    public SearchDialog(MainWindow mainWindow, boolean textSearch) {
        super(mainWindow);
        Set<SearchOptions> lastSearchOptions;
        this.textSearch = textSearch;
        this.options = textSearch ? (!(lastSearchOptions = this.cache.getLastSearchOptions()).isEmpty() ? lastSearchOptions : EnumSet.of(SearchOptions.CODE, SearchOptions.IGNORE_CASE)) : EnumSet.of(SearchOptions.CLASS);
        this.initUI();
        this.registerInitOnOpen();
        this.loadWindowPos();
    }

    @Override
    protected void openInit() {
        this.prepare();
        String lastSearch = this.cache.getLastSearch();
        if (lastSearch != null) {
            this.searchField.setText(lastSearch);
            this.searchField.selectAll();
            this.searchEmitter.emitSearch();
        }
        this.searchField.requestFocus();
    }

    private void initUI() {
        JLabel findLabel = new JLabel(NLS.str("search_dialog.open_by_name"));
        this.searchField = new JTextField();
        this.searchField.setAlignmentX(0.0f);
        new TextStandardActions(this.searchField);
        this.searchFieldSubscribe();
        JCheckBox caseChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.ignorecase"), SearchOptions.IGNORE_CASE);
        JCheckBox clsChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.class"), SearchOptions.CLASS);
        JCheckBox mthChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.method"), SearchOptions.METHOD);
        JCheckBox fldChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.field"), SearchOptions.FIELD);
        JCheckBox codeChBox = this.makeOptionsCheckBox(NLS.str("search_dialog.code"), SearchOptions.CODE);
        JPanel searchInPanel = new JPanel(new FlowLayout(0));
        searchInPanel.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.search_in")));
        searchInPanel.add(clsChBox);
        searchInPanel.add(mthChBox);
        searchInPanel.add(fldChBox);
        searchInPanel.add(codeChBox);
        JPanel searchOptions = new JPanel(new FlowLayout(0));
        searchOptions.setBorder(BorderFactory.createTitledBorder(NLS.str("search_dialog.options")));
        searchOptions.add(caseChBox);
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(searchInPanel);
        box.add(searchOptions);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new BoxLayout(searchPane, 3));
        findLabel.setLabelFor(this.searchField);
        searchPane.add(findLabel);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(this.searchField);
        searchPane.add(Box.createRigidArea(new Dimension(0, 5)));
        searchPane.add(box);
        searchPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)searchPane, "First");
        contentPane.add((Component)resultsPanel, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SearchDialog.this.resultsModel.getRowCount() != 0) {
                        SearchDialog.this.resultsTable.setRowSelectionInterval(0, 0);
                    }
                    SearchDialog.this.resultsTable.requestFocus();
                }
            }
        });
        this.setTitle(NLS.str("menu.text_search"));
        this.pack();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
    }

    private void searchFieldSubscribe() {
        this.searchEmitter = new SearchEventEmitter();
        Flowable<String> textChanges = SearchDialog.onTextFieldChanges(this.searchField);
        Flowable searchEvents = Flowable.merge(textChanges, this.searchEmitter.getFlowable());
        this.searchDisposable = searchEvents.filter(text -> text.length() > 0).subscribeOn(Schedulers.single()).doOnNext(r -> LOG.debug("search event: {}", r)).switchMap(text -> this.prepareSearch((String)text).doOnError(e -> LOG.error("Error prepare search: {}", (Object)e.getMessage(), e)).subscribeOn(Schedulers.single()).toList().toFlowable(), 1).observeOn(SwingSchedulers.edt()).doOnError(e -> LOG.error("Error while searching: {}", (Object)e.getMessage(), e)).subscribe(this::processSearchResults);
    }

    private Flowable<JNode> prepareSearch(String text) {
        if (text == null || text.isEmpty() || this.options.isEmpty()) {
            return Flowable.empty();
        }
        TextSearchIndex index = this.cache.getTextIndex();
        if (index == null) {
            return Flowable.empty();
        }
        return index.buildSearch(text, this.options);
    }

    private void processSearchResults(List<JNode> results) {
        String text;
        LOG.debug("search result size: {}", (Object)results.size());
        this.highlightText = text = this.searchField.getText();
        this.highlightTextCaseInsensitive = this.options.contains((Object)SearchOptions.IGNORE_CASE);
        this.cache.setLastSearch(text);
        if (this.textSearch) {
            this.cache.setLastSearchOptions(this.options);
        }
        this.resultsModel.clear();
        this.resultsModel.addAll(results);
        super.performSearch();
    }

    private static Flowable<String> onTextFieldChanges(final JTextField textField) {
        return Flowable.create(emitter -> {
            final DocumentListener listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.change();
                }

                public void change() {
                    emitter.onNext((Object)textField.getText());
                }
            };
            textField.getDocument().addDocumentListener(listener);
            emitter.setDisposable(new Disposable(){
                private boolean disposed = false;

                public void dispose() {
                    textField.getDocument().removeDocumentListener(listener);
                    this.disposed = true;
                }

                public boolean isDisposed() {
                    return this.disposed;
                }
            });
        }, (BackpressureStrategy)BackpressureStrategy.LATEST).debounce(300L, TimeUnit.MILLISECONDS).distinctUntilChanged();
    }

    @Override
    public void dispose() {
        if (this.searchDisposable != null && !this.searchDisposable.isDisposed()) {
            this.searchDisposable.dispose();
        }
        super.dispose();
    }

    private JCheckBox makeOptionsCheckBox(String name, SearchOptions opt) {
        JCheckBox chBox = new JCheckBox(name);
        chBox.setAlignmentX(0.0f);
        chBox.setSelected(this.options.contains((Object)opt));
        chBox.addItemListener(e -> {
            if (chBox.isSelected()) {
                this.options.add(opt);
            } else {
                this.options.remove((Object)opt);
            }
            this.searchEmitter.emitSearch();
        });
        return chBox;
    }

    @Override
    protected void loadFinished() {
        this.searchField.setEnabled(true);
    }

    @Override
    protected void loadStart() {
        this.searchField.setEnabled(false);
    }

    private class SearchEventEmitter {
        private final Flowable<String> flowable = Flowable.create(this::saveEmitter, (BackpressureStrategy)BackpressureStrategy.LATEST);
        private Emitter<String> emitter;

        public Flowable<String> getFlowable() {
            return this.flowable;
        }

        private void saveEmitter(Emitter<String> emitter) {
            this.emitter = emitter;
        }

        public synchronized void emitSearch() {
            this.emitter.onNext((Object)SearchDialog.this.searchField.getText());
        }
    }

    public static enum SearchOptions {
        CLASS,
        METHOD,
        FIELD,
        CODE,
        IGNORE_CASE;

    }
}

