#!/bin/sh
export PATH='/usr/obj/ports/hs-graphviz-2999.18.1.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: graphviz
version: 2999.18.1.2
id: graphviz-2999.18.1.2-9lxGW0LBIfy6urVbDb07Sj
key: graphviz-2999.18.1.2-9lxGW0LBIfy6urVbDb07Sj
license: BSD3
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
author: Matthew Sackman, Ivan Lazar Miljenovic
exposed: True
indefinite: False
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
abi: ce985e23b0ec87b82333fc2dd8cfb853
trusted: False
import-dirs: /usr/local/lib/ghc/graphviz-2999.18.1.2
library-dirs: /usr/local/lib/ghc/graphviz-2999.18.1.2
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-graphviz-2999.18.1.2
hs-libraries: HSgraphviz-2999.18.1.2-9lxGW0LBIfy6urVbDb07Sj
depends:
    base-4.10.1.0 containers-0.5.10.2 process-1.6.1.0 directory-1.3.0.2
    temporary-1.2.1.1-EaGJD8l9MwE6FMqsytxEjz
    fgl-5.5.2.3-E6nTygjgXmbItPqw11u3Y filepath-1.4.1.2
    polyparse-1.12-1bosF4Whssj874aGh3f9kn bytestring-0.10.8.2
    colour-2.3.3-BQD1Vp5Ogu6Fvom5yNWhu8 transformers-0.5.2.0
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ
    wl-pprint-text-1.1.0.4-Fw8LgBKInFZ1l1QCzqOPuT
    dlist-0.7.1.2-KqjNiWYSO8f46M5pKiubUe
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             containers-0.5.10.2=e77159590adf51c7ff6e1b02e6e4795b
             process-1.6.1.0=7237ff1c5fb267c936a1910f591febc6
             directory-1.3.0.2=89a675d415b6f9ef917edd79b87ac775
             temporary-1.2.1.1-EaGJD8l9MwE6FMqsytxEjz=f5d0b05b8071eefd52a2919ff6e14613
             fgl-5.5.2.3-E6nTygjgXmbItPqw11u3Y=68e39c5a83fbb0662649b714f1c47b32
             filepath-1.4.1.2=f49190c9093d895f9f159c40e7d1ff46
             polyparse-1.12-1bosF4Whssj874aGh3f9kn=5b0d7b259ccb56e3a26e251cda6d55c8
             bytestring-0.10.8.2=bad4023def214da3b9be582a43b5e246
             colour-2.3.3-BQD1Vp5Ogu6Fvom5yNWhu8=bacb9545da72fadb6a27d40ac7c82525
             transformers-0.5.2.0=e04579c0363c9229351d1a0b394bf2d5
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=052ad072c066fd2117f49783bd48d75c
             wl-pprint-text-1.1.0.4-Fw8LgBKInFZ1l1QCzqOPuT=606ca837c389428146c586f0f0ef3e2d
             dlist-0.7.1.2-KqjNiWYSO8f46M5pKiubUe=64dfaa31b27e0b5ed17dd67394568319
haddock-interfaces: /usr/local/share/doc/hs-graphviz-2999.18.1.2/html/graphviz.haddock
haddock-html: /usr/local/share/doc/hs-graphviz-2999.18.1.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

