#!/bin/sh
export PATH='/usr/obj/ports/hs-convertible-1.1.1.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: convertible
version: 1.1.1.0
id: convertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
key: convertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
license: BSD3
copyright: Copyright (c) 2009-2011 John Goerzen
maintainer: Erik Hesselink <hesselink@gmail.com>
stability: Stable
homepage: http://hackage.haskell.org/package/convertible
synopsis: Typeclasses and instances for converting between types
description:
    convertible provides a typeclass with a single function
    that is designed to help convert between different types: numeric
    values, dates and times, and the like.  The conversions perform bounds
    checking and return a pure Either value.  This means that you need
    not remember which specific function performs the conversion you
    desire.
    .
    Also included in the package are optional instances that provide
    conversion for various numeric and time types, as well as utilities
    for writing your own instances.
    .
    Finally, there is a function that will raise an exception on
    bounds-checking violation, or return a bare value otherwise,
    implemented in terms of the safer function described above.
    .
    Convertible is also used by HDBC 2.0 for handling marshalling of
    data to and from databases.
    .
    Convertible is backed by an extensive test suite and passes tests
    on GHC and Hugs.
category: Data
author: John Goerzen
exposed: True
indefinite: False
exposed-modules:
    Data.Convertible Data.Convertible.Base Data.Convertible.Instances
    Data.Convertible.Instances.C Data.Convertible.Instances.Map
    Data.Convertible.Instances.Num Data.Convertible.Instances.Text
    Data.Convertible.Instances.Time Data.Convertible.Utils
abi: 668d04581e5855cc97eeb3c524e464c2
trusted: False
import-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
library-dirs: /usr/local/lib/ghc/convertible-1.1.1.0
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-convertible-1.1.1.0
hs-libraries: HSconvertible-1.1.1.0-CcttzSMZvrP7n0GTZtYEig
depends:
    base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
    mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH
    old-locale-1.0.0.7-uLYLcRn7Nv8SkmeS8fMf9
    old-time-1.1.0.3-LmKk8FUXtYwDVw5bR99HBe
    text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ time-1.8.0.2
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             bytestring-0.10.8.2=bad4023def214da3b9be582a43b5e246
             containers-0.5.10.2=e77159590adf51c7ff6e1b02e6e4795b
             mtl-2.2.1-DscMMmDQUE6GBfOSl4qMUH=1e76d6f7019a4b5c8c222b2fbbb06681
             old-locale-1.0.0.7-uLYLcRn7Nv8SkmeS8fMf9=cd49072ee3f44d2ed6a40aa4d5cec718
             old-time-1.1.0.3-LmKk8FUXtYwDVw5bR99HBe=6bace2daafd26507400f205c6cde8f60
             text-1.2.1.3-5I6D6Lq0QEU97eY5wqs6DJ=052ad072c066fd2117f49783bd48d75c
             time-1.8.0.2=1980548222fbca3cc4f4aa5245bbb96e
haddock-interfaces: /usr/local/share/doc/hs-convertible-1.1.1.0/html/convertible.haddock
haddock-html: /usr/local/share/doc/hs-convertible-1.1.1.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

