/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.serialver;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.serialver.Messages;
import java.io.File;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVer {
    ArrayList<String> classes = new ArrayList();
    String classpath;

    private static void addFileURL(ArrayList<URL> list, String file) {
        try {
            list.add(new File(file).toURL());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private ClassLoader getClassLoader() {
        URL[] urls;
        if (this.classpath == null) {
            urls = new URL[]{};
        } else {
            StringTokenizer tok = new StringTokenizer(this.classpath, File.pathSeparator, true);
            ArrayList<URL> list = new ArrayList<URL>();
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (s.equals(File.pathSeparator)) {
                    SerialVer.addFileURL(list, ".");
                    continue;
                }
                SerialVer.addFileURL(list, s);
                if (!tok.hasMoreTokens()) continue;
                tok.nextToken();
                if (tok.hasMoreTokens()) continue;
                SerialVer.addFileURL(list, ".");
            }
            urls = new URL[list.size()];
            urls = list.toArray(urls);
        }
        return new URLClassLoader(urls);
    }

    private void printMessage(String format, String klass) {
        System.err.println(MessageFormat.format(format, klass));
    }

    public void run(String[] args) {
        ClasspathToolParser p = new ClasspathToolParser("serialver", true){

            protected void validate() throws OptionException {
                if (SerialVer.this.classes.isEmpty()) {
                    throw new OptionException(Messages.getString("SerialVer.NoClassesSpecd"));
                }
            }
        };
        p.setHeader(Messages.getString("SerialVer.HelpHeader"));
        p.add(new Option(Messages.getString("SerialVer.5"), Messages.getString("SerialVer.ClasspathHelp"), "PATH"){

            public void parsed(String argument) throws OptionException {
                if (SerialVer.this.classpath != null) {
                    throw new OptionException(Messages.getString("SerialVer.DupClasspath"));
                }
                SerialVer.this.classpath = argument;
            }
        });
        p.parse(args, new FileArgumentCallback(){

            public void notifyFile(String fileArgument) throws OptionException {
                SerialVer.this.classes.add(fileArgument);
            }
        });
        ClassLoader loader = this.getClassLoader();
        for (String name : this.classes) {
            try {
                Class<?> clazz = loader.loadClass(name);
                ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
                if (osc != null) {
                    System.out.println(String.valueOf(clazz.getName()) + ": " + "static final long serialVersionUID = " + osc.getSerialVersionUID() + "L;");
                    continue;
                }
                this.printMessage(Messages.getString("SerialVer.ClassNotSerial"), name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.printMessage(Messages.getString("SerialVer.ClassNotFound"), name);
            }
        }
    }

    public static void main(String[] args) {
        new SerialVer().run(args);
    }
}

