/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.BinaryExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantBoolean;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

abstract class BinaryRelationExpression
extends BinaryExpression {
    protected BinaryRelationExpression(Expression left, Expression right) {
        super(left, right);
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression leftValue = this.left.evaluate(context);
        ConstantExpression rightValue = this.right.evaluate(context);
        if (Type.DOUBLE == leftValue.getType() || Type.DOUBLE == rightValue.getType()) {
            return new ConstantBoolean(this.compute(leftValue.asNumber().doubleValue(), rightValue.asNumber().doubleValue()));
        }
        if (Type.FLOAT == leftValue.getType() || Type.FLOAT == rightValue.getType()) {
            return new ConstantBoolean(this.compute(leftValue.asNumber().floatValue(), rightValue.asNumber().floatValue()));
        }
        if (Type.LONG == leftValue.getType() || Type.LONG == rightValue.getType()) {
            return new ConstantBoolean(this.compute(leftValue.asNumber().longValue(), rightValue.asNumber().longValue()));
        }
        return new ConstantBoolean(this.compute(leftValue.asNumber().intValue(), rightValue.asNumber().intValue()));
    }

    protected abstract boolean compute(double var1, double var3);

    protected abstract boolean compute(float var1, float var2);

    protected abstract boolean compute(long var1, long var3);

    protected abstract boolean compute(int var1, int var2);
}

