/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Transform {
    private List<Rule> _rules = new ArrayList<Rule>();
    private Rule _matched = null;

    Transform() {
    }

    public void rule(String pattern, String substitution) {
        this._rules.add(new Rule(pattern, substitution));
    }

    public boolean apply(String src) {
        this._matched = null;
        for (Rule rule : this._rules) {
            if (!rule.apply(src)) continue;
            this._matched = rule;
            break;
        }
        return this._matched != null;
    }

    public boolean matched() {
        return this._matched != null;
    }

    public String result() {
        return this._matched != null ? this._matched.result() : null;
    }

    private static class Rule {
        String _pattern;
        String _substitution;
        Pattern _compiled;
        StringBuilder _sb = new StringBuilder();
        boolean _matched = false;
        String _result = null;

        Rule(String pattern, String substitution) {
            this._pattern = pattern;
            this._substitution = substitution;
            this._compiled = Pattern.compile(this._pattern.replace("*", "(.*)").replace("%", "([^/]*)"));
        }

        boolean apply(String src) {
            this._matched = false;
            this._result = null;
            Matcher m = this._compiled.matcher(src);
            if (m.matches()) {
                this._matched = true;
                if (this._substitution != null) {
                    this._sb.setLength(0);
                    int limit = this._substitution.length();
                    int idx = 0;
                    while (idx < limit) {
                        char c = this._substitution.charAt(idx);
                        switch (c) {
                            case '$': {
                                if (++idx >= limit) {
                                    throw new IllegalStateException("substition index truncated");
                                }
                                c = this._substitution.charAt(idx);
                                if (c == '$') {
                                    this._sb.append(c);
                                    ++idx;
                                    break;
                                }
                                int num = 0;
                                while (Character.isDigit(c)) {
                                    num *= 10;
                                    num += c - 48;
                                    c = ++idx < limit ? this._substitution.charAt(idx) : (char)'\u0000';
                                }
                                if (num > 0) {
                                    this._sb.append(m.group(num));
                                    break;
                                }
                                throw new IllegalStateException("bad substitution index at character[" + idx + "]: " + this._substitution);
                            }
                            default: {
                                this._sb.append(c);
                                ++idx;
                            }
                        }
                    }
                    this._result = this._sb.toString();
                }
            }
            return this._matched;
        }

        boolean matched() {
            return this._matched;
        }

        String result() {
            return this._result;
        }
    }
}

