"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var readdir = require("@mrmlnc/readdir-enhanced");
var reader_1 = require("./reader");
var ReaderAsync = /** @class */ (function (_super) {
    __extends(ReaderAsync, _super);
    function ReaderAsync() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Returns founded paths.
     */
    ReaderAsync.prototype.api = function (root, options) {
        return readdir.readdirStreamStat(root, options);
    };
    /**
     * Use sync API to read entries for Task.
     */
    ReaderAsync.prototype.read = function (task) {
        var _this = this;
        var root = this.getRootDirectory(task);
        var options = this.getReaderOptions(task);
        var entries = [];
        return new Promise(function (resolve, reject) {
            var stream = _this.api(root, options);
            stream.on('error', function (err) {
                _this.isEnoentCodeError(err) ? resolve([]) : reject(err);
                stream.pause();
            });
            stream.on('data', function (entry) { return entries.push(_this.transform(entry)); });
            stream.on('end', function () { return resolve(entries); });
        });
    };
    return ReaderAsync;
}(reader_1.default));
exports.default = ReaderAsync;
