/* libide-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Ide", gir_namespace = "Ide", gir_version = "1.0", lower_case_cprefix = "ide_")]
namespace Ide {
	[CCode (cheader_filename = "ide.h", type_id = "ide_application_get_type ()")]
	public class Application : Dazzle.Application, GLib.ActionGroup, GLib.ActionMap {
		[CCode (has_construct_function = false)]
		[Version (since = "3.22")]
		public Application (Ide.ApplicationMode mode);
		[Version (since = "3.24")]
		public void add_reaper (Dazzle.DirectoryReaper reaper);
		public unowned string get_keybindings_mode ();
		public static unowned GLib.Thread get_main_thread ();
		[Version (since = "3.20")]
		public Ide.ApplicationMode get_mode ();
		[Version (since = "3.28")]
		public GLib.File get_projects_directory ();
		public unowned Ide.RecentProjects get_recent_projects ();
		public unowned GLib.DateTime get_started_at ();
		[Version (since = "3.28")]
		public unowned Ide.TransferManager get_transfer_manager ();
		public async GLib.DBusProxy get_worker_async (string plugin_name, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public bool has_network ();
		[Version (since = "3.22")]
		public bool open_project (GLib.File file);
		public void show_projects_window ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_get_type ()")]
	public class Buffer : Gtk.SourceBuffer {
		[CCode (has_construct_function = false)]
		protected Buffer ();
		[Version (since = "3.26")]
		public unowned Ide.BufferAddin? addin_find_by_module_name (string module_name);
		public void check_for_volume_change ();
		public async bool format_selection_async (Ide.FormatterOptions options, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		public async string[] get_build_flags_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_busy ();
		public size_t get_change_count ();
		public bool get_changed_on_volume ();
		public GLib.Bytes get_content ();
		public unowned Ide.Context get_context ();
		public unowned Ide.Diagnostic? get_diagnostic_at_iter (Gtk.TextIter iter);
		public bool get_failed ();
		public unowned GLib.Error get_failure ();
		public unowned Ide.File get_file ();
		public bool get_has_diagnostics ();
		public bool get_highlight_diagnostics ();
		public Ide.SourceLocation get_insert_location ();
		public void get_iter_at_source_location (out Gtk.TextIter iter, Ide.SourceLocation location);
		public Ide.SourceLocation get_iter_location (Gtk.TextIter iter);
		public unowned string? get_language_id ();
		public Ide.BufferLineFlags get_line_flags (uint line);
		public bool get_loading ();
		public bool get_read_only ();
		public unowned Ide.RenameProvider? get_rename_provider ();
		public void get_selection_bounds (out Gtk.TextIter insert, out Gtk.TextIter selection);
		public bool get_spell_checking ();
		public unowned string get_style_scheme_name ();
		public async Ide.Symbol get_symbol_at_location_async (Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.ExtensionSetAdapter? get_symbol_resolvers ();
		public unowned string get_title ();
		public string get_uri ();
		public string get_word_at_iter (Gtk.TextIter iter);
		public void hold ();
		public void rehighlight ();
		public void release ();
		public void set_file (Ide.File file);
		public void set_highlight_diagnostics (bool highlight_diagnostics);
		public void set_spell_checking (bool enable);
		public void set_style_scheme_name (string style_scheme_name);
		public void sync_to_unsaved_files ();
		public void trim_trailing_whitespace ();
		public bool busy { get; }
		public bool changed_on_volume { get; }
		public Ide.Context context { get; construct; }
		[Version (since = "3.28")]
		public bool failed { get; }
		public Ide.File file { get; set; }
		public bool has_diagnostics { get; }
		public bool highlight_diagnostics { get; set; }
		public bool read_only { get; }
		public string style_scheme_name { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
		[Version (since = "3.26")]
		public signal void change_settled ();
		public virtual signal void cursor_moved (Gtk.TextIter location);
		public signal void destroy ();
		public signal void line_flags_changed ();
		public signal void loaded ();
		public signal void saved ();
		public signal void symbol_resolvers_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_change_monitor_get_type ()")]
	public class BufferChangeMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BufferChangeMonitor ();
		public void emit_changed ();
		public virtual Ide.BufferLineChange get_change (uint line);
		public virtual void reload ();
		[NoWrapper]
		public virtual void set_buffer (Ide.Buffer buffer);
		[NoAccessorMethod]
		public Ide.Buffer buffer { construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buffer_manager_get_type ()")]
	public class BufferManager : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected BufferManager ();
		public async bool apply_edits_async (owned GLib.GenericArray<Ide.ProjectEdit> edits, GLib.Cancellable? cancellable) throws GLib.Error;
		public Ide.Buffer create_temporary_buffer ();
		public unowned Ide.Buffer? find_buffer (GLib.File file);
		public bool get_auto_save ();
		public uint get_auto_save_timeout ();
		public GLib.GenericArray<Ide.Buffer> get_buffers ();
		public unowned Ide.Buffer get_focus_buffer ();
		public size_t get_max_file_size ();
		public uint get_n_buffers ();
		public bool has_file (GLib.File file);
		public async Ide.Buffer load_file_async (Ide.File file, bool force_reload, Ide.WorkbenchOpenFlags flags, Ide.Progress* progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_file_async (Ide.Buffer buffer, Ide.File file, Ide.Progress* progress, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_auto_save (bool auto_save);
		public void set_auto_save_timeout (uint auto_save_timeout);
		public void set_focus_buffer (Ide.Buffer buffer);
		public void set_max_file_size (size_t max_file_size);
		public bool auto_save { get; set; }
		public uint auto_save_timeout { get; set; }
		public Ide.Buffer focus_buffer { get; set; }
		public signal void buffer_focus_enter (Ide.Buffer buffer);
		public signal void buffer_focus_leave (Ide.Buffer buffer);
		public signal void buffer_loaded (Ide.Buffer buffer);
		public signal void buffer_saved (Ide.Buffer buffer);
		public signal void buffer_unloaded (Ide.Buffer buffer);
		public signal Ide.Buffer? create_buffer (Ide.File file);
		public signal void load_buffer (Ide.Buffer buffer, bool create_new_view);
		public signal void save_buffer (Ide.Buffer buffer);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_manager_get_type ()")]
	public class BuildManager : Ide.Object, GLib.ActionGroup, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected BuildManager ();
		[Version (since = "3.22")]
		public void cancel ();
		[Version (since = "3.22")]
		public async bool clean_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.22")]
		public async bool execute_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.22")]
		public bool get_busy ();
		[Version (since = "3.22")]
		public bool get_can_build ();
		[Version (since = "3.22")]
		public unowned GLib.DateTime? get_last_build_time ();
		[Version (since = "3.22")]
		public string get_message ();
		[Version (since = "3.22")]
		public unowned Ide.BuildPipeline? get_pipeline ();
		[Version (since = "3.22")]
		public GLib.TimeSpan get_running_time ();
		[Version (since = "3.22")]
		public async bool rebuild_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.22")]
		public bool busy { get; }
		[Version (since = "3.22")]
		public bool can_build { get; }
		[NoAccessorMethod]
		[Version (since = "3.22")]
		public uint error_count { get; }
		[NoAccessorMethod]
		[Version (since = "3.22")]
		public bool has_diagnostics { get; }
		[Version (since = "3.22")]
		public GLib.DateTime last_build_time { get; }
		[Version (since = "3.22")]
		public string message { owned get; }
		[Version (since = "3.22")]
		public Ide.BuildPipeline pipeline { get; }
		[Version (since = "3.22")]
		public int64 running_time { get; }
		[NoAccessorMethod]
		[Version (since = "3.22")]
		public uint warning_count { get; }
		[Version (since = "3.22")]
		public signal void build_failed (Ide.BuildPipeline pipeline);
		[Version (since = "3.22")]
		public signal void build_finished (Ide.BuildPipeline pipeline);
		[Version (since = "3.22")]
		public signal void build_started (Ide.BuildPipeline pipeline);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_pipeline_get_type ()")]
	public class BuildPipeline : Ide.Object, GLib.Initable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected BuildPipeline ();
		public uint add_error_format (string regex, GLib.RegexCompileFlags flags);
		public uint add_log_observer (owned Ide.BuildLogObserver observer);
		[Version (since = "3.28")]
		public void attach_pty (Ide.SubprocessLauncher launcher);
		[Version (since = "3.28")]
		public async bool build_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool clean_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		public uint connect (Ide.BuildPhase phase, int priority, Ide.BuildStage stage);
		public uint connect_launcher (Ide.BuildPhase phase, int priority, Ide.SubprocessLauncher launcher);
		public Ide.SubprocessLauncher create_launcher () throws GLib.Error;
		public void disconnect (uint stage_id);
		public void emit_diagnostic (Ide.Diagnostic diagnostic);
		[Version (since = "3.24")]
		public async bool execute_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void foreach_stage (GLib.Func stage_callback);
		public unowned string get_builddir ();
		public bool get_busy ();
		public bool get_can_export ();
		public unowned Ide.Configuration get_configuration ();
		[Version (since = "3.28")]
		public unowned Ide.Device get_device ();
		[Version (since = "3.30")]
		public unowned Ide.Triplet get_host_triplet ();
		public string? get_message ();
		public Ide.BuildPhase get_phase ();
		[Version (since = "3.28")]
		public unowned Vte.Pty? get_pty ();
		[Version (since = "3.28")]
		public Ide.BuildPhase get_requested_phase ();
		[Version (since = "3.28")]
		public unowned Ide.Runtime? get_runtime ();
		public unowned string get_srcdir ();
		public unowned Ide.BuildStage? get_stage_by_id (uint stage_id);
		[Version (since = "3.30")]
		public unowned Ide.Toolchain get_toolchain ();
		[Version (since = "3.28")]
		public bool has_configured ();
		public void invalidate_phase (Ide.BuildPhase phases);
		[Version (since = "3.30")]
		public bool is_native ();
		[Version (since = "3.28")]
		public bool is_ready ();
		public async bool rebuild_async (Ide.BuildPhase phase, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool remove_error_format (uint error_format_id);
		public bool remove_log_observer (uint observer_id);
		public bool request_phase (Ide.BuildPhase phase);
		[NoAccessorMethod]
		public bool busy { get; set; }
		public Ide.Configuration configuration { get; construct; }
		[Version (since = "3.28")]
		public Ide.Device device { get; construct; }
		[Version (since = "3.28")]
		public string message { owned get; }
		public Ide.BuildPhase phase { get; }
		[Version (since = "3.28")]
		public Vte.Pty pty { get; }
		public signal void diagnostic (Ide.Diagnostic diagnostic);
		public signal void finished (bool failed);
		public signal void started (Ide.BuildPhase phase);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_stage_get_type ()")]
	public class BuildStage : Ide.Object {
		[CCode (has_construct_function = false)]
		protected BuildStage ();
		public virtual async bool clean_async (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public void emit_reap (Dazzle.DirectoryReaper reaper);
		[NoWrapper]
		public virtual bool execute (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public virtual async bool execute_async (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public bool get_active ();
		public bool get_check_stdout ();
		public bool get_completed ();
		public bool get_disabled ();
		public unowned string get_name ();
		public unowned string get_stdout_path ();
		public bool get_transient ();
		public void log (Ide.BuildLogStream stream, string message, ssize_t message_len);
		public void log_subprocess (Ide.Subprocess subprocess);
		public void pause ();
		public void set_active (bool active);
		public void set_check_stdout (bool check_stdout);
		public void set_completed (bool completed);
		public void set_disabled (bool disabled);
		public void set_log_observer (owned Ide.BuildLogObserver observer);
		public void set_name (string name);
		public void set_stdout_path (string path);
		public void set_transient (bool transient);
		public void unpause ();
		[Version (since = "3.28")]
		public bool active { get; set; }
		public bool check_stdout { get; set; }
		public bool completed { get; set; }
		public bool disabled { get; set; }
		public string name { get; set; }
		public string stdout_path { get; set; }
		public bool transient { get; set; }
		[HasEmitter]
		public virtual signal bool chain (Ide.BuildStage next);
		public virtual signal void query (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable = null);
		public virtual signal void reap (Dazzle.DirectoryReaper reaper);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_stage_launcher_get_type ()")]
	public class BuildStageLauncher : Ide.BuildStage {
		[CCode (has_construct_function = false, type = "IdeBuildStage*")]
		public BuildStageLauncher (Ide.Context context, Ide.SubprocessLauncher? launcher);
		public unowned Ide.SubprocessLauncher? get_clean_launcher ();
		public bool get_ignore_exit_status ();
		public unowned Ide.SubprocessLauncher get_launcher ();
		public bool get_use_pty ();
		public void set_clean_launcher (Ide.SubprocessLauncher clean_launcher);
		public void set_ignore_exit_status (bool ignore_exit_status);
		public void set_launcher (Ide.SubprocessLauncher launcher);
		[Version (since = "3.28")]
		public void set_use_pty (bool use_pty);
		public Ide.SubprocessLauncher clean_launcher { get; set; }
		public bool ignore_exit_status { get; set; }
		public Ide.SubprocessLauncher launcher { get; set; }
		public bool use_pty { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_stage_mkdirs_get_type ()")]
	public class BuildStageMkdirs : Ide.BuildStage {
		[CCode (has_construct_function = false, type = "IdeBuildStage*")]
		public BuildStageMkdirs (Ide.Context context);
		public void add_path (string path, bool with_parents, int mode, bool remove_on_rebuild);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_build_stage_transfer_get_type ()")]
	public class BuildStageTransfer : Ide.BuildStage {
		[CCode (has_construct_function = false)]
		public BuildStageTransfer (Ide.Context context, Ide.Transfer transfer);
		[NoAccessorMethod]
		public bool disable_when_metered { get; set; }
		[NoAccessorMethod]
		public Ide.Transfer transfer { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_buildconfig_configuration_get_type ()")]
	public class BuildconfigConfiguration : Ide.Configuration {
		[CCode (has_construct_function = false)]
		protected BuildconfigConfiguration ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_postbuild ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_prebuild ();
		public void set_postbuild (string postbuild);
		public void set_prebuild (string prebuild);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] postbuild { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] prebuild { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_cell_renderer_fancy_get_type ()")]
	public class CellRendererFancy : Gtk.CellRenderer {
		[CCode (has_construct_function = false, type = "GtkCellRenderer*")]
		public CellRendererFancy ();
		public unowned string get_body ();
		public unowned string get_title ();
		public void set_body (string body);
		public void set_title (string title);
		[Version (since = "3.26")]
		public void take_title (owned string? title);
		public string body { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "ide.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_code_index_entry_get_type ()")]
	[Compact]
	public class CodeIndexEntry {
		public Ide.CodeIndexEntry copy ();
		public void free ();
		public Ide.SymbolFlags get_flags ();
		public unowned string get_key ();
		public Ide.SymbolKind get_kind ();
		public unowned string get_name ();
		[Version (since = "3.30")]
		public void get_range (out uint begin_line, out uint begin_line_offset, out uint end_line, out uint end_line_offset);
	}
	[CCode (cheader_filename = "ide.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_code_index_entry_builder_get_type ()")]
	[Compact]
	public class CodeIndexEntryBuilder {
		[CCode (has_construct_function = false)]
		public CodeIndexEntryBuilder ();
		[Version (since = "3.30")]
		public Ide.CodeIndexEntry build ();
		[Version (since = "3.30")]
		public Ide.CodeIndexEntryBuilder copy ();
		public void free ();
		public void set_flags (Ide.SymbolFlags flags);
		public void set_key (string key);
		public void set_kind (Ide.SymbolKind kind);
		public void set_name (string name);
		public void set_range (uint begin_line, uint begin_line_offset, uint end_line, uint end_line_offset);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_compile_commands_get_type ()")]
	public class CompileCommands : GLib.Object {
		[CCode (has_construct_function = false)]
		[Version (since = "3.28")]
		public CompileCommands ();
		[Version (since = "3.28")]
		public bool load (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.28")]
		public async bool load_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.28")]
		public string[]? lookup (GLib.File file, string system_includes, out GLib.File directory) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_get_type ()")]
	public class Completion : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Completion ();
		[Version (since = "3.30")]
		public void add_provider (Ide.CompletionProvider provider);
		public void block_interactive ();
		public void cancel ();
		[Version (since = "3.30")]
		public static string fuzzy_highlight (string haystack, string casefold_query);
		[Version (since = "3.30")]
		public static bool fuzzy_match (string? haystack, string casefold_needle, out uint priority);
		public unowned Gtk.TextBuffer get_buffer ();
		[Version (since = "3.30")]
		public unowned Ide.CompletionDisplay get_display ();
		public uint get_n_rows ();
		public unowned Gtk.SourceView get_view ();
		[Version (since = "3.30")]
		public bool is_visible ();
		public void move_cursor (Gtk.MovementStep step, int direction);
		[Version (since = "3.30")]
		public void remove_provider (Ide.CompletionProvider provider);
		public void set_n_rows (uint n_rows);
		public void unblock_interactive ();
		[Version (since = "3.30")]
		public Gtk.TextView buffer { get; }
		[Version (since = "3.30")]
		public uint n_rows { get; set; }
		[Version (since = "3.30")]
		public Gtk.SourceView view { get; construct; }
		[HasEmitter]
		[Version (since = "3.30")]
		public signal void hide ();
		[Version (since = "3.30")]
		public signal void provider_added (Ide.CompletionProvider provider);
		[Version (since = "3.30")]
		public signal void provider_removed (Ide.CompletionProvider provider);
		[HasEmitter]
		[Version (since = "3.30")]
		public signal void show ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_context_get_type ()")]
	public class CompletionContext : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected CompletionContext ();
		[Version (since = "3.30")]
		public Ide.CompletionActivation get_activation ();
		[Version (since = "3.30")]
		public bool get_bounds (out Gtk.TextIter begin, out Gtk.TextIter end);
		[Version (since = "3.30")]
		public unowned Gtk.TextBuffer? get_buffer ();
		[Version (since = "3.30")]
		public bool get_busy ();
		[Version (since = "3.30")]
		public unowned Ide.Completion? get_completion ();
		public bool get_item_full (uint position, Ide.CompletionProvider provider, Ide.CompletionProposal proposal);
		[Version (since = "3.30")]
		public unowned string? get_language ();
		[Version (since = "3.30")]
		public string get_line_text ();
		public bool get_start_iter (out Gtk.TextIter iter);
		public unowned Gtk.TextView? get_view ();
		public string get_word ();
		[Version (since = "3.30")]
		public bool is_empty ();
		[Version (since = "3.30")]
		public bool is_language (string language);
		[Version (since = "3.30")]
		public void set_proposals_for_provider (Ide.CompletionProvider provider, GLib.ListModel? results);
		[Version (since = "3.30")]
		public bool busy { get; }
		[Version (since = "3.30")]
		public Ide.Completion completion { get; construct; }
		[NoAccessorMethod]
		[Version (since = "3.30")]
		public bool empty { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_list_box_get_type ()")]
	public class CompletionListBox : Dazzle.Bin, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CompletionListBox ();
		public unowned Ide.CompletionContext? get_context ();
		public uint get_n_rows ();
		[Version (since = "3.30")]
		public Ide.CompletionProposal? get_proposal ();
		[Version (since = "3.30")]
		public bool get_selected (out Ide.CompletionProvider provider, out Ide.CompletionProposal proposal);
		public void move_cursor (Gtk.MovementStep step, int direction);
		[Version (since = "3.30")]
		public void set_context (Ide.CompletionContext context);
		public void set_n_rows (uint n_rows);
		public Ide.CompletionContext context { get; set; }
		[NoAccessorMethod]
		public Gtk.Adjustment hadjustment { owned get; set construct; }
		[NoAccessorMethod]
		public Gtk.ScrollablePolicy hscroll_policy { get; set; }
		public uint n_rows { get; set construct; }
		public Ide.CompletionProposal proposal { owned get; }
		[NoAccessorMethod]
		public Gtk.Adjustment vadjustment { owned get; set construct; }
		[NoAccessorMethod]
		public Gtk.ScrollablePolicy vscroll_policy { get; set; }
		public signal void reposition ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_list_box_row_get_type ()")]
	public class CompletionListBoxRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public CompletionListBoxRow ();
		[Version (since = "3.30")]
		public unowned Ide.CompletionProposal? get_proposal ();
		public void set_center (string? center);
		public void set_center_markup (string? center_markup);
		public void set_icon_name (string? icon_name);
		public void set_left (string? left);
		public void set_left_markup (string? left_markup);
		[Version (since = "3.30")]
		public void set_proposal (Ide.CompletionProposal proposal);
		public void set_right (string? right);
		[Version (since = "3.30")]
		public Ide.CompletionProposal proposal { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_overlay_get_type ()")]
	public class CompletionOverlay : Gtk.Bin, Atk.Implementor, Gtk.Buildable, Ide.CompletionDisplay {
		[CCode (has_construct_function = false)]
		protected CompletionOverlay ();
		[NoAccessorMethod]
		public Ide.CompletionContext context { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_view_get_type ()")]
	public class CompletionView : Dazzle.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected CompletionView ();
		[Version (since = "3.30")]
		public unowned Ide.CompletionContext? get_context ();
		[Version (since = "3.30")]
		public void set_context (Ide.CompletionContext context);
		public Ide.CompletionContext context { get; set; }
		[NoAccessorMethod]
		public Ide.CompletionProposal proposal { owned get; }
		public signal void activate ();
		public signal void move_cursor (Gtk.MovementStep object, int p0);
		[Version (since = "3.30")]
		public signal void reposition ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_completion_window_get_type ()")]
	public class CompletionWindow : Gtk.Window, Atk.Implementor, Gtk.Buildable, Ide.CompletionDisplay {
		[CCode (has_construct_function = false)]
		protected CompletionWindow ();
		[Version (since = "3.30")]
		public unowned Ide.CompletionContext? get_context ();
		public Ide.CompletionContext context { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_configuration_get_type ()")]
	public abstract class Configuration : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Configuration ();
		public void apply_path (Ide.SubprocessLauncher launcher);
		public unowned string? get_app_id ();
		public unowned string get_append_path ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_build_commands ();
		public unowned GLib.File? get_build_commands_dir ();
		public unowned string get_config_opts ();
		public bool get_debug ();
		public bool get_dirty ();
		public unowned string get_display_name ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_environ ();
		public unowned Ide.Environment get_environment ();
		public unowned string get_id ();
		public bool get_internal_boolean (string key);
		public int get_internal_int (string key);
		public int64 get_internal_int64 (string key);
		public unowned GLib.Object? get_internal_object (string key);
		public unowned string get_internal_string (string key);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_internal_strv (string key);
		public Ide.BuildLocality get_locality ();
		public int get_parallelism ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_post_install_commands ();
		public unowned string get_prefix ();
		public bool get_ready ();
		[Version (since = "3.26")]
		public unowned string? get_run_opts ();
		public virtual unowned Ide.Runtime? get_runtime ();
		public unowned string get_runtime_id ();
		public uint get_sequence ();
		[Version (since = "3.30")]
		public Ide.Toolchain? get_toolchain ();
		[Version (since = "3.30")]
		public unowned string? get_toolchain_id ();
		public unowned string getenv (string key);
		public void set_app_id (string app_id);
		public void set_append_path (string append_path);
		public void set_build_commands (string build_commands);
		public void set_build_commands_dir (GLib.File build_commands_dir);
		public void set_config_opts (string config_opts);
		public void set_debug (bool debug);
		public void set_dirty (bool dirty);
		public void set_display_name (string display_name);
		public void set_environment (Ide.Environment environment);
		public void set_internal_boolean (string key, bool value);
		public void set_internal_int (string key, int value);
		public void set_internal_int64 (string key, int64 value);
		public void set_internal_object (string key, GLib.Object? instance);
		public void set_internal_string (string key, string value);
		public void set_internal_strv (string key, string value);
		public void set_locality (Ide.BuildLocality locality);
		public void set_parallelism (int parallelism);
		public void set_post_install_commands (string post_install_commands);
		public void set_prefix (string prefix);
		[Version (since = "3.26")]
		public void set_run_opts (string? run_opts);
		public virtual void set_runtime (Ide.Runtime runtime);
		public void set_runtime_id (string runtime_id);
		[Version (since = "3.30")]
		public void set_toolchain (Ide.Toolchain? toolchain);
		[Version (since = "3.30")]
		public void set_toolchain_id (string toolchain_id);
		public void setenv (string key, string value);
		public virtual bool supports_runtime (Ide.Runtime runtime);
		public string app_id { get; set; }
		public string append_path { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] build_commands { get; set; }
		public GLib.File build_commands_dir { get; set; }
		public string config_opts { get; set; }
		public bool debug { get; set; }
		public bool dirty { get; set; }
		public string display_name { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { owned get; }
		public string id { get; construct; }
		public Ide.BuildLocality locality { get; set; }
		public int parallelism { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] post_install_commands { get; set; }
		public string prefix { get; set; }
		public bool ready { get; }
		public string run_opts { get; set; }
		public Ide.Runtime runtime { get; set; }
		public string runtime_id { get; set; }
		public Ide.Toolchain toolchain { owned get; set; }
		public string toolchain_id { get; set; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_configuration_manager_get_type ()")]
	public class ConfigurationManager : Ide.Object, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ConfigurationManager ();
		public void @delete (Ide.Configuration config);
		public void duplicate (Ide.Configuration config);
		public unowned Ide.Configuration? get_configuration (string id);
		public unowned Ide.Configuration get_current ();
		[Version (since = "3.28")]
		public bool get_ready ();
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_current (Ide.Configuration configuration);
		public Ide.Configuration current { get; set; }
		[NoAccessorMethod]
		public string current_display_name { owned get; }
		public bool ready { get; }
		public signal void invalidate ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_context_get_type ()")]
	public class Context : GLib.Object, GLib.AsyncInitable {
		[CCode (cname = "ide_context_new_async", has_construct_function = false)]
		public async Context (GLib.File project_file, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public void add_pausable (Ide.Pausable pausable);
		public void emit_log (GLib.LogLevelFlags log_level, string message, ssize_t message_len);
		public unowned Ide.BufferManager get_buffer_manager ();
		public unowned Ide.BuildManager get_build_manager ();
		public unowned Ide.BuildSystem get_build_system ();
		public unowned Ide.ConfigurationManager get_configuration_manager ();
		public unowned Ide.DebugManager get_debug_manager ();
		public unowned Ide.DeviceManager get_device_manager ();
		public unowned Ide.DiagnosticsManager get_diagnostics_manager ();
		[Version (since = "3.28")]
		public unowned Ide.VcsMonitor get_monitor ();
		public unowned Ide.Project get_project ();
		public unowned GLib.File get_project_file ();
		public GLib.Settings get_project_settings ();
		public unowned Gtk.RecentManager get_recent_manager ();
		public unowned Ide.RunManager get_run_manager ();
		public unowned Ide.RuntimeManager get_runtime_manager ();
		public unowned Ide.SearchEngine get_search_engine ();
		public unowned Ide.Service? get_service_typed (GLib.Type service_type);
		public Ide.Settings get_settings (string schema_id, string? relative_path);
		[Version (since = "3.30")]
		public unowned Ide.SnippetStorage get_snippets ();
		[Version (since = "3.28")]
		public unowned Ide.TestManager get_test_manager ();
		public unowned Ide.ToolchainManager get_toolchain_manager ();
		public unowned Ide.UnsavedFiles get_unsaved_files ();
		public unowned Ide.Vcs get_vcs ();
		[Version (since = "3.30")]
		public unowned Gtk.Widget? get_workbench ();
		public void hold ();
		public void hold_for_object (GLib.Object instance);
		[Version (since = "3.28")]
		public bool is_unloading ();
		public void release ();
		[Version (since = "3.26")]
		public void remove_pausable (Ide.Pausable pausable);
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool unload_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public Ide.BufferManager buffer_manager { get; }
		public Ide.BuildSystem build_system { get; }
		public Ide.ConfigurationManager configuration_manager { get; }
		public Ide.DeviceManager device_manager { get; }
		public Ide.Project project { get; }
		public GLib.File project_file { get; construct; }
		public Ide.RuntimeManager runtime_manager { get; }
		public Ide.SearchEngine search_engine { get; }
		public Ide.SnippetStorage snippets { get; }
		public Ide.ToolchainManager toolchain_manager { get; }
		public Ide.UnsavedFiles unsaved_files { get; }
		public Ide.Vcs vcs { get; }
		public signal void loaded ();
		[Version (since = "3.28")]
		public signal void log (uint log_level, string message);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debug_manager_get_type ()")]
	public class DebugManager : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DebugManager ();
		public Ide.Debugger? find_debugger (Ide.Runner runner);
		public bool get_active ();
		public Ide.DebuggerBreakpoints get_breakpoints_for_file (GLib.File file);
		public unowned Ide.Debugger? get_debugger ();
		public bool start (Ide.Runner runner) throws GLib.Error;
		public void stop ();
		[Version (since = "3.26")]
		public bool supports_language (string? language_id);
		public bool active { get; }
		public Ide.Debugger debugger { get; }
		[Version (since = "3.26")]
		public signal void breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public signal void breakpoint_reached (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public signal void breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_get_type ()")]
	public abstract class Debugger : Ide.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		protected Debugger ();
		public static Ide.DebuggerAddress address_parse (string string);
		[Version (since = "3.26")]
		public virtual async GLib.GenericArray<Ide.DebuggerInstruction> disassemble_async (Ide.DebuggerAddressRange range, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public void emit_breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public void emit_breakpoint_modified (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public void emit_breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public void emit_library_loaded (Ide.DebuggerLibrary library);
		[Version (since = "3.26")]
		public void emit_library_unloaded (Ide.DebuggerLibrary library);
		[Version (since = "3.26")]
		public void emit_log (Ide.DebuggerStream stream, GLib.Bytes content);
		[Version (since = "3.26")]
		public void emit_running ();
		[Version (since = "3.26")]
		public void emit_stopped (Ide.DebuggerStopReason stop_reason, Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public void emit_thread_added (Ide.DebuggerThread thread);
		public void emit_thread_group_added (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_exited (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_removed (Ide.DebuggerThreadGroup thread_group);
		public void emit_thread_group_started (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.26")]
		public void emit_thread_removed (Ide.DebuggerThread thread);
		[Version (since = "3.26")]
		public void emit_thread_selected (Ide.DebuggerThread thread);
		public unowned GLib.ListModel get_breakpoints ();
		[Version (since = "3.26")]
		public virtual bool get_can_move (Ide.DebuggerMovement movement);
		[Version (since = "3.26")]
		public unowned string get_display_name ();
		public bool get_is_running ();
		[Version (since = "3.26")]
		public unowned Ide.DebuggerThread? get_selected_thread ();
		public unowned GLib.ListModel get_thread_groups ();
		public unowned GLib.ListModel get_threads ();
		[Version (since = "3.26")]
		public virtual async bool insert_breakpoint_async (Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async bool interrupt_async (Ide.DebuggerThreadGroup? thread_group, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async GLib.GenericArray<Ide.DebuggerBreakpoint> list_breakpoints_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async GLib.GenericArray<Ide.DebuggerFrame>? list_frames_async (Ide.DebuggerThread thread, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async GLib.GenericArray<Ide.DebuggerVariable> list_locals_async (Ide.DebuggerThread thread, Ide.DebuggerFrame frame, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async GLib.GenericArray<Ide.DebuggerVariable> list_params_async (Ide.DebuggerThread thread, Ide.DebuggerFrame frame, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async GLib.GenericArray<Ide.DebuggerRegister> list_registers_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public unowned string locate_binary_at_address (Ide.DebuggerAddress address);
		[Version (since = "3.26")]
		public virtual async bool modify_breakpoint_async (Ide.DebuggerBreakpointChange change, Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual async bool move_async (Ide.DebuggerMovement movement, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public virtual void prepare (Ide.Runner runner);
		[Version (since = "3.26")]
		public virtual async bool remove_breakpoint_async (Ide.DebuggerBreakpoint breakpoint, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual async bool send_signal_async (int signum, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_display_name (string display_name);
		public virtual bool supports_runner (Ide.Runner runner, out int priority);
		[Version (since = "3.26")]
		public string display_name { get; set; }
		[Version (since = "3.26")]
		public Ide.DebuggerThread selected_thread { get; }
		[Version (since = "3.26")]
		public virtual signal void breakpoint_added (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public virtual signal void breakpoint_modified (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public virtual signal void breakpoint_removed (Ide.DebuggerBreakpoint breakpoint);
		[Version (since = "3.26")]
		public virtual signal void library_loaded (Ide.DebuggerLibrary library);
		[Version (since = "3.26")]
		public virtual signal void library_unloaded (Ide.DebuggerLibrary library);
		[Version (since = "3.26")]
		public virtual signal void log (Ide.DebuggerStream stream, GLib.Bytes content);
		[Version (since = "3.26")]
		public virtual signal void running ();
		[Version (since = "3.26")]
		public virtual signal void stopped (Ide.DebuggerStopReason stop_reason, Ide.DebuggerBreakpoint? breakpoint);
		[Version (since = "3.26")]
		public virtual signal void thread_added (Ide.DebuggerThread thread);
		[Version (since = "3.26")]
		public virtual signal void thread_group_added (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.26")]
		public virtual signal void thread_group_exited (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.26")]
		public virtual signal void thread_group_removed (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.26")]
		public virtual signal void thread_group_started (Ide.DebuggerThreadGroup thread_group);
		[Version (since = "3.26")]
		public virtual signal void thread_removed (Ide.DebuggerThread thread);
		[Version (since = "3.26")]
		public virtual signal void thread_selected (Ide.DebuggerThread thread);
	}
	[CCode (cheader_filename = "ide.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ide_debugger_address_range_get_type ()")]
	[Compact]
	public class DebuggerAddressRange {
		public Ide.DebuggerAddress from;
		public Ide.DebuggerAddress to;
		public Ide.DebuggerAddressRange copy ();
		public void free ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_breakpoint_get_type ()")]
	public class DebuggerBreakpoint : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerBreakpoint (string id);
		public int compare (Ide.DebuggerBreakpoint b);
		[Version (since = "3.26")]
		public Ide.DebuggerAddress get_address ();
		[Version (since = "3.26")]
		public int64 get_count ();
		[Version (since = "3.26")]
		public Ide.DebuggerDisposition get_disposition ();
		public bool get_enabled ();
		[Version (since = "3.26")]
		public unowned string? get_file ();
		[Version (since = "3.26")]
		public unowned string get_function ();
		[Version (since = "3.26")]
		public unowned string get_id ();
		[Version (since = "3.26")]
		public uint get_line ();
		[Version (since = "3.26")]
		public Ide.DebuggerBreakMode get_mode ();
		public unowned string? get_spec ();
		[Version (since = "3.26")]
		public unowned string? get_thread ();
		[Version (since = "3.26")]
		public void set_address (Ide.DebuggerAddress address);
		[Version (since = "3.26")]
		public void set_count (int64 count);
		[Version (since = "3.26")]
		public void set_disposition (Ide.DebuggerDisposition disposition);
		[Version (since = "3.26")]
		public void set_enabled (bool enabled);
		[Version (since = "3.26")]
		public void set_file (string? file);
		[Version (since = "3.26")]
		public void set_function (string? function);
		[Version (since = "3.26")]
		public void set_line (uint line);
		[Version (since = "3.26")]
		public void set_mode (Ide.DebuggerBreakMode mode);
		[Version (since = "3.26")]
		public void set_spec (string? spec);
		[Version (since = "3.26")]
		public void set_thread (string thread);
		[Version (since = "3.26")]
		public uint64 address { get; set; }
		[Version (since = "3.26")]
		public int64 count { get; set; }
		[Version (since = "3.26")]
		public Ide.DebuggerDisposition disposition { get; set; }
		[Version (since = "3.26")]
		public bool enabled { get; set; }
		[Version (since = "3.26")]
		public string file { get; set; }
		[Version (since = "3.26")]
		public string function { get; set; }
		[Version (since = "3.26")]
		public string id { get; construct; }
		[Version (since = "3.26")]
		public uint line { get; set; }
		[Version (since = "3.26")]
		public Ide.DebuggerBreakMode mode { get; set; }
		[Version (since = "3.26")]
		public string spec { get; set; }
		[Version (since = "3.26")]
		public string thread { get; set; }
		[Version (since = "3.26")]
		public virtual signal void reset ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_breakpoints_get_type ()")]
	public class DebuggerBreakpoints : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DebuggerBreakpoints ();
		[Version (since = "3.26")]
		public void @foreach (GLib.Func func);
		public unowned GLib.File get_file ();
		[Version (since = "3.26")]
		public unowned Ide.DebuggerBreakpoint? get_line (uint line);
		public Ide.DebuggerBreakMode get_line_mode (uint line);
		public GLib.File file { get; construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_frame_get_type ()")]
	public class DebuggerFrame : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerFrame ();
		public Ide.DebuggerAddress get_address ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_args ();
		public uint get_depth ();
		public unowned string get_file ();
		public unowned string get_function ();
		public unowned string get_library ();
		public uint get_line ();
		public void set_address (Ide.DebuggerAddress address);
		public void set_args (string args);
		public void set_depth (uint depth);
		public void set_file (string file);
		public void set_function (string function);
		public void set_library (string library);
		public void set_line (uint line);
		public uint64 address { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] args { get; set; }
		public uint depth { get; set; }
		public string file { get; set; }
		public string function { get; set; }
		public string library { get; set; }
		public uint line { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_instruction_get_type ()")]
	public class DebuggerInstruction : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerInstruction (Ide.DebuggerAddress address);
		public Ide.DebuggerAddress get_address ();
		public unowned string get_display ();
		public unowned string get_function ();
		public void set_display (string display);
		public void set_function (string function);
		public uint64 address { get; construct; }
		public string display { get; set; }
		public string function { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_library_get_type ()")]
	public class DebuggerLibrary : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerLibrary (string id);
		public void add_range (Ide.DebuggerAddressRange range);
		public int compare (Ide.DebuggerLibrary b);
		public unowned string get_host_name ();
		public unowned string get_id ();
		public unowned GLib.GenericArray<Ide.DebuggerAddressRange> get_ranges ();
		public unowned string get_target_name ();
		public void set_host_name (string host_name);
		public void set_target_name (string target_name);
		public string host_name { get; set; }
		public string id { get; construct; }
		public string target_name { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_register_get_type ()")]
	public class DebuggerRegister : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerRegister (string id);
		public int compare (Ide.DebuggerRegister b);
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned string get_value ();
		public void set_name (string name);
		public void set_value (string value);
		public string id { get; construct; }
		public string name { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_thread_get_type ()")]
	public class DebuggerThread : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerThread (string id);
		public int compare (Ide.DebuggerThread b);
		public unowned string get_group ();
		public unowned string get_id ();
		public void set_group (string thread_group);
		public string group { get; set; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_thread_group_get_type ()")]
	public class DebuggerThreadGroup : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerThreadGroup (string id);
		public int compare (Ide.DebuggerThreadGroup b);
		public unowned string get_exit_code ();
		public unowned string get_id ();
		public unowned string get_pid ();
		public void set_exit_code (string exit_code);
		public void set_pid (string pid);
		public string exit_code { get; set; }
		public string id { get; construct; }
		public string pid { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_debugger_variable_get_type ()")]
	public class DebuggerVariable : GLib.Object {
		[CCode (has_construct_function = false)]
		public DebuggerVariable (string name);
		public bool get_has_children ();
		public unowned string get_name ();
		public unowned string get_type_name ();
		public unowned string get_value ();
		public void set_has_children (bool has_children);
		public void set_type_name (string type_name);
		public void set_value (string value);
		public bool has_children { get; set; }
		public string name { get; construct; }
		public string type_name { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_deploy_strategy_get_type ()")]
	public abstract class DeployStrategy : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DeployStrategy ();
		[Version (since = "3.28")]
		public virtual async bool deploy_async (Ide.BuildPipeline pipeline, [CCode (delegate_target_pos = 2.33333, destroy_notify_pos = 2.66667)] owned GLib.FileProgressCallback? progress, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public virtual async bool load_async (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_get_type ()")]
	public abstract class Device : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Device ();
		public unowned string? get_display_name ();
		[Version (since = "3.28")]
		public unowned string? get_icon_name ();
		public unowned string get_id ();
		[Version (since = "3.28")]
		public virtual async Ide.DeviceInfo get_info_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void prepare_configuration (Ide.Configuration configuration);
		public void set_display_name (string display_name);
		[Version (since = "3.28")]
		public void set_icon_name (string icon_name);
		public void set_id (string id);
		public string display_name { get; set; }
		[Version (since = "3.28")]
		public string icon_name { get; set; }
		public string id { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_info_get_type ()")]
	public class DeviceInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public DeviceInfo ();
		[Version (since = "3.30")]
		public unowned Ide.Triplet? get_host_triplet ();
		public Ide.DeviceKind get_kind ();
		[Version (since = "3.30")]
		public void set_host_triplet (Ide.Triplet host_triplet);
		public void set_kind (Ide.DeviceKind kind);
		public Ide.Triplet host_triplet { get; set; }
		public Ide.DeviceKind kind { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_manager_get_type ()")]
	public class DeviceManager : Ide.Object, GLib.ActionGroup, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected DeviceManager ();
		[Version (since = "3.28")]
		public async bool deploy_async (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public unowned Ide.Device get_device ();
		public unowned Ide.Device get_device_by_id (string device_id);
		public double get_progress ();
		[Version (since = "3.28")]
		public void set_device (Ide.Device? device);
		[Version (since = "3.28")]
		public Ide.Device device { get; set; }
		[Version (since = "3.28")]
		public double progress { get; }
		public signal void deploy_finished ();
		public signal void deploy_started ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_device_provider_get_type ()")]
	public abstract class DeviceProvider : Ide.Object {
		[CCode (has_construct_function = false)]
		protected DeviceProvider ();
		[Version (since = "3.28")]
		public void emit_device_added (Ide.Device device);
		[Version (since = "3.28")]
		public void emit_device_removed (Ide.Device device);
		[Version (since = "3.28")]
		public GLib.GenericArray<Ide.Device> get_devices ();
		[Version (since = "3.28")]
		public virtual async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public virtual signal void device_added (Ide.Device device);
		[Version (since = "3.28")]
		public virtual signal void device_removed (Ide.Device device);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostic_ref", type_id = "ide_diagnostic_get_type ()", unref_function = "ide_diagnostic_unref")]
	[Compact]
	public class Diagnostic {
		[CCode (has_construct_function = false)]
		public Diagnostic (Ide.DiagnosticSeverity severity, string text, Ide.SourceLocation? location);
		public void add_range (Ide.SourceRange range);
		public int compare (Ide.Diagnostic b);
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Diagnostic.from_variant (GLib.Variant? variant);
		public unowned GLib.File? get_file ();
		public unowned Ide.Fixit get_fixit (uint index);
		public unowned Ide.SourceLocation get_location ();
		public uint get_num_fixits ();
		public uint get_num_ranges ();
		public unowned Ide.SourceRange? get_range (uint index);
		public Ide.DiagnosticSeverity get_severity ();
		public unowned string get_text ();
		public string get_text_for_display ();
		public uint hash ();
		public unowned Ide.Diagnostic @ref ();
		public void take_fixit (owned Ide.Fixit fixit);
		public void take_range (owned Ide.SourceRange range);
		[Version (since = "3.30")]
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_diagnostics_ref", type_id = "ide_diagnostics_get_type ()", unref_function = "ide_diagnostics_unref")]
	[Compact]
	public class Diagnostics {
		[CCode (has_construct_function = false)]
		public Diagnostics (owned GLib.GenericArray<Ide.Diagnostic>? ar);
		public void add (Ide.Diagnostic diagnostic);
		public size_t get_size ();
		public unowned Ide.Diagnostic index (size_t index);
		public void merge (Ide.Diagnostics other);
		public unowned Ide.Diagnostics @ref ();
		[Version (since = "3.30")]
		public void take (owned Ide.Diagnostic diagnostic);
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_diagnostics_manager_get_type ()")]
	public class DiagnosticsManager : Ide.Object, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected DiagnosticsManager ();
		public bool get_busy ();
		public Ide.Diagnostics get_diagnostics_for_file (GLib.File file);
		public uint get_sequence_for_file (GLib.File file);
		[Version (since = "3.28")]
		public void rediagnose (Ide.Buffer buffer);
		public void update_group_by_file (Ide.Buffer buffer, GLib.File new_file);
		public bool busy { get; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_build_system_get_type ()")]
	public class DirectoryBuildSystem : Ide.Object, GLib.AsyncInitable, Ide.BuildSystem {
		[CCode (has_construct_function = false)]
		protected DirectoryBuildSystem ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_directory_vcs_get_type ()")]
	public class DirectoryVcs : Ide.Object, GLib.AsyncInitable, Ide.Vcs {
		[CCode (has_construct_function = false)]
		protected DirectoryVcs ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_get_type ()")]
	public class Doap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Doap ();
		public unowned string get_bug_database ();
		public unowned string get_category ();
		public unowned string get_description ();
		public unowned string get_download_page ();
		public unowned string get_homepage ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.List<Ide.DoapPerson> get_maintainers ();
		public unowned string get_name ();
		public unowned string get_shortdesc ();
		public bool load_from_data (string data, size_t length) throws GLib.Error;
		public bool load_from_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[NoAccessorMethod]
		public string bug_database { owned get; set; }
		[NoAccessorMethod]
		public string category { owned get; set; }
		[NoAccessorMethod]
		public string description { owned get; set; }
		[NoAccessorMethod]
		public string download_page { owned get; set; }
		[NoAccessorMethod]
		public string homepage { owned get; set; }
		[NoAccessorMethod]
		public string languages { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string shortdesc { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_doap_person_get_type ()")]
	public class DoapPerson : GLib.Object {
		[CCode (has_construct_function = false)]
		public DoapPerson ();
		public unowned string get_email ();
		public unowned string get_name ();
		public void set_email (string email);
		public void set_name (string name);
		public string email { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_perspective_get_type ()")]
	public class EditorPerspective : Ide.Layout, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable, Ide.Perspective {
		[CCode (has_construct_function = false)]
		protected EditorPerspective ();
		public void focus_buffer (Ide.Buffer buffer);
		public void focus_buffer_in_current_stack (Ide.Buffer buffer);
		public void focus_location (Ide.SourceLocation location);
		[Version (since = "3.26")]
		public unowned Ide.LayoutView? get_active_view ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutGrid get_grid ();
		public unowned Gtk.Overlay get_overlay ();
		[Version (since = "3.26")]
		public unowned Ide.EditorSidebar get_sidebar ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutTransientSidebar get_transient_sidebar ();
		public unowned Gtk.Widget get_utilities ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_search_get_type ()")]
	public class EditorSearch : GLib.Object, GLib.ActionGroup {
		[CCode (has_construct_function = false)]
		[Version (since = "3.28")]
		public EditorSearch (Gtk.SourceView view);
		[Version (since = "3.28")]
		public void begin_interactive ();
		[Version (since = "3.28")]
		public void end_interactive ();
		public bool get_active ();
		[Version (since = "3.28")]
		public bool get_at_word_boundaries ();
		[Version (since = "3.28")]
		public bool get_case_sensitive ();
		[Version (since = "3.28")]
		public Ide.EditorSearchSelect get_extend_selection ();
		[Version (since = "3.28")]
		public uint get_match_count ();
		[Version (since = "3.28")]
		public uint get_match_position ();
		[Version (since = "3.28")]
		public bool get_regex_enabled ();
		public uint get_repeat ();
		[Version (since = "3.28")]
		public unowned string? get_replacement_text ();
		public bool get_replacement_text_invalid (uint invalid_begin, uint invalid_end);
		[Version (since = "3.28")]
		public bool get_reverse ();
		[Version (since = "3.28")]
		public unowned string? get_search_text ();
		[Version (since = "3.28")]
		public bool get_search_text_invalid (out uint invalid_begin, out uint invalid_end) throws GLib.Error;
		[Version (since = "3.28")]
		public bool get_visible ();
		[Version (since = "3.28")]
		public void move (Ide.EditorSearchDirection direction);
		[Version (since = "3.28")]
		public void replace ();
		[Version (since = "3.28")]
		public void replace_all ();
		[Version (since = "3.28")]
		public void set_at_word_boundaries (bool at_word_boundaries);
		[Version (since = "3.28")]
		public void set_case_sensitive (bool case_sensitive);
		public void set_extend_selection (Ide.EditorSearchSelect extend_selection);
		[Version (since = "3.28")]
		public void set_regex_enabled (bool regex_enabled);
		[Version (since = "3.28")]
		public void set_repeat (uint repeat);
		[Version (since = "3.28")]
		public void set_replacement_text (string? replacement_text);
		[Version (since = "3.28")]
		public void set_reverse (bool reverse);
		[Version (since = "3.28")]
		public void set_search_text (string? search_text);
		[Version (since = "3.28")]
		public void set_visible (bool visible);
		[Version (since = "3.28")]
		public bool active { get; }
		[Version (since = "3.28")]
		public bool at_word_boundaries { get; set; }
		[Version (since = "3.28")]
		public bool case_sensitive { get; set; }
		[Version (since = "3.28")]
		public Ide.EditorSearchSelect extend_selection { get; set; }
		[Version (since = "3.28")]
		public uint match_count { get; }
		[Version (since = "3.28")]
		public uint match_position { get; }
		[Version (since = "3.28")]
		public bool regex_enabled { get; set; }
		[Version (since = "3.28")]
		public uint repeat { get; set; }
		[Version (since = "3.28")]
		public string replacement_text { get; set; }
		[Version (since = "3.28")]
		public bool reverse { get; set; }
		[Version (since = "3.28")]
		public string search_text { get; set; }
		[NoAccessorMethod]
		[Version (since = "3.28")]
		public Gtk.SourceView view { owned get; construct; }
		[Version (since = "3.28")]
		public string visible { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_sidebar_get_type ()")]
	public class EditorSidebar : Ide.LayoutPane, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.26")]
		public EditorSidebar ();
		[Version (since = "3.26")]
		public void add_section (string? id, string title, string icon_name, string? menu_id, string? menu_icon_name, Gtk.Widget section, int priority);
		[Version (since = "3.26")]
		public unowned string? get_section_id ();
		[Version (since = "3.26")]
		public void set_section_id (string section_id);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_utilities_get_type ()")]
	public class EditorUtilities : Ide.LayoutPane, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected EditorUtilities ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_editor_view_get_type ()")]
	public class EditorView : Ide.LayoutView, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false)]
		protected EditorView ();
		[Version (since = "3.26")]
		public unowned Ide.EditorViewAddin? addin_find_by_module_name (string module_name);
		public bool get_auto_hide_map ();
		[Version (since = "3.26")]
		public unowned Ide.Buffer get_buffer ();
		[Version (since = "3.26")]
		public unowned Gtk.SourceLanguage? get_language ();
		[Version (since = "3.26")]
		public unowned string? get_language_id ();
		public unowned Ide.EditorSearch get_search ();
		public bool get_show_map ();
		[Version (since = "3.26")]
		public unowned Ide.SourceView get_view ();
		[Version (since = "3.26")]
		public void move_next_error ();
		[Version (since = "3.26")]
		public void move_next_search_result ();
		[Version (since = "3.26")]
		public void move_previous_error ();
		[Version (since = "3.26")]
		public void move_previous_search_result ();
		public void scroll_to_line (uint line);
		public void scroll_to_line_offset (uint line, uint line_offset);
		public void set_auto_hide_map (bool auto_hide_map);
		[Version (since = "3.26")]
		public void set_language (Gtk.SourceLanguage language);
		public void set_show_map (bool show_map);
		public bool auto_hide_map { get; set; }
		public Ide.Buffer buffer { get; construct; }
		public Ide.EditorSearch search { get; }
		public bool show_map { get; set; }
		public Ide.SourceView view { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_get_type ()")]
	public class Environment : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public Environment ();
		public void append (Ide.EnvironmentVariable variable);
		public Ide.Environment copy ();
		public void copy_into (Ide.Environment dest, bool replace);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_environ ();
		public unowned string getenv (string key);
		public void remove (Ide.EnvironmentVariable variable);
		public void setenv (string key, string value);
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_environment_variable_get_type ()")]
	public class EnvironmentVariable : GLib.Object {
		[CCode (has_construct_function = false)]
		public EnvironmentVariable (string key, string value);
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_adapter_get_type ()")]
	public class ExtensionAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionAdapter (Ide.Context context, Peas.Engine? engine, GLib.Type interface_type, string key, string? value);
		public unowned Peas.Engine get_engine ();
		public unowned GLib.Object get_extension ();
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Object extension { get; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_extension_set_adapter_get_type ()")]
	public class ExtensionSetAdapter : Ide.Object {
		[CCode (has_construct_function = false)]
		public ExtensionSetAdapter (Ide.Context context, Peas.Engine engine, GLib.Type interface_type, string key, string value);
		public void @foreach (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		public void foreach_by_priority (Ide.ExtensionSetAdapterForeachFunc foreach_func);
		public unowned Peas.Engine get_engine ();
		public unowned Peas.Extension? get_extension (Peas.PluginInfo plugin_info);
		public GLib.Type get_interface_type ();
		public unowned string get_key ();
		public uint get_n_extensions ();
		public unowned string get_value ();
		public void set_key (string key);
		public void set_value (string value);
		public Peas.Engine engine { get; construct; }
		public GLib.Type interface_type { get; construct; }
		public string key { get; set; }
		public string value { get; set; }
		public signal void extension_added (Peas.PluginInfo object, GLib.Object p0);
		public signal void extension_removed (Peas.PluginInfo object, GLib.Object p0);
		public signal void extensions_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_fancy_tree_view_get_type ()")]
	public class FancyTreeView : Gtk.TreeView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public FancyTreeView ();
		[Version (since = "3.26")]
		public void set_data_func (owned Gtk.CellLayoutDataFunc? func);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_get_type ()")]
	public class File : Ide.Object {
		[CCode (has_construct_function = false)]
		public File (Ide.Context? context, GLib.File file);
		public int compare (Ide.File b);
		public bool equal (Ide.File other);
		public async Ide.File? find_other_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public File.for_path (Ide.Context context, string path);
		public unowned GLib.File get_file ();
		public bool get_is_temporary ();
		public unowned Gtk.SourceLanguage? get_language ();
		public unowned string get_language_id ();
		public unowned string get_path ();
		public uint get_temporary_id ();
		public uint hash ();
		public async Ide.FileSettings load_settings_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public unowned Ide.FileSettings? peek_settings ();
		public GLib.File file { get; construct; }
		public bool is_temporary { get; }
		public Gtk.SourceLanguage language { get; }
		public string path { get; construct; }
		public uint temporary_id { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_file_settings_get_type ()")]
	public class FileSettings : Ide.Object {
		[CCode (has_construct_function = false)]
		public FileSettings (Ide.File file);
		public unowned Ide.File get_file ();
		public bool get_settled ();
		[NoAccessorMethod]
		public bool auto_indent { get; set; }
		[NoAccessorMethod]
		public bool auto_indent_set { get; set; }
		[NoAccessorMethod]
		public string encoding { owned get; set; }
		[NoAccessorMethod]
		public bool encoding_set { get; set; }
		public Ide.File file { get; construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { get; set; }
		[NoAccessorMethod]
		public bool indent_style_set { get; set; }
		[NoAccessorMethod]
		public int indent_width { get; set; }
		[NoAccessorMethod]
		public bool indent_width_set { get; set; }
		[NoAccessorMethod]
		public bool insert_matching_brace { get; set; }
		[NoAccessorMethod]
		public bool insert_matching_brace_set { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline { get; set; }
		[NoAccessorMethod]
		public bool insert_trailing_newline_set { get; set; }
		[NoAccessorMethod]
		public Gtk.SourceNewlineType newline_type { get; set; }
		[NoAccessorMethod]
		public bool newline_type_set { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces { get; set; }
		[NoAccessorMethod]
		public bool overwrite_braces_set { get; set; }
		[NoAccessorMethod]
		public uint right_margin_position { get; set; }
		[NoAccessorMethod]
		public bool right_margin_position_set { get; set; }
		[NoAccessorMethod]
		public bool settled { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin { get; set; }
		[NoAccessorMethod]
		public bool show_right_margin_set { get; set; }
		[NoAccessorMethod]
		public Ide.SpacesStyle spaces_style { get; set; }
		[NoAccessorMethod]
		public bool spaces_style_set { get; set; }
		[NoAccessorMethod]
		public uint tab_width { get; set; }
		[NoAccessorMethod]
		public bool tab_width_set { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace { get; set; }
		[NoAccessorMethod]
		public bool trim_trailing_whitespace_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_fixit_ref", type_id = "ide_fixit_get_type ()", unref_function = "ide_fixit_unref")]
	[Compact]
	public class Fixit {
		[CCode (has_construct_function = false)]
		public Fixit (Ide.SourceRange source_range, string replacement_text);
		public void apply ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Fixit.from_variant (GLib.Variant? variant);
		public unowned Ide.SourceRange get_range ();
		public unowned string get_text ();
		public unowned Ide.Fixit @ref ();
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_formatter_options_get_type ()")]
	public class FormatterOptions : GLib.Object {
		[CCode (has_construct_function = false)]
		public FormatterOptions ();
		public bool get_insert_spaces ();
		public uint get_tab_width ();
		public void set_insert_spaces (bool insert_spaces);
		public void set_tab_width (uint tab_width);
		public bool insert_spaces { get; set; }
		public uint tab_width { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_highlight_engine_get_type ()")]
	public class HighlightEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public HighlightEngine (Ide.Buffer buffer);
		[Version (since = "3.30")]
		public void advance ();
		public void clear ();
		public unowned Ide.Buffer get_buffer ();
		public unowned Ide.Highlighter get_highlighter ();
		public unowned Gtk.TextTag get_style (string style_name);
		public void invalidate (Gtk.TextIter begin, Gtk.TextIter end);
		public void pause ();
		public void rebuild ();
		public void unpause ();
		public Ide.Buffer buffer { get; construct; }
		public Ide.Highlighter highlighter { get; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_highlight_index_ref", type_id = "ide_highlight_index_get_type ()", unref_function = "ide_highlight_index_unref")]
	[Compact]
	public class HighlightIndex {
		[CCode (has_construct_function = false)]
		public HighlightIndex ();
		public void dump ();
		[CCode (has_construct_function = false)]
		public HighlightIndex.from_variant (GLib.Variant variant);
		public void insert (string word, void* tag);
		public void* lookup (string word);
		public unowned Ide.HighlightIndex @ref ();
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_hover_context_get_type ()")]
	public class HoverContext : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HoverContext ();
		public void add_content (int priority, string title, Ide.MarkedContent content);
		public void add_widget (int priority, string title, Gtk.Widget widget);
		public bool has_content ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_client_get_type ()")]
	public class LangservClient : Ide.Object {
		[CCode (has_construct_function = false)]
		public LangservClient (Ide.Context context, GLib.IOStream io_stream);
		public void add_language (string language_id);
		[Version (since = "3.26")]
		public async bool call_async (string method, GLib.Variant? @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool get_diagnostics_async (GLib.File file, GLib.Cancellable? cancellable, out Ide.Diagnostics? diagnostics) throws GLib.Error;
		[Version (since = "3.26")]
		public async bool send_notification_async (string method, GLib.Variant? @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public void start ();
		public void stop ();
		[NoAccessorMethod]
		public GLib.IOStream io_stream { owned get; construct; }
		public virtual signal void notification (string method, GLib.Variant @params);
		public virtual signal void published_diagnostics (GLib.File file, Ide.Diagnostics diagnostics);
		public virtual signal bool supports_language (string language_id);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_completion_item_get_type ()")]
	public class LangservCompletionItem : GLib.Object, Ide.CompletionProposal {
		[CCode (has_construct_function = false)]
		public LangservCompletionItem (GLib.Variant variant);
		public unowned string get_detail ();
		public unowned string get_icon_name ();
		public string get_markup (string typed_text);
		public unowned string get_return_type ();
		[Version (since = "3.30")]
		public Ide.Snippet get_snippet ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_completion_provider_get_type ()")]
	public abstract class LangservCompletionProvider : Ide.Object, Ide.CompletionProvider {
		[CCode (has_construct_function = false)]
		protected LangservCompletionProvider ();
		public unowned Ide.LangservClient? get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_completion_results_get_type ()")]
	public class LangservCompletionResults : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public LangservCompletionResults (GLib.Variant results);
		public void refilter (string typed_text);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_diagnostic_provider_get_type ()")]
	public abstract class LangservDiagnosticProvider : Ide.Object, Ide.DiagnosticProvider {
		[CCode (has_construct_function = false)]
		protected LangservDiagnosticProvider ();
		public unowned Ide.LangservClient? get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_formatter_get_type ()")]
	public class LangservFormatter : Ide.Object, Ide.Formatter {
		[CCode (has_construct_function = false)]
		protected LangservFormatter ();
		public unowned Ide.LangservClient get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_highlighter_get_type ()")]
	public class LangservHighlighter : Ide.Object, Ide.Highlighter {
		[CCode (has_construct_function = false)]
		protected LangservHighlighter ();
		public unowned Ide.LangservClient? get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_hover_provider_get_type ()")]
	public abstract class LangservHoverProvider : Ide.Object, Ide.HoverProvider {
		[CCode (has_construct_function = false)]
		protected LangservHoverProvider ();
		[Version (since = "3.30")]
		public unowned Ide.LangservClient? get_client ();
		[NoWrapper]
		public virtual void prepare ();
		[Version (since = "3.30")]
		public void set_client (Ide.LangservClient client);
		[NoAccessorMethod]
		[Version (since = "3.30")]
		public string category { owned get; set; }
		[Version (since = "3.30")]
		public Ide.LangservClient client { get; set; }
		[NoAccessorMethod]
		public int priority { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_rename_provider_get_type ()")]
	public abstract class LangservRenameProvider : Ide.Object, Ide.RenameProvider {
		[CCode (has_construct_function = false)]
		protected LangservRenameProvider ();
		public unowned Ide.LangservClient? get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_symbol_node_get_type ()")]
	public class LangservSymbolNode : Ide.SymbolNode {
		public weak GLib.Node gnode;
		[CCode (has_construct_function = false)]
		public LangservSymbolNode (GLib.File file, string name, string parent_name, int kind, uint begin_line, uint begin_column, uint end_line, uint end_column);
		public unowned string get_parent_name ();
		public bool is_parent_of (Ide.LangservSymbolNode other);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_symbol_resolver_get_type ()")]
	public abstract class LangservSymbolResolver : Ide.Object, Ide.SymbolResolver {
		[CCode (has_construct_function = false)]
		protected LangservSymbolResolver ();
		public unowned Ide.LangservClient? get_client ();
		public void set_client (Ide.LangservClient client);
		public Ide.LangservClient client { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_langserv_symbol_tree_get_type ()")]
	public class LangservSymbolTree : GLib.Object, Ide.SymbolTree {
		[CCode (has_construct_function = false)]
		public LangservSymbolTree (owned GLib.GenericArray<Ide.LangservSymbolNode> symbols);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_get_type ()")]
	public class Layout : Dazzle.DockBin, Atk.Implementor, Dazzle.Dock, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Layout ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_grid_get_type ()")]
	public class LayoutGrid : Dazzle.MultiPaned, Atk.Implementor, GLib.ListModel, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		[Version (since = "3.26")]
		public LayoutGrid ();
		public uint count_views ();
		public unowned Ide.LayoutView? focus_neighbor (Gtk.DirectionType dir);
		[Version (since = "3.26")]
		public void foreach_view (Gtk.Callback callback);
		public unowned Ide.LayoutGridColumn get_current_column ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutStack? get_current_stack ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutView get_current_view ();
		public unowned Ide.LayoutGridColumn get_nth_column (int nth);
		public void set_current_column (Ide.LayoutGridColumn? column);
		public Ide.LayoutGridColumn current_column { get; set; }
		public Ide.LayoutStack current_stack { get; }
		public Ide.LayoutView current_view { get; }
		public signal Ide.LayoutStack create_stack ();
		[Version (since = "3.28")]
		public signal Ide.LayoutView create_view (string uri);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_grid_column_get_type ()")]
	public class LayoutGridColumn : Dazzle.MultiPaned, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutGridColumn ();
		public unowned Ide.LayoutStack? get_current_stack ();
		public void set_current_stack (Ide.LayoutStack stack);
		public Ide.LayoutStack current_stack { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_pane_get_type ()")]
	public class LayoutPane : Dazzle.DockBinEdge, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected LayoutPane ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_stack_get_type ()")]
	public class LayoutStack : Gtk.Box, Atk.Implementor, GLib.ListModel, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutStack ();
		public void add_with_depth (Gtk.Widget widget, uint position);
		[Version (since = "3.26")]
		public unowned Ide.LayoutStackAddin? addin_find_by_module_name (string module_name);
		public virtual async bool agree_to_close_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.26")]
		public void foreach_view (Gtk.Callback callback);
		[Version (since = "3.26")]
		public bool get_has_view ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutStackHeader get_titlebar ();
		[Version (since = "3.26")]
		public unowned Ide.LayoutView? get_visible_child ();
		[Version (since = "3.26")]
		public void set_visible_child (Ide.LayoutView view);
		public bool has_view { get; }
		public Ide.LayoutView visible_child { get; set; }
		public signal void change_current_page (int object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_stack_header_get_type ()")]
	public class LayoutStackHeader : Dazzle.PriorityBox, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutStackHeader ();
		public void add_custom_title (Gtk.Widget widget, int priority);
		[NoAccessorMethod]
		[Version (since = "3.26")]
		public Gdk.RGBA background_rgba { set; }
		[NoAccessorMethod]
		[Version (since = "3.26")]
		public Gdk.RGBA foreground_rgba { set; }
		[NoAccessorMethod]
		public bool modified { get; set; }
		[NoAccessorMethod]
		public bool show_close_button { get; set; }
		[NoAccessorMethod]
		public string title { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_transient_sidebar_get_type ()")]
	public class LayoutTransientSidebar : Ide.LayoutPane, Atk.Implementor, Dazzle.DockItem, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected LayoutTransientSidebar ();
		public void set_panel (Gtk.Widget panel);
		[Version (since = "3.26")]
		public void set_view (Ide.LayoutView? view);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_layout_view_get_type ()")]
	public class LayoutView : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public LayoutView ();
		public virtual async bool agree_to_close_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_can_split ();
		public bool get_failed ();
		[Version (since = "3.30")]
		public unowned GLib.Icon? get_icon ();
		public unowned string get_icon_name ();
		public unowned string get_menu_id ();
		public bool get_modified ();
		[Version (since = "3.26")]
		public unowned Gdk.RGBA? get_primary_color_bg ();
		[Version (since = "3.26")]
		public unowned Gdk.RGBA? get_primary_color_fg ();
		public unowned string get_title ();
		public void set_can_split (bool can_split);
		public void set_failed (bool failed);
		public void set_icon (GLib.Icon icon);
		public void set_icon_name (string icon_name);
		public void set_menu_id (string menu_id);
		public void set_modified (bool modified);
		[Version (since = "3.26")]
		public void set_primary_color_bg (Gdk.RGBA? primary_color_bg);
		[Version (since = "3.26")]
		public void set_primary_color_fg (Gdk.RGBA? primary_color_fg);
		public void set_title (string title);
		public bool can_split { get; set; }
		public bool failed { get; set; }
		public GLib.Icon icon { get; set; }
		public string icon_name { get; set; }
		public string menu_id { get; set; }
		public bool modified { get; set; }
		[Version (since = "3.26")]
		public Gdk.RGBA primary_color_bg { get; set; }
		[Version (since = "3.26")]
		public Gdk.RGBA primary_color_fg { get; set; }
		public string title { get; set; }
		[HasEmitter]
		public virtual signal Ide.LayoutView create_split_view ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_local_device_get_type ()")]
	public class LocalDevice : Ide.Device {
		[CCode (has_construct_function = false)]
		protected LocalDevice ();
		[NoAccessorMethod]
		public Ide.Triplet triplet { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_marked_content_ref", type_id = "ide_marked_content_get_type ()", unref_function = "ide_marked_content_unref")]
	[Compact]
	public class MarkedContent {
		[CCode (has_construct_function = false)]
		public MarkedContent (GLib.Bytes content, Ide.MarkedKind kind);
		[Version (since = "3.30")]
		public string? as_string ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public MarkedContent.from_data (string data, ssize_t len, Ide.MarkedKind kind);
		public unowned GLib.Bytes get_bytes ();
		public Ide.MarkedKind get_kind ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public MarkedContent.plaintext (string? plaintext);
		[Version (since = "3.30")]
		public unowned Ide.MarkedContent @ref ();
		[Version (since = "3.30")]
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_marked_view_get_type ()")]
	public class MarkedView : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public MarkedView (Ide.MarkedContent content);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_object_get_type ()")]
	public class Object : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Object ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.18")]
		public Object.finish (GLib.AsyncResult result) throws GLib.Error;
		[Version (since = "3.18")]
		public virtual unowned Ide.Context get_context ();
		[Version (since = "3.18")]
		public bool hold ();
		public bool is_unloading ();
		[Version (since = "3.18")]
		public static void notify_in_main (GLib.Object instance, GLib.ParamSpec pspec);
		[Version (since = "3.18")]
		public void release ();
		[Version (since = "3.18")]
		public virtual void set_context (Ide.Context? context);
		public Ide.Context context { get; construct; }
		public virtual signal void destroy ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_omni_bar_get_type ()")]
	public class OmniBar : Gtk.Box, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public OmniBar ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_pausable_get_type ()")]
	public class Pausable : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pausable ();
		public bool get_paused ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public void pause ();
		public void set_paused (bool paused);
		public void set_subtitle (string subtitle);
		public void set_title (string title);
		public void unpause ();
		public bool paused { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
		public signal void unpaused ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_persistent_map_get_type ()")]
	public class PersistentMap : GLib.Object {
		[CCode (has_construct_function = false)]
		public PersistentMap ();
		public int64 builder_get_metadata_int64 (string key);
		public bool load_file (GLib.File file, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool load_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.Variant lookup_value (string key);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_persistent_map_builder_get_type ()")]
	public class PersistentMapBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		public PersistentMapBuilder ();
		public void insert (string key, GLib.Variant value, bool replace);
		public void set_metadata_int64 (string key, int64 value);
		public bool write (GLib.File destination, int io_priority, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool write_async (GLib.File destination, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_pkcon_transfer_get_type ()")]
	public class PkconTransfer : Ide.Transfer {
		[CCode (has_construct_function = false)]
		public PkconTransfer (string packages);
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] packages { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_perspective_get_type ()")]
	public class PreferencesPerspective : Dazzle.PreferencesView, Atk.Implementor, Dazzle.Preferences, Gtk.Buildable, Ide.Perspective {
		[CCode (has_construct_function = false)]
		protected PreferencesPerspective ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_preferences_window_get_type ()")]
	public class PreferencesWindow : Gtk.Window, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected PreferencesWindow ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_progress_get_type ()")]
	public class Progress : GLib.Object {
		[CCode (has_construct_function = false)]
		public Progress ();
		public static void file_progress_callback (int64 current_num_bytes, int64 total_num_bytes, void* user_data);
		public static void flatpak_progress_callback (string status, uint progress, bool estimating, void* user_data);
		public bool get_completed ();
		public double get_fraction ();
		public string get_message ();
		public void set_fraction (double fraction);
		public void set_message (string message);
		public bool completed { get; }
		public double fraction { get; set; }
		public string message { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_get_type ()")]
	public class Project : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Project ();
		[Version (since = "3.28")]
		public static string create_id (string name);
		public unowned string get_id ();
		public unowned string get_name ();
		public unowned Ide.ProjectItem get_root ();
		public void reader_lock ();
		public void reader_unlock ();
		public async bool rename_file_async (GLib.File orig_file, GLib.File new_file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool trash_file_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public void writer_lock ();
		public void writer_unlock ();
		public string id { get; }
		public string name { get; }
		public Ide.ProjectItem root { get; construct; }
		public signal void file_renamed (GLib.File object, GLib.File p0);
		public signal void file_trashed (GLib.File object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_edit_get_type ()")]
	public class ProjectEdit : GLib.Object {
		[CCode (has_construct_function = false)]
		public ProjectEdit ();
		public unowned Ide.SourceRange? get_range ();
		public unowned string get_replacement ();
		public void set_range (Ide.SourceRange range);
		public void set_replacement (string replacement);
		public Ide.SourceRange range { get; set; }
		public string replacement { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_info_get_type ()")]
	public class ProjectInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ProjectInfo ();
		public int compare (Ide.ProjectInfo info2);
		public unowned string get_build_system_name ();
		public unowned string get_description ();
		public unowned GLib.File? get_directory ();
		public unowned Ide.Doap? get_doap ();
		public unowned GLib.File? get_file ();
		public bool get_is_recent ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_languages ();
		public unowned GLib.DateTime? get_last_modified_at ();
		public unowned string get_name ();
		public int get_priority ();
		[Version (since = "3.28")]
		public unowned Ide.VcsUri? get_vcs_uri ();
		public void set_build_system_name (string build_system_name);
		public void set_description (string description);
		public void set_directory (GLib.File directory);
		public void set_doap (Ide.Doap doap);
		public void set_file (GLib.File file);
		public void set_is_recent (bool is_recent);
		public void set_languages (string languages);
		public void set_last_modified_at (GLib.DateTime modified_at);
		public void set_name (string name);
		public void set_priority (int priority);
		public void set_vcs_uri (Ide.VcsUri uri);
		public string build_system_name { get; set; }
		public string description { get; set; }
		public GLib.File directory { get; set; }
		public Ide.Doap doap { get; set; }
		public GLib.File file { get; set; }
		public bool is_recent { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] languages { get; set; }
		public GLib.DateTime last_modified_at { get; set; }
		public string name { get; set; }
		public int priority { get; set; }
		public Ide.VcsUri vcs_uri { get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_project_item_get_type ()")]
	public class ProjectItem : Ide.Object {
		[CCode (has_construct_function = false)]
		protected ProjectItem ();
		public void append (Ide.ProjectItem child);
		public unowned GLib.Sequence get_children ();
		public unowned Ide.ProjectItem? get_parent ();
		public Ide.ProjectItem @new ();
		public void remove (Ide.ProjectItem child);
		[NoAccessorMethod]
		public Ide.ProjectItem parent { owned get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_recent_projects_get_type ()")]
	public class RecentProjects : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		public RecentProjects ();
		public string find_by_directory (string directory);
		public void remove (GLib.List<Ide.ProjectInfo> project_infos);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_ref_ptr_ref", type_id = "ide_ref_ptr_get_type ()", unref_function = "ide_ref_ptr_unref")]
	[Compact]
	public class RefPtr {
		[CCode (has_construct_function = false)]
		public RefPtr (void* data, GLib.DestroyNotify free_func);
		public void* @get ();
		public unowned Ide.RefPtr @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_run_manager_get_type ()")]
	public class RunManager : Ide.Object, GLib.ActionGroup, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected RunManager ();
		public void add_handler (string id, string title, string icon_name, string accel, owned Ide.RunHandler run_handler);
		public void cancel ();
		public async Ide.BuildTarget discover_default_target_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Ide.BuildTarget get_build_target ();
		public bool get_busy ();
		public unowned string get_handler ();
		public void remove_handler (string id);
		public async bool run_async (Ide.BuildTarget build_target, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_build_target (Ide.BuildTarget build_target);
		public void set_handler (string id);
		public Ide.BuildTarget build_target { get; set; }
		public bool busy { get; }
		public string handler { get; }
		public signal void run (Ide.Runner runner);
		public signal void stopped ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_runner_get_type ()")]
	public class Runner : Ide.Object {
		[CCode (has_construct_function = false)]
		public Runner (Ide.Context context);
		public void append_argv (string param);
		[NoWrapper]
		public virtual void fixup_launcher (Ide.SubprocessLauncher launcher);
		public virtual void force_quit ();
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_argv ();
		[Version (since = "3.28")]
		public unowned Ide.BuildTarget? get_build_target ();
		public bool get_clear_env ();
		[Version (since = "3.28")]
		public unowned string? get_cwd ();
		public unowned Ide.Environment get_environment ();
		public bool get_failed ();
		public GLib.SubprocessFlags get_flags ();
		public bool get_run_on_host ();
		public virtual Ide.Runtime? get_runtime ();
		public virtual GLib.InputStream? get_stderr ();
		public virtual GLib.OutputStream? get_stdin ();
		public virtual GLib.InputStream? get_stdout ();
		public void prepend_argv (string param);
		[Version (since = "3.28")]
		public void push_args ([CCode (array_length = false, array_null_terminated = true)] string[]? args);
		public virtual async bool run_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_argv (string argv);
		[Version (since = "3.28")]
		public void set_build_target (Ide.BuildTarget? build_target);
		public void set_clear_env (bool clear_env);
		[Version (since = "3.28")]
		public void set_cwd (string? cwd);
		public void set_failed (bool failed);
		public void set_flags (GLib.SubprocessFlags flags);
		public void set_run_on_host (bool run_on_host);
		public virtual void set_tty (int tty_fd);
		public int steal_tty ();
		public int take_fd (int source_fd, int dest_fd);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] argv { owned get; set; }
		[Version (since = "3.28")]
		public Ide.BuildTarget build_target { get; set; }
		public bool clear_env { get; set; }
		public string cwd { get; set; }
		public Ide.Environment environment { get; }
		public bool failed { get; set; }
		public bool run_on_host { get; set; }
		public signal void exited ();
		public signal void spawned (string object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_runtime_get_type ()")]
	public class Runtime : Ide.Object {
		[CCode (has_construct_function = false)]
		public Runtime (Ide.Context context, string id, string title);
		public virtual bool contains_program_in_path (string program, GLib.Cancellable? cancellable = null);
		public virtual Ide.SubprocessLauncher create_launcher () throws GLib.Error;
		public virtual Ide.Runner? create_runner (Ide.BuildTarget? build_target);
		[Version (since = "3.28")]
		public string get_arch ();
		public unowned string get_display_name ();
		public unowned string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.28")]
		public virtual string[] get_system_include_dirs ();
		[Version (since = "3.30")]
		public virtual Ide.Triplet get_triplet ();
		public virtual void prepare_configuration (Ide.Configuration configuration);
		public void set_display_name (string display_name);
		public void set_id (string id);
		[Version (since = "3.30")]
		public virtual bool supports_toolchain (Ide.Toolchain toolchain);
		public virtual GLib.File translate_file (GLib.File file);
		public string display_name { get; set construct; }
		public string id { get; set construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_runtime_manager_get_type ()")]
	public class RuntimeManager : Ide.Object, GLib.Initable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected RuntimeManager ();
		public void add (Ide.Runtime runtime);
		public unowned Ide.Runtime get_runtime (string id);
		public void remove (Ide.Runtime runtime);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_engine_get_type ()")]
	public class SearchEngine : Ide.Object {
		[CCode (has_construct_function = false)]
		public SearchEngine ();
		public bool get_busy ();
		public async GLib.ListModel search_async (string query, uint max_results, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool busy { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_entry_get_type ()")]
	public class SearchEntry : Dazzle.SuggestionEntry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public SearchEntry ();
		[NoAccessorMethod]
		public uint max_results { get; set; }
		public signal void unfocus ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_search_result_get_type ()")]
	public class SearchResult : Dazzle.Suggestion {
		[CCode (has_construct_function = false)]
		public SearchResult ();
		public static int compare (void* a, void* b);
		public int get_priority ();
		public float get_score ();
		public virtual Ide.SourceLocation? get_source_location ();
		public void set_icon (GLib.Icon icon);
		public void set_priority (int priority);
		public void set_score (float score);
		public int priority { get; set; }
		public float score { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_session_get_type ()")]
	public class Session : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Session ();
		[Version (since = "3.30")]
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_settings_get_type ()")]
	public class Settings : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Settings ();
		public void bind (string key, void* object, string property, GLib.SettingsBindFlags flags);
		public void bind_with_mapping (string key, void* object, string property, GLib.SettingsBindFlags flags, GLib.SettingsBindGetMapping? get_mapping, owned GLib.SettingsBindSetMapping? set_mapping);
		public bool get_boolean (string key);
		public GLib.Variant get_default_value (string key);
		public double get_double (string key);
		public bool get_ignore_project_settings ();
		public int get_int (string key);
		public unowned string get_relative_path ();
		public unowned string get_schema_id ();
		public string get_string (string key);
		public uint get_uint (string key);
		public GLib.Variant get_user_value (string key);
		public GLib.Variant get_value (string key);
		public void set_boolean (string key, bool val);
		public void set_double (string key, double val);
		public void set_int (string key, int val);
		public void set_string (string key, string val);
		public void set_uint (string key, uint val);
		public void set_value (string key, GLib.Variant value);
		public void unbind (string property);
		public bool ignore_project_settings { get; construct; }
		public string relative_path { get; construct; }
		public string schema_id { get; construct; }
		public signal void changed (string object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_simple_build_target_get_type ()")]
	public class SimpleBuildTarget : Ide.Object, Ide.BuildTarget {
		[CCode (has_construct_function = false)]
		public SimpleBuildTarget (Ide.Context context);
		public void set_argv (string argv);
		public void set_cwd (string cwd);
		public void set_install_directory (GLib.File install_directory);
		public void set_language (string language);
		public void set_name (string name);
		public void set_priority (int priority);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_simple_toolchain_get_type ()")]
	public class SimpleToolchain : Ide.Toolchain {
		[CCode (has_construct_function = false)]
		public SimpleToolchain (Ide.Context context, string id, string display_name);
		[Version (since = "3.30")]
		public void set_tool_for_language (string language, string tool_id, string tool_path);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_snippet_get_type ()")]
	public class Snippet : GLib.Object {
		[CCode (has_construct_function = false)]
		public Snippet (string? trigger, string? language);
		public void add_chunk (Ide.SnippetChunk chunk);
		public Ide.Snippet copy ();
		public void get_chunk_range (Ide.SnippetChunk chunk, Gtk.TextIter begin, Gtk.TextIter end);
		public unowned Ide.SnippetContext? get_context ();
		public unowned string get_description ();
		public unowned string get_language ();
		public uint get_n_chunks ();
		public unowned Ide.SnippetChunk get_nth_chunk (uint n);
		public int get_tab_stop ();
		public unowned string? get_trigger ();
		public void set_description (string description);
		public void set_language (string language);
		public void set_trigger (string trigger);
		[NoAccessorMethod]
		public Gtk.TextBuffer buffer { owned get; }
		public string description { get; set; }
		public string language { get; set; }
		[NoAccessorMethod]
		public Gtk.TextMark mark_begin { owned get; }
		[NoAccessorMethod]
		public Gtk.TextMark mark_end { owned get; }
		public int tab_stop { get; }
		public string trigger { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_snippet_chunk_get_type ()")]
	public class SnippetChunk : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetChunk ();
		public Ide.SnippetChunk copy ();
		public unowned Ide.SnippetContext get_context ();
		public unowned string get_spec ();
		public int get_tab_stop ();
		public unowned string get_text ();
		public bool get_text_set ();
		public void set_context (Ide.SnippetContext context);
		public void set_spec (string spec);
		public void set_tab_stop (int tab_stop);
		public void set_text (string text);
		public void set_text_set (bool text_set);
		public Ide.SnippetContext context { get; set; }
		public string spec { get; set; }
		public int tab_stop { get; set; }
		public string text { get; set; }
		public bool text_set { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_snippet_context_get_type ()")]
	public class SnippetContext : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetContext ();
		public void add_shared_variable (string key, string value);
		public void add_variable (string key, string value);
		public void clear_variables ();
		public void dump ();
		public void emit_changed ();
		public string expand (string input);
		public unowned string get_variable (string key);
		public void set_line_prefix (string line_prefix);
		public void set_tab_width (int tab_size);
		public void set_use_spaces (bool use_spaces);
		public signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_snippet_parser_get_type ()")]
	public class SnippetParser : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetParser ();
		public unowned GLib.List<Ide.Snippet> get_snippets ();
		public bool load_from_data (string defalut_language, string data, ssize_t data_len) throws GLib.Error;
		public bool load_from_file (GLib.File file) throws GLib.Error;
		public signal void parsing_error (GLib.File object, uint p0, string p1);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_snippet_storage_get_type ()")]
	public class SnippetStorage : GLib.Object {
		[CCode (has_construct_function = false)]
		public SnippetStorage ();
		public void add (string default_scope, GLib.Bytes bytes);
		[Version (since = "3.30")]
		public void @foreach (Ide.SnippetStorageForeach @foreach);
		public async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public void query (string lang, string? prefix, Ide.SnippetStorageForeach @foreach);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_location_ref", type_id = "ide_source_location_get_type ()", unref_function = "ide_source_location_unref")]
	[Compact]
	public class SourceLocation {
		[CCode (has_construct_function = false)]
		public SourceLocation (Ide.File file, uint line, uint line_offset, uint offset);
		public int compare (Ide.SourceLocation b);
		[CCode (has_construct_function = false)]
		public SourceLocation.for_path (Ide.Context context, string path, uint line, uint line_offset);
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public SourceLocation.from_variant (GLib.Variant? variant);
		public unowned Ide.File get_file ();
		public uint get_line ();
		public uint get_line_offset ();
		public uint get_offset ();
		public unowned string? get_path ();
		public Ide.Uri get_uri ();
		public uint hash ();
		public unowned Ide.SourceLocation @ref ();
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_map_get_type ()")]
	public class SourceMap : Gtk.SourceMap, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceMap ();
		[Version (since = "3.18")]
		public signal void hide_map ();
		[Version (since = "3.18")]
		public signal void show_map ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_source_range_ref", type_id = "ide_source_range_get_type ()", unref_function = "ide_source_range_unref")]
	[Compact]
	public class SourceRange {
		[CCode (has_construct_function = false)]
		public SourceRange (Ide.SourceLocation begin, Ide.SourceLocation end);
		[CCode (has_construct_function = false)]
		public SourceRange.from_variant (GLib.Variant variant);
		public unowned Ide.SourceLocation get_begin ();
		public unowned Ide.SourceLocation get_end ();
		public unowned Ide.SourceRange @ref ();
		[Version (since = "3.30")]
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_source_view_get_type ()")]
	public class SourceView : Gtk.SourceView, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false)]
		protected SourceView ();
		[NoWrapper]
		public virtual void auto_indent ();
		[Version (since = "3.30")]
		public unowned Ide.Completion get_completion ();
		public int get_count ();
		public unowned Ide.Snippet? get_current_snippet ();
		public unowned Ide.FileSettings? get_file_settings ();
		public unowned Pango.FontDescription get_font_desc ();
		public bool get_highlight_current_line ();
		public bool get_insert_matching_brace ();
		public void get_iter_at_visual_column (uint column, Gtk.TextIter location);
		public unowned string get_mode_display_name ();
		public unowned string get_mode_name ();
		public bool get_overwrite ();
		public bool get_overwrite_braces ();
		public Pango.FontDescription get_scaled_font_desc ();
		public uint get_scroll_offset ();
		public bool get_show_grid_lines ();
		public bool get_show_line_changes ();
		public bool get_show_line_diagnostics ();
		public bool get_show_line_numbers ();
		public bool get_snippet_completion ();
		public bool get_spell_checking ();
		public Gdk.Rectangle get_visible_rect ();
		public uint get_visual_column (Gtk.TextIter location);
		public void get_visual_position (uint line, uint line_column);
		[Version (since = "3.30")]
		public bool has_snippet ();
		[NoWrapper]
		public virtual void insert_at_cursor_and_indent (string str);
		public bool is_processing_key ();
		public bool move_mark_onscreen (Gtk.TextMark mark);
		public bool place_cursor_onscreen ();
		public void rollback_search ();
		public void save_search (string search_text);
		public void scroll_mark_onscreen (Gtk.TextMark mark, Ide.SourceScrollAlign use_align, double alignx, double aligny);
		public void scroll_to_insert ();
		public void scroll_to_iter (Gtk.TextIter iter, double within_margin, Ide.SourceScrollAlign use_align, double xalign, double yalign, bool animate_scroll);
		public void scroll_to_mark (Gtk.TextMark mark, double within_margin, Ide.SourceScrollAlign use_align, double xalign, double yalign, bool animate_scroll);
		public void set_count (int count);
		public void set_font_desc (Pango.FontDescription font_desc);
		public void set_font_name (string font_name);
		public void set_highlight_current_line (bool highlight_current_line);
		public void set_insert_matching_brace (bool insert_matching_brace);
		public void set_misspelled_word (Gtk.TextIter start, Gtk.TextIter end);
		public void set_overwrite_braces (bool overwrite_braces);
		public void set_scroll_offset (uint scroll_offset);
		public void set_show_grid_lines (bool show_grid_lines);
		public void set_show_line_changes (bool show_line_changes);
		public void set_show_line_diagnostics (bool show_line_diagnostics);
		public void set_show_line_numbers (bool show_line_numbers);
		public void set_snippet_completion (bool snippet_completion);
		public void set_spell_checking (bool enable);
		[NoAccessorMethod]
		public uint completion_n_rows { get; set; }
		public int count { get; set; }
		public Ide.FileSettings file_settings { get; }
		public Pango.FontDescription font_desc { get; set; }
		public string font_name { set construct; }
		[NoAccessorMethod]
		public Ide.IndentStyle indent_style { set; }
		[NoAccessorMethod]
		public Ide.Indenter indenter { owned get; }
		public bool insert_matching_brace { get; set; }
		[NoAccessorMethod]
		public bool interactive_completion { get; set; }
		public string mode_display_name { get; }
		[NoAccessorMethod]
		public int overscroll { get; set; }
		public bool overwrite_braces { get; set; }
		public uint scroll_offset { get; set; }
		public bool show_grid_lines { get; set; }
		public bool show_line_changes { get; set; }
		public bool show_line_diagnostics { get; set; }
		public signal void action (string object, string p0, string p1);
		public virtual signal void add_cursor (Ide.CursorType type);
		public virtual signal void append_to_count (int digit);
		public virtual signal void begin_macro ();
		public virtual signal void begin_rename ();
		public signal void begin_user_action ();
		public virtual signal void capture_modifier ();
		public virtual signal void clear_count ();
		public virtual signal void clear_modifier ();
		[HasEmitter]
		public virtual signal void clear_search ();
		public virtual signal void clear_selection ();
		[HasEmitter]
		public virtual signal void clear_snippets ();
		public virtual signal void copy_clipboard_extended ();
		public virtual signal void cycle_completion (Gtk.DirectionType direction);
		public virtual signal void decrease_font_size ();
		public virtual signal void delete_selection ();
		public signal void draw_bubbles (Cairo.Context object);
		public signal void duplicate_entire_line ();
		public virtual signal void end_macro ();
		public signal void end_user_action ();
		public signal void find_references ();
		public virtual signal void focus_location (Ide.SourceLocation location);
		public signal void format_selection ();
		public virtual signal void goto_definition ();
		public virtual signal void hide_completion ();
		public virtual signal void increase_font_size ();
		public virtual signal void indent_selection (int level);
		public virtual signal void insert_modifier (bool use_count);
		[HasEmitter]
		public virtual signal void jump (Gtk.TextIter from, Gtk.TextIter to);
		public virtual signal void move_error (Gtk.DirectionType dir);
		public virtual signal void move_search (Gtk.DirectionType dir, bool extend_selection, bool select_match, bool exclusive, bool apply_count, int at_word_boundaries);
		public virtual signal void movement (Ide.SourceViewMovement movement, bool extend_selection, bool exclusive, bool apply_count);
		public virtual signal void paste_clipboard_extended (bool smart_lines, bool after_cursor, bool place_cursor_at_original);
		public virtual signal void pop_selection ();
		[HasEmitter]
		public signal void pop_snippet ();
		public virtual signal void push_selection ();
		[HasEmitter]
		public signal void push_snippet (Ide.Snippet snippet, Gtk.TextIter? location);
		public virtual signal void rebuild_highlight ();
		public signal void reindent ();
		public virtual signal void remove_cursors ();
		public virtual signal void replay_macro (bool use_count);
		public virtual signal void request_documentation ();
		[Version (since = "3.26")]
		public signal void reset ();
		public virtual signal void reset_font_size ();
		public virtual signal void restore_insert_mark ();
		public virtual signal void save_command ();
		public virtual signal void save_insert_mark ();
		public virtual signal void save_search_char ();
		public virtual signal void select_inner (string inner_left, string inner_right, bool exclusive, bool string_mode);
		public virtual signal void select_tag (bool exclusive);
		public virtual signal void selection_theatric (Ide.SourceViewTheatric theatric);
		public virtual signal void set_mode (string mode, Ide.SourceViewModeType type);
		public virtual signal void set_overwrite (bool overwrite);
		public virtual signal void set_search_text (string search_text, bool from_selection);
		public virtual signal void sort (bool ignore_case, bool reverse);
		public virtual signal void swap_selection_bounds ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_subprocess_launcher_get_type ()")]
	public class SubprocessLauncher : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubprocessLauncher (GLib.SubprocessFlags flags);
		public void append_path (string append_path);
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_argv ();
		public bool get_clear_env ();
		public unowned string get_cwd ();
		[CCode (array_length = false, array_null_terminated = true)]
		public unowned string[] get_environ ();
		public GLib.SubprocessFlags get_flags ();
		public bool get_run_on_host ();
		public unowned string getenv (string key);
		public void insert_argv (uint index, string arg);
		public void overlay_environment (Ide.Environment environment);
		public string pop_argv ();
		public void push_args ([CCode (array_length = false, array_null_terminated = true)] string[]? args);
		public void push_argv (string argv);
		public void replace_argv (uint index, string arg);
		public void set_argv (string argv);
		public void set_clear_env (bool clear_env);
		public void set_cwd (string cwd);
		public void set_environ ([CCode (array_length = false, array_null_terminated = true)] string[]? environ_);
		public void set_flags (GLib.SubprocessFlags flags);
		public void set_run_on_host (bool run_on_host);
		public void set_stdout_file_path (string stdout_file_path);
		public void setenv (string key, string value, bool replace);
		public virtual Ide.Subprocess spawn (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public void take_fd (int source_fd, int dest_fd);
		public void take_stderr_fd (int stderr_fd);
		public void take_stdin_fd (int stdin_fd);
		public void take_stdout_fd (int stdout_fd);
		[NoAccessorMethod]
		public bool clean_env { get; set; }
		public string cwd { get; set; }
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] environ { get; set; }
		public GLib.SubprocessFlags flags { get; set construct; }
		public bool run_on_host { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_subprocess_supervisor_get_type ()")]
	public class SubprocessSupervisor : GLib.Object {
		[CCode (has_construct_function = false)]
		public SubprocessSupervisor ();
		public unowned Ide.SubprocessLauncher? get_launcher ();
		public unowned Ide.Subprocess? get_subprocess ();
		public void set_launcher (Ide.SubprocessLauncher launcher);
		public void set_subprocess (Ide.Subprocess subprocess);
		public void start ();
		public void stop ();
		public signal void exited (Ide.Subprocess object);
		public virtual signal void spawned (Ide.Subprocess subprocess);
		public signal bool supervise (Ide.SubprocessLauncher object);
		public signal bool unsupervise (Ide.SubprocessLauncher object);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_symbol_ref", type_id = "ide_symbol_get_type ()", unref_function = "ide_symbol_unref")]
	[Compact]
	public class Symbol {
		[CCode (has_construct_function = false)]
		public Symbol (string name, Ide.SymbolKind kind, Ide.SymbolFlags flags, Ide.SourceLocation? declaration_location, Ide.SourceLocation? definition_location, Ide.SourceLocation? canonical_location);
		[CCode (has_construct_function = false)]
		public Symbol.from_variant (GLib.Variant variant);
		public unowned Ide.SourceLocation? get_canonical_location ();
		public unowned Ide.SourceLocation? get_declaration_location ();
		public unowned Ide.SourceLocation? get_definition_location ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public unowned string get_name ();
		public unowned Ide.Symbol @ref ();
		public GLib.Variant to_variant ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_symbol_node_get_type ()")]
	public class SymbolNode : Ide.Object {
		[CCode (has_construct_function = false)]
		protected SymbolNode ();
		public Ide.SymbolFlags get_flags ();
		public Ide.SymbolKind get_kind ();
		public virtual async Ide.SourceLocation? get_location_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string get_name ();
		public bool get_use_markup ();
		[NoAccessorMethod]
		public Ide.SymbolFlags flags { get; set; }
		[NoAccessorMethod]
		public Ide.SymbolKind kind { get; set; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public bool use_markup { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_tagged_entry_get_type ()")]
	public class TaggedEntry : Gtk.SearchEntry, Atk.Implementor, Gtk.Buildable, Gtk.CellEditable, Gtk.Editable {
		[CCode (has_construct_function = false)]
		public TaggedEntry ();
		public bool add_tag (Ide.TaggedEntryTag tag);
		public bool get_tag_button_visible ();
		public bool insert_tag (Ide.TaggedEntryTag tag, int position);
		public bool remove_tag (Ide.TaggedEntryTag tag);
		public void set_tag_button_visible (bool visible);
		[NoAccessorMethod]
		public bool tag_close_visible { set; }
		public signal void tag_button_clicked (Ide.TaggedEntryTag object);
		public signal void tag_clicked (Ide.TaggedEntryTag object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_tagged_entry_tag_get_type ()")]
	public class TaggedEntryTag : GLib.Object {
		[CCode (has_construct_function = false)]
		public TaggedEntryTag (string label);
		public bool get_area (Cairo.RectangleInt rect);
		public bool get_has_close_button ();
		public unowned string get_label ();
		public unowned string get_style ();
		public void set_has_close_button (bool has_close_button);
		public void set_label (string label);
		public void set_style (string style);
		public bool has_close_button { get; set construct; }
		public string label { get; set construct; }
		public string style { get; set construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_task_get_type ()")]
	public class Task : GLib.Object, GLib.AsyncResult {
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Task (GLib.Object? source_object, GLib.Cancellable? cancellable, [CCode (scope = "async", type = "GAsyncReadyCallback")] GLib.TaskReadyCallback callback);
		[Version (since = "3.30")]
		public void chain (Ide.Task other_task);
		[Version (since = "3.30")]
		public unowned GLib.Cancellable? get_cancellable ();
		public int get_complete_priority ();
		[Version (since = "3.30")]
		public bool get_completed ();
		public Ide.TaskKind get_kind ();
		[Version (since = "3.30")]
		public unowned string? get_name ();
		public int get_priority ();
		public bool get_return_on_cancel ();
		public void* get_source_tag ();
		[Version (since = "3.30")]
		public bool had_error ();
		[Version (since = "3.30")]
		public bool is_valid (void* source_object);
		public bool propagate_boolean () throws GLib.Error;
		public void* propagate_boxed () throws GLib.Error;
		public ssize_t propagate_int () throws GLib.Error;
		[Version (since = "3.30")]
		public GLib.Object propagate_object () throws GLib.Error;
		public void* propagate_pointer () throws GLib.Error;
		[Version (since = "3.30")]
		public void return_boolean (bool result);
		[Version (since = "3.30")]
		public void return_error (owned GLib.Error error);
		[Version (since = "3.30")]
		public bool return_error_if_cancelled ();
		[Version (since = "3.30")]
		public void return_int (ssize_t result);
		[Version (since = "3.30")]
		public void return_object (owned GLib.Object instance);
		[Version (since = "3.30")]
		public void set_check_cancellable (bool check_cancellable);
		public void set_complete_priority (int complete_priority);
		public void set_kind (Ide.TaskKind kind);
		[Version (since = "3.30")]
		public void set_name (string name);
		public void set_priority (int priority);
		[Version (since = "3.30")]
		public void set_release_on_propagate (bool release_on_propagate);
		[Version (since = "3.30")]
		public void set_return_on_cancel (bool return_on_cancel);
		[Version (since = "3.30")]
		public void set_source_tag (void* source_tag);
		public void set_task_data (void* task_data, GLib.DestroyNotify task_data_destroy);
		public bool completed { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_template_base_get_type ()")]
	public abstract class TemplateBase : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TemplateBase ();
		public void add_path (string path, GLib.File destination, Template.Scope scope, int mode);
		public void add_resource (string resource_path, GLib.File destination, Template.Scope scope, int mode);
		public async bool expand_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned Template.TemplateLocator? get_locator ();
		public void reset ();
		public void set_locator (Template.TemplateLocator locator);
		public Template.TemplateLocator locator { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_terminal_get_type ()")]
	public class Terminal : Vte.Terminal, Atk.Implementor, Gtk.Buildable, Gtk.Scrollable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public Terminal ();
		public virtual signal bool copy_link_address ();
		public virtual signal bool open_link ();
		public virtual signal void populate_popup (Gtk.Widget widget);
		public virtual signal void search_reveal ();
		public virtual signal void select_all (bool all);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_terminal_search_get_type ()")]
	public class TerminalSearch : Gtk.Bin, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected TerminalSearch ();
		[Version (since = "3.28")]
		public unowned Vte.Regex? get_regex ();
		[Version (since = "3.28")]
		public unowned Gtk.Revealer get_revealer ();
		[Version (since = "3.28")]
		public bool get_wrap_around ();
		[Version (since = "3.28")]
		public void set_terminal (Vte.Terminal terminal);
		public Vte.Regex regex { get; }
		public bool wrap_around { get; }
		public signal void search (bool object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_test_get_type ()")]
	public class Test : GLib.Object {
		[CCode (has_construct_function = false)]
		public Test ();
		[Version (since = "3.28")]
		public unowned string? get_display_name ();
		[Version (since = "3.28")]
		public unowned string? get_group ();
		public unowned string get_icon_name ();
		[Version (since = "3.28")]
		public unowned string? get_id ();
		public Ide.TestStatus get_status ();
		[Version (since = "3.28")]
		public void set_display_name (string? display_name);
		[Version (since = "3.28")]
		public void set_group (string? group);
		[Version (since = "3.28")]
		public void set_id (string? id);
		public void set_status (Ide.TestStatus status);
		public string display_name { get; set; }
		[Version (since = "3.28")]
		public string group { get; set; }
		[Version (since = "3.28")]
		public string id { get; set; }
		public Ide.TestStatus status { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_test_manager_get_type ()")]
	public class TestManager : Ide.Object, GLib.ActionGroup, GLib.Initable {
		[CCode (has_construct_function = false)]
		protected TestManager ();
		public bool get_loading ();
		[Version (since = "3.28")]
		public async bool run_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public async bool run_async (Ide.Test test, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public bool loading { get; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_test_provider_get_type ()")]
	public abstract class TestProvider : Ide.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected TestProvider ();
		public void add (Ide.Test test);
		public void clear ();
		public bool get_loading ();
		[Version (since = "3.28")]
		public virtual void reload ();
		public void remove (Ide.Test test);
		public virtual async bool run_async (Ide.Test test, Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_loading (bool loading);
		public bool loading { get; set; }
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	[Compact]
	public class ThreadPool {
		public static void push (Ide.ThreadPoolKind kind, [CCode (scope = "async")] Ide.ThreadFunc func);
		public static void push_task (Ide.ThreadPoolKind kind, GLib.Task task, [CCode (scope = "async")] GLib.TaskThreadFunc func);
		public static void push_with_priority (Ide.ThreadPoolKind kind, int priority, [CCode (scope = "async")] Ide.ThreadFunc func);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_toolchain_get_type ()")]
	public abstract class Toolchain : Ide.Object {
		[CCode (has_construct_function = false)]
		protected Toolchain ();
		public unowned string get_display_name ();
		[Version (since = "3.30")]
		public Ide.Triplet get_host_triplet ();
		[Version (since = "3.30")]
		public unowned string get_id ();
		[Version (since = "3.30")]
		public virtual unowned string get_tool_for_language (string language, string tool_id);
		[Version (since = "3.30")]
		public virtual GLib.HashTable<string,string> get_tools_for_id (string tool_id);
		public void set_display_name (string display_name);
		[Version (since = "3.30")]
		public void set_host_triplet (Ide.Triplet host_triplet);
		[Version (since = "3.30")]
		public void set_id (string id);
		public string display_name { get; set; }
		public Ide.Triplet host_triplet { owned get; set; }
		public string id { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_toolchain_manager_get_type ()")]
	public class ToolchainManager : Ide.Object, GLib.AsyncInitable, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected ToolchainManager ();
		[Version (since = "3.30")]
		public Ide.Toolchain get_toolchain (string id);
		[Version (since = "3.30")]
		public bool is_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfer_get_type ()")]
	public class Transfer : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Transfer ();
		public void cancel ();
		public static GLib.Quark error_quark ();
		public virtual async bool execute_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_active ();
		public bool get_completed ();
		public unowned string get_icon_name ();
		public double get_progress ();
		public unowned string get_status ();
		public unowned string get_title ();
		public void set_icon_name (string icon_name);
		public void set_progress (double progress);
		public void set_status (string status);
		public void set_title (string title);
		public bool active { get; }
		public bool completed { get; }
		public string icon_name { get; set; }
		public double progress { get; set; }
		public string status { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfer_button_get_type ()")]
	public class TransferButton : Dazzle.ProgressButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TransferButton (Ide.Transfer transfer);
		[NoAccessorMethod]
		public Ide.Transfer transfer { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfer_manager_get_type ()")]
	public class TransferManager : GLib.Object, GLib.ListModel {
		[CCode (has_construct_function = false)]
		protected TransferManager ();
		public void cancel_all ();
		public void clear ();
		public async bool execute_async (Ide.Transfer transfer, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool get_has_active ();
		public double get_progress ();
		public bool has_active { get; }
		public double progress { get; }
		public signal void all_transfers_completed ();
		public signal void transfer_completed (Ide.Transfer transfer);
		public signal void transfer_failed (Ide.Transfer transfer, GLib.Error reason);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfer_row_get_type ()")]
	public class TransferRow : Gtk.ListBoxRow, Atk.Implementor, Gtk.Actionable, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected TransferRow ();
		public unowned Ide.Transfer? get_transfer ();
		public void set_transfer (Ide.Transfer transfer);
		public Ide.Transfer transfer { get; set; }
		public signal void cancelled ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfers_button_get_type ()")]
	public class TransfersButton : Dazzle.ProgressMenuButton, Atk.Implementor, Gtk.Actionable, Gtk.Activatable, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TransfersButton ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_transfers_progress_icon_get_type ()")]
	public class TransfersProgressIcon : Gtk.DrawingArea, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public TransfersProgressIcon ();
		public double get_progress ();
		public void set_progress (double progress);
		public double progress { get; set; }
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_triplet_ref", type_id = "ide_triplet_get_type ()", unref_function = "ide_triplet_unref")]
	[Compact]
	public class Triplet {
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Triplet (string full_name);
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Triplet.from_system ();
		public unowned string get_arch ();
		[Version (since = "3.30")]
		public unowned string get_full_name ();
		[Version (since = "3.30")]
		public unowned string? get_kernel ();
		[Version (since = "3.30")]
		public unowned string? get_operating_system ();
		[Version (since = "3.30")]
		public unowned string? get_vendor ();
		[Version (since = "3.30")]
		public bool is_system ();
		[Version (since = "3.30")]
		public unowned Ide.Triplet @ref ();
		[Version (since = "3.30")]
		public void unref ();
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Triplet.with_quadruplet (string arch, string? vendor, string? kernel, string? operating_system);
		[CCode (has_construct_function = false)]
		[Version (since = "3.30")]
		public Triplet.with_triplet (string arch, string? kernel, string? operating_system);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_unsaved_file_ref", type_id = "ide_unsaved_file_get_type ()", unref_function = "ide_unsaved_file_unref")]
	[Compact]
	public class UnsavedFile {
		public unowned GLib.Bytes get_content ();
		public unowned GLib.File get_file ();
		public int64 get_sequence ();
		public unowned string get_temp_path ();
		public bool persist (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public unowned Ide.UnsavedFile @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_unsaved_files_get_type ()")]
	public class UnsavedFiles : Ide.Object {
		[CCode (has_construct_function = false)]
		protected UnsavedFiles ();
		public void clear ();
		public bool contains (GLib.File file);
		public int64 get_sequence ();
		public Ide.UnsavedFile? get_unsaved_file (GLib.File file);
		public async bool reap_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void remove (GLib.File file);
		public async bool restore_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.GenericArray<Ide.UnsavedFile> to_array ();
		public void update (GLib.File file, GLib.Bytes content);
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_uri_ref", type_id = "ide_uri_get_type ()", unref_function = "ide_uri_unref")]
	[Compact]
	public class Uri {
		[CCode (has_construct_function = false)]
		public Uri (string uri_string, Ide.UriParseFlags flags) throws GLib.Error;
		public static string build (string scheme, string userinfo, string host, string port, string path, string query, string fragment);
		public Ide.Uri copy ();
		[CCode (has_construct_function = false)]
		public Uri.from_file (GLib.File file);
		public unowned string get_auth_params ();
		public unowned string get_fragment ();
		public unowned string get_host ();
		public unowned string get_password ();
		public unowned string get_path ();
		public ushort get_port ();
		public unowned string get_query ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public bool is_file (GLib.File file);
		public Ide.Uri new_relative (string uri_string, Ide.UriParseFlags flags) throws GLib.Error;
		public static bool parse_host (string uri_string, Ide.UriParseFlags flags, out string scheme, out string host, out ushort port) throws GLib.Error;
		public static GLib.HashTable<weak string,weak string> parse_params (string @params, ssize_t length, char separator, bool case_insensitive);
		public unowned Ide.Uri @ref ();
		public void set_auth_params (string auth_params);
		public void set_fragment (string fragment);
		public void set_host (string host);
		public void set_password (string password);
		public void set_path (string path);
		public void set_port (ushort port);
		public void set_query (string query);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public static void split (string uri_string, bool strict, out string? scheme, out string? userinfo, out string? host, out string? port, out string? path, out string? query, out string? fragment);
		public GLib.File? to_file ();
		public string to_string (Ide.UriToStringFlags flags);
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_vcs_file_info_get_type ()")]
	public class VcsFileInfo : GLib.Object {
		[CCode (has_construct_function = false)]
		public VcsFileInfo (GLib.File file);
		[Version (since = "3.28")]
		public unowned GLib.File get_file ();
		public Ide.VcsFileStatus get_status ();
		public void set_status (Ide.VcsFileStatus status);
		public GLib.File file { get; construct; }
		public Ide.VcsFileStatus status { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_vcs_monitor_get_type ()")]
	public class VcsMonitor : Ide.Object {
		[CCode (has_construct_function = false)]
		protected VcsMonitor ();
		[Version (since = "3.28")]
		public Ide.VcsFileInfo? get_info (GLib.File file);
		[NoAccessorMethod]
		public GLib.File root { owned get; construct; }
		public signal void changed (GLib.File object, GLib.File p0, GLib.FileMonitorEvent p1);
		public signal void reloaded ();
	}
	[CCode (cheader_filename = "ide.h", ref_function = "ide_vcs_uri_ref", type_id = "ide_vcs_uri_get_type ()", unref_function = "ide_vcs_uri_unref")]
	[Compact]
	public class VcsUri {
		[CCode (has_construct_function = false)]
		public VcsUri (string uri);
		public unowned string get_host ();
		public unowned string get_path ();
		public uint get_port ();
		public unowned string get_scheme ();
		public unowned string get_user ();
		public static bool is_valid (string uri_string);
		public unowned Ide.VcsUri @ref ();
		public void set_host (string host);
		public void set_path (string path);
		public void set_port (uint port);
		public void set_scheme (string scheme);
		public void set_user (string user);
		public string to_string ();
		public void unref ();
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_workbench_get_type ()")]
	public class Workbench : Dazzle.ApplicationWindow, Atk.Implementor, GLib.ActionGroup, GLib.ActionMap, Gtk.Buildable {
		[CCode (has_construct_function = false)]
		protected Workbench ();
		public void add_perspective (Ide.Perspective perspective);
		[Version (since = "3.26")]
		public unowned Ide.WorkbenchAddin? addin_find_by_module_name (string addin_name);
		public void close ();
		public void focus (Gtk.Widget widget);
		public unowned Ide.Context? get_context ();
		public bool get_focus_mode ();
		public unowned Ide.WorkbenchHeaderBar get_headerbar ();
		public unowned Ide.Perspective? get_perspective_by_name (string name);
		public unowned Ide.Perspective get_visible_perspective ();
		public unowned string get_visible_perspective_name ();
		public async bool open_files_async ([CCode (array_length_cname = "n_files", array_length_pos = 1.5, array_length_type = "guint")] GLib.File[] files, string hint, Ide.WorkbenchOpenFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool open_project_async (GLib.File file_or_directory, GLib.Cancellable? cancellable) throws GLib.Error;
		public async bool open_uri_async (Ide.Uri uri, string hint, Ide.WorkbenchOpenFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool pop_message (string message_id);
		public void push_message (Ide.WorkbenchMessage message);
		public void remove_perspective (Ide.Perspective perspective);
		public async bool save_all_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_focus_mode (bool focus_mode);
		public void set_visible_perspective (Ide.Perspective perspective);
		public void set_visible_perspective_name (string name);
		public void views_foreach (Gtk.Callback callback);
		public Ide.Context context { get; }
		[NoAccessorMethod]
		public bool disable_greeter { get; construct; }
		public Ide.Perspective visible_perspective { get; set; }
		public string visible_perspective_name { get; set; }
		public signal void action (string object, string p0, string p1);
		public signal void set_perspective (string name);
		public signal void unload (Ide.Context object);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_workbench_header_bar_get_type ()")]
	public class WorkbenchHeaderBar : Gtk.HeaderBar, Atk.Implementor, Gtk.Buildable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WorkbenchHeaderBar ();
		[Version (since = "3.26")]
		public void add_primary (Gtk.Widget widget);
		public void focus_search ();
		public unowned Ide.OmniBar get_omni_bar ();
		public void insert_left (Gtk.Widget widget, Gtk.PackType pack_type, int priority);
		public void insert_right (Gtk.Widget widget, Gtk.PackType pack_type, int priority);
	}
	[CCode (cheader_filename = "ide.h", type_id = "ide_workbench_message_get_type ()")]
	public class WorkbenchMessage : Gtk.InfoBar, Atk.Implementor, Gtk.Buildable, Gtk.Orientable {
		[CCode (has_construct_function = false, type = "GtkWidget*")]
		public WorkbenchMessage ();
		public void add_action (string label, string action_name);
		public unowned string get_id ();
		public unowned string get_subtitle ();
		public unowned string get_title ();
		public void set_id (string id);
		public void set_subtitle (string subtitle);
		public void set_title (string title);
		public string id { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeApplicationAddinInterface", type_id = "ide_application_addin_get_type ()")]
	public interface ApplicationAddin : GLib.Object {
		[Version (since = "3.24")]
		public abstract void load (Ide.Application application);
		[Version (since = "3.24")]
		public abstract void unload (Ide.Application application);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeApplicationToolInterface", type_id = "ide_application_tool_get_type ()")]
	public interface ApplicationTool : GLib.Object {
		[Version (since = "3.22")]
		public abstract async int run_async ([CCode (array_length = false, array_null_terminated = true)] string[] arguments, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBufferAddinInterface", type_id = "ide_buffer_addin_get_type ()")]
	public interface BufferAddin : GLib.Object {
		[Version (since = "3.26")]
		public abstract void load (Ide.Buffer buffer);
		[Version (since = "3.26")]
		public abstract void unload (Ide.Buffer buffer);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildPipelineAddinInterface", type_id = "ide_build_pipeline_addin_get_type ()")]
	public interface BuildPipelineAddin : Ide.Object {
		public abstract void load (Ide.BuildPipeline pipeline);
		public void track (uint stage_id);
		public abstract void unload (Ide.BuildPipeline pipeline);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildSystemInterface", type_id = "ide_build_system_get_type ()")]
	public interface BuildSystem : Ide.Object {
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract async string[] get_build_flags_async (Ide.File file, GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.HashTable<Ide.File,string[]> get_build_flags_for_dir_async (GLib.File directory, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.HashTable<Ide.File,string[]> get_build_flags_for_files_async (GLib.GenericArray<Ide.File> files, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string get_builddir (Ide.BuildPipeline pipeline);
		public abstract string get_display_name ();
		public abstract string get_id ();
		public abstract int get_priority ();
		public static async Ide.BuildSystem new_async (Ide.Context context, GLib.File project_file, string build_system_hint, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract bool supports_toolchain (Ide.Toolchain toolchain);
		[NoAccessorMethod]
		public abstract GLib.File project_file { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildSystemDiscoveryInterface", type_id = "ide_build_system_discovery_get_type ()")]
	public interface BuildSystemDiscovery : GLib.Object {
		public abstract string discover (GLib.File project_file, GLib.Cancellable? cancellable, out int priority) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildTargetInterface", type_id = "ide_build_target_get_type ()")]
	public interface BuildTarget : Ide.Object {
		public bool compare (Ide.BuildTarget right);
		[CCode (array_length = false, array_null_terminated = true)]
		[Version (since = "3.28")]
		public abstract string[] get_argv ();
		[Version (since = "3.28")]
		public abstract string? get_cwd ();
		public abstract GLib.File? get_install_directory ();
		[Version (since = "3.28")]
		public abstract string get_language ();
		public abstract string? get_name ();
		[Version (since = "3.28")]
		public abstract int get_priority ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeBuildTargetProviderInterface", type_id = "ide_build_target_provider_get_type ()")]
	public interface BuildTargetProvider : GLib.Object {
		[Version (since = "3.28")]
		public abstract async GLib.GenericArray<Ide.BuildTarget> get_targets_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public abstract Ide.Context context { owned get; construct; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCodeIndexEntriesInterface", type_id = "ide_code_index_entries_get_type ()")]
	public interface CodeIndexEntries : GLib.Object {
		public abstract GLib.File get_file ();
		[Version (since = "3.26")]
		public abstract Ide.CodeIndexEntry? get_next_entry ();
		[Version (since = "3.30")]
		public abstract async GLib.GenericArray<Ide.CodeIndexEntry> next_entries_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCodeIndexerInterface", type_id = "ide_code_indexer_get_type ()")]
	public interface CodeIndexer : Ide.Object {
		[Version (since = "3.26")]
		public abstract async string generate_key_async (Ide.SourceLocation location, [CCode (array_length = false, array_null_terminated = true)] string[]? build_flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public abstract async Ide.CodeIndexEntries index_file_async (GLib.File file, [CCode (array_length = false, array_null_terminated = true)] string[]? build_flags, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCompletionDisplayInterface", type_id = "ide_completion_display_get_type ()")]
	public interface CompletionDisplay : Gtk.Widget {
		public abstract void attach (Gtk.SourceView view);
		public abstract bool key_press_event (Gdk.EventKey key);
		public abstract void move_cursor (Gtk.MovementStep step, int count);
		public abstract void set_context (Ide.CompletionContext context);
		[NoWrapper]
		public abstract void set_font_desc (Pango.FontDescription font_desc);
		public abstract void set_n_rows (uint n_rows);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCompletionProposalInterface", type_id = "ide_completion_proposal_get_type ()")]
	public interface CompletionProposal : GLib.Object {
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeCompletionProviderInterface", type_id = "ide_completion_provider_get_type ()")]
	public interface CompletionProvider : GLib.Object {
		public void activate_poposal (Ide.CompletionContext context, Ide.CompletionProposal proposal, Gdk.EventKey key);
		[NoWrapper]
		public abstract void activate_proposal (Ide.CompletionContext context, Ide.CompletionProposal proposal, Gdk.EventKey key);
		[Version (since = "3.30")]
		public abstract void display_proposal (Ide.CompletionListBoxRow row, Ide.CompletionContext context, string? typed_text, Ide.CompletionProposal proposal);
		[Version (since = "3.30")]
		public abstract string? get_comment (Ide.CompletionProposal proposal);
		public abstract GLib.Icon? get_icon ();
		[Version (since = "3.28")]
		public abstract int get_priority (Ide.CompletionContext context);
		public abstract string? get_title ();
		[Version (since = "3.30")]
		public abstract bool is_trigger (Gtk.TextIter iter, unichar ch);
		[Version (since = "3.30")]
		public abstract bool key_activates (Ide.CompletionProposal proposal, Gdk.EventKey key);
		[NoWrapper]
		public abstract void load (Ide.Context context);
		[Version (since = "3.28")]
		public abstract async GLib.ListModel populate_async (Ide.CompletionContext context, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public abstract bool refilter (Ide.CompletionContext context, GLib.ListModel proposals);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeConfigurationProviderInterface", type_id = "ide_configuration_provider_get_type ()")]
	public interface ConfigurationProvider : Ide.Object {
		[Version (since = "3.28")]
		public abstract void @delete (Ide.Configuration config);
		[Version (since = "3.28")]
		public abstract void duplicate (Ide.Configuration config);
		[Version (since = "3.28")]
		public void emit_added (Ide.Configuration config);
		[Version (since = "3.28")]
		public void emit_removed (Ide.Configuration config);
		[Version (since = "3.28")]
		public abstract async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool save_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload ();
		public virtual signal void added (Ide.Configuration config);
		public virtual signal void removed (Ide.Configuration config);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDependencyUpdaterInterface", type_id = "ide_dependency_updater_get_type ()")]
	public interface DependencyUpdater : Ide.Object {
		public abstract async bool update_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeDiagnosticProviderInterface", type_id = "ide_diagnostic_provider_get_type ()")]
	public interface DiagnosticProvider : Ide.Object {
		public abstract async Ide.Diagnostics? diagnose_async (Ide.File file, Ide.Buffer buffer, GLib.Cancellable? cancellable) throws GLib.Error;
		public void emit_invalidated ();
		public abstract void load ();
		public signal void invalidated ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeEditorAddinInterface", type_id = "ide_editor_addin_get_type ()")]
	public interface EditorAddin : GLib.Object {
		public static unowned Ide.EditorAddin? find_by_module_name (Ide.EditorPerspective editor, string module_name);
		[Version (since = "3.26")]
		public abstract void load (Ide.EditorPerspective perspective);
		[Version (since = "3.26")]
		public abstract void unload (Ide.EditorPerspective perspective);
		[Version (since = "3.26")]
		public abstract void view_set (Ide.LayoutView? view);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeEditorViewAddinInterface", type_id = "ide_editor_view_addin_get_type ()")]
	public interface EditorViewAddin : GLib.Object {
		public abstract void language_changed (string language_id);
		public abstract void load (Ide.EditorView view);
		public abstract void stack_set (Ide.LayoutStack stack);
		public abstract void unload (Ide.EditorView view);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeFormatterInterface", type_id = "ide_formatter_get_type ()")]
	public interface Formatter : GLib.Object {
		public abstract async bool format_async (Ide.Buffer buffer, Ide.FormatterOptions options, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool format_range_async (Ide.Buffer buffer, Ide.FormatterOptions options, Gtk.TextIter begin, Gtk.TextIter end, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeGenesisAddinInterface", type_id = "ide_genesis_addin_get_type ()")]
	public interface GenesisAddin : GLib.Object {
		public abstract bool apply_uri (Ide.VcsUri uri);
		public abstract string get_icon_name ();
		public abstract string get_label ();
		public abstract string get_next_label ();
		public abstract int get_priority ();
		public abstract string get_title ();
		public abstract unowned Gtk.Widget get_widget ();
		public abstract async bool run_async (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public abstract bool is_ready { get; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeGreeterSectionInterface", type_id = "ide_greeter_section_get_type ()")]
	public interface GreeterSection : Gtk.Widget {
		[Version (since = "3.28")]
		public abstract bool activate_first ();
		public abstract void delete_selected ();
		public void emit_project_activated (Ide.ProjectInfo project_info);
		[Version (since = "3.28")]
		public abstract bool filter (Dazzle.PatternSpec? spec);
		[Version (since = "3.28")]
		public abstract int get_priority ();
		public abstract void purge_selected ();
		public abstract void set_selection_mode (bool selection_mode);
		[NoAccessorMethod]
		public abstract bool has_selection { get; }
		[Version (since = "3.28")]
		public virtual signal void project_activated (Ide.ProjectInfo project_info);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeHighlighterInterface", type_id = "ide_highlighter_get_type ()")]
	public interface Highlighter : Ide.Object {
		public abstract void load ();
		[NoWrapper]
		public abstract void set_engine (Ide.HighlightEngine engine);
		public abstract Gtk.TextIter update (Ide.HighlightCallback callback, Gtk.TextIter range_begin, Gtk.TextIter range_end);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeHoverProviderInterface", type_id = "ide_hover_provider_get_type ()")]
	public interface HoverProvider : GLib.Object {
		[Version (since = "3.30")]
		public abstract async bool hover_async (Ide.HoverContext context, Gtk.TextIter location, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public abstract void load (Ide.SourceView view);
		[Version (since = "3.30")]
		public abstract void unload (Ide.SourceView view);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeIndenterInterface", type_id = "ide_indenter_get_type ()")]
	public interface Indenter : Ide.Object {
		public abstract string? format (Gtk.TextView text_view, Gtk.TextIter begin, Gtk.TextIter end, out int cursor_offset, Gdk.EventKey event);
		public abstract bool is_trigger (Gdk.EventKey event);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeLayoutStackAddinInterface", type_id = "ide_layout_stack_addin_get_type ()")]
	public interface LayoutStackAddin : GLib.Object {
		public abstract void load (Ide.LayoutStack stack);
		public abstract void set_view (Ide.LayoutView? view);
		public abstract void unload (Ide.LayoutStack stack);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdePerspectiveInterface", type_id = "ide_perspective_get_type ()")]
	public interface Perspective : GLib.Object {
		public abstract bool agree_to_shutdown ();
		public abstract string? get_accelerator ();
		public abstract string? get_icon_name ();
		public abstract string? get_id ();
		public abstract bool get_needs_attention ();
		public abstract string get_title ();
		public abstract unowned Gtk.Widget? get_titlebar ();
		public abstract bool is_early ();
		public abstract void restore_state ();
		public abstract void set_fullscreen (bool fullscreen);
		public abstract void views_foreach (Gtk.Callback callback);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdePreferencesAddinInterface", type_id = "ide_preferences_addin_get_type ()")]
	public interface PreferencesAddin : GLib.Object {
		public abstract void load (Dazzle.Preferences preferences);
		public abstract void unload (Dazzle.Preferences preferences);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeProjectTemplateInterface", type_id = "ide_project_template_get_type ()")]
	public interface ProjectTemplate : GLib.Object {
		public int compare (Ide.ProjectTemplate b);
		public abstract async bool expand_async (GLib.HashTable<string,GLib.Variant> @params, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract string get_description ();
		public abstract string get_icon_name ();
		public abstract string get_id ();
		[CCode (array_length = false, array_null_terminated = true)]
		public abstract string[] get_languages ();
		public abstract string get_name ();
		[Version (since = "3.28")]
		public abstract int get_priority ();
		public abstract unowned Gtk.Widget get_widget ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeRenameProviderInterface", type_id = "ide_rename_provider_get_type ()")]
	public interface RenameProvider : Ide.Object {
		public abstract void load ();
		public abstract async bool rename_async (Ide.SourceLocation location, string new_name, GLib.Cancellable? cancellable, out GLib.GenericArray<Ide.ProjectEdit> edits) throws GLib.Error;
		[NoAccessorMethod]
		public abstract Ide.Buffer buffer { set; }
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeRunnerAddinInterface", type_id = "ide_runner_addin_get_type ()")]
	public interface RunnerAddin : GLib.Object {
		public abstract void load (Ide.Runner runner);
		public abstract async bool posthook_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async bool prehook_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload (Ide.Runner runner);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeRuntimeProviderInterface", type_id = "ide_runtime_provider_get_type ()")]
	public interface RuntimeProvider : GLib.Object {
		[Version (since = "3.28")]
		public abstract async Ide.Runtime bootstrap_async (Ide.BuildPipeline pipeline, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract bool can_install (string runtime_id);
		public abstract async bool install_async (string runtime_id, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load (Ide.RuntimeManager manager);
		public abstract void unload (Ide.RuntimeManager manager);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSearchProviderInterface", type_id = "ide_search_provider_get_type ()")]
	public interface SearchProvider : Ide.Object {
		public abstract async GLib.GenericArray<Ide.SearchResult> search_async (string query, uint max_results, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeServiceInterface", type_id = "ide_service_get_type ()")]
	public interface Service : Ide.Object {
		[Version (since = "3.16")]
		public abstract unowned string get_name ();
		[Version (since = "3.16")]
		public abstract void start ();
		[Version (since = "3.16")]
		public abstract void stop ();
		[Version (since = "3.20")]
		public virtual signal void context_loaded ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSessionAddinInterface", type_id = "ide_session_addin_get_type ()")]
	public interface SessionAddin : Ide.Object {
		[Version (since = "3.30")]
		public abstract async bool restore_async (GLib.Variant state, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.30")]
		public abstract async GLib.Variant? save_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSubprocessInterface", type_id = "ide_subprocess_get_type ()")]
	public interface Subprocess : GLib.Object {
		public bool check_exit_status () throws GLib.Error;
		public abstract bool communicate (GLib.Bytes stdin_buf, GLib.Cancellable? cancellable, GLib.Bytes stdout_buf, GLib.Bytes stderr_buf) throws GLib.Error;
		public abstract async bool communicate_async (GLib.Bytes? stdin_buf, GLib.Cancellable? cancellable, out GLib.Bytes stdout_buf, out GLib.Bytes stderr_buf) throws GLib.Error;
		public abstract bool communicate_utf8 (string? stdin_buf, GLib.Cancellable? cancellable, out string? stdout_buf, out string? stderr_buf) throws GLib.Error;
		public abstract async bool communicate_utf8_async (string? stdin_buf, GLib.Cancellable? cancellable, out string stdout_buf, out string stderr_buf) throws GLib.Error;
		public abstract void force_exit ();
		public abstract int get_exit_status ();
		public abstract unowned string get_identifier ();
		public abstract bool get_if_exited ();
		public abstract bool get_if_signaled ();
		public abstract int get_status ();
		public abstract unowned GLib.InputStream get_stderr_pipe ();
		public abstract unowned GLib.OutputStream get_stdin_pipe ();
		public abstract unowned GLib.InputStream get_stdout_pipe ();
		public abstract bool get_successful ();
		public abstract int get_term_sig ();
		public abstract void send_signal (int signal_num);
		public abstract bool wait (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public abstract async bool wait_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool wait_check (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async bool wait_check_async (GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolResolverInterface", type_id = "ide_symbol_resolver_get_type ()")]
	public interface SymbolResolver : Ide.Object {
		[Version (since = "3.26")]
		public abstract async Ide.Symbol? find_nearest_scope_async (Ide.SourceLocation location, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async GLib.GenericArray<Ide.SourceRange> find_references_async (Ide.SourceLocation location, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract async Ide.SymbolTree? get_symbol_tree_async (GLib.File file, Ide.Buffer buffer, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load ();
		public abstract async Ide.Symbol? lookup_symbol_async (Ide.SourceLocation location, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeSymbolTreeInterface", type_id = "ide_symbol_tree_get_type ()")]
	public interface SymbolTree : GLib.Object {
		public abstract uint get_n_children (Ide.SymbolNode? node);
		public abstract Ide.SymbolNode? get_nth_child (Ide.SymbolNode? node, uint nth);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTagsBuilderInterface", type_id = "ide_tags_builder_get_type ()")]
	public interface TagsBuilder : GLib.Object {
		public abstract async bool build_async (GLib.File directory_or_file, bool recursive, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeTemplateProviderInterface", type_id = "ide_template_provider_get_type ()")]
	public interface TemplateProvider : GLib.Object {
		public abstract GLib.List<Ide.ProjectTemplate> get_project_templates ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeToolchainProviderInterface", type_id = "ide_toolchain_provider_get_type ()")]
	public interface ToolchainProvider : Ide.Object {
		[Version (since = "3.30")]
		public void emit_added (Ide.Toolchain toolchain);
		[Version (since = "3.30")]
		public void emit_removed (Ide.Toolchain toolchain);
		[Version (since = "3.30")]
		public abstract async bool load_async (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unload (Ide.ToolchainManager manager);
		public virtual signal void added (Ide.Toolchain toolchain);
		public virtual signal void removed (Ide.Toolchain toolchain);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeVcsInterface", type_id = "ide_vcs_get_type ()")]
	public interface Vcs : Ide.Object {
		public void emit_changed ();
		public abstract string get_branch_name ();
		public abstract Ide.BufferChangeMonitor? get_buffer_change_monitor (Ide.Buffer buffer);
		public abstract Ide.VcsConfig? get_config ();
		public abstract int get_priority ();
		[Version (since = "3.18")]
		public abstract unowned GLib.File get_working_directory ();
		[Version (since = "3.18")]
		public abstract bool is_ignored (GLib.File? file) throws GLib.Error;
		[Version (since = "3.28")]
		public abstract async GLib.ListModel? list_status_async (GLib.File directory_or_file, bool include_descendants, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public static async Ide.Vcs new_async (Ide.Context context, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.28")]
		public bool path_is_ignored (string? path) throws GLib.Error;
		public static void register_ignored (string pattern);
		public abstract string branch_name { owned get; }
		public abstract GLib.File working_directory { get; }
		public virtual signal void changed ();
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeVcsConfigInterface", type_id = "ide_vcs_config_get_type ()")]
	public interface VcsConfig : GLib.Object {
		public abstract void get_config (Ide.VcsConfigType type, GLib.Value value);
		public abstract void set_config (Ide.VcsConfigType type, GLib.Value value);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeVcsInitializerInterface", type_id = "ide_vcs_initializer_get_type ()")]
	public interface VcsInitializer : GLib.Object {
		public abstract string get_title ();
		public abstract async bool initialize_async (GLib.File file, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeWorkbenchAddinInterface", type_id = "ide_workbench_addin_get_type ()")]
	public interface WorkbenchAddin : GLib.Object {
		public abstract bool can_open (Ide.Uri uri, string? content_type, out int priority);
		public abstract string get_id ();
		public abstract void load (Ide.Workbench workbench);
		public abstract async bool open_async (Ide.Uri uri, string content_type, Ide.WorkbenchOpenFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void perspective_set (Ide.Perspective perspective);
		public abstract void unload (Ide.Workbench workbench);
	}
	[CCode (cheader_filename = "ide.h", type_cname = "IdeWorkerInterface", type_id = "ide_worker_get_type ()")]
	public interface Worker : GLib.Object {
		public abstract GLib.DBusProxy create_proxy (GLib.DBusConnection connection) throws GLib.Error;
		public abstract void register_service (GLib.DBusConnection connection);
	}
	[CCode (cheader_filename = "ide.h")]
	[SimpleType]
	public struct DebuggerAddress : uint64 {
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	public struct LineReader {
		public weak string contents;
		public size_t length;
		public ssize_t pos;
		public void init (string contents, ssize_t length);
		public unowned string next (size_t length);
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	public struct SearchReducer {
		public weak GLib.Sequence sequence;
		public size_t max_results;
		public size_t count;
		public bool accepts (float score);
		public void destroy ();
		public GLib.GenericArray<weak Ide.SearchResult>? free (bool free_results);
		public static void init (out Ide.SearchReducer reducer, size_t max_results);
		public void push (Ide.SearchResult result);
		public void take (owned Ide.SearchResult result);
	}
	[CCode (cheader_filename = "ide.h", has_type_id = false)]
	public struct SnippetInfo {
		public weak string lang;
		public weak string name;
		public weak string desc;
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_APPLICATION_MODE_", has_type_id = false)]
	public enum ApplicationMode {
		PRIMARY,
		WORKER,
		TOOL,
		TESTS
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_CHANGE_", has_type_id = false)]
	[Flags]
	public enum BufferLineChange {
		NONE,
		ADDED,
		CHANGED,
		DELETED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUFFER_LINE_FLAGS_", type_id = "ide_buffer_line_flags_get_type ()")]
	[Flags]
	public enum BufferLineFlags {
		NONE,
		ADDED,
		CHANGED,
		DELETED,
		ERROR,
		WARNING,
		NOTE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILD_LOCALITY_", type_id = "ide_build_locality_get_type ()")]
	[Flags]
	public enum BuildLocality {
		IN_TREE,
		OUT_OF_TREE,
		DEFAULT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILD_LOG_", type_id = "ide_build_log_stream_get_type ()")]
	public enum BuildLogStream {
		STDOUT,
		STDERR
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_BUILD_PHASE_", type_id = "ide_build_phase_get_type ()")]
	[Flags]
	public enum BuildPhase {
		NONE,
		PREPARE,
		DOWNLOADS,
		DEPENDENCIES,
		AUTOGEN,
		CONFIGURE,
		BUILD,
		INSTALL,
		COMMIT,
		EXPORT,
		FINAL,
		BEFORE,
		AFTER,
		FINISHED,
		FAILED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_COMPLETION_", type_id = "ide_completion_activation_get_type ()")]
	public enum CompletionActivation {
		INTERACTIVE,
		USER_REQUESTED,
		TRIGGERED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_COMPLETION_COLUMN_", type_id = "ide_completion_column_get_type ()")]
	public enum CompletionColumn {
		ICON,
		LEFT_OF,
		TYPED_TEXT,
		RIGHT_OF
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_CURSOR_", type_id = "ide_cursor_type_get_type ()")]
	public enum CursorType {
		COLUMN,
		SELECT,
		MATCH
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_BREAK_", type_id = "ide_debugger_break_mode_get_type ()")]
	public enum DebuggerBreakMode {
		NONE,
		BREAKPOINT,
		COUNTPOINT,
		WATCHPOINT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_BREAKPOINT_CHANGE_", type_id = "ide_debugger_breakpoint_change_get_type ()")]
	public enum DebuggerBreakpointChange {
		ENABLED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_DISPOSITION_", type_id = "ide_debugger_disposition_get_type ()")]
	public enum DebuggerDisposition {
		KEEP,
		DISABLE,
		DELETE_NEXT_HIT,
		DELETE_NEXT_STOP
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_MOVEMENT_", type_id = "ide_debugger_movement_get_type ()")]
	[Version (since = "3.26")]
	public enum DebuggerMovement {
		START,
		CONTINUE,
		STEP_IN,
		STEP_OUT,
		FINISH
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_STOP_", type_id = "ide_debugger_stop_reason_get_type ()")]
	public enum DebuggerStopReason {
		BREAKPOINT_HIT,
		CATCH,
		[CCode (cname = "IDE_DEBUGGER_STOP_EXITED")]
		STOP_EXITED,
		EXITED_NORMALLY,
		EXITED_SIGNALED,
		FUNCTION_FINISHED,
		LOCATION_REACHED,
		SIGNAL_RECEIVED,
		UNKNOWN
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEBUGGER_", type_id = "ide_debugger_stream_get_type ()")]
	[Version (since = "3.26")]
	public enum DebuggerStream {
		CONSOLE,
		[CCode (cname = "IDE_DEBUGGER_EVENT_LOG")]
		LOG,
		TARGET
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEVICE_KIND_", type_id = "ide_device_kind_get_type ()")]
	public enum DeviceKind {
		COMPUTER,
		PHONE,
		TABLET,
		MICRO_CONTROLLER
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DIAGNOSTIC_", type_id = "ide_diagnostic_severity_get_type ()")]
	public enum DiagnosticSeverity {
		IGNORED,
		NOTE,
		DEPRECATED,
		WARNING,
		ERROR,
		FATAL;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_EDITOR_SEARCH_", type_id = "ide_editor_search_direction_get_type ()")]
	public enum EditorSearchDirection {
		FORWARD,
		NEXT,
		PREVIOUS,
		BACKWARD
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_EDITOR_SEARCH_SELECT_", type_id = "ide_editor_search_select_get_type ()")]
	public enum EditorSearchSelect {
		NONE,
		WITH_RESULT,
		TO_RESULT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_HIGHLIGHT_", type_id = "ide_highlight_result_get_type ()")]
	public enum HighlightResult {
		STOP,
		CONTINUE
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_INDENT_STYLE_", type_id = "ide_indent_style_get_type ()")]
	public enum IndentStyle {
		SPACES,
		TABS
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_LSP_COMPLETION_", type_id = "ide_lsp_completion_kind_get_type ()")]
	public enum LspCompletionKind {
		TEXT,
		METHOD,
		FUNCTION,
		CONSTRUCTOR,
		FIELD,
		VARIABLE,
		CLASS,
		INTERFACE,
		MODULE,
		PROPERTY,
		UNIT,
		VALUE,
		ENUM,
		KEYWORD,
		SNIPPET,
		COLOR,
		FILE,
		REFERENCE,
		FOLDER,
		ENUM_MEMBER,
		CONSTANT,
		STRUCT,
		EVENT,
		OPERATOR,
		TYPE_PARAMETER
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_MARKED_KIND_", type_id = "ide_marked_kind_get_type ()")]
	public enum MarkedKind {
		PLAINTEXT,
		MARKDOWN,
		HTML,
		PANGO
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_SCROLL_", type_id = "ide_source_scroll_align_get_type ()")]
	[Flags]
	public enum SourceScrollAlign {
		NONE,
		BOTH,
		X,
		Y
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MODE_TYPE_", type_id = "ide_source_view_mode_type_get_type ()")]
	public enum SourceViewModeType {
		TRANSIENT,
		PERMANENT,
		MODAL
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_MOVEMENT_", type_id = "ide_source_view_movement_get_type ()")]
	public enum SourceViewMovement {
		PREVIOUS_OFFSET,
		NEXT_OFFSET,
		NTH_CHAR,
		PREVIOUS_CHAR,
		NEXT_CHAR,
		FIRST_CHAR,
		FIRST_NONSPACE_CHAR,
		MIDDLE_CHAR,
		LAST_CHAR,
		NEXT_WORD_START,
		NEXT_FULL_WORD_START,
		NEXT_SUB_WORD_START,
		PREVIOUS_SUB_WORD_START,
		PREVIOUS_WORD_START,
		PREVIOUS_FULL_WORD_START,
		PREVIOUS_WORD_END,
		PREVIOUS_FULL_WORD_END,
		NEXT_WORD_END,
		NEXT_FULL_WORD_END,
		NEXT_WORD_START_NEWLINE_STOP,
		NEXT_FULL_WORD_START_NEWLINE_STOP,
		PREVIOUS_WORD_START_NEWLINE_STOP,
		PREVIOUS_FULL_WORD_START_NEWLINE_STOP,
		PREVIOUS_WORD_END_NEWLINE_STOP,
		PREVIOUS_FULL_WORD_END_NEWLINE_STOP,
		NEXT_WORD_END_NEWLINE_STOP,
		NEXT_FULL_WORD_END_NEWLINE_STOP,
		SENTENCE_START,
		SENTENCE_END,
		PARAGRAPH_START,
		PARAGRAPH_END,
		PREVIOUS_LINE,
		NEXT_LINE,
		FIRST_LINE,
		NTH_LINE,
		LAST_LINE,
		LINE_PERCENTAGE,
		LINE_CHARS,
		LINE_END,
		HALF_PAGE_UP,
		HALF_PAGE_DOWN,
		HALF_PAGE_LEFT,
		HALF_PAGE_RIGHT,
		PAGE_UP,
		PAGE_UP_LINES,
		PAGE_DOWN,
		PAGE_DOWN_LINES,
		SCREEN_UP,
		SCREEN_DOWN,
		SCREEN_LEFT,
		SCREEN_RIGHT,
		SCREEN_TOP,
		SCREEN_MIDDLE,
		SCREEN_BOTTOM,
		MATCH_SPECIAL,
		SCROLL_SCREEN_TOP,
		SCROLL_SCREEN_CENTER,
		SCROLL_SCREEN_BOTTOM,
		SCROLL_SCREEN_LEFT,
		SCROLL_SCREEN_RIGHT,
		PREVIOUS_UNMATCHED_BRACE,
		NEXT_UNMATCHED_BRACE,
		PREVIOUS_UNMATCHED_PAREN,
		NEXT_UNMATCHED_PAREN,
		NEXT_MATCH_MODIFIER,
		PREVIOUS_MATCH_MODIFIER,
		NEXT_MATCH_SEARCH_CHAR,
		PREVIOUS_MATCH_SEARCH_CHAR,
		SMART_HOME
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SOURCE_VIEW_THEATRIC_", type_id = "ide_source_view_theatric_get_type ()")]
	public enum SourceViewTheatric {
		EXPAND,
		SHRINK
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SPACES_STYLE_", type_id = "ide_spaces_style_get_type ()")]
	[Flags]
	public enum SpacesStyle {
		IGNORE,
		BEFORE_LEFT_PAREN,
		BEFORE_LEFT_BRACKET,
		BEFORE_LEFT_BRACE,
		BEFORE_LEFT_ANGLE,
		BEFORE_COLON,
		BEFORE_COMMA,
		BEFORE_SEMICOLON
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_FLAGS_", type_id = "ide_symbol_flags_get_type ()")]
	[Flags]
	public enum SymbolFlags {
		NONE,
		IS_STATIC,
		IS_MEMBER,
		IS_DEPRECATED,
		IS_DEFINITION
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_SYMBOL_", type_id = "ide_symbol_kind_get_type ()")]
	public enum SymbolKind {
		NONE,
		ALIAS,
		ARRAY,
		BOOLEAN,
		CLASS,
		CONSTANT,
		CONSTRUCTOR,
		ENUM,
		ENUM_VALUE,
		FIELD,
		FILE,
		FUNCTION,
		HEADER,
		INTERFACE,
		MACRO,
		METHOD,
		MODULE,
		NAMESPACE,
		NUMBER,
		PACKAGE,
		PROPERTY,
		SCALAR,
		STRING,
		STRUCT,
		TEMPLATE,
		UNION,
		VARIABLE,
		KEYWORD,
		UI_ATTRIBUTES,
		UI_CHILD,
		UI_ITEM,
		UI_MENU,
		UI_MENU_ATTRIBUTE,
		UI_OBJECT,
		UI_PACKING,
		UI_PROPERTY,
		UI_SECTION,
		UI_SIGNAL,
		UI_STYLE,
		UI_STYLE_CLASS,
		UI_SUBMENU,
		UI_TEMPLATE,
		XML_ATTRIBUTE,
		XML_DECLARATION,
		XML_ELEMENT,
		XML_COMMENT,
		XML_CDATA;
		public unowned string get_icon_name ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_TASK_KIND_", type_id = "ide_task_kind_get_type ()")]
	public enum TaskKind {
		DEFAULT,
		COMPILER,
		INDEXER,
		IO,
		LAST
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_TEST_STATUS_", type_id = "ide_test_status_get_type ()")]
	public enum TestStatus {
		NONE,
		RUNNING,
		SUCCESS,
		FAILED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_THREAD_POOL_", type_id = "ide_thread_pool_kind_get_type ()")]
	public enum ThreadPoolKind {
		DEFAULT,
		COMPILER,
		INDEXER,
		IO,
		LAST
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_TRANSFER_ERROR_", has_type_id = false)]
	public enum TransferError {
		UNKNOWN,
		CONNECTION_IS_METERED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_PARSE_", has_type_id = false)]
	[Flags]
	public enum UriParseFlags {
		STRICT,
		HTML5,
		NO_IRI,
		PASSWORD,
		AUTH_PARAMS,
		NON_DNS,
		DECODED,
		UTF8_ONLY
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_HIDE_", has_type_id = false)]
	[Flags]
	public enum UriToStringFlags {
		AUTH_PARAMS,
		FRAGMENT
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_VCS_CONFIG_", type_id = "ide_vcs_config_type_get_type ()")]
	public enum VcsConfigType {
		FULL_NAME,
		EMAIL
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_VCS_FILE_STATUS_", type_id = "ide_vcs_file_status_get_type ()")]
	public enum VcsFileStatus {
		IGNORED,
		UNCHANGED,
		UNTRACKED,
		ADDED,
		RENAMED,
		DELETED,
		CHANGED
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_WORKBENCH_OPEN_FLAGS_", has_type_id = false)]
	[Flags]
	[Version (since = "3.24")]
	public enum WorkbenchOpenFlags {
		NONE,
		BACKGROUND,
		NO_VIEW
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DEVICE_ERROR_NO_SUCH_")]
	public errordomain DeviceError {
		DEVICE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_DOAP_ERROR_INVALID_")]
	public errordomain DoapError {
		FORMAT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_RUNTIME_ERROR_NO_SUCH_")]
	public errordomain RuntimeError {
		RUNTIME;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", cprefix = "IDE_URI_ERROR_")]
	public errordomain UriError {
		MISC,
		BAD_SCHEME,
		BAD_USER,
		BAD_PASSWORD,
		BAD_AUTH_PARAMS,
		BAD_HOST,
		BAD_PORT,
		BAD_PATH,
		BAD_QUERY,
		BAD_FRAGMENT;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "ide.h", instance_pos = 3.9)]
	public delegate void BuildLogObserver (Ide.BuildLogStream log_stream, string message, ssize_t message_len);
	[CCode (cheader_filename = "ide.h", instance_pos = 3.9)]
	public delegate void ExtensionSetAdapterForeachFunc (Ide.ExtensionSetAdapter @set, Peas.PluginInfo plugin_info, Peas.Extension extension);
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate Ide.HighlightResult HighlightCallback (Gtk.TextIter begin, Gtk.TextIter end, string style_name);
	[CCode (cheader_filename = "ide.h", instance_pos = 2.9)]
	public delegate void RunHandler (Ide.RunManager self, Ide.Runner runner);
	[CCode (cheader_filename = "ide.h", instance_pos = 2.9)]
	public delegate void SnippetStorageForeach (Ide.SnippetStorage self, Ide.SnippetInfo info);
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate void TaskThreadFunc (Ide.Task task, void* source_object, void* task_data, GLib.Cancellable? cancellable = null);
	[CCode (cheader_filename = "ide.h", instance_pos = 2.9)]
	public delegate bool TextIterCharPredicate (Gtk.TextIter iter, unichar ch);
	[CCode (cheader_filename = "ide.h", instance_pos = 0.9)]
	public delegate void ThreadFunc ();
	[CCode (cheader_filename = "ide.h", has_target = false)]
	public delegate void WidgetContextHandler (Gtk.Widget widget, Ide.Context context);
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK")]
	public const int BUFFER_LINE_FLAGS_DIAGNOSTICS_MASK;
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUILD_CHANNEL")]
	public const string BUILD_CHANNEL;
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUILD_IDENTIFIER")]
	public const string BUILD_IDENTIFIER;
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUILD_PHASE_MASK")]
	public const int BUILD_PHASE_MASK;
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUILD_PHASE_WHENCE_MASK")]
	public const int BUILD_PHASE_WHENCE_MASK;
	[CCode (cheader_filename = "ide.h", cname = "IDE_BUILD_TYPE")]
	public const string BUILD_TYPE;
	[CCode (cheader_filename = "ide.h", cname = "IDE_DEBUGGER_ADDRESS_INVALID")]
	public const int DEBUGGER_ADDRESS_INVALID;
	[CCode (cheader_filename = "ide.h", cname = "IDE_ENABLE_TRACE")]
	public const int ENABLE_TRACE;
	[CCode (cheader_filename = "ide.h", cname = "IDE_FILE_ATTRIBUTE_POSITION")]
	public const string FILE_ATTRIBUTE_POSITION;
	[CCode (cheader_filename = "ide.h", cname = "IDE_FILE_SETTINGS_EXTENSION_POINT")]
	public const string FILE_SETTINGS_EXTENSION_POINT;
	[CCode (cheader_filename = "ide.h", cname = "IDE_LANGSERV_COMPLETION_PROVIDER_PRIORITY")]
	public const int LANGSERV_COMPLETION_PROVIDER_PRIORITY;
	[CCode (cheader_filename = "ide.h", cname = "IDE_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "ide.h", cname = "IDE_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "ide.h", cname = "IDE_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "ide.h", cname = "IDE_PREFERENCES_PERSPECTIVE_PRIORITY")]
	public const int PREFERENCES_PERSPECTIVE_PRIORITY;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_BOOKMARK_FILENAME")]
	public const string RECENT_PROJECTS_BOOKMARK_FILENAME;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_BUILD_SYSTEM_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_BUILD_SYSTEM_GROUP_PREFIX;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_GROUP")]
	public const string RECENT_PROJECTS_GROUP;
	[CCode (cheader_filename = "ide.h", cname = "IDE_RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX")]
	public const string RECENT_PROJECTS_LANGUAGE_GROUP_PREFIX;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_ANY")]
	public const string TOOLCHAIN_LANGUAGE_ANY;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_C")]
	public const string TOOLCHAIN_LANGUAGE_C;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_CPLUSPLUS")]
	public const string TOOLCHAIN_LANGUAGE_CPLUSPLUS;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_D")]
	public const string TOOLCHAIN_LANGUAGE_D;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_FORTRAN")]
	public const string TOOLCHAIN_LANGUAGE_FORTRAN;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_PYTHON")]
	public const string TOOLCHAIN_LANGUAGE_PYTHON;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_LANGUAGE_VALA")]
	public const string TOOLCHAIN_LANGUAGE_VALA;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_AR")]
	public const string TOOLCHAIN_TOOL_AR;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_CC")]
	public const string TOOLCHAIN_TOOL_CC;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_CPP")]
	public const string TOOLCHAIN_TOOL_CPP;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_EXEC")]
	public const string TOOLCHAIN_TOOL_EXEC;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_LD")]
	public const string TOOLCHAIN_TOOL_LD;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_PKG_CONFIG")]
	public const string TOOLCHAIN_TOOL_PKG_CONFIG;
	[CCode (cheader_filename = "ide.h", cname = "IDE_TOOLCHAIN_TOOL_STRIP")]
	public const string TOOLCHAIN_TOOL_STRIP;
	[CCode (cheader_filename = "ide.h", cname = "IDE_VERSION_S")]
	public const string VERSION_S;
	[CCode (cheader_filename = "ide.h")]
	public static async Ide.BuildSystem build_system_new_async (Ide.Context context, GLib.File project_file, string build_system_hint, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static uint8 build_utils_filter_color_codes (uint8 data, size_t len, size_t out_len);
	[CCode (cheader_filename = "ide.h")]
	public static string create_host_triplet (string arch, string kernel, string system);
	[CCode (cheader_filename = "ide.h")]
	public static void dump_tasks ();
	[CCode (cheader_filename = "ide.h")]
	public static unowned Ide.EditorAddin? editor_addin_find_by_module_name (Ide.EditorPerspective editor, string module_name);
	[CCode (cheader_filename = "ide.h")]
	public static bool environ_parse (string pair, string key, string value);
	[CCode (cheader_filename = "ide.h")]
	public static string flatpak_get_app_path (string path);
	[CCode (cheader_filename = "ide.h")]
	public static GLib.Icon? g_content_type_get_symbolic_icon (string content_type);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.28")]
	public static async GLib.GenericArray<GLib.File> g_file_find_async (GLib.File file, string pattern, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.30")]
	public static async void g_file_find_with_depth_async (GLib.File file, string pattern, uint max_depth, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.28")]
	public static async GLib.GenericArray<GLib.FileInfo> g_file_get_children_async (GLib.File file, string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.28")]
	public static string? g_file_get_uncanonical_relative_path (GLib.File file, GLib.File other);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.28")]
	public static bool g_host_file_get_contents (string path, out string contents, out size_t len) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static void g_task_return_boolean_from_main (GLib.Task task, bool value);
	[CCode (cheader_filename = "ide.h")]
	public static void g_task_return_error_from_main (GLib.Task task, owned GLib.Error error);
	[CCode (cheader_filename = "ide.h")]
	public static void g_task_return_int_from_main (GLib.Task task, int value);
	[CCode (cheader_filename = "ide.h")]
	public static void g_task_return_pointer_from_main (GLib.Task task, void* value, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "ide.h")]
	public static unowned string get_program_name ();
	[CCode (cheader_filename = "ide.h")]
	public static GLib.Resource get_resource ();
	[CCode (cheader_filename = "ide.h")]
	public static string get_system_arch ();
	[CCode (cheader_filename = "ide.h")]
	public static size_t get_system_page_size ();
	[CCode (cheader_filename = "ide.h")]
	public static unowned string get_system_type ();
	[CCode (cheader_filename = "ide.h")]
	public static unowned string get_user_shell ();
	[CCode (cheader_filename = "ide.h")]
	public static unowned string gettext (string message);
	[CCode (cheader_filename = "ide.h")]
	public static bool gtk_show_uri_on_window (Gtk.Window window, string uri, uint32 timestamp) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static GLib.Resource icons_get_resource ();
	[CCode (cheader_filename = "ide.h")]
	public static bool is_flatpak ();
	[CCode (cheader_filename = "ide.h")]
	public static Ide.SymbolKind langserv_decode_completion_kind (uint kind);
	[CCode (cheader_filename = "ide.h")]
	public static Ide.SymbolKind langserv_decode_symbol_kind (uint kind);
	[CCode (cheader_filename = "ide.h")]
	public static string language_format_header (Gtk.SourceLanguage language, string header);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.20")]
	public static int log_get_verbosity ();
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.20")]
	public static void log_increase_verbosity ();
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.16")]
	public static void log_init (bool stdout_, string filename);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.20")]
	public static void log_set_verbosity (int level);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.16")]
	public static void log_shutdown ();
	[CCode (cheader_filename = "ide.h")]
	public static string path_collapse (string path);
	[CCode (cheader_filename = "ide.h")]
	public static string path_expand (string path);
	[CCode (cheader_filename = "ide.h")]
	public static void set_program_name (string program_name);
	[CCode (cheader_filename = "ide.h")]
	public static async void source_search_context_backward_async (Gtk.SourceSearchContext search, Gtk.TextIter iter, GLib.Cancellable? cancellable);
	[CCode (cheader_filename = "ide.h")]
	[Version (since = "3.30")]
	public static bool source_search_context_backward_finish2 (Gtk.SourceSearchContext search, GLib.AsyncResult result, out Gtk.TextIter match_begin, out Gtk.TextIter match_end, out bool has_wrapped_around) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static bool source_style_scheme_apply_style (Gtk.SourceStyleScheme style_scheme, string style, Gtk.TextTag tag);
	[CCode (cheader_filename = "ide.h")]
	public static async Ide.Vcs vcs_new_async (Ide.Context context, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
	[CCode (cheader_filename = "ide.h")]
	public static void vcs_register_ignored (string pattern);
	[CCode (cheader_filename = "ide.h")]
	public static int vte_pty_create_slave (Vte.Pty pty);
	[CCode (cheader_filename = "ide.h")]
	public static unowned Ide.Workbench? widget_get_workbench (Gtk.Widget widget);
	[CCode (cheader_filename = "ide.h")]
	public static void widget_set_context_handler (Gtk.Widget widget, [CCode (scope = "async")] Ide.WidgetContextHandler handler);
}
