/*===------- llvm/Config/llvm-config.h - llvm configuration -------*- C -*-===*/
/*                                                                            */
/*                     The LLVM Compiler Infrastructure                       */
/*                                                                            */
/* This file is distributed under the University of Illinois Open Source      */
/* License. See LICENSE.TXT for details.                                      */
/*                                                                            */
/*===----------------------------------------------------------------------===*/

/* This file enumerates variables from the LLVM configuration so that they
   can be in exported headers and won't override package specific directives.
   This is a C header that can be included in the llvm-c headers. */

#ifndef LLVM_CONFIG_H
#define LLVM_CONFIG_H

/*
 * When bsd.lib.mk builds shared libraries it builds with -DPIC which 
 * causes problems in the following files which use PIC as a variable name.
 * undefine PIC here to minimise the diff to upstream LLVM
 *
 * include/llvm/MC/MCObjectFileInfo.h
 * lib/MC/MCObjectFileInfo.cpp
 * lib/Transforms/Scalar/LICM.cpp
 * lib/Transforms/Utils/PredicateInfo.cpp
 */
#undef PIC

/* Define if LLVM_ENABLE_DUMP is enabled */
/* #undef LLVM_ENABLE_DUMP */

/* Define if we link Polly to the tools */
/* #undef LINK_POLLY_INTO_TOOLS */

/* Define if threads enabled */
#define LLVM_ENABLE_THREADS 1

/* Has gcc/MSVC atomic intrinsics */
#define LLVM_HAS_ATOMICS 1

/* Define if this is Unixish platform */
#define LLVM_ON_UNIX 1

/* Define if we have the Intel JIT API runtime support library */
#define LLVM_USE_INTEL_JITEVENTS 0

/* Define if we have the oprofile JIT-support library */
#define LLVM_USE_OPROFILE 0

/* Define if we have the perf JIT-support library */
#define LLVM_USE_PERF 0

/* Major version of the LLVM API */
#define LLVM_VERSION_MAJOR 7

/* Minor version of the LLVM API */
#define LLVM_VERSION_MINOR 0

/* Patch version of the LLVM API */
#define LLVM_VERSION_PATCH 1

/* LLVM version string */
#define LLVM_VERSION_STRING "7.0.1"

/* Whether LLVM records statistics for use with GetStatistics(),
 * PrintStatistics() or PrintStatisticsJSON()
 */
#define LLVM_FORCE_ENABLE_STATS 0

#define LLVM_DEFAULT_TARGET_TRIPLE "mips64el-unknown-openbsd6.5"
#define LLVM_HOST_TRIPLE "mips64el-unknown-openbsd6.5"
#define LLVM_NATIVE_ARCH Mips
#define LLVM_NATIVE_ASMPARSER LLVMInitializeMipsAsmParser
#define LLVM_NATIVE_ASMPRINTER LLVMInitializeMipsAsmPrinter
#define LLVM_NATIVE_DISASSEMBLER LLVMInitializeMipsDisassembler
#define LLVM_NATIVE_TARGET LLVMInitializeMipsTarget
#define LLVM_NATIVE_TARGETINFO LLVMInitializeMipsTargetInfo
#define LLVM_NATIVE_TARGETMC LLVMInitializeMipsTargetMC

#endif
